/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel.compta;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.generationEcritures.Ecriture;
import org.openconcerto.erp.generationEcritures.Exercice;
import org.openconcerto.erp.generationEcritures.Mouvement;
import org.openconcerto.erp.generationEcritures.Piece;
import org.openconcerto.erp.panel.compta.ExportFEC;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.users.User;
import org.openconcerto.utils.StringUtils;

public class ImportFEC {
    private String error = null;
    private Map<String, Piece> mapPiece = new HashMap<String, Piece>();

    public void loadFrom(File file) throws IOException {
        this.error = null;
        this.mapPiece = new HashMap<String, Piece>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader bReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("Cp1252")));){
            String line = bReader.readLine();
            List<String> headers = StringUtils.fastSplit(line, '\t');
            int i = 0;
            while (i < headers.size() && i < ExportFEC.COLS.size()) {
                String c2;
                String c1 = headers.get(i);
                if (!c1.equalsIgnoreCase(c2 = ExportFEC.COLS.get(i))) {
                    this.error = "L'ent\u00eate de la colonne " + (i + 1) + " : " + c1 + " n'est pas " + c2;
                    return;
                }
                ++i;
            }
            line = bReader.readLine();
            while (line != null) {
                Mouvement mouvement;
                Piece p;
                List<String> parts = ImportFEC.fastSplit(line, '\t');
                String journalCode = parts.get(0).trim();
                String journalLib = parts.get(1).trim();
                String ecritureNum = parts.get(2).trim();
                Date ecritureDate = this.parseDate(parts.get(3).trim());
                String compteNum = parts.get(4).trim();
                String compteLib = parts.get(5).trim();
                String compAuxNum = parts.get(6).trim();
                String compAuxLib = parts.get(7).trim();
                if (compteNum.startsWith("411") && compAuxNum != null && compAuxNum.trim().length() > 0) {
                    compteNum = "411" + compAuxNum.substring(1);
                    compteLib = compAuxLib;
                } else if (compteNum.startsWith("401") && compAuxNum != null && compAuxNum.trim().length() > 0) {
                    compteNum = "401" + compAuxNum.substring(1);
                    compteLib = compAuxLib;
                }
                String mvtKey = String.valueOf(ecritureNum) + "-" + journalCode;
                String pieceRef = parts.get(8).trim();
                String ecritureLib = parts.get(10).trim();
                BigDecimal debit = new BigDecimal(parts.get(11).replace(" ", "").replace(',', '.'));
                BigDecimal credit = new BigDecimal(parts.get(12).replace(" ", "").replace(',', '.'));
                String ecritureLet = parts.get(13).trim();
                Date dateLet = this.parseDate(parts.get(14).trim());
                Date validDate = this.parseDate(parts.get(15).trim());
                if (pieceRef.isEmpty()) {
                    pieceRef = mvtKey;
                }
                if ((p = this.mapPiece.get(mvtKey)) == null) {
                    p = new Piece(pieceRef);
                    mouvement = new Mouvement();
                    p.add(mouvement);
                    this.mapPiece.put(mvtKey, p);
                } else {
                    mouvement = p.getMouvements().get(0);
                }
                Ecriture ecriture = new Ecriture(ecritureDate, debit, credit);
                ecriture.setNom(ecritureLib);
                ecriture.setCompte(compteNum, compteLib);
                ecriture.setJournal(journalCode, journalLib);
                ecriture.setDateValidation(validDate);
                ecriture.setDateLettrage(dateLet);
                ecriture.setLettrage(ecritureLet);
                if ("AN".equals(journalCode)) {
                    ecriture.setaNouveau(true);
                }
                mouvement.add(ecriture);
                line = bReader.readLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Date parseDate(String str) {
        if (str.length() != 8) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        int year = Integer.parseInt(str.substring(0, 4));
        int month = Integer.parseInt(str.substring(4, 6));
        int day = Integer.parseInt(str.substring(6, 8));
        c.set(year, month - 1, day, 0, 0, 0);
        return c.getTime();
    }

    public String getError() {
        return this.error;
    }

    public void importTo(SQLElementDirectory directory, DBRoot rootSociete, User user) throws SQLException {
        Exercice e = new Exercice();
        e.insert(directory, rootSociete, user, new ArrayList<Piece>(this.mapPiece.values()));
    }

    public static void main(String[] args) throws IOException {
        ImportFEC i = new ImportFEC();
        i.loadFrom(new File("Y:\\Projets\\OpenConcerto\\ExportCiel\\FEC20171231.txt"));
        System.err.println("ImportFEC.main()" + i.getError());
    }

    public static final List<String> fastSplit(String string, char sep) {
        ArrayList<String> l = new ArrayList<String>();
        int length = string.length();
        char[] cars = string.toCharArray();
        int rfirst = 0;
        int i = 0;
        while (i < length) {
            if (cars[i] == sep) {
                l.add(new String(cars, rfirst, i - rfirst));
                rfirst = i + 1;
            }
            ++i;
        }
        if (rfirst <= length) {
            l.add(new String(cars, rfirst, length - rfirst));
        }
        return l;
    }
}

