/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public final class GenerationMvtReglementAchat
extends GenerationEcritures {
    private int idSaisieAchat;
    private static final Integer journalCaisse = 5;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLTable tableMouvement = base.getTable("MOUVEMENT");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
    private int idPere = 1;

    public GenerationMvtReglementAchat(SQLRow rowAchat, int idMvt) throws Exception {
        this.setRowAnalytiqueSource(rowAchat);
        this.idSaisieAchat = rowAchat.getID();
        this.idPere = idMvt;
        this.genereReglement();
    }

    private void genereReglement() throws Exception {
        PrixTTC prixTTC;
        System.out.println("G\u00e9n\u00e9ration des ecritures du reglement du mouvement " + this.idMvt);
        SQLRow saisieRow = base.getTable("SAISIE_ACHAT").getRow(this.idSaisieAchat);
        SQLRow modeRegRow = base.getTable("MODE_REGLEMENT").getRow(saisieRow.getInt("ID_MODE_REGLEMENT"));
        SQLRow typeRegRow = base.getTable("TYPE_REGLEMENT").getRow(modeRegRow.getInt("ID_TYPE_REGLEMENT"));
        System.out.println("Mode de reglement " + saisieRow.getInt("ID_MODE_REGLEMENT"));
        int idAvoir = saisieRow.getInt("ID_AVOIR_FOURNISSEUR");
        if (idAvoir > 1) {
            SQLRow avoirRow = base.getTable("AVOIR_FOURNISSEUR").getRow(idAvoir);
            long l = ((Number)avoirRow.getObject("MONTANT_TTC")).longValue();
            prixTTC = new PrixTTC((Long)saisieRow.getObject("MONTANT_TTC") - l);
        } else {
            prixTTC = new PrixTTC(((Long)saisieRow.getObject("MONTANT_TTC")).longValue());
        }
        this.date = (Date)saisieRow.getObject("DATE");
        SQLRow rowFournisseur = base.getTable("FOURNISSEUR").getRow(saisieRow.getInt("ID_FOURNISSEUR"));
        this.nom = "R\u00e8glement Achat : " + rowFournisseur.getString("NOM") + " Facture : " + saisieRow.getObject("NUMERO_FACTURE").toString() + " (" + typeRegRow.getString("NOM") + ")";
        if (typeRegRow.getID() != 7 && modeRegRow.getInt("AJOURS") == 0 && modeRegRow.getInt("LENJOUR") == 0) {
            System.out.println("R\u00e8glement Comptant");
            if (typeRegRow.getID() == 2) {
                Calendar c = modeRegRow.getDate("DATE_DEPOT");
                if (c != null) {
                    this.paiementCheque(c.getTime());
                } else {
                    this.paiementCheque(this.date);
                }
            } else {
                Calendar c2;
                SQLRowValues rowVals = new SQLRowValues(base.getTable("REGLER_MONTANT"));
                rowVals.put("MONTANT", prixTTC.getLongValue());
                rowVals.put("ID_FOURNISSEUR", rowFournisseur != null ? Integer.valueOf(rowFournisseur.getID()) : null);
                rowVals.put("DATE", this.date);
                if (typeRegRow.getID() >= 5 && (c2 = modeRegRow.getDate("DATE_VIREMENT")) != null) {
                    rowVals.put("DATE", c2.getTime());
                }
                SQLRowValues rowValsRegl = new SQLRowValues(modeRegRow.asRowValues());
                SQLRow copy = rowValsRegl.insert();
                rowVals.put("ID_MODE_REGLEMENT", copy.getID());
                SQLRow rowEncaisse = rowVals.insert();
                SQLRowValues rowValsElt = new SQLRowValues(base.getTable("REGLER_MONTANT_ELEMENT"));
                rowValsElt.put("MONTANT_REGLE", prixTTC.getLongValue());
                rowValsElt.put("ID_REGLER_MONTANT", rowEncaisse.getID());
                SQLRow rowEncaisseElt = rowValsElt.insert();
                SQLRow mvtSource = tableMouvement.getRow(this.idPere);
                this.idMvt = this.getNewMouvement(rowEncaisse.getTable().getName(), rowEncaisse.getID(), mvtSource.getID(), mvtSource.getInt("ID_PIECE"));
                this.putValue("DATE", new java.sql.Date(this.date.getTime()));
                this.putValue("NOM", this.nom);
                this.putValue("ID_MOUVEMENT", this.idMvt);
                if (typeRegRow.getID() == 4) {
                    this.putValue("ID_JOURNAL", journalCaisse);
                } else {
                    this.fillJournalBanqueFromRow(modeRegRow);
                }
                int compteFourn = rowFournisseur.getInt("ID_COMPTE_PCE");
                if (compteFourn <= 1 && (compteFourn = rowPrefsCompte.getInt("ID_COMPTE_PCE_FOURNISSEUR")) <= 1) {
                    compteFourn = ComptePCESQLElement.getIdComptePceDefault("Fournisseurs");
                }
                this.putValue("ID_COMPTE_PCE", compteFourn);
                this.putValue("DEBIT", prixTTC.getLongValue());
                this.putValue("CREDIT", 0L);
                this.ajoutEcriture();
                if (typeRegRow.getID() == 4) {
                    int idCompteRegl = typeRegRow.getInt("ID_COMPTE_PCE_FOURN");
                    if (idCompteRegl <= 1) {
                        idCompteRegl = ComptePCESQLElement.getIdComptePceDefault("VenteEspece");
                    }
                    this.putValue("ID_COMPTE_PCE", idCompteRegl);
                } else {
                    this.fillCompteBanqueFromRow(modeRegRow, "VenteCB", true);
                }
                this.putValue("DEBIT", 0L);
                this.putValue("CREDIT", prixTTC.getLongValue());
                this.ajoutEcriture();
            }
        } else {
            Date dateEch = ModeDeReglementSQLElement.calculDate(modeRegRow.getInt("AJOURS"), modeRegRow.getInt("LENJOUR"), this.date);
            SimpleDateFormat dateFormat = new SimpleDateFormat();
            System.out.println("Date d'\u00e9ch\u00e9ance " + dateFormat.format(dateEch));
            if (typeRegRow.getID() == 2) {
                this.paiementCheque(dateEch);
            } else {
                HashMap<String, Comparable<Integer>> mEcheance = new HashMap<String, Comparable<Integer>>();
                SQLRow rowMvtPere = tableMouvement.getRow(this.idPere);
                this.idMvt = this.getNewMouvement("ECHEANCE_FOURNISSEUR", 1, this.idPere, rowMvtPere.getInt("ID_PIECE"));
                mEcheance.put("ID_MOUVEMENT", Integer.valueOf(this.idMvt));
                mEcheance.put("DATE", new java.sql.Date(dateEch.getTime()));
                mEcheance.put("MONTANT", Long.valueOf(prixTTC.getLongValue()));
                mEcheance.put("ID_FOURNISSEUR", Integer.valueOf(saisieRow.getInt("ID_FOURNISSEUR")));
                SQLTable echeanceTable = base.getTable("ECHEANCE_FOURNISSEUR");
                SQLRowValues valEcheance = new SQLRowValues(echeanceTable, mEcheance);
                if (valEcheance.getInvalid() == null) {
                    SQLRow row = valEcheance.insert();
                    SQLRowValues rowVals = new SQLRowValues(tableMouvement);
                    rowVals.put("IDSOURCE", row.getID());
                    rowVals.update(this.idMvt);
                }
            }
        }
    }

    private void paiementCheque(Date dateEch) throws SQLException {
        PrixTTC prixTTC;
        SQLRow saisieRow = base.getTable("SAISIE_ACHAT").getRow(this.idSaisieAchat);
        int idAvoir = saisieRow.getInt("ID_AVOIR_FOURNISSEUR");
        if (idAvoir > 1) {
            SQLRow avoirRow = base.getTable("AVOIR_FOURNISSEUR").getRow(idAvoir);
            long l = ((Number)avoirRow.getObject("MONTANT_TTC")).longValue();
            prixTTC = new PrixTTC((Long)saisieRow.getObject("MONTANT_TTC") - l);
        } else {
            prixTTC = new PrixTTC(((Long)saisieRow.getObject("MONTANT_TTC")).longValue());
        }
        HashMap<String, Object> mCheque = new HashMap<String, Object>();
        mCheque.put("ID_FOURNISSEUR", saisieRow.getInt("ID_FOURNISSEUR"));
        mCheque.put("DATE_ACHAT", new java.sql.Date(this.date.getTime()));
        mCheque.put("DATE_MIN_DECAISSE", new java.sql.Date(dateEch.getTime()));
        mCheque.put("MONTANT", prixTTC.getLongValue());
        if (!saisieRow.isForeignEmpty("ID_MODE_REGLEMENT")) {
            SQLRow rowModeRegl = saisieRow.getForeignRow("ID_MODE_REGLEMENT");
            mCheque.put("ID_" + BanqueSQLElement.TABLENAME, rowModeRegl.getInt("ID_" + BanqueSQLElement.TABLENAME));
            mCheque.put("NUMERO", rowModeRegl.getObject("NUMERO"));
            mCheque.put("DATE", rowModeRegl.getObject("DATE"));
            mCheque.put("ETS", rowModeRegl.getObject("ETS"));
            if (rowModeRegl.getObject("DATE_DEPOT") != null) {
                mCheque.put("DATE_MIN_DECAISSE", rowModeRegl.getObject("DATE_DEPOT"));
            }
        }
        SQLRow rowMvtPere = tableMouvement.getRow(this.idPere);
        this.idMvt = this.getNewMouvement("CHEQUE_FOURNISSEUR", 1, this.idPere, rowMvtPere.getInt("ID_PIECE"));
        mCheque.put("ID_MOUVEMENT", this.idMvt);
        SQLTable chqFournTable = base.getTable("CHEQUE_FOURNISSEUR");
        SQLRowValues valDecaisse = new SQLRowValues(chqFournTable, mCheque);
        if (valDecaisse.getInvalid() == null) {
            SQLRow row = valDecaisse.insert();
            SQLRowValues rowVals = new SQLRowValues(tableMouvement);
            rowVals.put("IDSOURCE", row.getID());
            rowVals.update(this.idMvt);
        }
    }
}

