/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.AdresseClientProvider;
import org.openconcerto.sql.model.SQLRowAccessor;

public class AdresseVilleNomClientValueProvider
extends AdresseClientProvider {
    private int type;

    public AdresseVilleNomClientValueProvider(int type) {
        this.type = type;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor r = this.getAdresse(context.getRow(), this.type);
        String result = r.getString("VILLE");
        if (r.getBoolean("HAS_CEDEX").booleanValue()) {
            result = String.valueOf(result) + " Cedex";
            String cedex = r.getString("CEDEX");
            if (cedex != null && cedex.trim().length() > 0) {
                result = String.valueOf(result) + " " + cedex;
            }
        }
        return result;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("address.customer.country.name", new AdresseVilleNomClientValueProvider(ADRESSE_PRINCIPALE));
        SpreadSheetCellValueProviderManager.put("address.customer.invoice.country.name", new AdresseVilleNomClientValueProvider(ADRESSE_FACTURATION));
        SpreadSheetCellValueProviderManager.put("address.customer.shipment.country.name", new AdresseVilleNomClientValueProvider(ADRESSE_LIVRAISON));
    }
}

