/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.model.ProductComponent;
import org.openconcerto.erp.core.supplychain.order.component.CommandeSQLComponent;
import org.openconcerto.erp.core.supplychain.order.ui.CommandeItemTable;
import org.openconcerto.erp.core.supplychain.stock.element.ComposedItemStockUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockItem;
import org.openconcerto.erp.core.supplychain.supplier.component.MouvementStockSQLComponent;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;

public class MouvementStockSQLElement
extends ComptaSQLConfElement {
    public MouvementStockSQLElement() {
        super("MOUVEMENT_STOCK", "un mouvement de stock", "mouvements de stock");
    }

    @Override
    public ListMap<String, String> getShowAs() {
        ListMap<String, String> map = new ListMap<String, String>();
        map.putCollection("ID_STOCK", "ID_DEPOT_STOCK");
        return map;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_STOCK");
        l.add("DATE");
        l.add("NOM");
        l.add("ID_ARTICLE");
        l.add("QTE");
        l.add("REEL");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NOM");
        l.add("QTE");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new MouvementStockSQLComponent(this);
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        super.archive(trees, cutLinks);
        this.updateStock(trees.getRows(), true);
    }

    public ListMap<SQLRow, SQLRowValues> updateStock(Collection<SQLRow> rowsMvt, boolean archive) throws SQLException {
        ListMap<SQLRow, SQLRowValues> map = new ListMap<SQLRow, SQLRowValues>();
        if (rowsMvt == null || rowsMvt.isEmpty()) {
            return map;
        }
        DBRoot root = rowsMvt.iterator().next().getTable().getDBRoot();
        SQLTable tableCommandeElement = root.getTable("COMMANDE_ELEMENT");
        SQLTable tableStock = root.getTable("STOCK");
        for (SQLRow rowMvtStock : rowsMvt) {
            float qteNvlle;
            float qteNvlleEnAttenteExp;
            float qteNvlleEnAttenteRecept;
            SQLRowValues rowVals;
            float qteMvt;
            float qte;
            boolean retour = rowMvtStock.getString("SOURCE") == null || rowMvtStock.getString("SOURCE").startsWith("AVOIR_CLIENT");
            SQLRow rowArticle = rowMvtStock.getForeignRow("ID_ARTICLE");
            SQLRow rowStock = rowMvtStock.getForeignRow("ID_STOCK");
            if (rowStock == null || rowStock.isUndefined()) {
                rowStock = rowArticle.getForeign("ID_STOCK");
            }
            if (rowMvtStock.getBoolean("REEL").booleanValue()) {
                qte = rowStock.getFloat("QTE_REEL");
                qteMvt = rowMvtStock.getFloat("QTE");
                rowVals = new SQLRowValues(tableStock);
                qteNvlleEnAttenteRecept = rowStock.getFloat("QTE_RECEPT_ATTENTE");
                qteNvlleEnAttenteExp = rowStock.getFloat("QTE_LIV_ATTENTE");
                if (archive) {
                    qteNvlle = qte - qteMvt;
                    if (!retour) {
                        if (qteMvt > 0.0f) {
                            qteNvlleEnAttenteRecept += qteMvt;
                        } else {
                            qteNvlleEnAttenteExp -= qteMvt;
                        }
                    }
                } else {
                    qteNvlle = qte + qteMvt;
                    if (!retour) {
                        if (qteMvt > 0.0f) {
                            qteNvlleEnAttenteRecept -= qteMvt;
                        } else {
                            qteNvlleEnAttenteExp += qteMvt;
                        }
                    }
                }
                rowVals.put("QTE_REEL", Float.valueOf(qteNvlle));
                rowVals.put("QTE_RECEPT_ATTENTE", Float.valueOf(qteNvlleEnAttenteRecept));
                rowVals.put("QTE_LIV_ATTENTE", Float.valueOf(qteNvlleEnAttenteExp));
                try {
                    rowVals.update(rowStock.getID());
                    SQLPreferences prefs = new SQLPreferences(root);
                    boolean gestionStockMin = prefs.getBoolean(GestionArticleGlobalPreferencePanel.WARNING_STOCK_MIN, true);
                    if (archive || !gestionStockMin || rowStock.getObject("QTE_MIN") == null || !(qteNvlle < rowStock.getFloat("QTE_MIN"))) continue;
                    SQLInjector inj = SQLInjector.getInjector(rowArticle.getTable(), tableCommandeElement);
                    SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(rowArticle));
                    rowValsElt.put("ID_STYLE", 2);
                    SQLRow unite = rowArticle.getForeign("ID_UNITE_VENTE");
                    float qteElt = rowStock.getFloat("QTE_MIN") - qteNvlle;
                    if (unite.isUndefined() || unite.getBoolean("A_LA_PIECE").booleanValue()) {
                        rowValsElt.put("QTE", Math.round(qteElt));
                        rowValsElt.put("QTE_UNITAIRE", BigDecimal.ONE);
                    } else {
                        rowValsElt.put("QTE", 1);
                        rowValsElt.put("QTE_UNITAIRE", new BigDecimal(qteElt));
                    }
                    rowValsElt.put("ID_TAXE", rowValsElt.getObject("ID_TAXE"));
                    rowValsElt.put("T_POIDS", Float.valueOf((float)rowValsElt.getLong("POIDS") * qteElt));
                    rowValsElt.put("T_PA_HT", Float.valueOf((float)rowValsElt.getLong("PA_HT") * qteElt));
                    rowValsElt.put("T_PA_TTC", (double)rowValsElt.getLong("T_PA_HT") * ((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0));
                    map.add(rowArticle.getForeignRow("ID_FOURNISSEUR"), rowValsElt);
                    continue;
                }
                catch (SQLException e) {
                    throw new SQLException("Erreur lors de la mise \u00e0 jour du stock pour l'article " + rowArticle.getString("CODE"), e);
                }
            }
            qte = rowStock.getFloat("QTE_TH");
            qteMvt = rowMvtStock.getFloat("QTE");
            rowVals = new SQLRowValues(tableStock);
            qteNvlleEnAttenteRecept = rowStock.getFloat("QTE_RECEPT_ATTENTE");
            qteNvlleEnAttenteExp = rowStock.getFloat("QTE_LIV_ATTENTE");
            if (archive) {
                qteNvlle = qte - qteMvt;
                if (!retour) {
                    if (qteMvt > 0.0f) {
                        qteNvlleEnAttenteRecept -= qteMvt;
                    } else {
                        qteNvlleEnAttenteExp += qteMvt;
                    }
                }
            } else {
                qteNvlle = qte + qteMvt;
                if (!retour) {
                    if (qteMvt > 0.0f) {
                        qteNvlleEnAttenteRecept += qteMvt;
                    } else {
                        qteNvlleEnAttenteExp -= qteMvt;
                    }
                }
            }
            rowVals.put("QTE_TH", Float.valueOf(qteNvlle));
            rowVals.put("QTE_RECEPT_ATTENTE", Float.valueOf(qteNvlleEnAttenteRecept));
            rowVals.put("QTE_LIV_ATTENTE", Float.valueOf(qteNvlleEnAttenteExp));
            try {
                rowVals.update(rowStock.getID());
            }
            catch (SQLException e) {
                throw new SQLException("Erreur lors de la mise \u00e0 jour du stock pour l'article " + rowArticle.getString("CODE"), e);
            }
        }
        return map;
    }

    public static void createCommandeF(ListMap<SQLRow, SQLRowValues> col, SQLRow rowDevise) {
        MouvementStockSQLElement.createCommandeF(col, rowDevise, "");
    }

    public static void createCommandeF(ListMap<SQLRow, SQLRowValues> col, final SQLRow rowDevise, final String ref) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method must be called outside of EDT");
        }
        if (col.size() > 0) {
            final SQLElement commande = Configuration.getInstance().getDirectory().getElement("COMMANDE");
            Boolean useCommandeEnCours = SQLPreferences.getMemCached(commande.getTable().getDBRoot()).getBoolean(GestionCommercialeGlobalPreferencePanel.COMMANDE_FOURNISSEUR_EN_COURS, false);
            for (final Map.Entry e : col.entrySet()) {
                final SQLRow fournisseur = (SQLRow)e.getKey();
                SQLSelect sel = new SQLSelect();
                sel.addSelectStar(commande.getTable());
                Where w = new Where((FieldRef)commande.getTable().getField("EN_COURS"), "=", (Object)Boolean.TRUE);
                w = w.and(new Where((FieldRef)commande.getTable().getField("ID_FOURNISSEUR"), "=", fournisseur.getID()));
                sel.setWhere(w);
                final List rowsCmd = useCommandeEnCours == false ? null : (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), SQLRowListRSH.createFromSelect(sel));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommandeSQLComponent cmp;
                        EditFrame frame;
                        SQLRow commandeExistante = null;
                        if (rowsCmd != null && rowsCmd.size() > 0) {
                            commandeExistante = (SQLRow)rowsCmd.get(0);
                        }
                        if (commandeExistante != null) {
                            frame = new EditFrame(commande, EditPanel.EditMode.MODIFICATION);
                            cmp = (CommandeSQLComponent)frame.getSQLComponent();
                            cmp.select(commandeExistante);
                        } else {
                            frame = new EditFrame(commande);
                            cmp = (CommandeSQLComponent)frame.getSQLComponent();
                            SQLRowValues rowVals = new SQLRowValues(commande.getTable());
                            SQLElement eltComm = Configuration.getInstance().getDirectory().getElement("COMMERCIAL");
                            int idUser = UserManager.getInstance().getCurrentUser().getId();
                            SQLRow rowsComm = SQLBackgroundTableCache.getInstance().getCacheForTable(eltComm.getTable()).getFirstRowContains(idUser, eltComm.getTable().getField("ID_USER_COMMON"));
                            if (rowsComm != null) {
                                rowVals.put("ID_COMMERCIAL", rowsComm.getID());
                            }
                            if (fournisseur != null && !fournisseur.isUndefined()) {
                                rowVals.put("ID_FOURNISSEUR", fournisseur.getID());
                            }
                            if (rowDevise != null) {
                                rowVals.put("ID_DEVISE", rowDevise.getID());
                            }
                            if (commande.getTable().contains("ID_ADRESSE")) {
                                rowVals.put("ID_ADRESSE", null);
                            }
                            rowVals.put("NOM", ref);
                            cmp.select(rowVals);
                            cmp.getRowValuesTable().getRowValuesTableModel().clearRows();
                        }
                        CommandeItemTable itemTable = cmp.getRowValuesTablePanel();
                        RowValuesTableModel model = cmp.getRowValuesTable().getRowValuesTableModel();
                        List articleToCmd = (List)e.getValue();
                        Collections.sort(articleToCmd, new Comparator<SQLRowValues>(){

                            @Override
                            public int compare(SQLRowValues o1, SQLRowValues o2) {
                                SQLRowAccessor o2ArticleNumber;
                                SQLRowAccessor o1ArticleNumber = o1.contains("ID_ARTICLE") ? o1.getNonEmptyForeign("ID_ARTICLE") : null;
                                SQLRowAccessor sQLRowAccessor = o2ArticleNumber = o1.contains("ID_ARTICLE") ? o1.getNonEmptyForeign("ID_ARTICLE") : null;
                                if (o1ArticleNumber != null && o2ArticleNumber != null) {
                                    int comparedCode = o1ArticleNumber.getString("CODE").compareTo(o1ArticleNumber.getString("CODE"));
                                    if (comparedCode == 0) {
                                        SQLRowAccessor o2TailleNumber;
                                        int comparedCouleurCode;
                                        SQLRowAccessor o2CouleurNumber;
                                        SQLRowAccessor o1CouleurNumber = o1ArticleNumber.contains("ID_ARTICLE_DECLINAISON_COULEUR") ? o1ArticleNumber.getNonEmptyForeign("ID_ARTICLE_DECLINAISON_COULEUR") : null;
                                        SQLRowAccessor sQLRowAccessor2 = o2CouleurNumber = o2ArticleNumber.contains("ID_ARTICLE_DECLINAISON_COULEUR") ? o2ArticleNumber.getNonEmptyForeign("ID_ARTICLE_DECLINAISON_COULEUR") : null;
                                        if (o1CouleurNumber != null && o2CouleurNumber != null && (comparedCouleurCode = o1CouleurNumber.getBigDecimal("ORDRE").compareTo(o2CouleurNumber.getBigDecimal("ORDRE"))) != 0) {
                                            return comparedCouleurCode;
                                        }
                                        SQLRowAccessor o1TailleNumber = o1ArticleNumber.contains("ID_ARTICLE_TAILLE_COULEUR") ? o1ArticleNumber.getNonEmptyForeign("ID_ARTICLE_TAILLE_COULEUR") : null;
                                        SQLRowAccessor sQLRowAccessor3 = o2TailleNumber = o2ArticleNumber.contains("ID_ARTICLE_TAILLE_COULEUR") ? o2ArticleNumber.getNonEmptyForeign("ID_ARTICLE_TAILLE_COULEUR") : null;
                                        if (o1TailleNumber != null && o2TailleNumber != null) {
                                            int comparedTailleCode = o1TailleNumber.getBigDecimal("ORDRE").compareTo(o2TailleNumber.getBigDecimal("ORDRE"));
                                            return comparedTailleCode;
                                        }
                                    }
                                    return comparedCode;
                                }
                                return o1.getString("CODE").compareTo(o2.getString("CODE"));
                            }
                        });
                        for (SQLRowValues rowValsElt : articleToCmd) {
                            Object o;
                            SQLRowAccessor rowValsMatch = null;
                            int index = 0;
                            int i = 0;
                            while (i < model.getRowCount()) {
                                Number lineToAddArticleNumber;
                                SQLRowValues rowValsCmdElt = model.getRowValuesAt(i);
                                Number lineArticleNumber = rowValsCmdElt.contains("ID_ARTICLE") ? (Number)rowValsCmdElt.getNonEmptyForeignIDNumber("ID_ARTICLE") : (Number)null;
                                Number number = lineToAddArticleNumber = rowValsElt.contains("ID_ARTICLE") ? (Number)rowValsElt.getNonEmptyForeignIDNumber("ID_ARTICLE") : (Number)null;
                                if ((lineToAddArticleNumber == null || lineArticleNumber == null || lineArticleNumber.equals(lineToAddArticleNumber)) && ReferenceArticleSQLElement.isReferenceEquals(rowValsCmdElt, rowValsElt)) {
                                    rowValsMatch = rowValsCmdElt;
                                    index = i;
                                    break;
                                }
                                ++i;
                            }
                            if (rowValsMatch != null) {
                                int qte = rowValsMatch.getInt("QTE");
                                BigDecimal qteUV = rowValsMatch.getBigDecimal("QTE_UNITAIRE");
                                if (((SQLRowValues)rowValsMatch).getObject("ID_UNITE_VENTE") != null && rowValsMatch.getForeignID("ID_UNITE_VENTE") != 2) {
                                    qteUV = qteUV.multiply(new BigDecimal(qte));
                                    int qteElt = rowValsElt.getInt("QTE");
                                    BigDecimal qteUVElt = rowValsElt.getBigDecimal("QTE_UNITAIRE");
                                    qteUV = qteUV.add(qteUVElt.multiply(new BigDecimal(qteElt)));
                                    qte = 1;
                                } else {
                                    qte += rowValsElt.getInt("QTE");
                                }
                                model.putValue(qte, index, "QTE");
                                model.putValue(qteUV, index, "QTE_UNITAIRE");
                                continue;
                            }
                            model.addRow(rowValsElt);
                            if (rowValsElt.getObject("ID_ARTICLE") == null || rowValsElt.isForeignEmpty("ID_ARTICLE") || (o = itemTable.tarifCompletion(rowValsElt.getForeign("ID_ARTICLE").asRow(), "PRIX_METRIQUE_HA_1")) == null) continue;
                            model.putValue(o, model.getRowCount() - 1, "PRIX_METRIQUE_HA_1");
                        }
                        frame.pack();
                        FrameUtil.show(frame);
                    }
                });
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "Aucune commande \u00e0 passer", "Commande fournisseur", 1);
                }
            });
        }
    }

    @Override
    protected void _initListRequest(ListSQLRequest req) {
        super._initListRequest(req);
        req.addToGraphToFetch("SOURCE", "IDSOURCE");
    }

    public static final void showSource(final int id) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method must be called from EDT");
        }
        if (id != 1) {
            SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
            final SQLTable tableMvt = base.getTable("MOUVEMENT_STOCK");
            final String stringTableSource = tableMvt.getRow(id).getString("SOURCE");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditFrame f;
                    if (stringTableSource.trim().length() != 0 && tableMvt.getRow(id).getInt("IDSOURCE") != 1) {
                        f = new EditFrame(Configuration.getInstance().getDirectory().getElement(stringTableSource), EditPanel.READONLY);
                        f.selectionId(tableMvt.getRow(id).getInt("IDSOURCE"));
                    } else {
                        f = new EditFrame(Configuration.getInstance().getDirectory().getElement(tableMvt), EditPanel.READONLY);
                        f.selectionId(id);
                    }
                    f.pack();
                    FrameUtil.show(f);
                }
            });
        } else {
            System.err.println("Aucun mouvement associ\u00e9, impossible de modifier ou d'acc\u00e9der \u00e0 la source de cette ecriture!");
        }
    }

    public void transfertStock(final BigDecimal qteReel, final Date dateValue, final SQLRow selectedRowArticle, final SQLRow selectedRowDepotDepart, final SQLRow selectedRowDepotArrivee, final String labelTrStock) {
        final boolean usePrice = this.getTable().contains("PRICE");
        try {
            SQLUtils.executeAtomic(selectedRowDepotDepart.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

                @Override
                public Object handle(SQLDataSource ds) throws SQLException {
                    ArrayList<StockItem> stockItems = new ArrayList<StockItem>();
                    ArrayList<String> multipleRequestsHundred = new ArrayList<String>(100);
                    SQLRowAccessor rowStockDepart = ProductComponent.findOrCreateStock(selectedRowArticle, selectedRowDepotDepart);
                    StockItem item = new StockItem(selectedRowArticle, rowStockDepart);
                    if (!item.isStockInit()) {
                        SQLRowValues rowVals = new SQLRowValues(MouvementStockSQLElement.this.getTable().getTable("STOCK"));
                        rowVals.put("ID_ARTICLE", selectedRowArticle.getID());
                        rowVals.put("ID_DEPOT_STOCK", selectedRowDepotDepart.getID());
                        rowVals.commit();
                        selectedRowArticle.fetchValues();
                        item = new StockItem(selectedRowArticle, rowStockDepart);
                    }
                    stockItems.add(item);
                    double diff = -qteReel.doubleValue();
                    item.updateQty(diff, StockItem.TypeStockMouvement.REEL);
                    multipleRequestsHundred.add(MouvementStockSQLElement.this.getMvtRequest(dateValue, BigDecimal.ZERO, diff, item, MouvementStockSQLElement.this.getLabel(labelTrStock, selectedRowDepotDepart, selectedRowDepotArrivee), true, usePrice));
                    item.updateQty(diff, StockItem.TypeStockMouvement.THEORIQUE);
                    multipleRequestsHundred.add(MouvementStockSQLElement.this.getMvtRequest(dateValue, BigDecimal.ZERO, diff, item, MouvementStockSQLElement.this.getLabel(labelTrStock, selectedRowDepotDepart, selectedRowDepotArrivee), false, usePrice));
                    multipleRequestsHundred.add(item.getUpdateRequest());
                    SQLRowAccessor rowStockArrivee = ProductComponent.findOrCreateStock(selectedRowArticle, selectedRowDepotArrivee);
                    item = new StockItem(selectedRowArticle, rowStockArrivee);
                    if (!item.isStockInit()) {
                        SQLRowValues rowVals = new SQLRowValues(MouvementStockSQLElement.this.getTable().getTable("STOCK"));
                        rowVals.put("ID_ARTICLE", selectedRowArticle.getID());
                        rowVals.put("ID_DEPOT_STOCK", selectedRowDepotArrivee.getID());
                        rowVals.commit();
                        selectedRowArticle.fetchValues();
                        item = new StockItem(selectedRowArticle, rowStockArrivee);
                    }
                    stockItems.add(item);
                    diff = qteReel.doubleValue();
                    item.updateQty(diff, StockItem.TypeStockMouvement.REEL);
                    multipleRequestsHundred.add(MouvementStockSQLElement.this.getMvtRequest(dateValue, BigDecimal.ZERO, diff, item, MouvementStockSQLElement.this.getLabel(labelTrStock, selectedRowDepotDepart, selectedRowDepotArrivee), true, usePrice));
                    item.updateQty(diff, StockItem.TypeStockMouvement.THEORIQUE);
                    multipleRequestsHundred.add(MouvementStockSQLElement.this.getMvtRequest(dateValue, BigDecimal.ZERO, diff, item, MouvementStockSQLElement.this.getLabel(labelTrStock, selectedRowDepotDepart, selectedRowDepotArrivee), false, usePrice));
                    multipleRequestsHundred.add(item.getUpdateRequest());
                    int size = multipleRequestsHundred.size();
                    ArrayList<Object> handlers = new ArrayList<Object>(size);
                    int i = 0;
                    while (i < size) {
                        handlers.add(null);
                        ++i;
                    }
                    SQLUtils.executeMultiple(selectedRowArticle.getTable().getDBSystemRoot(), multipleRequestsHundred, handlers);
                    DBRoot root = MouvementStockSQLElement.this.getTable().getDBRoot();
                    if (root.contains("ARTICLE_ELEMENT")) {
                        ComposedItemStockUpdater comp = new ComposedItemStockUpdater(root, stockItems);
                        comp.update();
                    }
                    return null;
                }
            });
        }
        catch (SQLException e1) {
            ExceptionHandler.handle("Stock update error", e1);
        }
    }

    private String getLabel(String label, SQLRowAccessor fromDepot, SQLRowAccessor toDepot) {
        return String.valueOf(label) + " de " + fromDepot.getString("NOM") + " vers " + toDepot.getString("NOM");
    }

    private String getMvtRequest(Date time, BigDecimal prc, double qteFinal, StockItem item, String label, boolean reel, boolean usePrice) {
        String mvtStockTableQuoted = this.getTable().getSQLName().quote();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String mvtStockQuery = "INSERT INTO " + mvtStockTableQuoted + " (\"QTE\",\"DATE\",\"ID_ARTICLE\",\"ID_STOCK\",\"NOM\",\"REEL\",\"ORDRE\"";
        if (usePrice && prc != null) {
            mvtStockQuery = String.valueOf(mvtStockQuery) + ",\"PRICE\"";
        }
        mvtStockQuery = String.valueOf(mvtStockQuery) + ") VALUES(" + qteFinal + ",'" + dateFormat.format(time) + "'," + item.getArticle().getID() + "," + item.stock.getID() + ",'" + label + "'," + reel + ", (SELECT (MAX(\"ORDRE\")+1) FROM " + mvtStockTableQuoted + ")";
        if (usePrice && prc != null) {
            mvtStockQuery = String.valueOf(mvtStockQuery) + "," + prc.setScale(6, RoundingMode.HALF_UP).toString();
        }
        mvtStockQuery = String.valueOf(mvtStockQuery) + ")";
        return mvtStockQuery;
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".transaction";
    }
}

