/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.element;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.customerrelationship.customer.element.RelanceSQLElement;
import org.openconcerto.erp.core.customerrelationship.mail.EmailTemplate;
import org.openconcerto.erp.core.customerrelationship.mail.ValueListener;
import org.openconcerto.erp.core.finance.accounting.element.MouvementSQLElement;
import org.openconcerto.erp.core.finance.payment.element.EncaisserMontantSQLElement;
import org.openconcerto.erp.core.sales.invoice.action.ImportReglementSage;
import org.openconcerto.erp.core.sales.invoice.element.UpdateCommEchFrame;
import org.openconcerto.erp.core.sales.invoice.report.MailRelanceCreator;
import org.openconcerto.erp.core.sales.invoice.report.SituationCompteClientPanel;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.core.sales.invoice.ui.DecaleEcheancePanel;
import org.openconcerto.erp.rights.ComptaUserRight;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.EmailComposer;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.ListMap;

public class EcheanceClientSQLElement
extends ComptaSQLConfElement {
    SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMMM yyyy", Locale.ENGLISH);

    public EcheanceClientSQLElement() {
        super("ECHEANCE_CLIENT", "une \u00e9ch\u00e9ance client", "\u00e9ch\u00e9ances clients");
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction("D\u00e9tails client"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SQLElement eltClient = Configuration.getInstance().getDirectory().getElement(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT"));
                EditFrame edit = new EditFrame(eltClient, EditPanel.EditMode.MODIFICATION);
                edit.selectionId(IListe.get(arg0).getSelectedRow().asRow().getInt("ID_CLIENT"));
                edit.setVisible(true);
            }
        }, false);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
        action = new RowAction.PredicateRowAction(new AbstractAction("Voir la source"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SQLRow row = IListe.get(arg0).fetchSelectedRow();
                MouvementSQLElement.showSource(row.getInt("ID_MOUVEMENT"));
            }
        }, false);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
        action = new RowAction.PredicateRowAction(new AbstractAction("Ajouter un commentaire"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SQLRow row = IListe.get(arg0).fetchSelectedRow();
                UpdateCommEchFrame frame = UpdateCommEchFrame.getFrame();
                frame.select(row);
                frame.setVisible(true);
            }
        }, false);
        action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(action);
        action = new RowAction.PredicateRowAction(new AbstractAction("Envoyer un mail de relance"){

            @Override
            public void actionPerformed(ActionEvent e) {
                final IListe iListe = IListe.get(e);
                if (iListe.getSelectedRows().isEmpty()) {
                    int result = JOptionPane.showConfirmDialog(iListe, "Souhaitez vous envoyer un email de relance pour toutes les factures\ndont l'\u00e9ch\u00e9ance est d\u00e9pass\u00e9e?\nLes relances ne seront pas envoy\u00e9es si les factures ont d\u00e9j\u00e0\u00a0 une relance de moins d'un mois. ", "Relance automatique", 0);
                    if (result == 0) {
                        EmailTemplate.askTemplate(iListe, EcheanceClientSQLElement.this.getTable().getDBRoot(), EcheanceClientSQLElement.this.getTable().getName(), new ValueListener(){

                            @Override
                            public void valueSelected(final Object value) {
                                Thread t = new Thread(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            EmailTemplate template = (EmailTemplate)value;
                                            SQLTable table = EcheanceClientSQLElement.this.getTable();
                                            SQLRowValues v = new SQLRowValues(table);
                                            v.putNulls(table.getFieldsName());
                                            Where w = new Where((FieldRef)table.getField("REGLE"), "=", (Object)false);
                                            w = w.and(new Where((FieldRef)table.getField("REG_COMPTA"), "=", (Object)false));
                                            Calendar c = Calendar.getInstance();
                                            c.add(2, -1);
                                            w = w.and(new Where((FieldRef)table.getField("DATE_LAST_RELANCE"), ">", (Object)c.getTime()));
                                            w = w.and(new Where((FieldRef)table.getField("DATE"), "<=", (Object)Calendar.getInstance().getTime()));
                                            List<SQLRowValues> rowValues = SQLRowValuesListFetcher.create(v).fetch(w);
                                            if (rowValues.isEmpty()) {
                                                JOptionPane.showMessageDialog(iListe, "Aucune relance \u00e0\u00a0 envoyer.");
                                            } else {
                                                EcheanceClientSQLElement.this.sendMail(rowValues, template);
                                            }
                                        }
                                        catch (Exception e) {
                                            ExceptionHandler.handle("erreur lors de l'envoi", e);
                                        }
                                    }
                                });
                                t.setDaemon(true);
                                t.setName("email relance");
                                t.start();
                            }
                        });
                    }
                } else {
                    final SQLTable primaryTable = iListe.getRequest().getPrimaryTable();
                    final List<Integer> selectedIDs = iListe.getSelection().getSelectedIDs();
                    EmailTemplate.askTemplate(iListe, EcheanceClientSQLElement.this.getTable().getDBRoot(), EcheanceClientSQLElement.this.getTable().getName(), new ValueListener(){

                        @Override
                        public void valueSelected(final Object value) {
                            Thread t = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        EmailTemplate template = (EmailTemplate)value;
                                        List<SQLRow> rows = SQLRowListRSH.fetch(primaryTable, selectedIDs);
                                        EcheanceClientSQLElement.this.sendMail(rows, template);
                                    }
                                    catch (Exception e) {
                                        ExceptionHandler.handle("erreur lors de l'envoi", e);
                                    }
                                }
                            });
                            t.setDaemon(true);
                            t.setName("email relance selection");
                            t.start();
                        }
                    });
                }
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.createTotalRowCountPredicate(0, Integer.MAX_VALUE));
        this.getRowActions().add(action);
        RowAction.PredicateRowAction actionSituation = new RowAction.PredicateRowAction(new AbstractAction("G\u00e9n\u00e9rer une situationde compte"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelFrame frame = new PanelFrame(new SituationCompteClientPanel(ComptaPropsConfiguration.getInstanceCompta()), "Situation client");
                frame.setVisible(true);
            }
        }, true);
        actionSituation.setPredicate(IListeAction.IListeEvent.createSelectionCountPredicate(0, Integer.MAX_VALUE));
        this.getRowActions().add(actionSituation);
        RowAction.PredicateRowAction actionEchDecalage = new RowAction.PredicateRowAction(new AbstractAction("D\u00e9caler la date d'\u00e9ch\u00e9ance"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues rowVals = IListe.get(e).getSelectedRow();
                PanelFrame frame = new PanelFrame(new DecaleEcheancePanel(rowVals), "D\u00e9caler une \u00e9ch\u00e9ance");
                FrameUtil.showPacked(frame);
            }
        }, true);
        actionEchDecalage.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionEchDecalage);
        if (UserRightsManager.getCurrentUserRights().haveRight(ComptaUserRight.MENU)) {
            RowAction actionCancel = new RowAction(new AbstractAction("Annuler la r\u00e9gularisation en comptabilit\u00e9"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int answer = JOptionPane.showConfirmDialog(null, "Etes vous s\u00fbr de vouloir annuler la r\u00e9gularisation ?");
                    if (answer == 0) {
                        SQLRow row = IListe.get(e).getSelectedRow().asRow();
                        SQLRowValues rowVals = row.createEmptyUpdateRow();
                        rowVals.put("REG_COMPTA", Boolean.FALSE);
                        try {
                            rowVals.commit();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }, false){

                @Override
                public boolean enabledFor(List<SQLRowValues> selection) {
                    if (selection != null && selection.size() == 1) {
                        SQLRowAccessor row = selection.get(0);
                        return row.getBoolean("REG_COMPTA");
                    }
                    return true;
                }
            };
            this.getRowActions().add(actionCancel);
            RowAction actionRegul = new RowAction(new AbstractAction("R\u00e9gularisation en comptabilit\u00e9"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int answer;
                    SQLRow row = IListe.get(e).fetchSelectedRow();
                    String price = GestionDevise.currencyToString(row.getLong("MONTANT"));
                    SQLRow rowClient = row.getForeignRow("ID_CLIENT");
                    String nomClient = rowClient.getString("NOM");
                    String piece = "";
                    SQLRow rowMvt = row.getForeignRow("ID_MOUVEMENT");
                    if (rowMvt != null) {
                        SQLRow rowPiece = rowMvt.getForeignRow("ID_PIECE");
                        piece = rowPiece.getString("NOM");
                    }
                    if ((answer = JOptionPane.showConfirmDialog(null, "Etes vous s\u00fbr de vouloir r\u00e9gulariser l'\u00e9ch\u00e9ance de " + nomClient + " d'un montant de " + price + "\u20ac avec une saisie au kilometre?\nNom de la pi\u00e9ce : " + piece + ".")) == 0) {
                        SQLRowValues rowVals = row.createEmptyUpdateRow();
                        rowVals.put("REG_COMPTA", Boolean.TRUE);
                        try {
                            rowVals.commit();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }, false){

                @Override
                public boolean enabledFor(List<SQLRowValues> selection) {
                    if (selection != null && selection.size() == 1) {
                        SQLRowAccessor row = selection.get(0);
                        return row.getBoolean("REG_COMPTA") == false;
                    }
                    return true;
                }
            };
            this.getRowActions().add(actionRegul);
        }
        RowAction actionImport = new RowAction(new AbstractAction("Importer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame frame = SwingThreadUtils.getAncestorOrSelf(Frame.class, (Component)e.getSource());
                final FileDialog fd = new FileDialog(frame, "Import XML des r\u00e9glements Sage", 0);
                if (fd.getFile() != null) {
                    try {
                        SQLUtils.executeAtomic(EcheanceClientSQLElement.this.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, IOException>(){

                            @Override
                            public Object handle(SQLDataSource ds) throws SQLException, IOException {
                                ImportReglementSage sageImporter = new ImportReglementSage(EcheanceClientSQLElement.this.getDirectory().getElement(EncaisserMontantSQLElement.class));
                                try {
                                    sageImporter.importFromFile(new File(fd.getDirectory(), fd.getFile()));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    new SQLException(e);
                                }
                                return null;
                            }
                        });
                        JOptionPane.showMessageDialog(null, "Import des paiements termin\u00e9s!");
                    }
                    catch (IOException exn) {
                        ExceptionHandler.handle(frame, "Erreur lors de la lecture du fichier", exn);
                    }
                    catch (SQLException exn) {
                        ExceptionHandler.handle(frame, "Erreur lors de l'insertion des paiements dans la base", exn);
                    }
                }
                fd.setVisible(true);
            }
        }, true){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return true;
            }
        };
        this.getRowActions().add(actionImport);
    }

    private void sendMail(List<? extends SQLRowAccessor> rows, EmailTemplate template) throws Exception {
        ListMap<Integer, SQLRow> mapByCustomer = new ListMap<Integer, SQLRow>();
        for (SQLRowAccessor sQLRowAccessor : rows) {
            mapByCustomer.add(sQLRowAccessor.getForeignID("ID_CLIENT"), sQLRowAccessor.asRow());
        }
        for (List list : mapByCustomer.values()) {
            this.sendCustomerMail(list, template);
        }
    }

    private void sendCustomerMail(List<SQLRow> rows, EmailTemplate template) throws Exception {
        int idMvtSource = MouvementSQLElement.getSourceId(rows.get(0).getInt("ID_MOUVEMENT"));
        SQLRow rowMvtSource = this.getTable().getTable("MOUVEMENT").getRow(idMvtSource);
        if (!rowMvtSource.getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE")) {
            return;
        }
        int idFact = rowMvtSource.getInt("IDSOURCE");
        Set<SQLField> setContact = null;
        SQLTable tableContact = Configuration.getInstance().getRoot().findTable("CONTACT");
        setContact = rows.get(0).getTable().getForeignKeys(tableContact);
        Set<SQLField> setClient = null;
        SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete().getTable("CLIENT");
        setClient = rows.get(0).getTable().getForeignKeys(tableClient);
        String mail = "";
        for (SQLField field : setContact) {
            if (mail != null && mail.trim().length() != 0) continue;
            mail = rows.get(0).getForeignRow(field.getName()).getString("EMAIL");
        }
        for (SQLField field : setClient) {
            SQLRow rowCli = rows.get(0).getForeignRow(field.getName());
            if (mail != null && mail.trim().length() != 0) continue;
            mail = rowCli.getString("MAIL");
        }
        String adresseMail = mail;
        File[] files = new File[rows.size()];
        MailRelanceCreator creator = new MailRelanceCreator(template, rows);
        String references = creator.getObject();
        String text = creator.getValue();
        int i = 0;
        for (SQLRow row : rows) {
            SQLRow rowFacture = this.getTable().getTable("SAISIE_VENTE_FACTURE").getRow(row.getForeignID("ID_SAISIE_VENTE_FACTURE"));
            VenteFactureXmlSheet sheet = new VenteFactureXmlSheet(rowFacture);
            File f = sheet.getOrCreatePDFDocumentFile(true);
            files[i] = f.getAbsoluteFile();
            ++i;
        }
        EmailComposer.getInstance().compose(adresseMail, references, text, files);
        long montant = 0L;
        for (SQLRow rowEch : rows) {
            montant += rowEch.getLong("MONTANT");
        }
        String numero = NumerotationAutoSQLElement.getNextNumero(RelanceSQLElement.class);
        SQLRowValues rowValsR = new SQLRowValues(this.getTable().getTable("RELANCE"));
        rowValsR.put("DATE", new Date());
        rowValsR.put("NUMERO", numero);
        rowValsR.put("ID_CLIENT", rows.get(0).getForeignID("ID_CLIENT"));
        rowValsR.put("ID_SAISIE_VENTE_FACTURE", rows.get(0).getForeignID("ID_SAISIE_VENTE_FACTURE"));
        rowValsR.put("MONTANT", montant);
        rowValsR.put("INFOS", "Email");
        rowValsR.put("ID_ECHEANCE_CLIENT", rows.get(0).getID());
        rowValsR.insert();
        SQLTable tableNum = this.getTable().getBase().getTable("NUMEROTATION_AUTO");
        SQLRowValues rowVals = new SQLRowValues(tableNum);
        int val = tableNum.getRow(2).getInt("RELANCE_START");
        rowVals.put("RELANCE_START", (Object)(++val));
        rowVals.update(2);
        for (SQLRow rowEch : rows) {
            int nbRelance = rowEch.getInt("NOMBRE_RELANCE");
            SQLRowValues rowValsEch = new SQLRowValues(rowEch.getTable());
            rowValsEch.put("NOMBRE_RELANCE", ++nbRelance);
            rowValsEch.put("DATE_LAST_RELANCE", new Date());
            rowValsEch.update(rowEch.getID());
        }
    }

    @Override
    public ListMap<String, String> getShowAs() {
        ListMap<String, String> map = new ListMap<String, String>();
        return map;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_SAISIE_VENTE_FACTURE");
        l.add("DATE");
        l.add("ID_CLIENT");
        l.add("MONTANT");
        l.add("ID_MOUVEMENT");
        l.add("NOMBRE_RELANCE");
        l.add("INFOS");
        if (SQLPreferences.getMemCached(this.getTable().getDBRoot()).getBoolean("PourcentRG", false)) {
            l.add("RG");
        }
        l.add("DATE_LAST_RELANCE");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("ID_CLIENT");
        l.add("MONTANT");
        return l;
    }

    @Override
    protected void _initListRequest(ListSQLRequest req) {
        super._initListRequest(req);
        req.addToGraphToFetch("REG_COMPTA", "REGLE", "NOMBRE_RELANCE");
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private DeviseField montant;
            private JTextField nbRelance;
            private JDate date;
            private JTextField idMouvement;
            private ElementComboBox comboClient;

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                this.montant = new DeviseField();
                this.nbRelance = new JTextField();
                this.date = new JDate();
                this.idMouvement = new JTextField();
                this.comboClient = new ElementComboBox();
                JLabel labelMouvement = new JLabel("Mouvement");
                this.add((Component)labelMouvement, c);
                c.weightx = 1.0;
                ++c.gridx;
                this.add((Component)this.idMouvement, c);
                JLabel labelDate = new JLabel("Date");
                ++c.gridx;
                this.add((Component)labelDate, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.date, c);
                JLabel labelClient = new JLabel("Client");
                ++c.gridy;
                c.gridx = 0;
                this.add((Component)labelClient, c);
                ++c.gridx;
                c.weightx = 1.0;
                c.gridwidth = 0;
                this.add((Component)this.comboClient, c);
                JLabel labelRelance = new JLabel("Nombre de relance");
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 1;
                this.add((Component)labelRelance, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.nbRelance, c);
                c.gridwidth = 1;
                JLabel labelMontant = new JLabel("Montant");
                ++c.gridx;
                this.add((Component)labelMontant, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)this.montant, c);
                this.addSQLObject(this.montant, "MONTANT");
                this.addRequiredSQLObject(this.date, "DATE");
                this.addSQLObject(this.nbRelance, "NOMBRE_RELANCE");
                this.addRequiredSQLObject(this.comboClient, "ID_CLIENT");
                this.addSQLObject(this.idMouvement, "ID_MOUVEMENT");
            }
        };
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".commitment";
    }

    public void relanceClient(final SQLRow rowEch) {
        final SQLElement relanceElt = this.getDirectory().getElement("RELANCE");
        rowEch.fetchValues();
        if (rowEch != null) {
            int idMvtSource = MouvementSQLElement.getSourceId(rowEch.getForeignID("ID_MOUVEMENT"));
            SQLRow rowMvtSource = this.getTable().getTable("MOUVEMENT").getRow(idMvtSource);
            if (!rowMvtSource.getString("SOURCE").equalsIgnoreCase("SAISIE_VENTE_FACTURE")) {
                JOptionPane.showMessageDialog(null, "Impossible de relancer un \u00e9ch\u00e9ance qui n'est pas issue d'une facture.");
                return;
            }
            EditFrame editRelance = new EditFrame(relanceElt);
            editRelance.setIconImages(Gestion.getFrameIcon());
            editRelance.addEditPanelListener(new EditPanelListener(){

                @Override
                public void cancelled() {
                }

                @Override
                public void modified() {
                }

                @Override
                public void deleted() {
                }

                @Override
                public void inserted(int id) {
                    int nbRelance = rowEch.getInt("NOMBRE_RELANCE");
                    SQLRowValues rowValsEch = new SQLRowValues(rowEch.getTable());
                    rowValsEch.put("NOMBRE_RELANCE", ++nbRelance);
                    rowValsEch.put("DATE_LAST_RELANCE", new Date());
                    try {
                        rowValsEch.update(rowEch.getID());
                        relanceElt.getTable().getRow(id).createEmptyUpdateRow().put("ID_ECHEANCE_CLIENT", rowEch.getID()).commit();
                    }
                    catch (SQLException e1) {
                        ExceptionHandler.handle("erreur lors de la mise \u00e0 jour du nombre de relances", e1);
                    }
                }
            });
            SQLRowValues rowVals = new SQLRowValues(relanceElt.getTable());
            rowVals.put("ID_SAISIE_VENTE_FACTURE", rowMvtSource.getInt("IDSOURCE"));
            rowVals.put("MONTANT", rowEch.getObject("MONTANT"));
            rowVals.put("ID_CLIENT", rowEch.getForeignID("ID_CLIENT"));
            rowVals.put("NUMERO", NumerotationAutoSQLElement.getNextNumero(RelanceSQLElement.class, new Date()));
            editRelance.getSQLComponent().select(rowVals);
            editRelance.pack();
            editRelance.setVisible(true);
        }
    }
}

