/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import org.openconcerto.erp.core.common.element.StyleSQLElement;
import org.openconcerto.erp.core.common.ui.AjoutDeclinaisonButton;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.product.component.BatchSelectorFrame;
import org.openconcerto.erp.core.sales.product.element.LotReceptionSQLElement;
import org.openconcerto.erp.core.sales.product.element.LotSQLElement;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.model.BatchQuantity;
import org.openconcerto.erp.core.supplychain.receipt.ui.LotReceptionUIPanel;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.erp.utils.TM;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTableRenderer;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.XTableColumnModel;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;

public abstract class AbstractArticleItemTable
extends JPanel {
    protected RowValuesTable table;
    protected SQLTableElement totalHT;
    protected SQLTableElement totalHA;
    protected SQLTableElement tableElementTVA;
    protected SQLTableElement tableElementTotalTTC;
    protected SQLTableElement tableElementTotalDevise;
    protected SQLTableElement service;
    protected SQLTableElement qte;
    protected SQLTableElement ha;
    protected SQLTableElement tableElementPoidsTotal;
    protected SQLTableElement tableElementEcoID;
    protected SQLTableElement tableElementEco;
    protected SQLTableElement tableElementEcoTotal;
    protected SQLTableElement prebilan;
    protected SQLRowAccessor rowCatComptable;
    private RowValuesTableModel model;
    protected SQLRowValues defaultRowVals;
    protected List<JButton> buttons = new ArrayList<JButton>();
    protected RowValuesTableControlPanel control = null;
    private SQLRowAccessor tarif = null;
    public static String SHOW_TOTAL_ECO_CONTRIBUTION = "SHOW_TOTAL_ECO_CONTRIBUTION";
    public static String SHOW_ECO_CONTRIBUTION_COLUMNS = "SHOW_ECO_CONTRIBUTION_COLUMNS";
    private Date dateDevise = new Date();
    private boolean usedBiasedDevise = true;
    private boolean soumisInterfel = false;
    private SQLRowAccessor rowClient = null;

    public AbstractArticleItemTable() {
        this((List<JButton>)null);
    }

    public AbstractArticleItemTable(List<JButton> buttons) {
        this.buttons = buttons;
        this.init();
        this.uiInit();
    }

    public void setRowCatComptable(SQLRowAccessor rowCatComptable) {
        this.rowCatComptable = rowCatComptable;
    }

    protected abstract void init();

    protected void setModel(RowValuesTableModel model) {
        this.model = model;
    }

    public boolean isUsedBiasedDevise() {
        return this.usedBiasedDevise;
    }

    public void setUsedBiasedDevise(boolean usedBiasedDevise) {
        this.usedBiasedDevise = usedBiasedDevise;
    }

    public void setSoumisInterfel(boolean soumisInterfel) {
        this.soumisInterfel = soumisInterfel;
    }

    public boolean isSoumisInterfel() {
        return this.soumisInterfel;
    }

    public void setDateDevise(Date dateDevise) {
        if (dateDevise != null) {
            this.dateDevise = dateDevise;
            this.refreshDeviseAmount();
        }
    }

    public Date getDateDevise() {
        return this.dateDevise;
    }

    protected abstract void refreshDeviseAmount();

    protected File getConfigurationFile() {
        return new File(Configuration.getInstance().getConfDir(), "Table/" + this.getConfigurationFileName());
    }

    protected void uiInit() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        this.buttons.add(1, new AjoutDeclinaisonButton(this));
        if (this.getSQLElement().getTable().getName().equals("BON_RECEPTION_ELEMENT")) {
            this.buttons.add(1, new JButton(new AbstractAction("Lot / N\u00b0 s\u00e9rie"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFrame root = (JFrame)SwingUtilities.getRoot(AbstractArticleItemTable.this);
                    final int selectedRow = AbstractArticleItemTable.this.getRowValuesTable().getSelectedRow();
                    if (selectedRow == -1) {
                        JOptionPane.showMessageDialog(root, "Aucune ligne s\u00e9lectionn\u00e9e!");
                    } else {
                        final SQLRowValues rowValuesAt = AbstractArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(selectedRow);
                        if (rowValuesAt.isForeignEmpty("ID_ARTICLE")) {
                            JOptionPane.showMessageDialog(root, "Aucun article sur ligne s\u00e9lectionn\u00e9e!");
                        } else {
                            final Number foreignIDNumberUnite = rowValuesAt.getForeignIDNumber("ID_UNITE_VENTE");
                            JDialog d = new JDialog(root, "Lot / N\u00b0 s\u00e9rie", true);
                            final LotReceptionSQLElement elementLotR = AbstractArticleItemTable.this.getSQLElement().getDirectory().getElement(LotReceptionSQLElement.class);
                            d.getContentPane().add(new LotReceptionUIPanel(elementLotR, rowValuesAt));
                            d.pack();
                            d.setLocationRelativeTo(null);
                            d.setVisible(true);
                            d.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosed(WindowEvent e) {
                                    TableCellEditor cellEditor = AbstractArticleItemTable.this.getRowValuesTable().getCellEditor();
                                    if (cellEditor != null) {
                                        cellEditor.stopCellEditing();
                                    }
                                    Collection referentRows = rowValuesAt.getReferentRows(elementLotR.getTable().getField("ID_BON_RECEPTION_ELEMENT"));
                                    BigDecimal b = BigDecimal.ZERO;
                                    for (SQLRowValues sqlRowValues : referentRows) {
                                        if (sqlRowValues.contains("ARCHIVE") && sqlRowValues.isArchived()) continue;
                                        b = b.add(sqlRowValues.getBigDecimal("QUANTITE"));
                                    }
                                    if (b.signum() != 0) {
                                        if (foreignIDNumberUnite != null && foreignIDNumberUnite.intValue() == 2) {
                                            AbstractArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().setValueAt(b.intValue(), selectedRow, AbstractArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().getColumnForField("QTE"));
                                        } else {
                                            AbstractArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().setValueAt(1, selectedRow, AbstractArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().getColumnForField("QTE"));
                                            AbstractArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().setValueAt(b, selectedRow, AbstractArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().getColumnForField("QTE_UNITAIRE"));
                                        }
                                    }
                                }
                            });
                        }
                    }
                }
            }));
        } else if (this.getSQLElement().getTable().getName().equals("BON_DE_LIVRAISON_ELEMENT")) {
            this.buttons.add(1, new JButton(new AbstractAction("Lot / N\u00b0 s\u00e9rie"){
                private final Map<SQLRowValues, BigDecimal> mapDBQuantity;
                {
                    this.mapDBQuantity = new HashMap<SQLRowValues, BigDecimal>();
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFrame root = (JFrame)SwingUtilities.getRoot(AbstractArticleItemTable.this);
                    final int selectedRow = AbstractArticleItemTable.this.getRowValuesTable().getSelectedRow();
                    if (selectedRow == -1) {
                        JOptionPane.showMessageDialog(root, "Aucune ligne s\u00e9lectionn\u00e9e!");
                    } else {
                        final SQLRowValues rowValuesAt = AbstractArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(selectedRow);
                        if (rowValuesAt.isForeignEmpty("ID_ARTICLE")) {
                            JOptionPane.showMessageDialog(root, "Aucun article sur ligne s\u00e9lectionn\u00e9e!");
                        } else {
                            final Number foreignIDNumberUnite = rowValuesAt.getForeignIDNumber("ID_UNITE_VENTE");
                            final SQLElementDirectory directory = AbstractArticleItemTable.this.getSQLElement().getDirectory();
                            Collection referentRows = rowValuesAt.getReferentRows(AbstractArticleItemTable.this.getSQLElement().getTable().getTable("LOT_LIVRAISON").getField("ID_BON_DE_LIVRAISON_ELEMENT"));
                            try {
                                ArrayList<SQLRowValues> listRefRows = new ArrayList<SQLRowValues>();
                                for (SQLRowValues sqlRowValues : referentRows) {
                                    if (!this.mapDBQuantity.containsKey(sqlRowValues)) {
                                        this.mapDBQuantity.put(sqlRowValues, sqlRowValues.getBigDecimal("QUANTITE"));
                                    }
                                    if (sqlRowValues.contains("ARCHIVE") && sqlRowValues.isArchived()) continue;
                                    listRefRows.add(sqlRowValues);
                                }
                                List<BatchQuantity> createBatchQuantity = directory.getElement(LotSQLElement.class).createBatchQuantity(listRefRows);
                                int i = 0;
                                while (i < createBatchQuantity.size()) {
                                    SQLRowValues ref = (SQLRowValues)listRefRows.get(i);
                                    if (this.mapDBQuantity.containsKey(ref)) {
                                        createBatchQuantity.get(i).setQuantityInDB(this.mapDBQuantity.get(ref));
                                    }
                                    ++i;
                                }
                                final BatchSelectorFrame frame = new BatchSelectorFrame((Frame)root, directory, rowValuesAt.getForeign("ID_ARTICLE").asRow(), createBatchQuantity);
                                frame.setDefaultCloseOperation(2);
                                frame.pack();
                                frame.setVisible(true);
                                frame.setLocationRelativeTo(null);
                                frame.addWindowListener(new WindowAdapter(){

                                    @Override
                                    public void windowClosed(WindowEvent e) {
                                        if (frame.isCancelled()) {
                                            return;
                                        }
                                        TableCellEditor cellEditor = AbstractArticleItemTable.this.getRowValuesTable().getCellEditor();
                                        if (cellEditor != null) {
                                            cellEditor.stopCellEditing();
                                        }
                                        List<BatchQuantity> quantities = frame.getQuantities();
                                        directory.getElement(LotSQLElement.class).createLotLivraison(quantities, rowValuesAt);
                                        BigDecimal b = frame.getTotalSelectedQuantity();
                                        if (b.signum() != 0) {
                                            if (foreignIDNumberUnite != null && foreignIDNumberUnite.intValue() == 2) {
                                                AbstractArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().setValueAt(b.intValue(), selectedRow, AbstractArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().getColumnForField("QTE_LIVREE"));
                                            } else {
                                                AbstractArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().setValueAt(1, selectedRow, AbstractArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().getColumnForField("QTE_LIVREE"));
                                                AbstractArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().setValueAt(b, selectedRow, AbstractArticleItemTable.this.getRowValuesTable().getRowValuesTableModel().getColumnForField("QTE_UNITAIRE"));
                                            }
                                        }
                                    }
                                });
                            }
                            catch (SQLException e1) {
                                ExceptionHandler.handle("Erreur lors de la r\u00e9cup\u00e9ration des lots", e1);
                            }
                        }
                    }
                }
            }));
        }
        this.control = new RowValuesTableControlPanel(this.table, this.buttons);
        this.control.setOpaque(false);
        this.add((Component)this.control, c);
        ++c.gridy;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane comp = new JScrollPane(this.table);
        comp.setVerticalScrollBarPolicy(22);
        this.add((Component)comp, c);
        this.table.setDefaultRenderer(Long.class, new RowValuesTableRenderer());
    }

    protected abstract String getConfigurationFileName();

    public abstract SQLElement getSQLElement();

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public RowValuesTable getRowValuesTable() {
        return this.table;
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public SQLTableElement getPrebilanElement() {
        return this.prebilan;
    }

    public SQLTableElement getPrixTotalHTElement() {
        return this.totalHT;
    }

    public SQLTableElement getPoidsTotalElement() {
        return this.tableElementPoidsTotal;
    }

    public SQLTableElement getPrixTotalTTCElement() {
        return this.tableElementTotalTTC;
    }

    public SQLTableElement getPrixServiceElement() {
        return this.service;
    }

    public SQLTableElement getQteElement() {
        return this.qte;
    }

    public SQLTableElement getHaElement() {
        return this.ha;
    }

    public SQLTableElement getTotalHaElement() {
        return this.totalHA;
    }

    public SQLTableElement getTVAElement() {
        return this.tableElementTVA;
    }

    public SQLTableElement getTableElementTotalDevise() {
        return this.tableElementTotalDevise;
    }

    public SQLTableElement getTableElementTotalEco() {
        return this.tableElementEcoTotal;
    }

    public void deplacerDe(int inc) {
        int rowIndex = this.table.getSelectedRow();
        int dest = this.model.moveBy(rowIndex, inc);
        this.table.getSelectionModel().setSelectionInterval(dest, dest);
    }

    public float getPoidsTotal() {
        float poids = 0.0f;
        int poidsTColIndex = this.model.getColumnIndexForElement(this.tableElementPoidsTotal);
        if (poidsTColIndex >= 0) {
            int i = 0;
            while (i < this.table.getRowCount()) {
                Number tmp = (Number)this.model.getValueAt(i, poidsTColIndex);
                int level = 1;
                if (this.model.getRowValuesAt(i).getObject("NIVEAU") != null) {
                    level = this.model.getRowValuesAt(i).getInt("NIVEAU");
                }
                if (tmp != null && level == 1) {
                    poids += tmp.floatValue();
                }
                ++i;
            }
        }
        return poids;
    }

    public void refreshTable() {
        this.table.repaint();
    }

    public void createArticle(int id, SQLElement eltSource) {
        SQLElement eltArticleTable = this.getSQLElement();
        SQLTable tableArticle = this.getSQLElement().getTable().getTable("ARTICLE");
        boolean modeAvance = DefaultNXProps.getInstance().getBooleanValue("ArticleModeVenteAvance", false);
        SQLPreferences prefs = SQLPreferences.getMemCached(tableArticle.getDBRoot());
        boolean createArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.CREATE_ARTICLE_AUTO, true);
        if (createArticle) {
            SQLRowValues rowValsToFetch = new SQLRowValues(eltArticleTable.getTable());
            rowValsToFetch.putNulls(eltArticleTable.getTable().getFieldsName());
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsToFetch);
            Where w = new Where((FieldRef)eltArticleTable.getTable().getField("CODE"), "!=", (Object)"");
            w = w.and(new Where((FieldRef)eltArticleTable.getTable().getField("NOM"), "!=", (Object)""));
            Where w2 = new Where((FieldRef)eltArticleTable.getTable().getField("ID_ARTICLE"), "!=", tableArticle.getUndefinedID());
            w2 = w2.or(new Where((FieldRef)eltArticleTable.getTable().getField("ID_ARTICLE"), "!=", (Object)null));
            List<SQLRowValues> resultNonAssigned = fetcher.fetch(w.and(w2).and(new Where((FieldRef)eltArticleTable.getTable().getForeignKeys(eltSource.getTable()).iterator().next(), "=", id)));
            Set<SQLField> fields = tableArticle.getFields();
            SQLRowAccessor rowCmd = null;
            for (SQLRowAccessor sQLRowAccessor : resultNonAssigned) {
                SQLRowValues rowArticle = new SQLRowValues(tableArticle);
                Set<String> fieldsName = sQLRowAccessor.getTable().getFieldsName();
                for (SQLField field : fields) {
                    String name = field.getName();
                    if (!fieldsName.contains(name) || field.isPrimaryKey()) continue;
                    rowArticle.put(name, sQLRowAccessor.getObject(name));
                }
                if (sQLRowAccessor.getTable().getName().equals("COMMANDE_ELEMENT")) {
                    if (rowCmd == null) {
                        rowCmd = sQLRowAccessor.getTable().getForeignTable("ID_COMMANDE").getRow(id);
                    }
                    rowArticle.put("ID_FOURNISSEUR", rowCmd.getForeignIDNumber("ID_FOURNISSEUR"));
                    SQLRowValues rowValsTarifF = new SQLRowValues(rowCmd.getTable().getTable("ARTICLE_TARIF_FOURNISSEUR"));
                    rowValsTarifF.put("ID_FOURNISSEUR", rowCmd.getForeignIDNumber("ID_FOURNISSEUR"));
                    rowValsTarifF.put("ID_ARTICLE", (Object)rowArticle);
                    rowValsTarifF.put("PRIX_ACHAT", rowArticle.getObject("PRIX_METRIQUE_HA_1"));
                    rowValsTarifF.put("PRIX_ACHAT_DEVISE_F", rowArticle.getObject("PRIX_METRIQUE_HA_1"));
                    rowValsTarifF.put("QTE", 1);
                    rowValsTarifF.put("DATE_PRIX", rowCmd.getDate("DATE").getTime());
                }
                int idArt = -1;
                idArt = modeAvance ? ReferenceArticleSQLElement.getIdForCNM(rowArticle, createArticle) : ReferenceArticleSQLElement.getIdForCN(rowArticle, createArticle);
                if (!createArticle || idArt <= 1 || !sQLRowAccessor.isForeignEmpty("ID_ARTICLE")) continue;
                try {
                    sQLRowAccessor.createEmptyUpdateRow().put("ID_ARTICLE", idArt).update();
                }
                catch (SQLException e) {
                    ExceptionHandler.handle("Erreur lors de l'affectation de l'article cr\u00e9e!", e);
                }
            }
        }
    }

    public SQLRowValues getDefaultRowValues() {
        return this.defaultRowVals;
    }

    public SQLRowAccessor getTarif() {
        return this.tarif;
    }

    public void setTarif(SQLRowAccessor idTarif, boolean ask) {
        this.tarif = idTarif;
        if (this.tarif != null && this.tarif.getTable().contains("ID_DEVISE") && !this.tarif.isForeignEmpty("ID_DEVISE") && this.defaultRowVals != null) {
            this.defaultRowVals.put("ID_DEVISE", this.tarif.getForeignID("ID_DEVISE"));
        }
    }

    protected void setColumnVisible(int col, boolean visible) {
        if (col >= 0) {
            XTableColumnModel columnModel = this.table.getColumnModel();
            columnModel.setColumnVisible(columnModel.getColumnByModelIndex(col), visible);
        }
    }

    public SQLRowAccessor getRowClient() {
        return this.rowClient;
    }

    public void setClient(SQLRowAccessor rowClient, boolean ask) {
        this.rowClient = rowClient;
    }

    protected void calculTarifNomenclature() {
        if (this.model.getRowCount() == 0) {
            return;
        }
        int columnForField = this.model.getColumnForField("NIVEAU");
        if (columnForField >= 0) {
            this.checkNiveau();
            int rowCount = this.model.getRowCount();
            int niveau = 4;
            while (niveau > 1) {
                int index = rowCount - 1;
                while (index > 0) {
                    BigDecimal prixUnitHT = BigDecimal.ZERO;
                    BigDecimal prixUnitHA = BigDecimal.ZERO;
                    BigDecimal prixUnitEco = BigDecimal.ZERO;
                    boolean update = false;
                    int indexToUpdate = index;
                    int i = index;
                    while (i >= 0) {
                        indexToUpdate = i;
                        SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i);
                        int niveauCourant = niveau;
                        if (rowVals.getObject("NIVEAU") != null) {
                            niveauCourant = rowVals.getInt("NIVEAU");
                        }
                        if (niveauCourant > 0) {
                            if (niveauCourant < niveau || niveauCourant == 1) break;
                            if (niveauCourant == niveau) {
                                update = true;
                                prixUnitHT = prixUnitHT.add(rowVals.getBigDecimal("PV_HT").multiply(new BigDecimal(rowVals.getInt("QTE"))).multiply(rowVals.getBigDecimal("QTE_UNITAIRE")));
                                prixUnitHA = prixUnitHA.add(rowVals.getBigDecimal("PA_HT").multiply(new BigDecimal(rowVals.getInt("QTE"))).multiply(rowVals.getBigDecimal("QTE_UNITAIRE")));
                                BigDecimal eco = rowVals.getBigDecimal("ECO_CONTRIBUTION");
                                if (eco != null) {
                                    prixUnitEco = prixUnitEco.add(eco.multiply(new BigDecimal(rowVals.getInt("QTE"))).multiply(rowVals.getBigDecimal("QTE_UNITAIRE")));
                                }
                            }
                        }
                        --i;
                    }
                    if (update) {
                        int columnForFieldEco;
                        int columnForFieldPVht1;
                        int columnForFieldHA = this.model.getColumnForField("PRIX_METRIQUE_HA_1");
                        if (columnForFieldHA >= 0) {
                            this.model.setValueAt(prixUnitHA, indexToUpdate, columnForFieldHA);
                        }
                        if ((columnForFieldPVht1 = this.model.getColumnForField("PRIX_METRIQUE_VT_1")) >= 0) {
                            this.model.setValueAt(prixUnitHT, indexToUpdate, columnForFieldPVht1);
                        }
                        if ((columnForFieldEco = this.model.getColumnForField("ECO_CONTRIBUTION")) >= 0) {
                            this.model.setValueAt(prixUnitEco, indexToUpdate, columnForFieldEco);
                        }
                    }
                    index = indexToUpdate - 1;
                }
                --niveau;
            }
        }
    }

    private void checkNiveau() {
        int n = this.model.getRowCount();
        int columnForField = this.model.getColumnForField("NIVEAU");
        if (n > 0 && columnForField >= 0) {
            int start = 0;
            int i = 0;
            while (i < n) {
                start = i;
                SQLRowValues rowVals = this.model.getRowValuesAt(i);
                if (rowVals.getObject("NIVEAU") == null || rowVals.getInt("NIVEAU") >= 1) {
                    this.model.setValueAt(1, i, columnForField);
                    break;
                }
                ++i;
            }
            int lastGoodPrevious = this.model.getRowValuesAt(start).getInt("NIVEAU");
            int i2 = start + 1;
            while (i2 < n) {
                int niveau;
                SQLRowValues rowVals = this.model.getRowValuesAt(i2);
                if (rowVals.getObject("NIVEAU") == null) {
                    this.model.setValueAt(1, i2, columnForField);
                }
                if ((niveau = rowVals.getInt("NIVEAU")) != -1) {
                    if (niveau - lastGoodPrevious > 1) {
                        this.model.setValueAt(lastGoodPrevious, i2, columnForField);
                    }
                    lastGoodPrevious = niveau;
                }
                ++i2;
            }
        }
    }

    public List<SQLRowValues> getRowValuesAtLevel(int level) {
        int rowCount = this.model.getRowCount();
        ArrayList<SQLRowValues> result = new ArrayList<SQLRowValues>(rowCount);
        int i = 0;
        while (i < rowCount) {
            SQLRowValues row = this.model.getRowValuesAt(i);
            if (row.getObject("NIVEAU") == null || row.getInt("NIVEAU") == level) {
                result.add(row);
            }
            ++i;
        }
        return result;
    }

    public AutoCompletionManager getCodeCompletionManager() {
        return null;
    }

    public void expandNomenclature(int index, AutoCompletionManager m, EXPAND_TYPE type) {
        SQLRowValues rowValsLineFather = this.model.getRowValuesAt(index);
        if (!rowValsLineFather.isForeignEmpty("ID_ARTICLE")) {
            int a;
            SQLRowValues rowValsLineNext;
            int a1;
            if (type == EXPAND_TYPE.EXPAND ? (a1 = JOptionPane.showConfirmDialog(this.table, TM.tr((String)"product.bom.expand.warning", (Object[])new Object[0]), "Warning", 2)) != 0 : type == EXPAND_TYPE.FLAT && (a1 = JOptionPane.showConfirmDialog(this.table, TM.tr((String)"product.bom.flatexpand.warning", (Object[])new Object[0]), "Warning", 2)) != 0) {
                return;
            }
            int fatherLevel = rowValsLineFather.getInt("NIVEAU");
            if (index < this.table.getRowCount() - 1 && fatherLevel < (rowValsLineNext = this.model.getRowValuesAt(index + 1)).getInt("NIVEAU") && (a = JOptionPane.showConfirmDialog(this.table, "Cette ligne contient d\u00e9j\u00e0 des \u00e9l\u00e9ments d'un niveau inf\u00e9rieur. \u00cates vous s\u00fbr de vouloir \u00e9clater la nomenclature?", "Nomenclature", 0)) == 1) {
                return;
            }
            SQLRowAccessor rowValsArticleFather = rowValsLineFather.getForeign("ID_ARTICLE");
            Collection<? extends SQLRowAccessor> elts = rowValsArticleFather.getReferentRows(rowValsArticleFather.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT"));
            if (elts.size() == 0) {
                JOptionPane.showMessageDialog(this.table, "Cet article ne contient aucun \u00e9l\u00e9ment.");
            }
            ArrayList<? extends SQLRowAccessor> eltsList = new ArrayList<SQLRowAccessor>(elts);
            if (type == EXPAND_TYPE.FLAT) {
                this.model.putValue(-1, index, "NIVEAU");
            }
            Set<String> fieldsFrom = m.getFieldsFrom();
            fieldsFrom.remove("POURCENT_REMISE");
            int i = eltsList.size() - 1;
            while (i >= 0) {
                SQLRowAccessor sqlRowArticleChildElement = (SQLRowAccessor)eltsList.get(i);
                SQLRowAccessor foreignArticleChild = sqlRowArticleChildElement.getForeign("ID_ARTICLE");
                if (foreignArticleChild != null && !foreignArticleChild.isUndefined()) {
                    SQLRowValues row2Insert = new SQLRowValues(this.model.getDefaultRowValues());
                    m.fillRowValues(foreignArticleChild, fieldsFrom, row2Insert);
                    row2Insert.put("ID_ARTICLE", foreignArticleChild.getID());
                    row2Insert.put("CODE", foreignArticleChild.getObject("CODE"));
                    row2Insert.put("NOM", foreignArticleChild.getObject("NOM"));
                    if (type == EXPAND_TYPE.FLAT) {
                        row2Insert.put("QTE", sqlRowArticleChildElement.getInt("QTE") * rowValsLineFather.getInt("QTE"));
                    } else {
                        row2Insert.put("QTE", sqlRowArticleChildElement.getInt("QTE"));
                    }
                    if (row2Insert.getTable().contains("POURCENT_REMISE")) {
                        row2Insert.put("POURCENT_REMISE", BigDecimal.ZERO);
                        row2Insert.put("MONTANT_REMISE", BigDecimal.ZERO);
                    }
                    if (type == EXPAND_TYPE.EXPAND) {
                        row2Insert.put("NIVEAU", fatherLevel + 1);
                    } else if (type == EXPAND_TYPE.VIEW_ONLY) {
                        row2Insert.put("NIVEAU", -1);
                    } else if (type == EXPAND_TYPE.FLAT) {
                        row2Insert.put("NIVEAU", 1);
                    }
                    if (type != EXPAND_TYPE.VIEW_ONLY) {
                        BigDecimal r;
                        float taux;
                        Float resultTaux;
                        BigDecimal resultTotalHT;
                        if (row2Insert.getTable().contains("T_PA_TTC")) {
                            row2Insert.put("PA_HT", row2Insert.getObject("PRIX_METRIQUE_HA_1"));
                            resultTotalHT = row2Insert.getBigDecimal("PA_HT").multiply(new BigDecimal(row2Insert.getInt("QTE")));
                            row2Insert.put("T_PA_HT", resultTotalHT);
                            resultTaux = TaxeCache.getCache().getTauxFromId(row2Insert.getForeignID("ID_TAXE"));
                            if (resultTaux == null) {
                                SQLRow rowTax = TaxeCache.getCache().getFirstTaxe();
                                resultTaux = Float.valueOf(rowTax.getFloat("TAUX"));
                            }
                            taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                            r = resultTotalHT.multiply(BigDecimal.valueOf(taux).movePointLeft(2).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION);
                            row2Insert.put("T_PA_TTC", r);
                        } else {
                            row2Insert.put("PV_HT", row2Insert.getObject("PRIX_METRIQUE_VT_1"));
                            resultTotalHT = row2Insert.getBigDecimal("PV_HT").multiply(new BigDecimal(row2Insert.getInt("QTE")));
                            row2Insert.put("T_PV_HT", resultTotalHT);
                            resultTaux = TaxeCache.getCache().getTauxFromId(row2Insert.getForeignID("ID_TAXE"));
                            if (resultTaux == null) {
                                SQLRow rowTax = TaxeCache.getCache().getFirstTaxe();
                                resultTaux = Float.valueOf(rowTax.getFloat("TAUX"));
                            }
                            taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                            r = resultTotalHT.multiply(BigDecimal.valueOf(taux).movePointLeft(2).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION);
                            row2Insert.put("T_PV_TTC", r);
                        }
                    }
                    Map<String, Integer> allStyleByName = this.getSQLElement().getDirectory().getElement(StyleSQLElement.class).getAllStyleByName();
                    row2Insert.put("ID_STYLE", allStyleByName.get("Composant"));
                    this.model.addRowAt(index + 1, row2Insert);
                }
                --i;
            }
        }
    }

    protected List<AbstractAction> getAdditionnalMouseAction(int rowIndex) {
        return Collections.emptyList();
    }

    public void insertFromReliquat(List<SQLRowValues> reliquats) {
        for (SQLRowValues reliquat : reliquats) {
            SQLRowValues row2Insert = new SQLRowValues(this.getRowValuesTable().getRowValuesTableModel().getDefaultRowValues());
            SQLRow article = reliquat.getForeign("ID_ARTICLE").asRow();
            row2Insert.put("ID_ARTICLE", ((SQLRowAccessor)article).getID());
            row2Insert.put("CODE", ((SQLRowAccessor)article).getObject("CODE"));
            row2Insert.put("NOM", ((SQLRowAccessor)article).getObject("NOM"));
            row2Insert.put("QTE", reliquat.getObject("QTE"));
            row2Insert.put("QTE_UNITAIRE", reliquat.getObject("QTE_UNITAIRE"));
            row2Insert.put("ID_UNITE_VENTE", reliquat.getForeignID("ID_UNITE_VENTE"));
            this.getRowValuesTable().getRowValuesTableModel().addRowAt(0, row2Insert);
        }
    }

    public static enum EXPAND_TYPE {
        VIEW_ONLY,
        EXPAND,
        FLAT;

    }
}

