/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SwingThrottle {
    private Timer timer;
    private Runnable runnable;

    public SwingThrottle(int delayInMs, final Runnable runnable) {
        this.runnable = runnable;
        this.timer = new Timer(delayInMs, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingThrottle.this.timer.stop();
                SwingUtilities.invokeLater(runnable);
            }
        });
    }

    public synchronized void execute() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalArgumentException("must be called in EDT");
        }
        this.timer.restart();
    }

    public synchronized void executeNow() {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.runnable.run();
        }
    }
}

