/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.erp.generationDoc.AbstractJOOReportsSheet;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.utils.CollectionUtils;

public class CourrierClientSheet
extends AbstractJOOReportsSheet {
    private SQLRow rowCourrier;
    public static final String TEMPLATE_ID = "Courrier";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationCourrier";

    public CourrierClientSheet(SQLRow row) {
        this.rowCourrier = row;
        Date d = (Date)this.rowCourrier.getObject("DATE");
        String year = this.yearFormat.format(d);
        SQLRowAccessor foreignModele = this.rowCourrier.getNonEmptyForeign("ID_MODELE_COURRIER_CLIENT");
        String modele = "Courrier.odt";
        if (foreignModele != null && foreignModele.getString("TEMPLATE_NAME").trim().length() > 0) {
            modele = foreignModele.getString("TEMPLATE_NAME");
        }
        this.init(year, modele, "CourrierPrinter");
    }

    @Override
    public String getDefaultTemplateID() {
        return TEMPLATE_ID;
    }

    @Override
    public String getDefaultLocationProperty() {
        return TEMPLATE_PROPERTY_NAME;
    }

    @Override
    protected Map<String, Object> createMap() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        SQLRow rowModele = this.rowCourrier.getForeign("ID_MODELE_COURRIER_CLIENT");
        String contenu = rowModele.getString("CONTENU");
        m.put("Corps", contenu);
        m.put("Objet", this.rowCourrier.getString("NOM"));
        m.put("Date", this.dateFormat.format(this.rowCourrier.getDate("DATE").getTime()));
        SQLRow rowContactCom = this.rowCourrier.getForeign("ID_CONTACT");
        if (rowContactCom != null) {
            SQLRowAccessor rowTitre = rowContactCom.getNonEmptyForeign("ID_TITRE_PERSONNEL");
            String correspondant = rowTitre.getString("NOM");
            String contact = rowTitre.getString("NOM");
            contact = String.valueOf(contact) + " " + rowContactCom.getString("PRENOM");
            contact = String.valueOf(contact) + " " + rowContactCom.getString("NOM");
            m.put("Correspondant", correspondant);
            m.put("Contact", contact);
            m.put("contactNom", rowContactCom.getString("NOM"));
            m.put("contactPrenom", rowContactCom.getString("PRENOM"));
            m.put("contactFonction", rowContactCom.getString("FONCTION"));
            if (rowTitre != null) {
                m.put("contactTitre", rowTitre.getString("NOM"));
                m.put("contactTitre.code", rowTitre.getString("CODE"));
            }
        }
        SQLRow rowClient = this.rowCourrier.getForeign("ID_CLIENT");
        m.put("clientFormejuridique", rowClient.getString("FORME_JURIDIQUE"));
        m.put("clientSiret", rowClient.getString("SIRET"));
        if (rowClient.getTable().contains("RCS")) {
            m.put("clientRcs", rowClient.getString("RCS"));
        }
        if (rowClient.getTable().contains("APE")) {
            m.put("clientApe", rowClient.getString("APE"));
        }
        if (rowClient.getTable().contains("CAPITAL")) {
            m.put("clientCapital", rowClient.getString("CAPITAL"));
        }
        m.put("clientResponsable", rowClient.getString("RESPONSABLE"));
        m.put("clientNom", rowClient.getString("NOM"));
        m.put("clientMail", rowClient.getString("MAIL"));
        m.put("clientTelephone", rowClient.getString("TEL"));
        SQLRow rowAdresseClient = rowClient.getForeignRow("ID_ADRESSE");
        m.put("clientDestinataire", rowAdresseClient.getString("DEST"));
        m.put("clientAdresse", rowAdresseClient.getString("RUE"));
        m.put("clientCodePostal", rowAdresseClient.getString("CODE_POSTAL"));
        String villeCli = rowAdresseClient.getString("VILLE");
        Object cedexCli = rowAdresseClient.getObject("CEDEX");
        boolean hasCedexCli = rowAdresseClient.getBoolean("HAS_CEDEX");
        if (hasCedexCli) {
            villeCli = String.valueOf(villeCli) + " CEDEX";
            if (cedexCli != null && cedexCli.toString().trim().length() > 0) {
                villeCli = String.valueOf(villeCli) + " " + cedexCli.toString().trim();
            }
        }
        m.put("clientVille", villeCli);
        int idAdresse = this.rowCourrier.getInt("ID_ADRESSE");
        if (idAdresse > 1) {
            rowAdresseClient = this.rowCourrier.getForeignRow("ID_ADRESSE");
            m.put("clientFormejuridique", rowClient.getString("FORME_JURIDIQUE"));
            m.put("clientDestinataire", rowAdresseClient.getString("DEST"));
            m.put("clientAdresse", rowAdresseClient.getString("RUE"));
            m.put("clientCodePostal", rowAdresseClient.getString("CODE_POSTAL"));
            villeCli = rowAdresseClient.getString("VILLE");
            cedexCli = rowAdresseClient.getObject("CEDEX");
            hasCedexCli = rowAdresseClient.getBoolean("HAS_CEDEX");
            if (hasCedexCli) {
                villeCli = String.valueOf(villeCli) + " CEDEX";
                if (cedexCli != null && cedexCli.toString().trim().length() > 0) {
                    villeCli = String.valueOf(villeCli) + " " + cedexCli.toString().trim();
                }
            }
            m.put("clientVille", villeCli);
        }
        System.err.println(CollectionUtils.join(m.keySet(), "\n"));
        return m;
    }

    @Override
    protected String getName() {
        return "Courrier_" + this.rowCourrier.getString("NUMERO");
    }
}

