/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.report;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.openconcerto.erp.core.finance.accounting.report.GrandLivrePDF;
import org.openconcerto.erp.core.supplychain.stock.report.SQLRowValuesTree;
import org.openconcerto.erp.core.supplychain.stock.report.SQLRowValuesTreeNode;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;

public class StockReportPDF {
    private static final int LINE_HEIGHT = 10;
    private static final float COL_1_SIZE = 80.0f;
    private static final float COL_2_SIZE = 300.0f;
    private static final float COL_3_SIZE = 30.0f;
    private static final float COL_4_SIZE = 40.0f;
    private static final float COL_5_SIZE = 50.0f;
    private static final float COL_1_X = 50.0f;
    private static final float COL_2_X = 130.0f;
    private static final float COL_3_X = 430.0f;
    private static final float COL_4_X = 460.0f;
    private static final float COL_5_X = 500.0f;
    private final PDDocument doc;
    private final List<SQLRow> etatsStock = new ArrayList<SQLRow>();
    private final String companyName;
    private final String title;
    private int y = 0;
    private PDPageContentStream content;
    private final DecimalFormat decimalFormat = new DecimalFormat("#,##0.00", DecimalFormatSymbols.getInstance(Locale.FRANCE));
    private final DecimalFormat decimalFormatQuantity = new DecimalFormat("#,##0.##", DecimalFormatSymbols.getInstance(Locale.FRANCE));
    private Map<SQLRow, BigDecimal> totaux = new HashMap<SQLRow, BigDecimal>();

    public StockReportPDF(String companyName, String title) throws IOException {
        this.companyName = companyName;
        this.title = title;
        this.doc = new PDDocument();
        PDPage page = new PDPage(PDRectangle.A4);
        this.doc.addPage(page);
        this.content = new PDPageContentStream(this.doc, page);
        this.y = this.drawHeader(true, true);
    }

    private int drawHeader(boolean full, boolean columns) throws IOException {
        this.y = 795;
        this.content.beginText();
        this.content.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 14.0f);
        this.content.newLineAtOffset(40.0f, (float)this.y);
        this.content.showText("INVENTAIRE    " + StringUtils.cleanPDFString(this.companyName.toUpperCase()));
        this.content.endText();
        this.y -= 17;
        if (full) {
            this.content.beginText();
            this.content.setFont((PDFont)PDType1Font.HELVETICA, 12.0f);
            this.content.newLineAtOffset(40.0f, (float)this.y);
            this.content.showText(StringUtils.cleanPDFString(this.title));
            this.content.endText();
            this.y -= 20;
        }
        this.content.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 7.0f);
        if (columns) {
            this.content.beginText();
            this.content.newLineAtOffset(55.0f, (float)this.y);
            this.content.showText("CODE");
            this.content.endText();
            this.content.beginText();
            this.content.newLineAtOffset(130.0f, (float)this.y);
            this.content.showText("ARTICLE");
            this.content.endText();
            StockReportPDF.drawRightAlign(this.content, 430.0f, this.y, 30.0f, "QUANTITE");
            StockReportPDF.drawRightAlign(this.content, 460.0f, this.y, 40.0f, "PRIX U.");
            StockReportPDF.drawRightAlign(this.content, 500.0f, this.y, 50.0f, "TOTAL");
        }
        this.y -= 4;
        this.content.setStrokingColor(Color.BLACK);
        this.content.setLineWidth(1.0f);
        this.content.moveTo(46.0f, (float)this.y);
        this.content.lineTo(554.0f, (float)this.y);
        this.content.stroke();
        return this.y;
    }

    private static void drawRightAlign(PDPageContentStream content, float x, float y, float width, String text) throws IOException {
        content.beginText();
        float w = PDType1Font.HELVETICA.getStringWidth(StringUtils.cleanPDFString(text)) / 1000.0f * 7.0f;
        content.newLineAtOffset(x + width - w, y);
        content.showText(StringUtils.cleanPDFString(text));
        content.endText();
    }

    private void drawFamilleName(String name) throws IOException {
        this.y -= 10;
        this.content.setFont((PDFont)PDType1Font.HELVETICA_BOLD, 7.0f);
        this.content.beginText();
        this.content.newLineAtOffset(50.0f, (float)this.y);
        this.content.showText(StringUtils.cleanPDFString(name));
        this.content.endText();
    }

    private void fillDeclinaisons(DBRoot root, Map<String, Map<Integer, Tuple2<String, BigDecimal>>> mapDeclinaisons) {
        ArrayList<String> tablesDeclinaisons = new ArrayList<String>();
        ArrayList<String> declinaisonsFieldNames = new ArrayList<String>();
        SQLTable tableArticle = root.getTable("ARTICLE");
        for (SQLField f : tableArticle.getFields()) {
            if (!f.getName().startsWith("ID_ARTICLE_DECLINAISON_")) continue;
            declinaisonsFieldNames.add(f.getName());
            tablesDeclinaisons.add(f.getName().substring("ID_".length()));
        }
        for (String table : tablesDeclinaisons) {
            SQLTable t = tableArticle.getTable(table);
            SQLSelect selDecl = new SQLSelect();
            selDecl.addSelect(t.getKey());
            selDecl.addSelect(t.getField("NOM"));
            selDecl.addSelect(t.getField("ORDRE"));
            HashMap<Integer, Tuple2<String, BigDecimal>> m = new HashMap<Integer, Tuple2<String, BigDecimal>>();
            mapDeclinaisons.put("ID_" + table, m);
            for (SQLRow row : SQLRowListRSH.execute(selDecl)) {
                m.put(row.getID(), Tuple2.create(row.getString("NOM"), row.getBigDecimal("ORDRE")));
            }
        }
    }

    private void drawLine(String code, String article, BigDecimal qte, BigDecimal prixUnitaire, BigDecimal total) throws IOException {
        String s = StringUtils.splitString(article, 70);
        List<String> parts = StringUtils.fastSplitTrimmed(s, '\n');
        this.y -= 10;
        if (this.y - 10 * parts.size() < 50) {
            PDPage page = new PDPage(PDRectangle.A4);
            this.doc.addPage(page);
            if (this.content != null) {
                this.content.close();
            }
            this.content = new PDPageContentStream(this.doc, page);
            this.y = this.drawHeader(false, true);
            this.y -= 10;
            this.y -= 10;
        }
        this.content.setFont((PDFont)PDType1Font.HELVETICA, 7.0f);
        if (code != null) {
            this.content.beginText();
            this.content.newLineAtOffset(50.0f, (float)this.y);
            this.content.showText(StringUtils.cleanPDFString(code));
            this.content.endText();
        }
        StockReportPDF.drawRightAlign(this.content, 430.0f, this.y, 30.0f, this.decimalFormatQuantity.format(qte));
        StockReportPDF.drawRightAlign(this.content, 460.0f, this.y, 40.0f, this.decimalFormat.format(prixUnitaire));
        StockReportPDF.drawRightAlign(this.content, 500.0f, this.y, 50.0f, this.decimalFormat.format(total));
        for (String part : parts) {
            this.content.beginText();
            this.content.newLineAtOffset(130.0f, (float)this.y);
            this.content.showText(StringUtils.cleanPDFString(part));
            this.content.endText();
            this.y -= 10;
        }
        this.y += 10;
        this.content.setLineWidth(0.5f);
        this.content.setStrokingColor(Color.LIGHT_GRAY);
        this.content.moveTo(46.0f, (float)this.y - 2.0f);
        this.content.lineTo(554.0f, (float)this.y - 2.0f);
        this.content.stroke();
    }

    public void addStockDepot(SQLRow rowEtatStock) throws IOException {
        this.etatsStock.add(rowEtatStock);
        DBRoot root = rowEtatStock.getTable().getDBRoot();
        if (this.etatsStock.size() > 1) {
            PDPage page = new PDPage(PDRectangle.A4);
            this.doc.addPage(page);
            if (this.content != null) {
                this.content.close();
            }
            this.content = new PDPageContentStream(this.doc, page);
            this.y = this.drawHeader(false, true);
        }
        SQLTable tDepot = root.getTable("DEPOT_STOCK");
        SQLTable tFamilleArtice = root.getTable("FAMILLE_ARTICLE");
        SQLRow rDepot = tDepot.getRow(rowEtatStock.getInt("ID_DEPOT_STOCK"));
        this.y -= 20;
        this.content.setFont((PDFont)PDType1Font.HELVETICA, 10.0f);
        this.content.beginText();
        this.content.newLineAtOffset(50.0f, (float)this.y);
        this.content.showText(StringUtils.cleanPDFString("D\u00c9P\u00d4T : " + rDepot.getString("NOM")));
        this.content.endText();
        this.y -= 10;
        SQLTable tEtatStockElement = root.getTable("ETAT_STOCK_ELEMENT");
        SQLRowValues rElements = new SQLRowValues(tEtatStockElement);
        SQLRowValues putRowValues = rElements.putRowValues("ID_ARTICLE");
        putRowValues.putNulls("ID_FAMILLE_ARTICLE");
        for (SQLField field : putRowValues.getTable().getContentFields()) {
            if (!field.getName().startsWith("ID_ARTICLE_DECLINAISON_")) continue;
            putRowValues.put(field.getName(), null);
        }
        rElements.putNulls("PA", "T_PA", "QTE", "CODE", "NOM");
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rElements);
        List<SQLRowValues> elements = fetcher.fetch(new Where((FieldRef)tEtatStockElement.getField("ID_ETAT_STOCK"), "=", rowEtatStock.getID()).and(new Where((FieldRef)tEtatStockElement.getField("QTE"), ">", (Object)BigDecimal.ZERO)));
        Collections.sort(elements, new Comparator<SQLRowValues>(){

            @Override
            public int compare(SQLRowValues o1, SQLRowValues o2) {
                BigDecimal qte1 = o1.getBigDecimal("PA");
                BigDecimal qte2 = o2.getBigDecimal("PA");
                if (qte1.signum() == 0 && qte2.signum() == 0 || qte1.signum() != 0 && qte2.signum() != 0) {
                    return o1.getString("NOM").compareTo(o2.getString("NOM"));
                }
                if (qte1.signum() == 0) {
                    return 1;
                }
                return -1;
            }
        });
        HashMap<Number, List<SQLRowValues>> mapFamilleElement = new HashMap<Number, List<SQLRowValues>>();
        for (SQLRowValues e : elements) {
            Number idFamille = e.getForeign("ID_ARTICLE").getForeignIDNumber("ID_FAMILLE_ARTICLE");
            ArrayList<SQLRowValues> l = (ArrayList<SQLRowValues>)mapFamilleElement.get(idFamille);
            if (l == null) {
                l = new ArrayList<SQLRowValues>();
                mapFamilleElement.put(idFamille, l);
            }
            l.add(e);
        }
        SQLRowValues rFamille = new SQLRowValues(root.getTable("FAMILLE_ARTICLE"));
        rFamille.putNulls("NOM", "ID_FAMILLE_ARTICLE_PERE");
        List<SQLRowValues> familles = SQLRowValuesListFetcher.create(rFamille).fetch();
        System.out.println("StockReportPDF.addStockDepot()" + familles.size() + " familles");
        SQLRowValuesTree tree = new SQLRowValuesTree(familles, "ID_FAMILLE_ARTICLE_PERE");
        tree.dump(System.out);
        HashMap<String, Map<Integer, Tuple2<String, BigDecimal>>> mapDeclinaison = new HashMap<String, Map<Integer, Tuple2<String, BigDecimal>>>();
        this.fillDeclinaisons(tDepot.getDBRoot(), mapDeclinaison);
        BigDecimal t = BigDecimal.ZERO;
        for (SQLRowValues e : elements) {
            Number idFamille = e.getForeign("ID_ARTICLE").getForeignIDNumber("ID_FAMILLE_ARTICLE");
            if (idFamille.intValue() != tFamilleArtice.getUndefinedID()) continue;
            this.drawEtatStockElement(e, mapDeclinaison);
            t = t.add(e.getBigDecimal("T_PA"));
        }
        this.totaux.put(rowEtatStock, t);
        List<SQLRowValuesTreeNode> roots = tree.getChildren();
        Comparator<SQLRowValuesTreeNode> comparatorFamille = new Comparator<SQLRowValuesTreeNode>(){

            @Override
            public int compare(SQLRowValuesTreeNode o1, SQLRowValuesTreeNode o2) {
                return o1.getSQLRowValues().getString("NOM").compareToIgnoreCase(o2.getSQLRowValues().getString("NOM"));
            }
        };
        Collections.sort(roots, comparatorFamille);
        for (SQLRowValuesTreeNode f : roots) {
            this.drawFamilleNode(mapFamilleElement, f, mapDeclinaison);
        }
    }

    private void drawFamilleNode(Map<Number, List<SQLRowValues>> mapFamilleElement, SQLRowValuesTreeNode f, Map<String, Map<Integer, Tuple2<String, BigDecimal>>> mapDeclinaison) throws IOException {
        List<SQLRowValues> list;
        if (f.getChildrenCount() > 0) {
            this.drawFamilleName(f.getSQLRowValues().getString("NOM").toUpperCase());
        }
        if ((list = mapFamilleElement.get(f.getSQLRowValues().getIDNumber())) != null) {
            for (SQLRowValues e : list) {
                this.drawEtatStockElement(e, mapDeclinaison);
            }
        }
        for (SQLRowValuesTreeNode n : f.getChildren()) {
            this.drawFamilleNode(mapFamilleElement, n, mapDeclinaison);
        }
    }

    private void drawEtatStockElement(SQLRowValues e, Map<String, Map<Integer, Tuple2<String, BigDecimal>>> mapDeclinaison) throws IOException {
        String detailsDeclString;
        String code = e.getString("CODE");
        String article = e.getString("NOM");
        StringBuilder detailsDeclinaison = new StringBuilder();
        SQLRowAccessor nonEmptyForeignArticle = e.getNonEmptyForeign("ID_ARTICLE");
        if (nonEmptyForeignArticle != null) {
            for (String fieldDecl : mapDeclinaison.keySet()) {
                String declinaisonName;
                Number nonEmptyForeignDecl;
                if (nonEmptyForeignArticle.getObject(fieldDecl) == null || (nonEmptyForeignDecl = nonEmptyForeignArticle.getNonEmptyForeignIDNumber(fieldDecl)) == null || (declinaisonName = mapDeclinaison.get(fieldDecl).get(nonEmptyForeignDecl).get0()).trim().length() <= 0) continue;
                detailsDeclinaison.append(fieldDecl.substring("ID_ARTICLE_DECLINAISON_".length()));
                detailsDeclinaison.append(" : ");
                detailsDeclinaison.append(declinaisonName);
                detailsDeclinaison.append("     ");
            }
        }
        if ((detailsDeclString = detailsDeclinaison.toString().trim()).length() > 0) {
            article = String.valueOf(article) + "\n" + detailsDeclString;
        }
        BigDecimal qte = e.getBigDecimal("QTE");
        BigDecimal prixUnitaire = e.getBigDecimal("PA");
        BigDecimal total = e.getBigDecimal("T_PA");
        this.drawLine(code, article, qte, prixUnitaire, total);
    }

    public void savePDF(File f) throws IOException {
        int length;
        PDPage page = new PDPage(PDRectangle.A4);
        this.doc.addPage(page);
        if (this.content != null) {
            this.content.close();
        }
        this.content = new PDPageContentStream(this.doc, page);
        this.drawHeader(false, false);
        this.y -= 10;
        this.content.setFont((PDFont)PDType1Font.HELVETICA, 10.0f);
        for (SQLRow r : this.etatsStock) {
            BigDecimal total = this.totaux.get(r);
            SQLTable tDepot = r.getTable().getTable("DEPOT_STOCK");
            SQLRow rDepot = tDepot.getRow(r.getInt("ID_DEPOT_STOCK"));
            this.y -= 20;
            this.content.setFont((PDFont)PDType1Font.HELVETICA, 10.0f);
            this.content.beginText();
            this.content.newLineAtOffset(50.0f, (float)this.y);
            this.content.showText(StringUtils.cleanPDFString("TOTAL D\u00c9P\u00d4T : " + rDepot.getString("NOM") + " : " + this.decimalFormat.format(total) + " EUR"));
            this.content.endText();
        }
        this.content.close();
        InputStream sImage = GrandLivrePDF.class.getResourceAsStream("OpenConcerto_2000px.png");
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while ((length = sImage.read(buf)) > 0) {
            bOut.write(buf, 0, length);
        }
        sImage.close();
        bOut.close();
        float ratio = 20.0f;
        int pageCount = this.doc.getNumberOfPages();
        int index = 0;
        while (index < pageCount) {
            PDPage currentPage = this.doc.getPage(index);
            this.content = new PDPageContentStream(this.doc, currentPage, PDPageContentStream.AppendMode.APPEND, true, true);
            if (index == 0 || index == pageCount - 1) {
                PDImageXObject pdImage = PDImageXObject.createFromByteArray((PDDocument)this.doc, (byte[])bOut.toByteArray(), (String)"openconcerto.png");
                float h = (float)pdImage.getHeight() / 20.0f;
                this.content.drawImage(pdImage, 40.0f, 10.0f, (float)pdImage.getWidth() / 20.0f, h);
            }
            this.content.beginText();
            this.content.setFont((PDFont)PDType1Font.HELVETICA, 10.0f);
            this.content.newLineAtOffset(500.0f, 20.0f);
            this.content.showText("Page " + (index + 1) + " / " + pageCount);
            this.content.endText();
            this.content.close();
            ++index;
        }
        this.doc.save(f);
    }
}

