/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.action;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import org.openconcerto.erp.action.CreateIListFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.common.ui.ListeViewPanel;
import org.openconcerto.erp.core.sales.order.element.CommandeClientElementSQLElement;
import org.openconcerto.erp.core.sales.product.ui.QteAcommanderRenderer;
import org.openconcerto.erp.core.supplychain.stock.action.ListeDesStocksAction;
import org.openconcerto.erp.core.supplychain.stock.element.StockSQLElement;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.IListPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.cc.ITransformer;

public class ListeDesElementsACommanderClientAction
extends CreateIListFrameAbstractAction<CommandeClientElementSQLElement> {
    public ListeDesElementsACommanderClientAction(ComptaPropsConfiguration conf) {
        super(conf, CommandeClientElementSQLElement.class);
    }

    protected String getPanelVariant() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected SQLTableModelSource createTableSource() {
        SQLTableModelSource tableSource = super.createTableSource();
        final CommandeClientElementSQLElement eltCmd = (CommandeClientElementSQLElement)this.getElem();
        tableSource.getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                String quoteQteL = new SQLName(input.getAlias(eltCmd.getTable()).getAlias(), "QTE_LIVREE").quote();
                String quoteQte = new SQLName(input.getAlias(eltCmd.getTable()).getAlias(), "QTE").quote();
                String quoteQteU = new SQLName(input.getAlias(eltCmd.getTable()).getAlias(), "QTE_UNITAIRE").quote();
                Where w = Where.createRaw(String.valueOf(quoteQteL) + " < (" + quoteQte + "*" + quoteQteU + ")", eltCmd.getTable().getField("QTE_LIVREE"), eltCmd.getTable().getField("QTE"), eltCmd.getTable().getField("QTE_UNITAIRE")).or(Where.isNull(input.getAlias(eltCmd.getTable()).getField("QTE_LIVREE")));
                w = w.and(new Where((FieldRef)eltCmd.getTable().getField("LIVRE_FORCED"), "=", (Object)Boolean.FALSE));
                input.setWhere(w);
                return input;
            }
        });
        SQLPreferences prefs = SQLPreferences.getMemCached(eltCmd.getTable().getDBRoot());
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_MULTI_DEPOT, false)) {
            BaseSQLTableModelColumn colStockD = new BaseSQLTableModelColumn("D\u00e9p\u00f4t", String.class){

                @Override
                protected Object show_(SQLRowAccessor r) {
                    SQLRowAccessor foreign2;
                    SQLRowAccessor foreign = r.getForeign("ID_ARTICLE");
                    if (foreign != null && !foreign.isUndefined() && (foreign2 = StockSQLElement.getStockFetched(r)) != null && !foreign2.isUndefined()) {
                        return foreign2.getForeign("ID_DEPOT_STOCK").getString("NOM");
                    }
                    return "";
                }

                @Override
                public Set<FieldPath> getPaths() {
                    Path p = new Path(eltCmd.getTable());
                    p = (Path)p.add(p.getLast().getField("ID_ARTICLE"));
                    Path p2 = (Path)p.add(p.getLast().getTable("STOCK").getField("ID_ARTICLE"));
                    Path p3 = (Path)p2.add(p2.getLast().getField("ID_DEPOT_STOCK"));
                    Path p4 = (Path)p.add(p.getLast().getField("ID_DEPOT_STOCK"));
                    return CollectionUtils.createSet(new FieldPath(p3, "NOM"), new FieldPath(p4, "NOM"));
                }
            };
            tableSource.getColumns().add(colStockD);
        }
        BaseSQLTableModelColumn colStockR = new BaseSQLTableModelColumn("Stock Reel", Float.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                SQLRowAccessor foreign2;
                SQLRowAccessor foreign = r.getForeign("ID_ARTICLE");
                if (foreign != null && !foreign.isUndefined() && foreign.getBoolean("GESTION_STOCK").booleanValue() && (foreign2 = StockSQLElement.getStockFetched(r)) != null && !foreign2.isUndefined()) {
                    return Float.valueOf(foreign2.getFloat("QTE_REEL"));
                }
                return null;
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(eltCmd.getTable());
                p = (Path)p.add(p.getLast().getField("ID_ARTICLE"));
                Path p2 = (Path)p.add(p.getLast().getTable("STOCK").getField("ID_ARTICLE"));
                return CollectionUtils.createSet(new FieldPath(p, "ID_DEPOT_STOCK"), new FieldPath(p2, "QTE_REEL"), new FieldPath(p2, "ID_DEPOT_STOCK"));
            }
        };
        tableSource.getColumns().add(colStockR);
        BaseSQLTableModelColumn colLiv2 = new BaseSQLTableModelColumn("Stock TH", Float.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                SQLRowAccessor foreign2;
                SQLRowAccessor foreign = r.getForeign("ID_ARTICLE");
                if (foreign != null && !foreign.isUndefined() && foreign.getBoolean("GESTION_STOCK").booleanValue() && (foreign2 = StockSQLElement.getStockFetched(r)) != null && !foreign2.isUndefined()) {
                    return Float.valueOf(foreign2.getFloat("QTE_TH"));
                }
                return null;
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(eltCmd.getTable());
                p = (Path)p.add(p.getLast().getField("ID_ARTICLE"));
                Path p2 = (Path)p.add(p.getLast().getTable("STOCK").getField("ID_ARTICLE"));
                return CollectionUtils.createSet(new FieldPath(p, "ID_DEPOT_STOCK"), new FieldPath(p2, "QTE_TH"), new FieldPath(p2, "ID_DEPOT_STOCK"));
            }
        };
        tableSource.getColumns().add(colLiv2);
        BaseSQLTableModelColumn colStockMin = new BaseSQLTableModelColumn("Stock Min", Float.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                SQLRowAccessor foreign2;
                SQLRowAccessor foreign = r.getForeign("ID_ARTICLE");
                if (foreign != null && !foreign.isUndefined() && foreign.getBoolean("GESTION_STOCK").booleanValue() && (foreign2 = StockSQLElement.getStockFetched(r)) != null && !foreign2.isUndefined()) {
                    return Float.valueOf(foreign2.getFloat("QTE_MIN"));
                }
                return null;
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(eltCmd.getTable());
                p = (Path)p.add(p.getLast().getField("ID_ARTICLE"));
                Path p2 = (Path)p.add(p.getLast().getTable("STOCK").getField("ID_ARTICLE"));
                return CollectionUtils.createSet(new FieldPath(p, "ID_DEPOT_STOCK"), new FieldPath(p2, "QTE_MIN"), new FieldPath(p2, "ID_DEPOT_STOCK"));
            }
        };
        tableSource.getColumns().add(colStockMin);
        BaseSQLTableModelColumn colSug = new BaseSQLTableModelColumn("Qt\u00e8 \u00e0 commander", Float.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                SQLRowAccessor foreign2;
                SQLRowAccessor foreign = r.getForeign("ID_ARTICLE");
                if (foreign != null && !foreign.isUndefined() && foreign.getBoolean("GESTION_STOCK").booleanValue() && (foreign2 = StockSQLElement.getStockFetched(r)) != null && !foreign2.isUndefined()) {
                    float qteMin = foreign2.getFloat("QTE_MIN");
                    float manque = foreign2.getFloat("QTE_TH") - qteMin;
                    if (manque < 0.0f) {
                        return Float.valueOf(-manque);
                    }
                    return Float.valueOf(0.0f);
                }
                return Float.valueOf(r.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(r.getInt("QTE"))).floatValue());
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(eltCmd.getTable());
                p = (Path)p.add(p.getLast().getField("ID_ARTICLE"));
                Path p2 = (Path)p.add(p.getLast().getTable("STOCK").getField("ID_ARTICLE"));
                return CollectionUtils.createSet(new FieldPath(p, "ID_DEPOT_STOCK"), new FieldPath(p2, "QTE_TH"), new FieldPath(p2, "QTE_MIN"), new FieldPath(p2, "ID_DEPOT_STOCK"));
            }
        };
        tableSource.getColumns().add(colSug);
        colSug.setRenderer(new QteAcommanderRenderer());
        return tableSource;
    }

    private BigDecimal getAvancementLFromBL(SQLRowAccessor r) {
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("COMMANDE_CLIENT_ELEMENT"));
        BigDecimal totalQte = BigDecimal.ZERO;
        BigDecimal totalQteL = BigDecimal.ZERO;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            BigDecimal qte = sQLRowAccessor.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(sQLRowAccessor.getInt("QTE")));
            totalQte = totalQte.add(qte);
            totalQteL = sQLRowAccessor.getBoolean("LIVRE_FORCED") != false || sQLRowAccessor.getBoolean("LIVRE") != false ? totalQteL.add(qte) : totalQteL.add(sQLRowAccessor.getBigDecimal("QTE_LIVREE"));
        }
        if (totalQte.signum() != 0) {
            return totalQteL.divide(totalQte, DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ONE.movePointRight(2);
    }

    protected IListPanel instantiateListPanel(SQLTableModelSource tableSource, String panelVariant) {
        IListPanel panel = super.instantiateListPanel(tableSource, panelVariant);
        final CommandeClientElementSQLElement eltCmd = (CommandeClientElementSQLElement)this.getElem();
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.fill = 1;
        c.anchor = 13;
        c.weightx = 1.0;
        c.gridy = 4;
        IListFilterDatePanel datePanel = new IListFilterDatePanel(panel.getListe(), eltCmd.getTable().getForeignTable("ID_COMMANDE_CLIENT").getField("DATE"), IListFilterDatePanel.getDefaultMap());
        datePanel.setFilterOnDefault();
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new GridBagLayout());
        bottomPanel.setOpaque(false);
        DefaultGridBagConstraints c2 = new DefaultGridBagConstraints();
        c2.fill = 0;
        c2.weightx = 1.0;
        bottomPanel.add((Component)datePanel, c2);
        panel.add((Component)bottomPanel, c);
        RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction("Calcul des besoins"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLPreferences prefs = SQLPreferences.getMemCached(eltCmd.getTable().getDBRoot());
                if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_MULTI_DEPOT, false)) {
                    ListeDesStocksAction action = new ListeDesStocksAction(true);
                    FrameUtil.show(action.createFrame());
                } else {
                    final SQLElement artElt = eltCmd.getForeignElement("ID_ARTICLE");
                    SQLTableModelSourceOnline createTableSource = artElt.createTableSource();
                    createTableSource.getReq().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                        @Override
                        public SQLSelect transformChecked(SQLSelect input) {
                            FieldRef refStock = input.getAlias(artElt.getTable().getForeignTable("ID_STOCK").getField("QTE_TH"));
                            FieldRef refStockMin = input.getAlias(artElt.getTable().getForeignTable("ID_STOCK").getField("QTE_MIN"));
                            SQLSelectJoin j = input.getJoinFromField(artElt.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT"));
                            if (j == null) {
                                j = input.addBackwardJoin("LEFT", artElt.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT"), null);
                            }
                            Where w = new Where(refStock, "<", refStockMin);
                            w = w.and(new Where(j.getJoinedTable().getKey(), "=", (Object)null));
                            input.setWhere(w);
                            return input;
                        }
                    });
                    IListe listeArt = new IListe(createTableSource);
                    RowAction.PredicateRowAction predicateACtion = new RowAction.PredicateRowAction(new AbstractAction("Passer une commande fournisseur"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            List<SQLRowAccessor> selectedRows = IListe.get(e).getSelectedRowAccessors();
                            eltCmd.transfertCommande(selectedRows);
                        }
                    }, true);
                    predicateACtion.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
                    listeArt.addIListeAction(predicateACtion);
                    ListeViewPanel p = new ListeViewPanel(artElt, listeArt);
                    IListFrame f = new IListFrame(p);
                    FrameUtil.show(f);
                }
            }
        }, true);
        action.setPredicate(IListeAction.IListeEvent.createTotalRowCountPredicate(0, Integer.MAX_VALUE));
        panel.getListe().addIListeAction(action);
        return panel;
    }
}

