/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.edm.AttachmentAction;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.sales.account.PartialInvoiceEditGroup;
import org.openconcerto.erp.core.sales.account.VenteFactureSituationSQLComponent;
import org.openconcerto.erp.core.sales.account.VenteFactureSoldeEditGroup;
import org.openconcerto.erp.core.sales.account.VenteFactureSoldeSQLComponent;
import org.openconcerto.erp.core.sales.invoice.component.SaisieVenteFactureSQLComponent;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.core.sales.invoice.ui.InvoicePercentRenderer;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.shipment.component.BonDeLivraisonSQLComponent;
import org.openconcerto.erp.core.supplychain.stock.element.MouvementStockSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteFacture;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.erp.rights.NXRights;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.TableSorter;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;

public class SaisieVenteFactureSQLElement
extends ComptaSQLConfElement {
    public static final String TABLENAME = "SAISIE_VENTE_FACTURE";
    public static final String MESSAGE_FIELD_NAME = "ID_SDD_MESSAGE";
    public static final String END2END_FIELD_NAME = "SDD_EndToEndId";
    Map<String, DoWithRow> specialAction = new HashMap<String, DoWithRow>();

    public SaisieVenteFactureSQLElement() {
        super(TABLENAME, "une facture", "factures");
        GlobalMapper.getInstance().map("sales.invoice.partial", new PartialInvoiceEditGroup());
        GlobalMapper.getInstance().map("sales.invoice.partial.future", new PartialInvoiceEditGroup());
        this.addComponentFactory("sales.invoice.partial", new ITransformer<Tuple2<SQLElement, String>, SQLComponent>(){

            @Override
            public SQLComponent transformChecked(Tuple2<SQLElement, String> input) {
                return new VenteFactureSituationSQLComponent(SaisieVenteFactureSQLElement.this);
            }
        });
        this.addComponentFactory("sales.invoice.partial.future", new ITransformer<Tuple2<SQLElement, String>, SQLComponent>(){

            @Override
            public SQLComponent transformChecked(Tuple2<SQLElement, String> input) {
                return new VenteFactureSituationSQLComponent(SaisieVenteFactureSQLElement.this);
            }
        });
        GlobalMapper.getInstance().map("sales.invoice.partial.balance", new VenteFactureSoldeEditGroup());
        GlobalMapper.getInstance().map("sales.invoice.partial.balance.future", new VenteFactureSoldeEditGroup());
        this.addComponentFactory("sales.invoice.partial.balance", new ITransformer<Tuple2<SQLElement, String>, SQLComponent>(){

            @Override
            public SQLComponent transformChecked(Tuple2<SQLElement, String> input) {
                return new VenteFactureSoldeSQLComponent(SaisieVenteFactureSQLElement.this);
            }
        });
        this.addComponentFactory("sales.invoice.partial.balance.future", new ITransformer<Tuple2<SQLElement, String>, SQLComponent>(){

            @Override
            public SQLComponent transformChecked(Tuple2<SQLElement, String> input) {
                return new VenteFactureSoldeSQLComponent(SaisieVenteFactureSQLElement.this);
            }
        });
        boolean affact = UserRightsManager.getCurrentUserRights().haveRight(NXRights.ACCES_RETOUR_AFFACTURAGE.getCode());
        ArrayList<RowAction> l = new ArrayList<RowAction>(5);
        RowAction.PredicateRowAction actionBL = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransfertBaseSQLComponent.openTransfertFrame(IListe.get(e).getSelectedRows(), "BON_DE_LIVRAISON");
            }
        }, false, "sales.invoice.create.delivery");
        actionBL.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        l.add(actionBL);
        if (this.getTable().contains("ATTACHMENTS")) {
            RowAction.PredicateRowAction actionAttachment = new RowAction.PredicateRowAction(new AttachmentAction().getAction(), true);
            actionAttachment.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
            this.getRowActions().add(actionAttachment);
        }
        RowAction.PredicateRowAction actionAvoir = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TransfertBaseSQLComponent.openTransfertFrame(IListe.get(e).getSelectedRows(), "AVOIR_CLIENT");
            }
        }, false, "sales.invoice.create.credit");
        actionAvoir.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        l.add(actionAvoir);
        String property = PrinterNXProps.getInstance().getProperty("QLPrinter");
        if (property != null && property.trim().length() > 0) {
            RowAction.PredicateRowAction actionPrintLabel = new RowAction.PredicateRowAction((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            }, false, "customerrelationship.customer.label.print");
            actionPrintLabel.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        }
        RowAction actionClone = new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLElement eltFact = Configuration.getInstance().getDirectory().getElement(SaisieVenteFactureSQLElement.TABLENAME);
                EditFrame editFrame = new EditFrame(eltFact, EditPanel.CREATION);
                ((SaisieVenteFactureSQLComponent)editFrame.getSQLComponent()).loadFactureExistante(IListe.get(e).getSelectedId());
                editFrame.setVisible(true);
            }
        }, true, "sales.invoice.clone"){

            @Override
            public boolean enabledFor(List<SQLRowValues> l) {
                if (l.size() == 1) {
                    SQLRowAccessor r = l.get(0);
                    return r.getBoolean("PARTIAL") == false && r.getBoolean("SOLDE") == false;
                }
                return false;
            }
        };
        l.add(actionClone);
        this.getRowActions().addAll(l);
        RowAction.PredicateRowAction actionClient = new RowAction.PredicateRowAction((Action)new AbstractAction("D\u00e9tails client"){
            EditFrame edit;
            private SQLElement eltClient;
            {
                this.eltClient = Configuration.getInstance().getDirectory().getElement(((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.edit == null) {
                    this.edit = new EditFrame(this.eltClient, EditPanel.EditMode.READONLY);
                }
                this.edit.selectionId(IListe.get(e).fetchSelectedRow().getInt("ID_CLIENT"));
                this.edit.setVisible(true);
            }
        }, false, "sales.invoice.info.show");
        actionClient.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionClient);
        RowAction.PredicateRowAction actionCommande = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaisieVenteFactureSQLElement elt = (SaisieVenteFactureSQLElement)Configuration.getInstance().getDirectory().getElement(SaisieVenteFactureSQLElement.TABLENAME);
                elt.transfertCommande(IListe.get(e).getSelectedId());
            }
        }, false, "sales.invoice.create.supplier.order");
        actionCommande.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionCommande);
        RowAction.PredicateRowAction actionCancelAvoir = new RowAction.PredicateRowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaisieVenteFactureSQLElement.this.cancelAvoir(IListe.get(e).getSelectedRow());
            }
        }, false, "sales.invoice.cancel.credit"){

            @Override
            public boolean enabledFor(List<SQLRowValues> rows) {
                if (rows.size() != 1) {
                    return false;
                }
                SQLRow selectedRow = rows.get(0).asRow();
                return !selectedRow.isForeignEmpty("ID_AVOIR_CLIENT");
            }
        };
        actionCancelAvoir.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionCancelAvoir);
        MouseSheetXmlListeListener mouseSheetXmlListeListener = new MouseSheetXmlListeListener((SQLElement)this, VenteFactureXmlSheet.class);
        this.getRowActions().addAll(mouseSheetXmlListeListener.getRowActions());
    }

    @Override
    protected void setupLinks(SQLElementLinksSetup links) {
        super.setupLinks(links);
        if (this.getTable().contains("ID_ADRESSE")) {
            links.get("ID_ADRESSE").setType(SQLElementLink.LinkType.ASSOCIATION);
        }
        if (this.getTable().contains("ID_ADRESSE_LIVRAISON")) {
            links.get("ID_ADRESSE_LIVRAISON").setType(SQLElementLink.LinkType.ASSOCIATION);
        }
        links.get(MESSAGE_FIELD_NAME).setType(SQLElementLink.LinkType.ASSOCIATION, SQLElement.ReferenceAction.RESTRICT);
    }

    @Override
    public ListMap<String, String> getShowAs() {
        ListMap<String, String> map = new ListMap<String, String>();
        map.putCollection(null, "NUMERO", "DATE", "ID_COMMERCIAL");
        return map;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("DATE");
        l.add("NOM");
        l.add("ID_CLIENT");
        l.add("ID_MODE_REGLEMENT");
        l.add("ID_COMMERCIAL");
        if (UserRightsManager.getCurrentUserRights().haveRight("CORPS_VOIR_PRIX_ACHAT")) {
            l.add("T_HA");
        }
        if (SQLPreferences.getMemCached(this.getTable().getDBRoot()).getBoolean("ShowInterfel", false)) {
            l.add("MONTANT_INTERFEL_HT");
        }
        l.add("T_HT");
        l.add("T_TTC");
        l.add("INFOS");
        l.add("DATE_ENVOI");
        l.add("DATE_REGLEMENT");
        return l;
    }

    @Override
    protected void _initListRequest(ListSQLRequest req) {
        super._initListRequest(req);
        req.changeGraphToFetch(new IClosure<SQLRowValues>(){

            @Override
            public void executeChecked(SQLRowValues graphToFetch) {
                graphToFetch.put("ACOMPTE", null);
                graphToFetch.put("PARTIAL", null);
                graphToFetch.put("SOLDE", null);
                graphToFetch.put("COMPLEMENT", null);
                graphToFetch.put("PREVISIONNELLE", null);
                graphToFetch.grow("ID_MODE_REGLEMENT").put("AJOURS", null).put("LENJOUR", null);
                SQLRowValues value = new SQLRowValues(graphToFetch.getTable().getTable("MOUVEMENT"));
                value.put("ID_PIECE", null);
                graphToFetch.put("ID_MOUVEMENT", (Object)value);
                graphToFetch.put("T_AVOIR_TTC", null);
            }
        });
    }

    private BigDecimal getAvancement(SQLRowAccessor r) {
        BigDecimal totalAregler;
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("ECHEANCE_CLIENT"));
        long totalEch = 0L;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (sQLRowAccessor.getBoolean("REGLE").booleanValue() || sQLRowAccessor.getBoolean("REG_COMPTA").booleanValue()) continue;
            totalEch += sQLRowAccessor.getLong("MONTANT");
        }
        SQLRowAccessor sQLRowAccessor = r.getForeign("ID_AVOIR_CLIENT");
        BigDecimal avoirTTC = BigDecimal.ZERO;
        if (sQLRowAccessor != null && !sQLRowAccessor.isUndefined()) {
            avoirTTC = new BigDecimal(sQLRowAccessor.getLong("MONTANT_TTC"));
        }
        if ((totalAregler = new BigDecimal(r.getLong("T_TTC")).subtract(avoirTTC)).signum() > 0 && totalEch > 0L) {
            return totalAregler.subtract(new BigDecimal(totalEch)).divide(totalAregler, DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP);
        }
        return BigDecimal.ONE.movePointRight(2);
    }

    @Override
    protected synchronized void _initTableSource(SQLTableModelSource table) {
        super._initTableSource(table);
        this.addCommercialFilter(table, this.getTable().getField("ID_COMMERCIAL"));
        BaseSQLTableModelColumn colAvancement = new BaseSQLTableModelColumn("Avancement r\u00e9glement", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                return SaisieVenteFactureSQLElement.this.getAvancement(r);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path pFact = new Path(SaisieVenteFactureSQLElement.this.getTable());
                Path p = new Path(SaisieVenteFactureSQLElement.this.getTable());
                p = (Path)p.add(SaisieVenteFactureSQLElement.this.getTable().getTable("ECHEANCE_CLIENT"));
                Path p2 = new Path(SaisieVenteFactureSQLElement.this.getTable());
                p2 = (Path)p2.add(SaisieVenteFactureSQLElement.this.getTable().getField("ID_AVOIR_CLIENT"));
                return CollectionUtils.createSet(new FieldPath(pFact, "NET_A_PAYER"), new FieldPath(pFact, "AFFACTURAGE"), new FieldPath(p, "MONTANT"), new FieldPath(p, "REG_COMPTA"), new FieldPath(p, "REGLE"), new FieldPath(p2, "MONTANT_TTC"));
            }
        };
        table.getColumns().add(colAvancement);
        colAvancement.setRenderer(new DefaultTableCellRenderer(){
            private InvoicePercentRenderer r = new InvoicePercentRenderer();

            @Override
            public Component getTableCellRendererComponent(JTable jtable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                TableSorter sorter = (TableSorter)jtable.getModel();
                SQLRowValues row2 = ((ITableModel)sorter.getTableModel()).getRow(row).getRow();
                this.r.setSoldeAvoir(row2.getLong("NET_A_PAYER") == 0L);
                this.r.setAffacturer(row2.getTable().contains("AFFACTURAGE") && row2.getBoolean("AFFACTURAGE") != false);
                this.r.setValue((Number)value);
                return this.r;
            }
        });
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        return l;
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> s = new HashSet<String>(1);
        s.add("CONTROLE_TECHNIQUE");
        s.add("PREVISIONNELLE");
        s.add("MONTANT_INTERFEL_HT");
        return s;
    }

    @Override
    public Set<String> getInsertOnlyFields() {
        HashSet<String> s = new HashSet<String>(1);
        s.add("ACOMPTE");
        return s;
    }

    @Override
    public SQLComponent createComponent() {
        return new SaisieVenteFactureSQLComponent();
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        for (SQLRow row : trees.getRows()) {
            if (row.getInt("ID_AVOIR_CLIENT") > 1) {
                SQLElement eltAvoir = Configuration.getInstance().getDirectory().getElement("AVOIR_CLIENT");
                SQLRow rowAvoir = eltAvoir.getTable().getRow(row.getInt("ID_AVOIR_CLIENT"));
                Long montantSolde = (Long)rowAvoir.getObject("MONTANT_SOLDE");
                Long avoirTTC = (Long)row.getObject("T_AVOIR_TTC");
                long montant = montantSolde - avoirTTC;
                if (montant < 0L) {
                    montant = 0L;
                }
                SQLRowValues rowVals = rowAvoir.createEmptyUpdateRow();
                rowVals.put("SOLDE", Boolean.FALSE);
                rowVals.put("MONTANT_SOLDE", montant);
                Long restant = (Long)rowAvoir.getObject("MONTANT_TTC") - montantSolde;
                rowVals.put("MONTANT_RESTANT", restant);
                try {
                    rowVals.update();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            super.archive(new TreesOfSQLRows((SQLElement)this, row), cutLinks);
            SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
            if (!prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true)) continue;
            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            SQLSelect sel = new SQLSelect();
            sel.addSelect(eltMvtStock.getTable().getField("ID"));
            Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
            Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
            sel.setWhere(w.and(w2));
            List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
            if (l == null) continue;
            int i = 0;
            while (i < l.size()) {
                Object[] tmp = (Object[])l.get(i);
                eltMvtStock.archive(((Number)tmp[0]).intValue());
                ++i;
            }
        }
    }

    public void transfertBL(int idFacture) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON");
        EditFrame editAvoirFrame = new EditFrame(elt);
        editAvoirFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        BonDeLivraisonSQLComponent comp = (BonDeLivraisonSQLComponent)editAvoirFrame.getSQLComponent();
        SQLInjector inject = SQLInjector.getInjector(this.getTable(), elt.getTable());
        SQLRowValues createRowValuesFrom = inject.createRowValuesFrom(idFacture);
        SQLRow rowFacture = this.getTable().getRow(idFacture);
        String string = rowFacture.getString("NOM");
        createRowValuesFrom.put("NOM", String.valueOf(string) + (string.trim().length() == 0 ? "" : ", ") + rowFacture.getString("NUMERO"));
        comp.select(createRowValuesFrom);
        editAvoirFrame.pack();
        editAvoirFrame.setState(0);
        editAvoirFrame.setVisible(true);
    }

    public void transfertCommande(final int idFacture) {
        ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE_ELEMENT");
                SQLTable tableCmdElt = Configuration.getInstance().getDirectory().getElement("COMMANDE_ELEMENT").getTable();
                SQLElement eltArticle = Configuration.getInstance().getDirectory().getElement("ARTICLE");
                Collection rows = SaisieVenteFactureSQLElement.this.getTable().getRow(idFacture).getReferentRows(elt.getTable());
                ListMap<SQLRow, SQLRowValues> map = new ListMap<SQLRow, SQLRowValues>();
                SQLRow rowDeviseF = null;
                for (SQLRow sqlRow : rows) {
                    SQLRowValues rowArticle = new SQLRowValues(eltArticle.getTable());
                    for (SQLField field : eltArticle.getTable().getFields()) {
                        if (!sqlRow.getTable().getFieldsName().contains(field.getName())) continue;
                        rowArticle.put(field.getName(), sqlRow.getObject(field.getName()));
                    }
                    int idArticle = ReferenceArticleSQLElement.getIdForCNM(rowArticle, true);
                    SQLRow rowArticleFind = eltArticle.getTable().getRow(idArticle);
                    if (rowArticleFind == null) continue;
                    SQLInjector inj = SQLInjector.getInjector(rowArticle.getTable(), tableCmdElt);
                    SQLRowValues rowValsElt = new SQLRowValues(inj.createRowValuesFrom(rowArticleFind));
                    rowValsElt.put("ID_STYLE", sqlRow.getObject("ID_STYLE"));
                    rowValsElt.put("QTE", sqlRow.getObject("QTE"));
                    rowValsElt.put("T_POIDS", rowValsElt.getLong("POIDS") * (long)rowValsElt.getInt("QTE"));
                    rowDeviseF = sqlRow.getForeignRow("ID_DEVISE");
                    SQLRow rowDeviseHA = rowArticleFind.getForeignRow("ID_DEVISE_HA");
                    BigDecimal qte = new BigDecimal(rowValsElt.getInt("QTE"));
                    if (rowDeviseF != null && !rowDeviseF.isUndefined()) {
                        if (rowDeviseF.getID() == rowDeviseHA.getID()) {
                            rowValsElt.put("PA_DEVISE", rowArticleFind.getObject("PA_DEVISE"));
                            rowValsElt.put("PA_DEVISE_T", ((BigDecimal)rowArticleFind.getObject("PA_DEVISE")).multiply(qte, DecimalUtils.HIGH_PRECISION));
                            rowValsElt.put("ID_DEVISE", rowDeviseF.getID());
                        } else {
                            BigDecimal taux = (BigDecimal)rowDeviseF.getObject("TAUX");
                            rowValsElt.put("PA_DEVISE", taux.multiply((BigDecimal)rowValsElt.getObject("PA_HT")));
                            rowValsElt.put("PA_DEVISE_T", ((BigDecimal)rowValsElt.getObject("PA_DEVISE")).multiply(qte, DecimalUtils.HIGH_PRECISION));
                            rowValsElt.put("ID_DEVISE", rowDeviseF.getID());
                        }
                    }
                    BigDecimal prixHA = (BigDecimal)rowValsElt.getObject("PA_HT");
                    rowValsElt.put("T_PA_HT", prixHA.multiply(qte, DecimalUtils.HIGH_PRECISION));
                    rowValsElt.put("T_PA_HT", prixHA.multiply(qte, DecimalUtils.HIGH_PRECISION));
                    rowValsElt.put("T_PA_TTC", ((BigDecimal)rowValsElt.getObject("T_PA_HT")).multiply(new BigDecimal((double)rowValsElt.getForeign("ID_TAXE").getFloat("TAUX") / 100.0 + 1.0), DecimalUtils.HIGH_PRECISION));
                    map.add(rowArticleFind.getForeignRow("ID_FOURNISSEUR"), rowValsElt);
                }
                MouvementStockSQLElement.createCommandeF(map, rowDeviseF);
            }
        });
    }

    public DoWithRow getSpecialAction(String key) {
        return this.specialAction.get(key);
    }

    public void putSpecialAction(String key, DoWithRow action) {
        this.specialAction.put(key, action);
    }

    public void cancelAvoir(final SQLRowAccessor rowFactureOrigin) {
        JPanel p = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        p.add((Component)new JLabel("Voulez annuler l'avoir affect\u00e9 sur cette facture?"), c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        JButton buttonApply = new JButton("Appliquer");
        JButton buttonAnnuler = new JButton("Fermer");
        p.add((Component)buttonApply, c);
        ++c.gridx;
        p.add((Component)buttonAnnuler, c);
        final PanelFrame f = new PanelFrame(p, "Suppression d'un avoir client sur facture");
        buttonAnnuler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                f.dispose();
            }
        });
        buttonApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long ttc = rowFactureOrigin.getLong("T_TTC");
                long avoirTTC = rowFactureOrigin.getLong("T_AVOIR_TTC");
                SQLRowAccessor rowAvoir = rowFactureOrigin.getForeign("ID_AVOIR_CLIENT");
                SQLRowValues createEmptyUpdateRow = rowFactureOrigin.createEmptyUpdateRow();
                createEmptyUpdateRow.put("ID_AVOIR_CLIENT", rowFactureOrigin.getTable().getTable("AVOIR_CLIENT").getUndefinedID());
                createEmptyUpdateRow.put("NET_A_PAYER", ttc);
                createEmptyUpdateRow.put("T_AVOIR_TTC", 0L);
                try {
                    try {
                        SQLRow rowFacture = createEmptyUpdateRow.commit();
                        SQLRowValues rowVals = rowAvoir.createEmptyUpdateRow();
                        rowVals.put("SOLDE", Boolean.FALSE);
                        rowVals.put("MONTANT_SOLDE", 0L);
                        rowVals.put("MONTANT_RESTANT", avoirTTC);
                        rowVals.update();
                        EcritureSQLElement eltEcr = (EcritureSQLElement)Configuration.getInstance().getDirectory().getElement("ECRITURE");
                        int foreignIDmvt = rowFacture.getForeignID("ID_MOUVEMENT");
                        eltEcr.archiveMouvementProfondeur(foreignIDmvt, false);
                        System.err.println("Regeneration des ecritures");
                        new GenerationMvtSaisieVenteFacture(rowFacture.getID(), foreignIDmvt);
                        System.err.println("Fin regeneration");
                    }
                    catch (SQLException e1) {
                        ExceptionHandler.handle("Erreur lors de l'affection de l'avoir sur la facture!", e1);
                        f.dispose();
                    }
                }
                finally {
                    f.dispose();
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrameUtil.showPacked(f);
            }
        });
    }

    @Override
    protected String createCode() {
        return "sales.invoice";
    }

    public static interface DoWithRow {
        public void process(SQLRow var1);
    }
}

