/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.supplychain.order.element.SaisieAchatSQLElement;
import org.openconcerto.erp.core.supplychain.supplier.element.FournisseurSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieAchat;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.action.SQLRowValuesAction;

public class ReleveBancaireElementSQLElement
extends ComptaSQLConfElement {
    public static final String TABLE_NAME = "RELEVE_BANCAIRE_ELEMENT";

    public ReleveBancaireElementSQLElement(DBRoot root) {
        super(root.getTable(TABLE_NAME));
        this.getRowValuesActions().add(this.getCreateAction());
    }

    @Override
    protected List<String> getListFields() {
        return Arrays.asList("DATE_VALEUR", "TYPE", "DESCRIPTION", "COMMENT", "MONTANT");
    }

    @Override
    protected SQLComponent createComponent() {
        return null;
    }

    public SQLRowValuesAction.PredicateRowAction getCreateAction() {
        SQLRowValuesAction.PredicateRowAction action = new SQLRowValuesAction.PredicateRowAction(true, true, "purchase.create", a -> {
            try {
                List<? extends SQLRowAccessor> selectedRowAccessors = a.getSelectedRowAccessors();
                this.create(selectedRowAccessors);
                JOptionPane.showMessageDialog(null, String.valueOf(selectedRowAccessors.size()) + " lignes trait\u00e9es");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        action.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        return action;
    }

    void create(List<? extends SQLRowAccessor> rows) throws Exception {
        HashMap<String, Integer> mapFournisseur = new HashMap<String, Integer>();
        HashMap<String, Integer> mapCompte = new HashMap<String, Integer>();
        for (final SQLRowAccessor sQLRowAccessor : rows) {
            Integer idComptePCE;
            Integer idFournisseur;
            final SQLRow row = sQLRowAccessor.fetchNewRow(false);
            String comptePCE = "607";
            String toSearch = "";
            String nom = "Mat\u00e9riel";
            if (row.getBigDecimal("MONTANT").signum() < 0) {
                String desc = row.getString("DESCRIPTION").toLowerCase();
                if (desc.contains("amazon")) {
                    toSearch = "Amazon";
                    nom = "Mat\u00e9riel";
                } else if (desc.contains("atelier porta")) {
                    toSearch = "L'atelier du portable";
                    nom = "Mat\u00e9riel";
                } else if (desc.contains("google")) {
                    toSearch = "Google";
                    comptePCE = "604";
                    nom = "Publicit\u00e9";
                } else if (desc.contains("sendinblue")) {
                    toSearch = "SendInBlue";
                    comptePCE = "623";
                    nom = "Mailing";
                } else if (desc.contains("united parcel s")) {
                    toSearch = "UPS";
                    comptePCE = "624";
                    nom = "Transport";
                }
            }
            if ((idFournisseur = (Integer)mapFournisseur.get(toSearch)) == null) {
                idFournisseur = this.searchFournisseur(toSearch);
                mapFournisseur.put(toSearch, idFournisseur);
            }
            if ((idComptePCE = (Integer)mapCompte.get(comptePCE)) == null) {
                idComptePCE = this.searchCompte(comptePCE);
                mapCompte.put(toSearch, idComptePCE);
            }
            if (idFournisseur == null || idComptePCE == null) continue;
            String type = sQLRowAccessor.getString("TYPE");
            if (type.equals("card")) {
                try {
                    final int idF = idFournisseur;
                    final int idPCE = idComptePCE;
                    final String n = nom;
                    SQLUtils.executeAtomic(this.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, Exception>(){

                        @Override
                        public Object handle(SQLDataSource ds) throws Exception {
                            SQLRowValues modeReglement = new SQLRowValues(ReleveBancaireElementSQLElement.this.getDirectory().getElement(ModeDeReglementSQLElement.class).getTable());
                            modeReglement.put("ID_TYPE_REGLEMENT", 3);
                            modeReglement.put("COMPTANT", Boolean.TRUE);
                            modeReglement.put("DATE_FACTURE", Boolean.TRUE);
                            SQLRow taxe = TaxeCache.getCache().getFirstTaxe();
                            SQLRowValues rAchat = new SQLRowValues(ReleveBancaireElementSQLElement.this.getDirectory().getElement(SaisieAchatSQLElement.class).getTable());
                            int ttcCents = Math.abs(sQLRowAccessor.getBigDecimal("MONTANT").multiply(new BigDecimal("100")).intValue());
                            float ht = (float)ttcCents / 1.2f;
                            int htCents = Math.round(ht);
                            int tvaCents = ttcCents - htCents;
                            rAchat.put("ID_FOURNISSEUR", idF);
                            rAchat.put("MONTANT_TTC", ttcCents);
                            rAchat.put("SOURCE", "");
                            rAchat.put("NOM", n);
                            rAchat.put("ID_MODE_REGLEMENT", (Object)modeReglement);
                            rAchat.put("ID_COMPTE_PCE", idPCE);
                            rAchat.put("MONTANT_HT", htCents);
                            rAchat.put("ID_TAXE", taxe.getID());
                            rAchat.put("DATE", row.getDate("DATE").getTime());
                            rAchat.put("MONTANT_TVA", tvaCents);
                            SQLRow resutl = rAchat.commit();
                            new GenerationMvtSaisieAchat(resutl).genereMouvement();
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            System.out.println("ReleveBancaireSQLElement " + sQLRowAccessor.getString("TYPE") + " not supported");
        }
    }

    protected Integer searchCompte(String comptePCE) {
        SQLSelect select = new SQLSelect();
        SQLTable tComptePCE = this.getDirectory().getElement(ComptePCESQLElement.class).getTable();
        select.addSelect(tComptePCE.getKey());
        select.addSelect(tComptePCE.getField("NUMERO"));
        select.setWhere(new Where((FieldRef)tComptePCE.getField("NUMERO"), "=", (Object)comptePCE));
        List<SQLRow> rows = SQLRowListRSH.execute(select);
        if (rows.isEmpty()) {
            return null;
        }
        return rows.get(0).getID();
    }

    protected Integer searchFournisseur(String name) {
        SQLSelect select = new SQLSelect();
        SQLTable tFournisseur = this.getDirectory().getElement(FournisseurSQLElement.class).getTable();
        select.addSelect(tFournisseur.getKey());
        select.addSelect(tFournisseur.getField("NOM"));
        select.setWhere(new Where((FieldRef)tFournisseur.getField("NOM"), "=", (Object)name));
        List<SQLRow> rows = SQLRowListRSH.execute(select);
        if (rows.isEmpty()) {
            return null;
        }
        return rows.get(0).getID();
    }
}

