/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.mail;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.openconcerto.erp.core.customerrelationship.mail.EmailTemplateTableNameItem;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.doc.Documented;

public class EmailTemplateTableComboBox
extends JComboBox<EmailTemplateTableNameItem>
implements ValueWrapper<EmailTemplateTableNameItem>,
Documented,
RowItemViewComponent {
    private final ValueChangeSupport<EmailTemplateTableNameItem> supp;
    public static final List<String> tablesCustomer = Arrays.asList("ECHEANCE_CLIENT", "RELANCE", "AVOIR_CLIENT", "DEVIS", "COMMANDE_CLIENT", "BON_DE_LIVRAISON", "SAISIE_VENTE_FACTURE");
    public static final List<String> tablesSupplier = Arrays.asList("COMMANDE", "DEMANDE_PRIX", "BON_RECEPTION", "FACTURE_FOURNISSEUR", "AVOIR_FOURNISSEUR");
    private Map<String, EmailTemplateTableNameItem> mapItem = new HashMap<String, EmailTemplateTableNameItem>();

    public EmailTemplateTableComboBox(SQLElementDirectory dir) {
        EmailTemplateTableNameItem item;
        this.supp = new ValueChangeSupport<EmailTemplateTableNameItem>(this);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailTemplateTableComboBox.this.supp.fireValueChange();
            }
        });
        for (String name : tablesCustomer) {
            item = new EmailTemplateTableNameItem(name, dir, true);
            this.mapItem.put(name, item);
            this.addItem(item);
        }
        for (String name : tablesSupplier) {
            item = new EmailTemplateTableNameItem(name, dir, true);
            this.mapItem.put(name, item);
            this.addItem(item);
        }
    }

    public EmailTemplateTableNameItem getItemFromTableName(String tableName) {
        return this.mapItem.get(tableName);
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.supp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.supp.removeValidListener(l);
    }

    @Override
    public void setValue(EmailTemplateTableNameItem val) {
        this.setSelectedItem(val);
    }

    @Override
    public void resetValue() {
    }

    @Override
    public EmailTemplateTableNameItem getValue() {
        return (EmailTemplateTableNameItem)this.getSelectedItem();
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public void init(SQLRowItemView v) {
    }

    @Override
    public String getGenericDoc() {
        return "";
    }

    @Override
    public String getDocId() {
        return "TableName";
    }

    @Override
    public boolean onScreen() {
        return true;
    }

    @Override
    public boolean isDocTransversable() {
        return false;
    }

    @Override
    public JComponent getComp() {
        return this;
    }
}

