/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.mail;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.customerrelationship.mail.EmailTemplateGroup;
import org.openconcerto.erp.core.customerrelationship.mail.EmailTemplateSQLComponent;
import org.openconcerto.sql.element.GlobalMapper;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.StringUtils;

public class EmailTemplateSQLElement
extends ComptaSQLConfElement {
    public static final String TABLE_NAME = "MODELE_EMAIL";

    public EmailTemplateSQLElement() {
        super(TABLE_NAME, "un mod\u00e8le d'email", "mod\u00e8les d'emails");
        EmailTemplateGroup group = new EmailTemplateGroup();
        GlobalMapper.getInstance().map("customerrelationship.mail.email.template", group);
        this.setDefaultGroup(group);
    }

    @Override
    protected List<String> getListFields() {
        return Arrays.asList("NOM", "PAR_DEFAUT");
    }

    @Override
    protected void _initTableSource(SQLTableModelSource res) {
        super._initTableSource(res);
        BaseSQLTableModelColumn colTableName = new BaseSQLTableModelColumn("Table", String.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                String string = r.getString("TABLE_NAME");
                return StringUtils.firstUp(EmailTemplateSQLElement.this.getDirectory().getElement(string).getPluralName());
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(EmailTemplateSQLElement.this.getTable());
                return CollectionUtils.createSet(new FieldPath(p, "TABLE_NAME"));
            }
        };
        res.getColumns().add(colTableName);
    }

    @Override
    protected List<String> getComboFields() {
        return Arrays.asList("NOM");
    }

    @Override
    protected SQLComponent createComponent() {
        return new EmailTemplateSQLComponent(this);
    }

    @Override
    protected String createCode() {
        return "customerrelationship.mail.email.template";
    }
}

