/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.mail;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.customerrelationship.mail.EmailTemplate;
import org.openconcerto.erp.core.customerrelationship.mail.EmailTemplateTableComboBox;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.GestionDevise;

public class EmailCreator {
    private final EmailTemplate template;
    private final List<SQLRow> rows;
    private final Map<String, String> map;
    private final String files;

    public EmailCreator(EmailTemplate template, List<SQLRow> row, String files) {
        this.template = template;
        this.rows = row;
        this.files = files;
        this.map = this.getMapValues();
    }

    private Map<String, String> getMapValues() {
        SQLRow tiersRowNX;
        String datePattern = this.template.getDateFormat();
        if (datePattern == null || datePattern.trim().isEmpty()) {
            datePattern = "dd/MM/yyyy";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        SQLRow rowSoc = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        SQLRow rowSocAdresse = rowSoc.getForeignRow("ID_ADRESSE_COMMON");
        SQLRow rowUser = rowSoc.getTable().getDBRoot().findTable("USER_COMMON").getRow(UserManager.getUser().getId());
        map.put("UserName", rowUser.getString("NOM"));
        map.put("UserFirstName", rowUser.getString("PRENOM"));
        if (rowUser.getTable().contains("MAIL")) {
            map.put("UserMail", rowUser.getString("MAIL"));
        }
        if (rowUser.getTable().contains("TEL")) {
            map.put("UserTel", rowUser.getString("TEL"));
        }
        map.put("SocieteType", rowSoc.getString("TYPE"));
        map.put("SocieteNom", rowSoc.getString("NOM"));
        map.put("SocieteAdresse", rowSocAdresse.getString("RUE"));
        map.put("SocieteCodePostal", rowSocAdresse.getString("CODE_POSTAL"));
        String ville = rowSocAdresse.getString("VILLE");
        Object cedex = rowSocAdresse.getObject("CEDEX");
        boolean hasCedex = rowSocAdresse.getBoolean("HAS_CEDEX");
        if (hasCedex) {
            ville = String.valueOf(ville) + " CEDEX";
            if (cedex != null && cedex.toString().trim().length() > 0) {
                ville = String.valueOf(ville) + " " + cedex.toString().trim();
            }
        }
        map.put("SocieteVille", ville);
        map.put("Pi\u00e8cesJointes", this.files);
        String fieldTiers = "ID_CLIENT";
        if (EmailTemplateTableComboBox.tablesSupplier.contains(this.rows.get(0).getTable().getName())) {
            fieldTiers = "ID_FOURNISSEUR";
        }
        SQLRow rowTiers = tiersRowNX = this.rows.get(0).getForeignRow(fieldTiers);
        SQLRow rowAdresse = rowTiers.getForeignRow("ID_ADRESSE");
        if (fieldTiers.equals("ID_CLIENT")) {
            map.put("TiersType", rowTiers.getString("FORME_JURIDIQUE"));
        }
        map.put("TiersNom", rowTiers.getString("NOM"));
        map.put("TiersAdresse", rowAdresse.getString("RUE"));
        map.put("TiersCodePostal", rowAdresse.getString("CODE_POSTAL"));
        String villeCli = rowAdresse.getString("VILLE");
        Object cedexCli = rowAdresse.getObject("CEDEX");
        boolean hasCedexCli = rowAdresse.getBoolean("HAS_CEDEX");
        if (hasCedexCli) {
            villeCli = String.valueOf(villeCli) + " CEDEX";
            if (cedexCli != null && cedexCli.toString().trim().length() > 0) {
                villeCli = String.valueOf(villeCli) + " " + cedexCli.toString().trim();
            }
        }
        map.put("TiersVille", villeCli);
        Date d = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        map.put("Date", dateFormat.format(d));
        Long lTotalTTC = 0L;
        Long lTotalHT = 0L;
        Long lTotalTVA = 0L;
        HashSet<String> affairesNumero = new HashSet<String>();
        HashSet<String> affairesRef = new HashSet<String>();
        HashSet<String> documentsNumero = new HashSet<String>();
        HashSet<String> documentsRef = new HashSet<String>();
        HashSet<String> documentsDate = new HashSet<String>();
        HashSet<String> dateReception = new HashSet<String>();
        HashSet<String> documentsDateValid = new HashSet<String>();
        for (SQLRow sqlRow : this.rows) {
            if (sqlRow.getTable().contains("DATE_RECEPTION_DEMANDEE")) {
                Calendar dateRecpt = sqlRow.getDate("DATE_RECEPTION_DEMANDEE");
                if (d != null) {
                    dateReception.add(dateFormat.format(dateRecpt.getTime()));
                }
            }
            String fieldTotal = "T_";
            if (!sqlRow.getTable().contains("T_TTC") && sqlRow.getTable().contains("MONTANT_TTC")) {
                fieldTotal = "MONTANT_";
            }
            lTotalTTC = lTotalTTC + (Long)sqlRow.getObject(String.valueOf(fieldTotal) + "TTC");
            lTotalHT = lTotalHT + (Long)sqlRow.getObject(String.valueOf(fieldTotal) + "HT");
            lTotalTVA = lTotalTVA + (Long)sqlRow.getObject(String.valueOf(fieldTotal) + "TVA");
            documentsNumero.add(sqlRow.getString("NUMERO"));
            if (sqlRow.getTable().contains("NOM")) {
                documentsRef.add(sqlRow.getString("NOM"));
            } else if (sqlRow.getTable().contains("OBJET")) {
                documentsRef.add(sqlRow.getString("OBJET"));
            }
            documentsDate.add(dateFormat.format((Date)sqlRow.getObject("DATE")));
            if (sqlRow.getTable().contains("ID_AFFAIRE")) {
                SQLRow rowAffaire = sqlRow.getForeign("ID_AFFAIRE");
                if (rowAffaire.getTable().contains("OBJET")) {
                    affairesRef.add(rowAffaire.getString("OBJET"));
                }
                affairesNumero.add(rowAffaire.getString("NUMERO"));
            }
            if (!sqlRow.getTable().contains("DATE_VALIDITE") || sqlRow.getObject("DATE_VALIDITE") == null) continue;
            documentsDateValid.add(dateFormat.format((Date)sqlRow.getObject("DATE_VALIDITE")));
        }
        map.put("DocumentDateValidite", CollectionUtils.join(documentsDateValid, ","));
        map.put("NomAffaire", CollectionUtils.join(affairesRef, ","));
        map.put("NumeroAffaire", CollectionUtils.join(affairesNumero, ","));
        map.put("DocumentNumero", CollectionUtils.join(documentsNumero, ","));
        map.put("DocumentReference", CollectionUtils.join(documentsRef, ","));
        map.put("DocumentDate", CollectionUtils.join(documentsDate, ","));
        map.put("DocumentDateReception", CollectionUtils.join(dateReception, ","));
        map.put("DocumentTotalTTC", GestionDevise.currencyToString(lTotalTTC, true));
        map.put("DocumentTotalHT", GestionDevise.currencyToString(lTotalHT, true));
        map.put("DocumentTotalTVA", GestionDevise.currencyToString(lTotalTVA, true));
        map.put("message", "");
        return map;
    }

    public String getObject() {
        return this.fill(this.template.getTitle());
    }

    public String getValue() {
        return this.fill(this.template.getText());
    }

    private String fill(String string) {
        String result = string;
        for (String key : this.map.keySet()) {
            result = result.replace("{" + key + "}", this.map.get(key));
        }
        return result;
    }
}

