/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.JSONToLightUIConvertorManager;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.io.JSONAble;
import org.openconcerto.utils.io.JSONConverter;

public class Row
implements Externalizable,
JSONAble {
    private Number id;
    private String extendId = "";
    private List<Object> values;
    private Boolean fillWidth = false;
    private Boolean toggleable = false;
    private Boolean visible = true;

    public Row() {
    }

    public Row(JSONObject json) {
        this.fromJSON(json);
    }

    public Row(Number id, int valueCount) {
        this.id = id;
        this.values = new ArrayList<Object>(valueCount);
        if (valueCount > 0) {
            int i = 0;
            while (i < valueCount) {
                this.values.add(null);
                ++i;
            }
        }
    }

    public Row(Number id) {
        this.id = id;
        this.values = new ArrayList<Object>();
    }

    public final void setValues(List<Object> values) {
        this.values = values;
    }

    public final List<Object> getValues() {
        return this.values;
    }

    public final Number getId() {
        return this.id;
    }

    public final String getExtendId() {
        return this.extendId;
    }

    public final void setExtendId(String extendId) {
        if (extendId == null) {
            throw new IllegalArgumentException("extendId cannot be null");
        }
        this.extendId = extendId;
    }

    public final void addValue(Object v) {
        this.values.add(v);
    }

    public final void setValue(int index, Object v) {
        this.values.set(index, v);
    }

    public final Boolean isFillWidth() {
        return this.fillWidth;
    }

    public final void setFillWidth(Boolean fillWidth) {
        this.fillWidth = fillWidth;
    }

    public final Boolean isToggleable() {
        return this.toggleable;
    }

    public final void setToggleable(Boolean toggleable) {
        this.toggleable = toggleable;
    }

    public final Boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeUTF(this.extendId);
        out.writeObject(this.values);
        out.writeBoolean(this.fillWidth);
        out.writeBoolean(this.toggleable);
        out.writeBoolean(this.visible);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (Number)in.readObject();
        this.extendId = in.readUTF();
        this.values = CollectionUtils.castList((List)in.readObject(), Object.class);
        this.fillWidth = in.readBoolean();
        this.toggleable = in.readBoolean();
        this.visible = in.readBoolean();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put("class", "Row");
        result.put("id", this.id);
        if (this.extendId != null) {
            result.put("extend-id", this.extendId);
        }
        if (!this.values.isEmpty()) {
            result.put("values", JSONConverter.getJSON(this.values));
        }
        if (this.fillWidth.booleanValue()) {
            result.put("fill-width", true);
        }
        if (this.toggleable.booleanValue()) {
            result.put("toggleable", true);
        }
        if (!this.visible.booleanValue()) {
            result.put("visible", false);
        }
        return result;
    }

    @Override
    public void fromJSON(JSONObject json) {
        this.id = JSONConverter.getParameterFromJSON(json, "id", Number.class);
        this.extendId = JSONConverter.getParameterFromJSON(json, "extend-id", String.class);
        this.fillWidth = JSONConverter.getParameterFromJSON(json, "fill-width", Boolean.class, false);
        this.toggleable = JSONConverter.getParameterFromJSON(json, "toggleable", Boolean.class, false);
        this.visible = JSONConverter.getParameterFromJSON(json, "visible", Boolean.class, true);
        JSONArray jsonValues = JSONConverter.getParameterFromJSON(json, "values", JSONArray.class);
        if (jsonValues != null) {
            int valuesSize = jsonValues.size();
            this.values = new ArrayList<Object>(valuesSize);
            int i = 0;
            while (i < valuesSize) {
                Object objValue = jsonValues.get(i);
                if (objValue instanceof JSONObject) {
                    JSONObject jsonValue = (JSONObject)objValue;
                    objValue = JSONToLightUIConvertorManager.getInstance().createUIElementFromJSON(jsonValue);
                } else if (objValue instanceof String) {
                    objValue = JSONConverter.getObjectFromJSON(objValue, String.class);
                } else if (objValue instanceof Integer) {
                    objValue = JSONConverter.getObjectFromJSON(objValue, Integer.class);
                } else if (objValue instanceof Long) {
                    objValue = JSONConverter.getObjectFromJSON(objValue, Long.class);
                } else if (objValue instanceof Boolean) {
                    objValue = JSONConverter.getObjectFromJSON(objValue, Boolean.class);
                } else if (objValue instanceof Double) {
                    objValue = JSONConverter.getObjectFromJSON(objValue, Double.class);
                } else if (objValue != null) {
                    throw new IllegalArgumentException("unknow type: " + objValue.getClass().getName());
                }
                this.values.add(objValue);
                ++i;
            }
        }
    }

    public String toString() {
        return "Row id: " + this.id + " values: " + this.values;
    }
}

