/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.User;

public class UpdateBuilder {
    private final SQLTable t;
    private final Map<String, String> fields;
    private boolean addMetaData;
    private User user;
    private final List<String> tables;
    private Where where;
    private final Map<String, VirtualJoin> virtualJoins;
    private final Map<String, Boolean> virtualJoinsOptimized;

    public UpdateBuilder(SQLTable t) {
        this.t = t;
        this.fields = new LinkedHashMap<String, String>();
        this.addMetaData = false;
        this.user = null;
        this.tables = new ArrayList<String>();
        this.virtualJoins = new HashMap<String, VirtualJoin>(4);
        this.virtualJoinsOptimized = new HashMap<String, Boolean>(4);
    }

    public final SQLTable getTable() {
        return this.t;
    }

    public final UpdateBuilder setAddMetaData(boolean addMetaData) {
        this.addMetaData = addMetaData;
        return this;
    }

    public final UpdateBuilder setUser(User user) {
        this.setAddMetaData(true);
        this.user = user;
        return this;
    }

    public final SQLSyntax getSyntax() {
        return SQLSyntax.get(this.getTable());
    }

    private final void checkField(String field) {
        this.checkField(field, this.getTable());
    }

    private final void checkField(String field, TableRef t) {
        if (!t.getTable().contains(field)) {
            throw new IllegalArgumentException("unknown " + field + " in " + t.getSQL());
        }
    }

    private final void checkField(SQLField field) {
        if (this.getTable() != field.getTable()) {
            throw new IllegalArgumentException(field + " not in " + this.getTable().getSQLName());
        }
    }

    public final UpdateBuilder set(String field, String value) {
        this.checkField(field);
        this.fields.put(field, value);
        return this;
    }

    public final UpdateBuilder setObject(String fieldName, Object value) {
        this.fields.put(fieldName, this.getTable().getField(fieldName).getType().toString(value));
        return this;
    }

    public final UpdateBuilder setObject(SQLField field, Object value) {
        this.checkField(field);
        this.fields.put(field.getName(), field.getType().toString(value));
        return this;
    }

    private final boolean isJoinVirtual(String alias) {
        if (!this.virtualJoins.containsKey(alias)) {
            throw new IllegalArgumentException("Not a join " + alias);
        }
        return this.getTable().getServer().getSQLSystem() == SQLSystem.H2 || this.virtualJoinsOptimized.get(alias) == Boolean.FALSE;
    }

    public final UpdateBuilder setFromVirtualJoinField(String field, String joinAlias, String joinedTableField) {
        return this.setFromVirtualJoin(field, joinAlias, new SQLName(joinAlias, joinedTableField).quote());
    }

    public final UpdateBuilder setFromVirtualJoin(String field, String joinAlias, String value) {
        String val;
        if (this.isJoinVirtual(joinAlias)) {
            VirtualJoin virtualJoin = this.virtualJoins.get(joinAlias);
            val = virtualJoin.getSelect(value);
        } else {
            val = value;
        }
        return this.set(field, val);
    }

    public final Set<String> getFieldsNames() {
        return this.fields.keySet();
    }

    public final boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public final void setWhere(Where where) {
        this.where = where;
    }

    public final Where getWhere() {
        return this.where;
    }

    public final void addTable(TableRef t) {
        this.tables.add(t.getSQL());
    }

    public final void addTable(SQLSelect sel, String alias) {
        this.addRawTable("( " + sel.asString() + " )", SQLBase.quoteIdentifier(alias));
    }

    public final void addRawTable(String definition, String rawAlias) {
        this.tables.add(String.valueOf(definition) + (rawAlias == null ? "" : " " + rawAlias));
    }

    public final void addBackwardVirtualJoin(TableRef t, String joinedTableField) {
        this.checkField(joinedTableField, t);
        this.addVirtualJoin(t.getSQL(), t.getAlias(), true, joinedTableField, this.getTable().getKey().getName());
    }

    public final void addForwardVirtualJoin(TableRef t, String joinField) {
        this.checkField(joinField, this.getTable());
        this.addVirtualJoin(t.getSQL(), t.getAlias(), true, t.getKey().getField().getName(), joinField);
    }

    public final void addVirtualJoin(String definition, String alias, String joinedTableField) {
        this.addVirtualJoin(definition, alias, false, joinedTableField, this.getTable().getKey().getName());
    }

    public final void addVirtualJoin(String definition, String alias, boolean aliasAlreadyDefined, String joinedTableField, String field) {
        this.addVirtualJoin(definition, alias, aliasAlreadyDefined, joinedTableField, "=", field, true);
    }

    public final VirtualJoin addVirtualJoin(TableRef t, String joinedTableField, String op, String field) {
        return this.addVirtualJoin(t.getSQL(), t.getAlias(), true, joinedTableField, op, field, true);
    }

    public final VirtualJoin addVirtualJoin(String definition, String alias, boolean aliasAlreadyDefined, String joinedTableField, String op, String field) {
        return this.addVirtualJoin(definition, alias, aliasAlreadyDefined, joinedTableField, op, field, true);
    }

    public final VirtualJoin addVirtualJoin(String definition, String alias, boolean aliasAlreadyDefined, String joinedTableField, String op, String field, boolean optimize) {
        if (alias == null) {
            throw new NullPointerException("No alias");
        }
        if (this.virtualJoins.containsKey(alias)) {
            throw new IllegalStateException("Alias already exists : " + alias);
        }
        this.checkField(field);
        String completeDef = aliasAlreadyDefined ? definition : String.valueOf(definition) + ' ' + SQLBase.quoteIdentifier(alias);
        VirtualJoin res = new VirtualJoin(alias, completeDef, field, op, joinedTableField);
        this.virtualJoins.put(alias, res);
        this.virtualJoinsOptimized.put(alias, optimize);
        return res;
    }

    public final String asString() {
        Map<String, String> execFields;
        String w;
        Where computedWhere = this.where;
        ArrayList<String> computedTables = new ArrayList<String>(this.tables);
        for (Map.Entry<String, VirtualJoin> e : this.virtualJoins.entrySet()) {
            Where w2;
            String joinAlias = e.getKey();
            VirtualJoin virtualJoin = e.getValue();
            if (this.isJoinVirtual(joinAlias)) {
                w2 = Where.createRaw("EXISTS " + virtualJoin.getSelect("1"), new FieldRef[0]);
            } else {
                w2 = Where.createRaw(virtualJoin.getWhere(), new FieldRef[0]);
                computedTables.add(virtualJoin.getDefinition());
            }
            computedWhere = w2.and(computedWhere);
        }
        String string = w = computedWhere == null ? "" : "\nWHERE " + computedWhere.getClause();
        if (this.addMetaData) {
            execFields = new HashMap<String, String>(this.fields);
            UpdateBuilder.setFieldValue(execFields, this.getTable().getModifUserField(), this.user == null ? null : Integer.valueOf(this.user.getId()));
            UpdateBuilder.setFieldValue(execFields, this.getTable().getModifDateField(), System.currentTimeMillis());
        } else {
            execFields = Collections.unmodifiableMap(this.fields);
        }
        return "UPDATE " + this.getSyntax().getUpdate(this.getTable(), Collections.unmodifiableList(computedTables), execFields) + w;
    }

    private static void setFieldValue(Map<String, String> vals, SQLField f, Object val) {
        if (f == null) {
            return;
        }
        vals.put(f.getName(), val == null ? "DEFAULT" : f.getType().toString(val));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + this.asString();
    }

    public final class VirtualJoin {
        private final String alias;
        private final String definition;
        private final String updateTableField;
        private final String op;
        private final String joinedTableField;

        protected VirtualJoin(String alias, String definition, String updateTableField, String op, String joinedTableField) {
            this.alias = alias;
            this.definition = definition;
            this.updateTableField = updateTableField;
            this.op = op;
            this.joinedTableField = joinedTableField;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final String getUpdateTableField() {
            return this.updateTableField;
        }

        public final String getJoinedTableField() {
            return this.joinedTableField;
        }

        protected final String getWhere() {
            SQLName joinedTableFieldName = new SQLName(this.getAlias(), this.getJoinedTableField());
            return Where.comparison(UpdateBuilder.this.getSyntax(), UpdateBuilder.this.getTable().getField(this.getUpdateTableField()).getSQLNameUntilDBRoot(false).quote(), this.op, joinedTableFieldName.quote());
        }

        protected final String getSelect(String value) {
            return "( select " + value + " from " + this.getDefinition() + " where " + this.getWhere() + " )";
        }
    }
}

