/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.utils.GestionDevise;

public class RecapFactureProvider
implements SpreadSheetCellValueProvider {
    private final TypeRecapFactureProvider type;
    private final boolean withDate;

    public RecapFactureProvider(TypeRecapFactureProvider t, boolean withDate) {
        this.type = t;
        this.withDate = withDate;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        Calendar c = row.getDate("DATE");
        Collection<? extends SQLRowAccessor> rows = row.getReferentRows(row.getTable().getTable("TR_COMMANDE_CLIENT"));
        StringBuffer result = new StringBuffer();
        HashSet<SQLRowAccessor> facture = new HashSet<SQLRowAccessor>();
        facture.add(row);
        for (SQLRowAccessor sQLRowAccessor : rows) {
            result.append(this.getPreviousAcompte(sQLRowAccessor.getForeign("ID_COMMANDE_CLIENT"), facture, c));
        }
        if (result.length() > 0) {
            return "Facturation pr\u00e9c\u00e9dente :" + result.toString();
        }
        return null;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.account.history", new RecapFactureProvider(TypeRecapFactureProvider.HT, false));
        SpreadSheetCellValueProviderManager.put("sales.account.history.ttc", new RecapFactureProvider(TypeRecapFactureProvider.TTC, false));
        SpreadSheetCellValueProviderManager.put("sales.account.history.withdate", new RecapFactureProvider(TypeRecapFactureProvider.HT, true));
        SpreadSheetCellValueProviderManager.put("sales.account.history.ttc.withdate", new RecapFactureProvider(TypeRecapFactureProvider.TTC, true));
    }

    public String getPreviousAcompte(SQLRowAccessor sqlRowAccessor, Set<SQLRowAccessor> alreadyAdded, Calendar c) {
        if (sqlRowAccessor == null || sqlRowAccessor.isUndefined()) {
            return "";
        }
        Collection<? extends SQLRowAccessor> rows = sqlRowAccessor.getReferentRows(sqlRowAccessor.getTable().getTable("TR_COMMANDE_CLIENT"));
        StringBuffer result = new StringBuffer();
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        for (SQLRowAccessor sQLRowAccessor : rows) {
            SQLRowAccessor rowFact = sQLRowAccessor.getForeign("ID_SAISIE_VENTE_FACTURE");
            if (rowFact == null || rowFact.isUndefined() || alreadyAdded.contains(rowFact) || !rowFact.getDate("DATE").before(c)) continue;
            alreadyAdded.add(rowFact);
            String fieldTotal = this.type == TypeRecapFactureProvider.HT ? "T_HT" : "T_TTC";
            result.append(rowFact.getString("NUMERO"));
            result.append(" (");
            if (this.withDate) {
                result.append(String.valueOf(format.format(rowFact.getDate("DATE").getTime())) + " ");
            }
            result.append(String.valueOf(GestionDevise.currencyToString(rowFact.getLong(fieldTotal))) + "\u20ac), ");
            if (!this.withDate) continue;
            result.append("\n");
        }
        return result.toString();
    }

    private static enum TypeRecapFactureProvider {
        HT,
        TTC;

    }
}

