/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;

@ThreadSafe
public final class MenuAndActions {
    @GuardedBy(value="this")
    private final Group group;
    @GuardedBy(value="this")
    private final Map<String, Action> actions;

    public MenuAndActions() {
        this(new Group("menu.main"), Collections.emptyMap());
    }

    public MenuAndActions(Group group, Map<String, Action> actions) {
        this.group = Group.copy(group, null);
        this.actions = new HashMap<String, Action>(actions);
    }

    public final synchronized MenuAndActions copy() {
        return new MenuAndActions(this.getGroup(), this.actions);
    }

    public final void putAction(Action a) {
        this.putAction(a, null);
    }

    public final void putAction(Action a, String id) {
        this.putAction(a, id, false);
    }

    public final String putAction(Action a, String id, boolean canReplace) {
        return this.putAction(a, id, canReplace, false);
    }

    private final synchronized String putAction(Action a, String id, boolean canReplace, boolean dryRun) {
        if (a == null) {
            throw new NullPointerException("Null action");
        }
        if (id == null) {
            id = SwingThreadUtils.getActionID(a);
        }
        if (id == null) {
            throw new NullPointerException("Null ID");
        }
        if (!canReplace && this.actions.containsKey(id)) {
            throw new IllegalStateException("ID exists : " + this.actions.get(id));
        }
        if (!dryRun) {
            this.actions.put(id, a);
        }
        return id;
    }

    public final synchronized Action getAction(String id) {
        return this.actions.get(id);
    }

    public final synchronized Group getGroup() {
        return this.group;
    }

    public void addMenuItem(Action action, List<String> path) {
        this.addMenuItem(action, null, path);
    }

    public void addMenuItem(Action action, String actionID, List<String> path) {
        this.addMenuItem(action, actionID, path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item addMenuItem(Action action, String actionID, List<String> path, boolean canReplace) throws IllegalStateException {
        Item res;
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Empty path");
        }
        MenuAndActions menuAndActions = this;
        synchronized (menuAndActions) {
            actionID = this.putAction(action, actionID, canReplace, true);
            Group groupDesc = this.getGroup().followPath(path, true);
            Item child = groupDesc.getDescFromID(actionID);
            if (!canReplace && child != null) {
                throw new IllegalStateException("ID exists : " + child);
            }
            if (child == null) {
                res = new Item(actionID);
                groupDesc.add(res);
            } else {
                res = child;
            }
            this.putAction(action, actionID, canReplace, false);
        }
        assert (res != null);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMenuItemVisible(String actionID, boolean v) {
        MenuAndActions menuAndActions = this;
        synchronized (menuAndActions) {
            Item mi = this.getGroup().getDescFromID(actionID);
            mi.setLocalHint(mi.getLocalHint().getBuilder().setVisible(v).build());
        }
    }
}

