/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.receipt.action;

import java.awt.Component;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Set;
import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.supplychain.receipt.element.BonReceptionSQLElement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.model.graph.PathBuilder;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.PercentTableCellRenderer;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.DecimalUtils;

public class ListeDesBonsReceptionsAction
extends CreateFrameAbstractAction {
    private BigDecimal bigDecimal100 = new BigDecimal(100);

    public ListeDesBonsReceptionsAction() {
        this.putValue("Name", "Liste des bons de r\u00e9ceptions");
    }

    public JFrame createFrame() {
        final SQLElement element = Configuration.getInstance().getDirectory().getElement("BON_RECEPTION");
        SQLTableModelSourceOnline tableSource = element.getTableSource(true);
        BaseSQLTableModelColumn colAvancement = new BaseSQLTableModelColumn("Avancement facturation", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                return ListeDesBonsReceptionsAction.this.getAvancement(r);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = ((PathBuilder)((PathBuilder)new PathBuilder(element.getTable()).addTable("TR_BON_RECEPTION")).addTable("FACTURE_FOURNISSEUR")).build();
                return CollectionUtils.createSet(new FieldPath(p, "T_HT"));
            }
        };
        tableSource.getColumns().add(colAvancement);
        colAvancement.setRenderer(new PercentTableCellRenderer());
        IListFrame frame = new IListFrame(new ListeAddPanel(element, new IListe(tableSource)));
        IListFilterDatePanel datePanel = new IListFilterDatePanel(frame.getPanel().getListe(), element.getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridwidth = 0;
        c.fill = 0;
        c.weightx = 0.0;
        ++c.gridy;
        ++c.gridy;
        c.anchor = 10;
        datePanel.setFilterOnDefault();
        frame.getPanel().add((Component)datePanel, c);
        return frame;
    }

    private BigDecimal getAvancement(SQLRowAccessor r) {
        Collection<? extends SQLRowAccessor> rows = r.getReferentRows(r.getTable().getTable("TR_BON_RECEPTION"));
        long totalFact = 0L;
        long total = r.getObject("TOTAL_HT") == null ? 0L : r.getLong("TOTAL_HT");
        for (SQLRowAccessor sQLRowAccessor : rows) {
            if (sQLRowAccessor.isForeignEmpty("ID_FACTURE_FOURNISSEUR")) continue;
            SQLRowAccessor rowFact = sQLRowAccessor.getForeign("ID_FACTURE_FOURNISSEUR");
            Long l = rowFact.getLong("T_HT");
            totalFact += l.longValue();
        }
        if (total > 0L) {
            return this.bigDecimal100.min(new BigDecimal(totalFact).divide(new BigDecimal(total), DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP));
        }
        return BigDecimal.ONE.movePointRight(2);
    }

    private void transfertFactureFournisseur(SQLRow row) {
        BonReceptionSQLElement elt = (BonReceptionSQLElement)Configuration.getInstance().getDirectory().getElement("BON_RECEPTION");
        elt.transfertFacture(row.getID());
    }
}

