/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTableRenderer;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class ClientCodeArticleTable
extends JPanel {
    private RowValuesTable table;
    private RowValuesTableModel model;

    public ClientCodeArticleTable() {
        this.init();
        this.uiInit();
    }

    protected void init() {
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTableElement tableElementClient = new SQLTableElement(e.getTable().getField("ID_ARTICLE"));
        list.add(tableElementClient);
        SQLTableElement code = new SQLTableElement(e.getTable().getField("CODE"));
        list.add(code);
        SQLTableElement nom = new SQLTableElement(e.getTable().getField("NOM"));
        list.add(nom);
        SQLRowValues defautRow = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(e.getTable()));
        this.model = new RowValuesTableModel(e, list, e.getTable().getField("ID_ARTICLE"), false, defautRow);
        this.table = new RowValuesTable(this.model, null, true);
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
    }

    public void insertFrom(String field, SQLRowValues row) {
        this.table.insertFrom(field, row);
    }

    protected void uiInit() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.gridx = 0;
        RowValuesTableControlPanel control = new RowValuesTableControlPanel(this.table);
        control.setOpaque(false);
        this.add((Component)control, c);
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        JScrollPane comp = new JScrollPane(this.table);
        comp.setVerticalScrollBarPolicy(22);
        this.add((Component)comp, c);
        this.table.setDefaultRenderer(Long.class, new RowValuesTableRenderer());
    }

    public SQLElement getSQLElement() {
        return Configuration.getInstance().getDirectory().getElement("ARTICLE_CODE_CLIENT");
    }

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public RowValuesTable getRowValuesTable() {
        return this.table;
    }

    public void insertFrom(String field, int id) {
        this.table.insertFrom(field, id);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public void refreshTable() {
        this.table.repaint();
    }
}

