/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.openconcerto.erp.core.common.ui.DeviseNiceTableCellRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererDecorator;
import org.openconcerto.ui.table.TableCellRendererUtils;

public class CommandeClientRenderer
extends TableCellRendererDecorator {
    private static HashSet<Integer> setFacture = new HashSet();
    private static HashSet<Integer> setBon = new HashSet();
    private static CommandeClientRenderer instance;
    private static final Map<Color, Color> COLORS;

    static {
        final SQLElement eltFact = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE");
        SQLSelect select = new SQLSelect();
        select.addSelect(eltFact.getTable().getField("IDSOURCE"));
        Where w = new Where((FieldRef)eltFact.getTable().getField("SOURCE"), "=", (Object)"COMMANDE_CLIENT");
        select.setWhere(w);
        List l = Configuration.getInstance().getBase().getDataSource().executeCol(select.asString());
        for (Integer integer : l) {
            setFacture.add(integer);
        }
        eltFact.getTable().addTableModifiedListener(new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                SQLRow row;
                if (evt.getTable().getName().equalsIgnoreCase(eltFact.getTable().getName()) && (row = evt.getRow()).getString("SOURCE").equalsIgnoreCase("COMMANDE_CLIENT")) {
                    if (evt.getMode() == SQLTableEvent.Mode.ROW_ADDED) {
                        setFacture.add(row.getInt("IDSOURCE"));
                    } else if (evt.getMode() == SQLTableEvent.Mode.ROW_UPDATED && row.isArchived()) {
                        setFacture.remove(row.getInt("IDSOURCE"));
                    }
                }
            }
        });
        final SQLElement eltBon = Configuration.getInstance().getDirectory().getElement("BON_DE_LIVRAISON");
        SQLSelect selectBon = new SQLSelect();
        selectBon.addSelect(eltBon.getTable().getField("ID_COMMANDE_CLIENT"));
        Where wBon = new Where((FieldRef)eltBon.getTable().getField("ID_COMMANDE_CLIENT"), "!=", 1);
        selectBon.setWhere(wBon);
        List lBon = Configuration.getInstance().getBase().getDataSource().executeCol(selectBon.asString());
        for (Integer integer : lBon) {
            setBon.add(integer);
        }
        eltBon.getTable().addTableModifiedListener(new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                if (evt.getTable().getName().equalsIgnoreCase(eltBon.getTable().getName())) {
                    int int1;
                    SQLRow row = evt.getRow();
                    if (evt.getMode() == SQLTableEvent.Mode.ROW_ADDED) {
                        int int12 = row.getInt("ID_COMMANDE_CLIENT");
                        if (int12 > 1) {
                            setBon.add(int12);
                        }
                    } else if (evt.getMode() == SQLTableEvent.Mode.ROW_DELETED && row.isArchived() && (int1 = row.getInt("ID_COMMANDE_CLIENT")) > 1) {
                        setBon.remove(int1);
                    }
                }
            }
        });
        instance = null;
        COLORS = new HashMap<Color, Color>();
        COLORS.put(DeviseNiceTableCellRenderer.couleurFacture, DeviseNiceTableCellRenderer.couleurFactureMore);
        COLORS.put(DeviseNiceTableCellRenderer.couleurBon, DeviseNiceTableCellRenderer.couleurBonMore);
    }

    public static synchronized CommandeClientRenderer getInstance() {
        if (instance == null) {
            instance = new CommandeClientRenderer();
        }
        return instance;
    }

    private CommandeClientRenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = this.getRenderer(table, column).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        AlternateTableCellRenderer.setBGColorMap((JComponent)comp, COLORS);
        int rowID = ITableModel.getLine(table.getModel(), row).getID();
        TableCellRendererUtils.setBackgroundColor(comp, table, isSelected);
        if (setFacture.contains(rowID)) {
            if (isSelected) {
                comp.setBackground(DeviseNiceTableCellRenderer.couleurFactureDark);
            } else {
                comp.setBackground(DeviseNiceTableCellRenderer.couleurFacture);
            }
        } else if (setBon.contains(rowID)) {
            if (isSelected) {
                comp.setBackground(DeviseNiceTableCellRenderer.couleurBonDark);
            } else {
                comp.setBackground(DeviseNiceTableCellRenderer.couleurBon);
            }
        }
        return comp;
    }

    public JPanel getLegendePanel() {
        JPanel panelLegende = new JPanel(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JLabel labelFacture = new JLabel("Commandes transf\u00e9r\u00e9es en facture");
        JPanel panel = new JPanel();
        panel.add(labelFacture);
        panel.setBackground(DeviseNiceTableCellRenderer.couleurFacture);
        panelLegende.add((Component)panel, c);
        JPanel panel2 = new JPanel();
        JLabel labelBL = new JLabel("Commandes transf\u00e9r\u00e9es en bon de livraison");
        panel2.add(labelBL);
        panel2.setBackground(DeviseNiceTableCellRenderer.couleurBon);
        ++c.gridy;
        c.gridx = 0;
        panelLegende.add((Component)panel2, c);
        return panelLegende;
    }
}

