/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class TruncatableList<T> {
    private static final TruncatableList EMPTY_LIST = new TruncatableList(Collections.emptyList(), false);
    private final List<T> list;
    private final boolean truncated;

    public static final <T> TruncatableList<T> empty() {
        return EMPTY_LIST;
    }

    public static final <T> TruncatableList<T> create(List<T> l, int maxCount) {
        boolean truncated = maxCount >= 0 && l.size() > maxCount;
        return new TruncatableList<T>(truncated ? l.subList(0, maxCount) : l, truncated);
    }

    public TruncatableList(List<T> list, boolean truncated) {
        this.list = Objects.requireNonNull(list);
        this.truncated = truncated;
    }

    public final List<T> getList() {
        return this.list;
    }

    public final boolean isTruncated() {
        return this.truncated;
    }

    public final TruncatableList<T> truncate(int maxCount) {
        if (this.getList().size() <= maxCount) {
            return this;
        }
        return new TruncatableList<T>(this.getList().subList(0, maxCount), true);
    }

    public int hashCode() {
        return Objects.hash(this.list, this.truncated);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TruncatableList other = (TruncatableList)obj;
        return Objects.equals(this.list, other.list) && this.truncated == other.truncated;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + (this.isTruncated() ? " truncated : " : " not truncated : ") + this.getList();
    }
}

