/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.sql.PropsConfiguration;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.task.ui.UserListCellRenderer;
import org.openconcerto.task.ui.UserListModel;
import org.openconcerto.task.ui.UserRightPanelDetail;
import org.openconcerto.ui.DisplayabilityListener;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.state.WindowStateManager;

public class UserRightsPrefPanel
extends JPanel
implements ListSelectionListener {
    private UserRightPanelDetail detail;
    private JList l;

    public UserRightsPrefPanel(final PropsConfiguration conf) {
        UserManager uMngr = conf.getUserManager();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        final UserListModel dataModel = new UserListModel(uMngr);
        this.addHierarchyListener(new DisplayabilityListener(){

            @Override
            protected void displayabilityChanged(Component c) {
                if (c.isDisplayable()) {
                    dataModel.start();
                } else {
                    dataModel.stop();
                }
            }
        });
        this.l = new JList<User>(dataModel);
        this.l.setCellRenderer(new UserListCellRenderer());
        this.l.setBorder(BorderFactory.createEmptyBorder());
        JScrollPane scrollPane = new JScrollPane(this.l);
        scrollPane.setMinimumSize(new Dimension(10 * this.getFont().getSize(), 120));
        scrollPane.setPreferredSize(new Dimension(12 * this.getFont().getSize(), 120));
        this.add((Component)scrollPane, c);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        ++c.gridx;
        JSeparator sep = new JSeparator(1);
        this.add((Component)sep, c);
        c.weightx = 1.0;
        this.detail = new UserRightPanelDetail(uMngr, conf.getRoot());
        this.add((Component)this.detail, c);
        c.weighty = 0.0;
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        JSeparator sep2 = new JSeparator(0);
        this.add((Component)sep2, c);
        ++c.gridy;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 0;
        c.gridwidth = 2;
        c.anchor = 18;
        JButton manageUsers = new JButton(new AbstractAction("Gestion des utilisateurs"){
            private JFrame frame;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.frame == null) {
                    this.frame = this.createFrame();
                    this.frame.pack();
                    new WindowStateManager(this.frame, new File(conf.getConfDir(), String.valueOf(UserRightsPrefPanel.this.getClass().getSimpleName()) + "-window.xml"), true).loadState();
                    this.frame.setDefaultCloseOperation(1);
                }
                FrameUtil.show(this.frame);
            }

            public JFrame createFrame() {
                return new IListFrame(new ListeAddPanel(conf.getDirectory().getElement("USER_COMMON")));
            }
        });
        this.add((Component)manageUsers, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.anchor = 12;
        final JButton button = new JButton("Fermer");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.getWindowAncestor(button).dispose();
            }
        });
        this.add((Component)button, c);
        this.l.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        System.out.println(e);
        if (!e.getValueIsAdjusting()) {
            this.detail.setUser((User)this.l.getSelectedValue());
        }
    }
}

