/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.search;

import java.util.List;
import org.openconcerto.sql.view.search.SearchSpec;
import org.openconcerto.sql.view.search.TextSearchSpec;

public final class ColumnSearchSpec
implements SearchSpec {
    private final boolean excludeFilterString;
    private final SearchSpec spec;
    private final int columnIndex;

    public static final ColumnSearchSpec create(String toSearch, int columnIndex) {
        return new ColumnSearchSpec(new TextSearchSpec(toSearch), columnIndex);
    }

    public ColumnSearchSpec(SearchSpec spec, int columnIndex) {
        this(false, spec, columnIndex);
    }

    public ColumnSearchSpec(boolean excludeFilterString, SearchSpec spec, int columnIndex) {
        this.excludeFilterString = excludeFilterString;
        this.spec = spec;
        this.columnIndex = columnIndex;
    }

    private boolean contains(List<?> list) {
        int stop;
        int start;
        if (this.columnIndex < 0) {
            start = 0;
            stop = list.size();
        } else {
            start = this.columnIndex;
            stop = this.columnIndex + 1;
        }
        int i = start;
        while (i < stop) {
            Object cell = list.get(i);
            if (this.spec.match(cell)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean match(Object line) {
        return this.isEmpty() || this.excludeFilterString ^ this.contains((List)line);
    }

    public String toString() {
        return String.valueOf(this.excludeFilterString) + ":" + this.spec + " col:" + this.columnIndex;
    }

    @Override
    public boolean isEmpty() {
        return this.spec == null || this.spec.isEmpty();
    }
}

