/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.receipt.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.sql.Timestamp;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.supplychain.receipt.ui.BatchQuantityRenderer;
import org.openconcerto.erp.core.supplychain.receipt.ui.BatchQuantityTableCellEditor;
import org.openconcerto.erp.core.supplychain.receipt.ui.BatchRequiredRenderer;
import org.openconcerto.erp.core.supplychain.receipt.ui.LotReceptionTableModel;
import org.openconcerto.erp.core.supplychain.receipt.ui.SerialAreaEditor;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.EnhancedTable;
import org.openconcerto.ui.TextAreaRenderer;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.ui.table.TimestampTableCellEditor;

public class LotReceptionUIPanel
extends JPanel {
    public LotReceptionUIPanel(SQLElement eltLotReception, SQLRowValues selRowElt) {
        final EnhancedTable table = new EnhancedTable();
        final LotReceptionTableModel dataModel = new LotReceptionTableModel(eltLotReception, selRowElt);
        table.setModel(dataModel);
        TimestampTableCellEditor editorPrec = new TimestampTableCellEditor(false){

            @Override
            public Object getCellEditorValue() {
                Object o = super.getCellEditorValue();
                Date d = null;
                if (o != null) {
                    d = new Date(((Timestamp)o).getTime());
                }
                return d;
            }
        };
        editorPrec.setAllowNull(true);
        Number foreignIDNumberUnite = selRowElt.getForeignIDNumber("ID_UNITE_VENTE");
        BatchQuantityTableCellEditor editorQty = new BatchQuantityTableCellEditor(foreignIDNumberUnite);
        table.getColumnModel().getColumn(0).setCellEditor(editorQty);
        table.getColumnModel().getColumn(0).setCellRenderer(new BatchQuantityRenderer());
        SQLRowAccessor foreign = selRowElt.getForeign("ID_ARTICLE");
        table.getColumnModel().getColumn(1).setCellRenderer(new BatchRequiredRenderer(table.getDefaultRenderer(String.class), foreign.getBoolean("NUMERO_LOT_REQUIS")));
        table.getColumnModel().getColumn(2).setCellEditor(editorPrec);
        table.getColumnModel().getColumn(2).setCellRenderer(new BatchRequiredRenderer(table.getDefaultRenderer(Date.class), foreign.getBoolean("DLC_REQUIS")));
        table.getColumnModel().getColumn(3).setCellEditor(editorPrec);
        table.getColumnModel().getColumn(3).setCellRenderer(new BatchRequiredRenderer(table.getDefaultRenderer(Date.class), foreign.getBoolean("DLUO_REQUIS")));
        table.getColumnModel().getColumn(4).setCellEditor(new SerialAreaEditor(table));
        table.getColumnModel().getColumn(4).setCellRenderer(new BatchRequiredRenderer(new TextAreaRenderer(), foreign.getBoolean("NUMERO_SERIE_REQUIS")));
        AlternateTableCellRenderer.UTILS.setAllColumns(table);
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout(0));
        JButton add = new JButton(new AbstractAction("Ajouter un lot/n\u00b0 de s\u00e9rie"){

            @Override
            public void actionPerformed(ActionEvent e) {
                dataModel.addLine();
            }
        });
        final JButton remove = new JButton(new AbstractAction("Supprimer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                dataModel.removeLine(table.getSelectedRow());
            }
        });
        buttons.add(add);
        buttons.add(remove);
        remove.setEnabled(false);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                remove.setEnabled(table.getSelectedRows().length > 0);
            }
        });
        JButton close = new JButton(new AbstractAction("Fermer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                dataModel.checkData();
                ((Window)SwingUtilities.getRoot(LotReceptionUIPanel.this)).dispose();
            }
        });
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        this.add((Component)buttons, c);
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)new JScrollPane(table), c);
        ++c.gridy;
        c.fill = 0;
        c.anchor = 14;
        this.add((Component)close, c);
    }
}

