/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.element;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.core.common.component.TransfertBaseSQLComponent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.edm.AttachmentAction;
import org.openconcerto.erp.core.sales.order.ui.ReliquatCommandeTableModel;
import org.openconcerto.erp.core.supplychain.order.component.CommandeSQLComponent;
import org.openconcerto.erp.core.supplychain.order.component.SaisieAchatSQLComponent;
import org.openconcerto.erp.core.supplychain.receipt.component.BonReceptionSQLComponent;
import org.openconcerto.erp.generationDoc.gestcomm.CommandeXmlSheet;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.erp.preferences.GestionCommercialeGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.EditPanelListener;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.PanelFrame;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.cc.ITransformer;

public class CommandeSQLElement
extends ComptaSQLConfElement {
    private final List<SQLTableModifiedListener> listenerCmdInserted = new ArrayList<SQLTableModifiedListener>();

    public CommandeSQLElement() {
        super("COMMANDE", "une commande fournisseur", "commandes fournisseur");
        if (this.getTable().contains("ATTACHMENTS")) {
            RowAction.PredicateRowAction actionAttachment = new RowAction.PredicateRowAction(new AttachmentAction().getAction(), true);
            actionAttachment.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
            this.getRowActions().add(actionAttachment);
        }
        this.getRowActions().addAll(new MouseSheetXmlListeListener((SQLElement)this, CommandeXmlSheet.class).getRowActions());
        RowAction.PredicateRowAction bonAction = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SQLRowValues> selectedRows = IListe.get(e).getSelectedRows();
                CommandeSQLElement.this.transfertBR(selectedRows);
            }
        }, true, "supplychain.order.create.receipt");
        bonAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(bonAction);
        RowAction.PredicateRowAction actionsTRFA = new RowAction.PredicateRowAction(new AbstractAction("Transfert vers facture fournisseur"){

            @Override
            public void actionPerformed(ActionEvent e) {
                final List<SQLRowValues> selectedRows = IListe.get(e).getSelectedRows();
                SwingWorker<Boolean, Object> worker = new SwingWorker<Boolean, Object>(){

                    @Override
                    protected Boolean doInBackground() throws Exception {
                        boolean b = TransfertBaseSQLComponent.isAlreadyAllTransfert(selectedRows, CommandeSQLElement.this.getTable(), CommandeSQLElement.this.getTable().getTable("FACTURE_FOURNISSEUR"), "T_HT", "T_HT");
                        if (b) {
                            String label = "Attention ";
                            label = selectedRows.size() > 1 ? String.valueOf(label) + " les " + CommandeSQLElement.this.getPluralName() + " ont d\u00e9j\u00e0 \u00e9t\u00e9 transf\u00e9r\u00e9!" : String.valueOf(label) + CommandeSQLElement.this.getSingularName() + " a d\u00e9j\u00e0 \u00e9t\u00e9 transf\u00e9r\u00e9!";
                            int ans = JOptionPane.showConfirmDialog(null, label = String.valueOf(label) + "\n Voulez vous continuer?", "Transfert " + CommandeSQLElement.this.getSingularName(), 0);
                            if (ans == 1) {
                                return Boolean.FALSE;
                            }
                        }
                        return Boolean.TRUE;
                    }

                    @Override
                    protected void done() {
                        try {
                            Boolean b = (Boolean)this.get();
                            if (b.booleanValue()) {
                                TransfertBaseSQLComponent.openTransfertFrame(selectedRows, "FACTURE_FOURNISSEUR");
                            }
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle("Erreur lors du transfert des " + CommandeSQLElement.this.getPluralName() + "!", e);
                        }
                    }
                };
                worker.execute();
            }
        }, false);
        actionsTRFA.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        this.getRowActions().add(actionsTRFA);
        RowAction.PredicateRowAction factureAction = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandeSQLElement.this.transfertFacture(IListe.get(e).getSelectedRow().getID());
            }
        }, false, "supplychain.order.create.purchase");
        factureAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(factureAction);
        this.getRowActions().add(this.getCloneAction());
        RowAction.PredicateRowAction tagValidAction = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues asRowValues = IListe.get(e).getSelectedRow().asRow().createEmptyUpdateRow();
                asRowValues.put("EN_COURS", Boolean.FALSE);
                try {
                    asRowValues.commit();
                }
                catch (SQLException e1) {
                    ExceptionHandler.handle("Une erreur est survenue pour notifier la commande valider", e1);
                }
            }
        }, false, "supplychain.order.valid");
        tagValidAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(tagValidAction);
        RowAction.PredicateRowAction reliquatAction = new RowAction.PredicateRowAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPanel panelReliquat = new JPanel(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                ReliquatCommandeTableModel dm = new ReliquatCommandeTableModel(IListe.get(e).getSelectedRowAccessor());
                if (dm.getRowCount() > 0) {
                    JTable table = new JTable(dm);
                    JScrollPane comp = new JScrollPane(table);
                    c.weightx = 1.0;
                    c.weighty = 1.0;
                    c.fill = 1;
                    panelReliquat.add((Component)comp, c);
                    PanelFrame frame = new PanelFrame(panelReliquat, "Reliquat commande");
                    frame.pack();
                    frame.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Aucun reliquat restant");
                }
            }
        }, false, "sales.order.reliquat.show");
        reliquatAction.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(reliquatAction);
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>(8);
        l.add("NUMERO");
        l.add("NOM");
        l.add("DATE");
        l.add("ID_FOURNISSEUR");
        l.add("ID_COMMERCIAL");
        l.add("T_HT");
        l.add("T_TTC");
        Boolean useCommandeEnCours = SQLPreferences.getMemCached(this.getTable().getDBRoot()).getBoolean(GestionCommercialeGlobalPreferencePanel.COMMANDE_FOURNISSEUR_EN_COURS, false);
        if (useCommandeEnCours.booleanValue()) {
            l.add("EN_COURS");
        }
        l.add("INFOS");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>(3);
        l.add("NUMERO");
        l.add("NOM");
        l.add("DATE");
        return l;
    }

    @Override
    public SQLComponent createComponent() {
        return new CommandeSQLComponent();
    }

    public void addInsertedCmdListener(SQLTableModifiedListener l) {
        this.listenerCmdInserted.add(l);
    }

    public void removeInsertedCmdListener(SQLTableModifiedListener l) {
        this.listenerCmdInserted.remove(l);
    }

    public void fireInsertedCmdListener(SQLRow row) {
        for (SQLTableModifiedListener sqlTableModifiedListener : this.listenerCmdInserted) {
            sqlTableModifiedListener.tableModified(new SQLTableEvent(row, SQLTableEvent.Mode.ROW_ADDED, null));
        }
    }

    public void transfertBR(final List<SQLRowValues> selectedRows) {
        EditFrame f = TransfertBaseSQLComponent.openTransfertFrame(selectedRows, "BON_RECEPTION");
        BonReceptionSQLComponent comp = (BonReceptionSQLComponent)f.getSQLComponent();
        final SQLTable tableElt = comp.getElement().getTable().getTable("BON_RECEPTION_ELEMENT");
        SQLRowValues rowVals = new SQLRowValues(tableElt);
        rowVals.put("QTE_UNITAIRE", null);
        rowVals.put("QTE", null);
        rowVals.put("ID_ARTICLE", null);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                ArrayList<Integer> ids = new ArrayList<Integer>(selectedRows.size());
                for (SQLRowValues sqlRowValues : selectedRows) {
                    ids.add(sqlRowValues.getID());
                }
                SQLSelectJoin joinBR = input.addJoin("RIGHT", tableElt.getTable("BON_RECEPTION_ELEMENT").getField("ID_BON_RECEPTION"));
                SQLSelectJoin joinTR = input.addBackwardJoin("RIGHT", tableElt.getTable("TR_COMMANDE").getField("ID_BON_RECEPTION"), joinBR.getJoinedTable().getAlias());
                joinTR.setWhere(new Where(joinTR.getJoinedTable().getField("ID_COMMANDE"), ids));
                return input;
            }
        });
        comp.loadQuantity(fetcher.fetch());
        comp.removeZeroQtyLines();
    }

    public void transfertFacture(final int commandeID) {
        SQLElement elt = Configuration.getInstance().getDirectory().getElement("SAISIE_ACHAT");
        EditFrame editFactureFrame = new EditFrame(elt);
        editFactureFrame.setIconImage(new ImageIcon(Gestion.class.getResource("frameicon.png")).getImage());
        SaisieAchatSQLComponent comp = (SaisieAchatSQLComponent)editFactureFrame.getSQLComponent();
        comp.loadCommande(commandeID);
        editFactureFrame.pack();
        editFactureFrame.setState(0);
        editFactureFrame.setVisible(true);
        editFactureFrame.addEditPanelListener(new EditPanelListener(){

            @Override
            public void modified() {
            }

            @Override
            public void inserted(int id) {
                try {
                    SQLRowValues rowValsTR = new SQLRowValues(CommandeSQLElement.this.getTable().getTable("TR_COMMANDE"));
                    rowValsTR.put("ID_COMMANDE", commandeID);
                    rowValsTR.put("ID_SAISIE_ACHAT", id);
                    rowValsTR.commit();
                }
                catch (SQLException e) {
                    ExceptionHandler.handle("Erreur lors de l'insertion de la ligne de transfert", e);
                }
            }

            @Override
            public void deleted() {
            }

            @Override
            public void cancelled() {
            }
        });
    }

    public RowAction getCloneAction() {
        return new RowAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRowValues selectedRow = IListe.get(e).getSelectedRow();
                SQLElement eltFact = Configuration.getInstance().getDirectory().getElement("COMMANDE");
                EditFrame editFrame = new EditFrame(eltFact, EditPanel.CREATION);
                ((CommandeSQLComponent)editFrame.getSQLComponent()).duplicate(((SQLRowAccessor)selectedRow).getID());
                editFrame.setVisible(true);
            }
        }, true, "sales.quote.clone"){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                return selection != null && selection.size() == 1;
            }
        };
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        for (SQLRow row : trees.getRows()) {
            SQLElement eltMvtStock = Configuration.getInstance().getDirectory().getElement("MOUVEMENT_STOCK");
            SQLSelect sel = new SQLSelect();
            sel.addSelect(eltMvtStock.getTable().getField("ID"));
            Where w = new Where((FieldRef)eltMvtStock.getTable().getField("IDSOURCE"), "=", row.getID());
            Where w2 = new Where((FieldRef)eltMvtStock.getTable().getField("SOURCE"), "=", (Object)this.getTable().getName());
            sel.setWhere(w.and(w2));
            List l = (List)eltMvtStock.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
            if (l == null) continue;
            int i = 0;
            while (i < l.size()) {
                Object[] tmp = (Object[])l.get(i);
                eltMvtStock.archive(((Number)tmp[0]).intValue());
                ++i;
            }
        }
        super.archive(trees, cutLinks);
    }

    @Override
    protected String createCode() {
        return "supplychain.order";
    }
}

