/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.utils.QuickOrderedMap;
import org.openconcerto.utils.Tuple2;

public class Categorie {
    private static List<Categorie> topLevelCategories = new ArrayList<Categorie>();
    private static List<Categorie> allCategories = new ArrayList<Categorie>();
    private static List<Article> favoriteProducts = new ArrayList<Article>();
    private String name;
    private List<Categorie> l = new ArrayList<Categorie>();
    private Set<Article> articles = new HashSet<Article>();
    private Categorie parent;
    private boolean isUnknown = false;

    public Categorie(String string) {
        this(string, false);
    }

    public Categorie(String string, boolean top) {
        this.name = string;
        if (top) {
            topLevelCategories.add(this);
        }
        allCategories.add(this);
    }

    public void setUnknown() {
        this.isUnknown = true;
    }

    public boolean isUnknown() {
        return this.isUnknown;
    }

    public String toString() {
        return this.name;
    }

    public void add(Categorie s) {
        this.l.add(s);
        s.setParentCategorie(this);
    }

    private void setParentCategorie(Categorie categorie) {
        this.parent = categorie;
    }

    public Categorie getParent() {
        return this.parent;
    }

    void addArticle(Article a) {
        this.articles.add(a);
    }

    public static List<Categorie> getTopLevelCategories() {
        return topLevelCategories;
    }

    public static List<Categorie> getAllCategories() {
        return allCategories;
    }

    public List<Categorie> getSubCategories() {
        return this.l;
    }

    public String getName() {
        return this.name;
    }

    public List<Article> getArticles() {
        int size = this.articles.size();
        for (Categorie c : this.l) {
            size += c.getArticles().size();
        }
        ArrayList<Article> result = new ArrayList<Article>(size);
        result.addAll(this.articles);
        for (Categorie c : this.l) {
            result.addAll(c.getArticles());
        }
        Collections.sort(result, new Comparator<Article>(){

            @Override
            public int compare(Article o1, Article o2) {
                boolean hasDecl;
                boolean isChild = o1.getArticlePereNom() != null && o2.getArticlePereNom() != null && o1.getArticlePereNom().trim().length() > 0 && o1.getArticlePereNom().equals(o2.getArticlePereNom());
                QuickOrderedMap<String, Tuple2<String, BigDecimal>> declinaisons1 = o1.getDeclinaisons();
                QuickOrderedMap<String, Tuple2<String, BigDecimal>> declinaisons2 = o2.getDeclinaisons();
                boolean bl = hasDecl = isChild && declinaisons1 != null && !declinaisons1.isEmpty() && declinaisons2 != null && !declinaisons2.isEmpty();
                if (o1.getName().compareTo(o2.getName()) == 0 && hasDecl) {
                    int i = 0;
                    while (i < declinaisons1.size()) {
                        BigDecimal order2;
                        BigDecimal order1;
                        String key = declinaisons1.getKey(i);
                        Tuple2<String, BigDecimal> tuple1 = declinaisons1.get(key);
                        Tuple2<String, BigDecimal> tuple2 = declinaisons2.get(key);
                        if (tuple1 != null && tuple2 != null && (order1 = tuple1.get1()).compareTo(order2 = tuple2.get1()) != 0) {
                            return order1.compareTo(order2);
                        }
                        ++i;
                    }
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }

    public static void setFavoriteProducts(List<Article> products) {
        favoriteProducts = products;
    }

    public static List<Article> getFavoriteProducts() {
        return favoriteProducts;
    }

    public static void toggleFavoriteState(Article product) {
        if (favoriteProducts.contains(product)) {
            favoriteProducts.remove(product);
        } else {
            favoriteProducts.add(product);
        }
    }
}

