/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.importer;

import java.math.BigDecimal;
import java.time.LocalDate;

public class Transaction {
    public static final String TYPE_PRELEVEMENT = "directdebit";
    public static final String TYPE_AUTRE = "other";
    public static final String TYPE_VIREMENT = "transfer";
    public static final String TYPE_CARTE = "card";
    public static final String TYPE_CHEQUE = "check";
    public static final String TYPE_ESPECES = "cash";
    private String uuid;
    private BigDecimal amount;
    private String name;
    private String memo;
    private LocalDate date;
    private LocalDate dateValue;
    private String comment;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        return this.uuid.equals(((Transaction)o).uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public LocalDate getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(LocalDate date) {
        this.dateValue = date;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        return this.date + " " + this.amount + " " + this.name + "|" + this.memo + "[" + this.uuid + "]";
    }

    public String getType() {
        String rawname = this.getName().toUpperCase();
        String type = TYPE_AUTRE;
        if (this.getAmount().compareTo(BigDecimal.ZERO) < 0) {
            if (rawname.contains("PRLV") || rawname.contains("PRELEV")) {
                type = TYPE_PRELEVEMENT;
            } else if (rawname.contains("VIREMENT") || rawname.contains("VIR CPTE")) {
                type = TYPE_VIREMENT;
            } else if (rawname.contains("CARTE")) {
                type = TYPE_CARTE;
            } else if (rawname.contains("CHEQUE")) {
                type = TYPE_CHEQUE;
            } else if (rawname.contains("ESPECES")) {
                type = TYPE_ESPECES;
            }
        } else if (rawname.contains("VIR")) {
            type = TYPE_VIREMENT;
        } else if (rawname.contains("REM") && rawname.contains("CARTE")) {
            type = TYPE_CARTE;
        } else if (rawname.contains("REM") && rawname.contains("CHEQUE")) {
            type = TYPE_CHEQUE;
        } else if (rawname.contains("ESPECES")) {
            type = TYPE_ESPECES;
        }
        return type;
    }
}

