/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.Acompte;
import org.openconcerto.erp.core.common.ui.AcompteCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNumericCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseNumericHTConvertorCellEditor;
import org.openconcerto.erp.core.common.ui.DeviseTableCellRenderer;
import org.openconcerto.erp.core.common.ui.ItemAutoCompletionManager;
import org.openconcerto.erp.core.common.ui.NiveauTableCellEditor;
import org.openconcerto.erp.core.common.ui.NiveauTableCellRender;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.common.ui.QteCellEditor;
import org.openconcerto.erp.core.common.ui.Remise;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.pos.io.BarcodeReader;
import org.openconcerto.erp.core.sales.pos.ui.BarcodeListener;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.model.ProductComponent;
import org.openconcerto.erp.core.sales.product.model.ProductHelper;
import org.openconcerto.erp.core.sales.product.ui.ArticleRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.CurrencyWithSymbolRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteMultipleRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteUnitRowValuesRenderer;
import org.openconcerto.erp.core.sales.product.ui.QteUnitairePieceRowValuesRenderer;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.StockConsultPanel;
import org.openconcerto.erp.importer.ArrayTableModel;
import org.openconcerto.erp.importer.DataImporter;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBackgroundTableCacheItem;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.ITextArticleWithCompletionCellEditor;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.list.AutoCompletionManager;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.sql.view.list.SQLTextComboTableCellEditor;
import org.openconcerto.sql.view.list.ValidStateChecker;
import org.openconcerto.ui.preferences.DefaultProps;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.i18n.TranslationManager;

public abstract class AbstractVenteArticleItemTable
extends AbstractArticleItemTable {
    public static final String ARTICLE_SHOW_DEVISE = "ArticleShowDevise";
    public static final String ARTICLE_SERVICE = "ArticleService";
    public static final String EDIT_PRIX_VENTE_CODE = "CORPS_EDITER_PRIX_VENTE";
    public static final String SHOW_PRIX_ACHAT_CODE = "CORPS_VOIR_PRIX_ACHAT";
    public static final String SHOW_PRIX_VENTE_CODE = "CORPS_VOIR_PRIX_VENTE";
    public static final String LOCK_PRIX_MIN_VENTE_CODE = "CORPS_VERROU_PRIX_MIN_VENTE";
    SQLTableElement tableElementFacturable;
    protected SQLTableElement tableElementRemise;
    private Acompte acompteFacturer = null;
    private static Map<String, Boolean> visibilityMap = new HashMap<String, Boolean>();
    private SQLTable tableArticleTarif = Configuration.getInstance().getBase().getTable("ARTICLE_TARIF");
    private SQLTable tableArticle = Configuration.getInstance().getBase().getTable("ARTICLE");
    protected AutoCompletionManager codeCompletionManager;
    Collection<? extends SQLRowAccessor> cacheRemise = null;
    Collection<? extends SQLRowAccessor> cacheRemiseFamille = null;

    public AbstractVenteArticleItemTable() {
    }

    public AbstractVenteArticleItemTable(List<JButton> buttons) {
        super(buttons);
    }

    protected boolean isCellNiveauEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
        RowValuesTableModel model = this.getModel();
        int niveau = vals.getInt("NIVEAU");
        return rowIndex + 1 == model.getRowCount() || niveau >= model.getRowValuesAt(rowIndex + 1).getInt("NIVEAU");
    }

    public void calculPourcentage(final Acompte a, final TypeCalcul type) {
        this.acompteFacturer = a;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SQLTableElement tableElement = type == TypeCalcul.CALCUL_FACTURABLE ? (this).AbstractVenteArticleItemTable.this.tableElementFacturable : (this).AbstractVenteArticleItemTable.this.tableElementRemise;
                        RowValuesTableModel model = AbstractVenteArticleItemTable.this.getModel();
                        if (a == null) {
                            int i = 0;
                            while (i < model.getRowCount()) {
                                model.putValue(null, i, type.getFieldMontant());
                                model.putValue(null, i, type.getFieldPourcent());
                                tableElement.fireModification(model.getRowValuesAt(i));
                                ++i;
                            }
                        } else if (a.getPercent() != null) {
                            int i = 0;
                            while (i < model.getRowCount()) {
                                model.putValue(a.getPercent(), i, type.getFieldPourcent());
                                model.putValue(null, i, type.getFieldMontant());
                                tableElement.fireModification(model.getRowValuesAt(i));
                                ++i;
                            }
                        } else {
                            BigDecimal totalHT = AbstractVenteArticleItemTable.this.getTotalHT(type);
                            int i = 0;
                            while (i < model.getRowCount()) {
                                if (model.getRowValuesAt(i).getInt("NIVEAU") == 1) {
                                    model.putValue(null, i, type.getFieldPourcent());
                                    SQLRowValues rowVals = model.getRowValuesAt(i);
                                    int qte = rowVals.getInt("QTE");
                                    BigDecimal qteU = rowVals.getBigDecimal("QTE_UNITAIRE");
                                    BigDecimal pU = rowVals.getBigDecimal("PV_HT");
                                    BigDecimal totalLine = pU.multiply(qteU, DecimalUtils.HIGH_PRECISION).multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION).setScale(2, RoundingMode.HALF_UP);
                                    if (rowVals.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                                        BigDecimal acomptePercent = rowVals.getBigDecimal("POURCENT_REMISE");
                                        BigDecimal acompteMontant = rowVals.getBigDecimal("MONTANT_REMISE");
                                        Remise remise = new Remise(acomptePercent, acompteMontant);
                                        totalLine = remise.getResultFrom(totalLine);
                                    }
                                    BigDecimal percent = totalHT.signum() != 0 ? totalLine.divide(totalHT, DecimalUtils.HIGH_PRECISION) : BigDecimal.ZERO;
                                    model.putValue(a.getMontant().multiply(percent, DecimalUtils.HIGH_PRECISION).setScale(6, RoundingMode.HALF_UP), i, type.getFieldMontant());
                                    tableElement.fireModification(model.getRowValuesAt(i));
                                }
                                ++i;
                            }
                        }
                        model.fireTableDataChanged();
                    }
                });
            }
        };
        this.getModel().submit(r);
    }

    public BigDecimal getTotalHT(TypeCalcul type) {
        BigDecimal totalHT = BigDecimal.ZERO;
        for (SQLRowValues rowVals : this.getRowValuesAtLevel(1)) {
            BigDecimal acompteMontant;
            BigDecimal acomptePercent;
            int qte = rowVals.getInt("QTE");
            BigDecimal qteU = rowVals.getBigDecimal("QTE_UNITAIRE");
            BigDecimal pU = rowVals.getBigDecimal("PV_HT");
            BigDecimal totalLine = pU.multiply(qteU, DecimalUtils.HIGH_PRECISION).multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION).setScale(2, RoundingMode.HALF_UP);
            if ((type == TypeCalcul.CALCUL_FACTURABLE || type == TypeCalcul.CALCUL_MONTANT_TOTAL) && rowVals.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                acomptePercent = rowVals.getBigDecimal("POURCENT_REMISE");
                acompteMontant = rowVals.getBigDecimal("MONTANT_REMISE");
                Remise remise = new Remise(acomptePercent, acompteMontant);
                totalLine = remise.getResultFrom(totalLine);
            }
            if (type == TypeCalcul.CALCUL_MONTANT_TOTAL && rowVals.getTable().getFieldsName().contains("POURCENT_FACTURABLE")) {
                acomptePercent = rowVals.getBigDecimal("POURCENT_FACTURABLE");
                acompteMontant = rowVals.getBigDecimal("MONTANT_FACTURABLE");
                Acompte acompte = new Acompte(acomptePercent, acompteMontant);
                totalLine = acompte.getResultFrom(totalLine);
            }
            totalHT = totalHT.add(totalLine);
        }
        return totalHT;
    }

    public static Map<String, Boolean> getVisibilityMap() {
        return visibilityMap;
    }

    @Override
    protected void init() {
        BarcodeReader barcodeReader;
        SQLTableElement marge;
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getSQLElement().getTable().getDBRoot());
        boolean selectArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.USE_CREATED_ARTICLE, false);
        final boolean activeCalculM2 = prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVE_CALCUL_M2, false);
        final boolean filterFamilleArticle = prefs.getBoolean(GestionArticleGlobalPreferencePanel.FILTER_BY_FAMILY, false);
        boolean createAuto = prefs.getBoolean(GestionArticleGlobalPreferencePanel.CREATE_ARTICLE_AUTO, true);
        boolean showEco = prefs.getBoolean(SHOW_ECO_CONTRIBUTION_COLUMNS, false);
        boolean showDevise = prefs.getBoolean(ARTICLE_SHOW_DEVISE, false);
        boolean withDeclinaison = prefs.getBoolean(GestionArticleGlobalPreferencePanel.ACTIVER_DECLINAISON, false);
        UserRights rights = UserRightsManager.getCurrentUserRights();
        final boolean editVTPrice = rights.haveRight(EDIT_PRIX_VENTE_CODE);
        boolean showHAPrice = rights.haveRight(SHOW_PRIX_ACHAT_CODE);
        final boolean lockVTMinPrice = rights.haveRight(LOCK_PRIX_MIN_VENTE_CODE);
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTableElement eNiveau = new SQLTableElement(e.getTable().getField("NIVEAU")){

            @Override
            public void setValueFrom(SQLRowValues row, Object value) {
                super.setValueFrom(row, value);
            }
        };
        eNiveau.setRenderer(new NiveauTableCellRender());
        eNiveau.setEditor(new NiveauTableCellEditor());
        list.add(eNiveau);
        list.add(new SQLTableElement(e.getTable().getField("ID_STYLE")));
        if (e.getTable().contains("ID_COMPTE_PCE")) {
            list.add(new SQLTableElement(e.getTable().getField("ID_COMPTE_PCE")));
        }
        SQLTableElement tableFamille = new SQLTableElement(e.getTable().getField("ID_FAMILLE_ARTICLE"));
        list.add(tableFamille);
        SQLTableElement tableElementDepot = new SQLTableElement(e.getTable().getField("ID_DEPOT_STOCK"), true, true, true);
        list.add(tableElementDepot);
        SQLTableElement tableElementArticle = new SQLTableElement(e.getTable().getField("ID_ARTICLE"), true, true, true);
        list.add(tableElementArticle);
        Set<String> fieldsName = e.getTable().getFieldsName();
        if (fieldsName.contains("ID_ECO_CONTRIBUTION")) {
            this.tableElementEcoID = new SQLTableElement(e.getTable().getField("ID_ECO_CONTRIBUTION"));
            list.add(this.tableElementEcoID);
        }
        SQLTableElement tableElementCode = new SQLTableElement(e.getTable().getField("CODE"), String.class, new ITextArticleWithCompletionCellEditor(e.getTable().getTable("ARTICLE"), e.getTable().getTable("ARTICLE_FOURNISSEUR"), withDeclinaison));
        list.add(tableElementCode);
        SQLTableElement tableElementNom = new SQLTableElement(e.getTable().getField("NOM"));
        list.add(tableElementNom);
        ArrayList<String> fieldDecl = new ArrayList<String>();
        if (withDeclinaison) {
            for (String string : fieldsName) {
                if (!string.startsWith("ID_ARTICLE_DECLINAISON")) continue;
                SQLTableElement tableElementDeclinaison = new SQLTableElement(e.getTable().getField(string));
                tableElementDeclinaison.setEditable(false);
                fieldDecl.add(string);
                list.add(tableElementDeclinaison);
            }
        }
        if (fieldsName.contains("COLORIS")) {
            SQLTableElement tableElementColoris = new SQLTableElement(e.getTable().getField("COLORIS"));
            list.add(tableElementColoris);
        }
        if (fieldsName.contains("DESCRIPTIF")) {
            SQLTableElement tableElementDesc = new SQLTableElement(e.getTable().getField("DESCRIPTIF"));
            list.add(tableElementDesc);
        }
        if (fieldsName.contains("DELAI")) {
            SQLTableElement tableElementDelai = new SQLTableElement(e.getTable().getField("DELAI"));
            list.add(tableElementDelai);
        }
        if (showDevise) {
            SQLTableElement tableElementCodeDouane = new SQLTableElement(e.getTable().getField("CODE_DOUANIER"));
            list.add(tableElementCodeDouane);
            SQLTableElement tableElementPays = new SQLTableElement(e.getTable().getField("ID_PAYS"));
            list.add(tableElementPays);
        }
        SQLTableElement qteU = new SQLTableElement(e.getTable().getField("QTE_UNITAIRE"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                SQLRowAccessor row = vals.getForeign("ID_UNITE_VENTE");
                if (row != null && !row.isUndefined() && row.getBoolean("A_LA_PIECE").booleanValue()) {
                    return false;
                }
                if (activeCalculM2 && row != null && !row.isUndefined() && row.getID() == 4) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitairePieceRowValuesRenderer();
            }

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }
        };
        list.add(qteU);
        SQLTableElement uniteVente = new SQLTableElement(e.getTable().getField("ID_UNITE_VENTE"));
        list.add(uniteVente);
        this.qte = new SQLTableElement(e.getTable().getField("QTE"), Integer.class, new QteCellEditor()){

            @Override
            protected Object getDefaultNullValue() {
                return 0;
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                if (AbstractVenteArticleItemTable.this.getSQLElement().getTable().getFieldsName().contains("QTE_ACHAT")) {
                    return new QteMultipleRowValuesRenderer();
                }
                return super.getTableCellRenderer();
            }
        };
        this.qte.setPreferredSize(20);
        list.add(this.qte);
        SQLTableElement tableElement_ValeurMetrique2 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_2"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && (modeNumber.intValue() == 5 || modeNumber.intValue() == 4 || modeNumber.intValue() == 2)) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique2);
        SQLTableElement tableElement_ValeurMetrique3 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_3"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && modeNumber.intValue() != 4) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique3);
        SQLTableElement tableElement_ValeurMetrique1 = new SQLTableElement(e.getTable().getField("VALEUR_METRIQUE_1"), Float.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                Number modeNumber = (Number)vals.getObject("ID_MODE_VENTE_ARTICLE");
                if (modeNumber != null && (modeNumber.intValue() == 5 || modeNumber.intValue() == 4 || modeNumber.intValue() == 6)) {
                    return false;
                }
                return super.isCellEditable(vals, rowIndex, columnIndex);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new ArticleRowValuesRenderer(null);
            }
        };
        list.add(tableElement_ValeurMetrique1);
        if (fieldsName.contains("PREBILAN")) {
            this.prebilan = new SQLTableElement(e.getTable().getField("PREBILAN"), BigDecimal.class){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }

                @Override
                public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                    return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
                }
            };
            this.prebilan.setRenderer(new DeviseTableCellRenderer());
            list.add(this.prebilan);
        }
        SQLTableElement tableElement_PrixMetrique1_AchatHT = new SQLTableElement(e.getTable().getField("PRIX_METRIQUE_HA_1"), BigDecimal.class){

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        tableElement_PrixMetrique1_AchatHT.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(tableElement_PrixMetrique1_AchatHT);
        SQLTableElement eltDevise = null;
        SQLTableElement eltUnitDevise = null;
        if (showDevise) {
            eltDevise = new SQLTableElement(e.getTable().getField("ID_DEVISE"));
            list.add(eltDevise);
            eltUnitDevise = new SQLTableElement(e.getTable().getField("PV_U_DEVISE"), BigDecimal.class){

                @Override
                public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                    return editVTPrice && AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
                }

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }
            };
            Path p = (Path)new Path(this.getSQLElement().getTable()).addForeignField("ID_DEVISE");
            eltUnitDevise.setRenderer(new CurrencyWithSymbolRenderer(new FieldPath(p, "CODE")));
            list.add(eltUnitDevise);
        }
        SQLField field = e.getTable().getField("PRIX_METRIQUE_VT_1");
        final DeviseNumericHTConvertorCellEditor editorPVHT = new DeviseNumericHTConvertorCellEditor(field);
        SQLTableElement tableElement_PrixMetrique1_VenteHT = new SQLTableElement(field, BigDecimal.class, editorPVHT){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return editVTPrice && AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        tableElement_PrixMetrique1_VenteHT.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(tableElement_PrixMetrique1_VenteHT);
        if (fieldsName.contains("ECO_CONTRIBUTION")) {
            this.tableElementEco = new SQLTableElement(e.getTable().getField("ECO_CONTRIBUTION"));
            list.add(this.tableElementEco);
        }
        SQLTableElement eltLongueur = new SQLTableElement(e.getTable().getField("LONGUEUR")){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                int idUv = vals.getForeignID("ID_UNITE_VENTE");
                return idUv == 4;
            }
        };
        list.add(eltLongueur);
        SQLTableElement eltLargeur = new SQLTableElement(e.getTable().getField("LARGEUR")){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                int idUv = vals.getForeignID("ID_UNITE_VENTE");
                return idUv == 4;
            }
        };
        list.add(eltLargeur);
        SQLTableElement eltHauteur = new SQLTableElement(e.getTable().getField("HAUTEUR"));
        list.add(eltHauteur);
        if (e.getTable().contains("RETOUR_STOCK")) {
            list.add(new SQLTableElement(e.getTable().getField("RETOUR_STOCK")));
        }
        SQLTableElement tableElement_ModeVente = new SQLTableElement(e.getTable().getField("ID_MODE_VENTE_ARTICLE"));
        list.add(tableElement_ModeVente);
        SQLField prixAchatHTField = e.getTable().getField("PA_HT");
        DeviseNumericCellEditor editorPAchatHT = new DeviseNumericCellEditor(prixAchatHTField);
        this.ha = new SQLTableElement(e.getTable().getField("PA_HT"), BigDecimal.class, editorPAchatHT){

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        this.ha = new SQLTableElement(prixAchatHTField, BigDecimal.class, editorPAchatHT){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        this.ha.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(this.ha);
        SQLField prixVenteHTField = e.getTable().getField("PV_HT");
        DeviseNumericCellEditor editorPVenteHT = new DeviseNumericCellEditor(prixAchatHTField);
        final SQLTableElement tableElement_PrixVente_HT = new SQLTableElement(prixVenteHTField, BigDecimal.class, editorPVenteHT){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return editVTPrice && AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        tableElement_PrixVente_HT.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(tableElement_PrixVente_HT);
        this.tableElementTVA = new SQLTableElement(e.getTable().getField("ID_TAXE"));
        this.tableElementTVA.setPreferredSize(20);
        list.add(this.tableElementTVA);
        SQLTableElement tableElementPoids = new SQLTableElement(e.getTable().getField("POIDS"), Float.class){

            @Override
            protected Object getDefaultNullValue() {
                return Float.valueOf(0.0f);
            }

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitRowValuesRenderer();
            }
        };
        tableElementPoids.setPreferredSize(20);
        list.add(tableElementPoids);
        this.tableElementPoidsTotal = new SQLTableElement(e.getTable().getField("T_POIDS"), Float.class){

            @Override
            public TableCellRenderer getTableCellRenderer() {
                return new QteUnitRowValuesRenderer();
            }
        };
        this.tableElementPoidsTotal.setEditable(false);
        list.add(this.tableElementPoidsTotal);
        if (e.getTable().contains("POIDS_COLIS_NET") && prefs.getBoolean(GestionArticleGlobalPreferencePanel.ITEM_PACKAGING, false)) {
            SQLTableElement tareColis = new SQLTableElement(e.getTable().getField("TARE"), BigDecimal.class){

                @Override
                public TableCellRenderer getTableCellRenderer() {
                    return new QteUnitRowValuesRenderer();
                }
            };
            list.add(tareColis);
            SQLTableElement nbColis = new SQLTableElement(e.getTable().getField("NB_COLIS"), Integer.class);
            list.add(nbColis);
            SQLTableElement totalPoidsColis = new SQLTableElement(e.getTable().getField("T_POIDS_COLIS_NET"), BigDecimal.class){

                @Override
                public TableCellRenderer getTableCellRenderer() {
                    return new QteUnitRowValuesRenderer();
                }
            };
            list.add(totalPoidsColis);
            final SQLTableElement totalPoidsBrut = new SQLTableElement(e.getTable().getField("T_POIDS_BRUT"), BigDecimal.class){

                @Override
                public TableCellRenderer getTableCellRenderer() {
                    return new QteUnitRowValuesRenderer();
                }
            };
            list.add(totalPoidsBrut);
            tareColis.addModificationListener(totalPoidsBrut);
            nbColis.addModificationListener(totalPoidsBrut);
            this.tableElementPoidsTotal.addModificationListener(totalPoidsBrut);
            totalPoidsBrut.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    BigDecimal tare = row.getBigDecimal("TARE");
                    Object o3 = row.getObject("NB_COLIS");
                    BigDecimal pdsBrutTotal = BigDecimal.ZERO;
                    if (row.getObject("T_POIDS") != null) {
                        pdsBrutTotal = new BigDecimal(row.getFloat("T_POIDS"));
                    }
                    if (tare != null && o3 != null) {
                        int nb = (Integer)o3;
                        pdsBrutTotal = pdsBrutTotal.add(tare.multiply(new BigDecimal(nb)));
                    }
                    return pdsBrutTotal.setScale(totalPoidsBrut.getDecimalDigits(), RoundingMode.HALF_UP);
                }
            });
        }
        if (DefaultNXProps.getInstance().getBooleanValue(ARTICLE_SERVICE, false)) {
            this.service = new SQLTableElement(e.getTable().getField("SERVICE"), Boolean.class);
            list.add(this.service);
        }
        this.totalHT = new SQLTableElement(e.getTable().getField("T_PV_HT"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        CurrencyWithSymbolRenderer totalRenderer = new CurrencyWithSymbolRenderer();
        totalRenderer.setHideZeroValue(true);
        this.totalHT.setRenderer(totalRenderer);
        this.totalHT.setEditable(false);
        this.totalHA = new SQLTableElement(e.getTable().getField("T_PA_HT"), BigDecimal.class);
        if (fieldsName.contains("MONTANT_FACTURABLE")) {
            this.tableElementFacturable = new SQLTableElement(e.getTable().getField("POURCENT_FACTURABLE"), Acompte.class, new AcompteCellEditor("POURCENT_FACTURABLE", "MONTANT_FACTURABLE")){

                @Override
                public void setValueFrom(SQLRowValues row, Object value) {
                    if (value != null) {
                        Acompte a = (Acompte)value;
                        row.put("MONTANT_FACTURABLE", a.getMontant());
                        row.put("POURCENT_FACTURABLE", a.getPercent());
                    } else {
                        row.put("MONTANT_FACTURABLE", null);
                        row.put("POURCENT_FACTURABLE", BigDecimal.ONE.movePointRight(2));
                    }
                    this.fireModification(row);
                }
            };
            this.tableElementFacturable.setRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    SQLRowValues rowVals = ((RowValuesTable)table).getRowValuesTableModel().getRowValuesAt(row);
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    BigDecimal percent = rowVals.getBigDecimal("POURCENT_FACTURABLE");
                    BigDecimal amount = rowVals.getBigDecimal("MONTANT_FACTURABLE");
                    Acompte a = new Acompte(percent, amount);
                    label.setText(a.toPlainString(true));
                    return label;
                }
            });
            this.tableElementFacturable.addModificationListener(this.totalHT);
            this.tableElementFacturable.addModificationListener(this.totalHA);
            list.add(this.tableElementFacturable);
        }
        SQLField fieldRemise = e.getTable().getField("POURCENT_REMISE");
        if (fieldsName.contains("MONTANT_REMISE")) {
            this.tableElementRemise = new SQLTableElement(e.getTable().getField("POURCENT_REMISE"), Acompte.class, new AcompteCellEditor("POURCENT_REMISE", "MONTANT_REMISE")){

                @Override
                public void setValueFrom(SQLRowValues row, Object value) {
                    if (value != null) {
                        Acompte a = (Acompte)value;
                        row.put("MONTANT_REMISE", a.getMontant());
                        row.put("POURCENT_REMISE", a.getPercent());
                    } else {
                        row.put("MONTANT_REMISE", null);
                        row.put("POURCENT_REMISE", BigDecimal.ZERO);
                    }
                    this.fireModification(row);
                }
            };
            this.tableElementRemise.setRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    SQLRowValues rowVals = ((RowValuesTable)table).getRowValuesTableModel().getRowValuesAt(row);
                    JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    BigDecimal percent = rowVals.getBigDecimal("POURCENT_REMISE");
                    BigDecimal amount = rowVals.getBigDecimal("MONTANT_REMISE");
                    Remise a = new Remise(percent, amount);
                    label.setText(a.toPlainString(true));
                    return label;
                }
            });
        } else {
            this.tableElementRemise = new SQLTableElement(fieldRemise){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }
            };
        }
        list.add(this.tableElementRemise);
        SQLTableElement tableElementRG = null;
        if (fieldsName.contains("POURCENT_RG")) {
            tableElementRG = new SQLTableElement(e.getTable().getField("POURCENT_RG"));
            list.add(tableElementRG);
        }
        this.totalHA.setRenderer(totalRenderer);
        this.totalHA.setEditable(false);
        list.add(this.totalHA);
        if (showDevise) {
            this.tableElementTotalDevise = new SQLTableElement(e.getTable().getField("PV_T_DEVISE"), BigDecimal.class){

                @Override
                public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                    return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
                }
            };
            Path p = (Path)new Path(this.getSQLElement().getTable()).addForeignField("ID_DEVISE");
            CurrencyWithSymbolRenderer currencyRenderer = new CurrencyWithSymbolRenderer(new FieldPath(p, "CODE"));
            currencyRenderer.setHideZeroValue(true);
            this.tableElementTotalDevise.setRenderer(currencyRenderer);
            list.add(this.tableElementTotalDevise);
        }
        if (fieldsName.contains("MARGE_HT")) {
            marge = new SQLTableElement(e.getTable().getField("MARGE_HT"), BigDecimal.class){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }

                @Override
                public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                    return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
                }
            };
            marge.setRenderer(totalRenderer);
            marge.setEditable(false);
            list.add(marge);
            this.totalHT.addModificationListener(marge);
            this.totalHA.addModificationListener(marge);
            marge.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    BigDecimal vt = (BigDecimal)row.getObject("T_PV_HT");
                    BigDecimal ha = (BigDecimal)row.getObject("T_PA_HT");
                    BigDecimal acomptePercent = row.getBigDecimal("POURCENT_FACTURABLE");
                    BigDecimal acompteMontant = row.getBigDecimal("MONTANT_FACTURABLE");
                    Acompte acompte = new Acompte(acomptePercent, acompteMontant);
                    ha = acompte.getResultFrom(ha);
                    vt = acompte.getResultFrom(vt);
                    return vt.subtract(ha).setScale(marge.getDecimalDigits(), RoundingMode.HALF_UP);
                }
            });
        }
        if (fieldsName.contains("MARGE_PREBILAN_HT")) {
            marge = new SQLTableElement(e.getTable().getField("MARGE_PREBILAN_HT"), BigDecimal.class){

                @Override
                protected Object getDefaultNullValue() {
                    return BigDecimal.ZERO;
                }
            };
            marge.setRenderer(new DeviseTableCellRenderer());
            marge.setEditable(false);
            list.add(marge);
            this.totalHT.addModificationListener(marge);
            this.prebilan.addModificationListener(marge);
            marge.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    BigDecimal vt = (BigDecimal)row.getObject("T_PV_HT");
                    BigDecimal ha = row.getObject("PREBILAN") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PREBILAN");
                    BigDecimal acomptePercent = row.getBigDecimal("POURCENT_FACTURABLE");
                    BigDecimal acompteMontant = row.getBigDecimal("MONTANT_FACTURABLE");
                    Acompte acompte = new Acompte(acomptePercent, acompteMontant);
                    ha = acompte.getResultFrom(ha);
                    vt = acompte.getResultFrom(vt);
                    return vt.subtract(ha).setScale(marge.getDecimalDigits(), RoundingMode.HALF_UP);
                }
            });
        }
        if (fieldsName.contains("T_ECO_CONTRIBUTION")) {
            this.tableElementEcoTotal = new SQLTableElement(e.getTable().getField("T_ECO_CONTRIBUTION"));
            list.add(this.tableElementEcoTotal);
        }
        this.totalHT.setEditable(false);
        list.add(this.totalHT);
        this.tableElementTotalTTC = new SQLTableElement(e.getTable().getField("T_PV_TTC"), BigDecimal.class){

            @Override
            public boolean isCellEditable(SQLRowValues vals, int rowIndex, int columnIndex) {
                return AbstractVenteArticleItemTable.this.isCellNiveauEditable(vals, rowIndex, columnIndex);
            }
        };
        this.tableElementTotalTTC.setRenderer(totalRenderer);
        this.tableElementTotalTTC.setEditable(false);
        list.add(this.tableElementTotalTTC);
        this.defaultRowVals = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(e.getTable()));
        this.defaultRowVals.put("ID_TAXE", TaxeCache.getCache().getFirstTaxe().getID());
        this.defaultRowVals.put("CODE", "");
        this.defaultRowVals.put("NOM", "");
        if (e.getTable().contains("ID_DEPOT_STOCK")) {
            DefaultProps props = DefaultNXProps.getInstance();
            Integer depotDefault = props.getIntProperty("DepotStockDefault", DepotStockSQLElement.DEFAULT_ID);
            this.defaultRowVals.put("ID_DEPOT_STOCK", depotDefault);
        }
        RowValuesTableModel model = new RowValuesTableModel(e, list, e.getTable().getField("ID_TAXE"), false, this.defaultRowVals){

            @Override
            public void commitData() throws SQLException {
                int size = this.getRowCount();
                int i = 0;
                while (i < size) {
                    SQLRowValues rowVals = this.getRowValuesAt(i);
                    if (rowVals.getObject("PV_U_DEVISE") == null) {
                        rowVals.put("PV_U_DEVISE", rowVals.getObject("PRIX_METRIQUE_VT_1"));
                        BigDecimal globalQty = rowVals.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(rowVals.getInt("QTE")));
                        rowVals.put("PV_T_DEVISE", rowVals.getBigDecimal("PRIX_METRIQUE_VT_1").multiply(globalQty));
                    }
                    ++i;
                }
                super.commitData(true);
            }

            @Override
            public List<SQLRowValues> fetchDataFromDB(SQLRowAccessor rowVals, SQLField referentField, SQLField fieldWhere, Object value) {
                ArrayList<SQLRowValues> newRows = new ArrayList<SQLRowValues>();
                SQLTable table = this.getSQLElement().getTable();
                SQLRowValues rowValsItem = new SQLRowValues(table);
                rowValsItem.putNulls(table.getFieldsName());
                rowValsItem.putRowValues("ID_ARTICLE").putNulls("ID", "CODE", "NOM", "ID_FAMILLE_ARTICLE", "DLC_REQUIS", "DLUO_REQUIS", "NUMERO_LOT_REQUIS", "NUMERO_SERIE_REQUIS");
                if (table.contains("ID_UNITE_VENTE")) {
                    rowValsItem.putRowValues("ID_UNITE_VENTE").putNulls("A_LA_PIECE");
                }
                if (referentField == null) {
                    referentField = table.getField("ID_" + rowVals.getTable().getName());
                }
                List<SQLRowValues> fetch = SQLRowValuesListFetcher.create(rowValsItem).fetch(new Where((FieldRef)referentField, "=", rowVals.getID()));
                for (SQLRowValues row2 : fetch) {
                    if (fieldWhere != null && !CompareUtils.equals(row2.getObject(fieldWhere.getName()), value)) continue;
                    newRows.add(row2);
                }
                return newRows;
            }
        };
        this.setModel(model);
        this.table = new RowValuesTable(model, this.getConfigurationFile());
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
        if (this.getSQLElement().getTable().getName().equals("COMMANDE_CLIENT_ELEMENT")) {
            this.table.getClearCloneTableElement().add("ID_MISSION");
            this.table.getClearCloneTableElement().add("ID_DEVIS_ELEMENT");
            this.table.getClearCloneTableElement().add("QTE_LIVREE");
            this.table.getClearCloneTableElement().add("LIVRE");
            this.table.getClearCloneTableElement().add("LIVRE_FORCED");
        }
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.displayPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.displayPopupMenu(e);
                }
            }

            private void displayPopupMenu(MouseEvent e) {
                JPopupMenu menu = new JPopupMenu();
                TaxeCache cache = TaxeCache.getCache();
                Set<SQLRowAccessor> taxes = cache.getAllTaxe();
                JMenu subMenuTVA = new JMenu("Appliquer une TVA sp\u00e9cifique sur toutes les lignes");
                menu.add(subMenuTVA);
                for (final SQLRowAccessor taxe : taxes) {
                    subMenuTVA.add(new JMenuItem(new AbstractAction(String.valueOf(taxe.getFloat("TAUX")) + "%"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int i = 0;
                            while (i < (this).AbstractVenteArticleItemTable.this.table.getRowCount()) {
                                (this).AbstractVenteArticleItemTable.this.table.getRowValuesTableModel().putValue(taxe.getID(), i, "ID_TAXE");
                                ++i;
                            }
                        }
                    }));
                }
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        if (filterFamilleArticle) {
            ((SQLTextComboTableCellEditor)tableElementArticle.getTableCellEditor(this.table)).setDynamicWhere(e.getTable().getTable("ARTICLE").getField("ID_FAMILLE_ARTICLE"));
        }
        final SQLTable sqlTableArticle = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("ARTICLE");
        ArrayList<String> completionField = new ArrayList<String>();
        if (fieldsName.contains("ID_ECO_CONTRIBUTION")) {
            completionField.add("ID_ECO_CONTRIBUTION");
        }
        if (showDevise) {
            completionField.add("CODE_DOUANIER");
            completionField.add("ID_PAYS");
        }
        completionField.add("POURCENT_REMISE");
        completionField.add("ID_UNITE_VENTE");
        completionField.add("QTE_UNITAIRE");
        completionField.add("QTE");
        completionField.add("PA_HT");
        completionField.add("PV_HT");
        completionField.add("ID_TAXE");
        completionField.add("POIDS");
        completionField.add("PRIX_METRIQUE_HA_1");
        completionField.add("PRIX_METRIQUE_HA_2");
        completionField.add("PRIX_METRIQUE_HA_3");
        completionField.add("VALEUR_METRIQUE_1");
        completionField.add("VALEUR_METRIQUE_2");
        completionField.add("VALEUR_METRIQUE_3");
        completionField.add("ID_MODE_VENTE_ARTICLE");
        completionField.add("PRIX_METRIQUE_VT_1");
        completionField.add("PRIX_METRIQUE_VT_2");
        completionField.add("PRIX_METRIQUE_VT_3");
        completionField.add("SERVICE");
        completionField.add("ID_FAMILLE_ARTICLE");
        completionField.add("LONGUEUR");
        completionField.add("LARGEUR");
        completionField.add("HAUTEUR");
        completionField.addAll(fieldDecl);
        if (this.getSQLElement().getTable().getFieldsName().contains("DESCRIPTIF")) {
            completionField.add("DESCRIPTIF");
        }
        if (showDevise) {
            completionField.add("ID_DEVISE");
            completionField.add("PV_U_DEVISE");
        }
        if (this.getSQLElement().getTable().getFieldsName().contains("QTE_ACHAT") && sqlTableArticle.getTable().getFieldsName().contains("QTE_ACHAT")) {
            completionField.add("QTE_ACHAT");
        }
        if (this.getSQLElement().getTable().getFieldsName().contains("POIDS_COLIS_NET") && sqlTableArticle.getTable().getFieldsName().contains("POIDS_COLIS_NET")) {
            completionField.add("POIDS_COLIS_NET");
        }
        if (this.getSQLElement().getTable().getFieldsName().contains("TARE") && sqlTableArticle.getTable().getFieldsName().contains("TARE")) {
            completionField.add("TARE");
        }
        this.codeCompletionManager = new ItemAutoCompletionManager(this, tableElementCode, sqlTableArticle.getField("CODE"), this.table, this.table.getRowValuesTableModel());
        this.codeCompletionManager.fill("NOM", "NOM");
        this.codeCompletionManager.fill("ID", "ID_ARTICLE");
        for (String string : completionField) {
            this.codeCompletionManager.fill(string, string);
        }
        ITransformer<SQLSelect, SQLSelect> selTrans = new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                SQLTable tableStock = sqlTableArticle.getTable("STOCK");
                input.andWhere(new Where((FieldRef)tableStock.getKey(), "=", sqlTableArticle.getField("ID_STOCK")));
                input.setExcludeUndefined(false, tableStock);
                Where w = new Where((FieldRef)sqlTableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE).or(new Where(input.getAlias(tableStock.getKey()), "!=", tableStock.getUndefinedID()).and(new Where(input.getAlias(tableStock.getField("QTE_REEL")), ">", 0)));
                if (input.getWhere() != null) {
                    input.setWhere(input.getWhere().and(w));
                } else {
                    input.setWhere(w);
                }
                input.asString();
                return input;
            }
        };
        this.codeCompletionManager.setSelectTransformer(selTrans);
        this.table.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent dtde) {
                AbstractVenteArticleItemTable.this.dropInTable(dtde, AbstractVenteArticleItemTable.this.codeCompletionManager);
            }
        });
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.CAN_EXPAND_NOMENCLATURE_VT, true)) {
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.handlePopup(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.handlePopup(e);
                }

                public void handlePopup(MouseEvent e) {
                    final int rowindex = AbstractVenteArticleItemTable.this.table.getSelectedRow();
                    if (rowindex < 0) {
                        return;
                    }
                    if (e.isPopupTrigger() && e.getComponent() instanceof JTable) {
                        JPopupMenu popup = new JPopupMenu();
                        popup.add(new AbstractAction(TranslationManager.getInstance().getTranslationForItem("product.bom.expand")){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                AbstractVenteArticleItemTable.this.expandNomenclature(rowindex, (this).AbstractVenteArticleItemTable.this.codeCompletionManager, AbstractArticleItemTable.EXPAND_TYPE.EXPAND);
                            }
                        });
                        popup.add(new AbstractAction(TranslationManager.getInstance().getTranslationForItem("product.bom.expose")){

                            @Override
                            public void actionPerformed(ActionEvent arg0) {
                                AbstractVenteArticleItemTable.this.expandNomenclature(rowindex, (this).AbstractVenteArticleItemTable.this.codeCompletionManager, AbstractArticleItemTable.EXPAND_TYPE.VIEW_ONLY);
                            }
                        });
                        for (AbstractAction action : AbstractVenteArticleItemTable.this.getAdditionnalMouseAction(rowindex)) {
                            popup.add(action);
                        }
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        ComboSQLRequest req = new ComboSQLRequest(sqlTableArticle, Arrays.asList("NOM", "CODE"));
        req.setSelectTransf(selTrans);
        final ItemAutoCompletionManager m2 = new ItemAutoCompletionManager(this, tableElementNom, sqlTableArticle.getField("NOM"), this.table, this.table.getRowValuesTableModel(), req);
        m2.fill("CODE", "CODE");
        m2.fill("ID", "ID_ARTICLE");
        for (String string : completionField) {
            m2.fill(string, string);
        }
        m2.setSelectTransformer(selTrans);
        ItemAutoCompletionManager m3 = new ItemAutoCompletionManager(this, tableElementArticle, sqlTableArticle.getField("NOM"), this.table, this.table.getRowValuesTableModel(), 2, true, true, new ValidStateChecker());
        m3.fill("CODE", "CODE");
        m3.fill("NOM", "NOM");
        for (String string : completionField) {
            m3.fill(string, string);
        }
        m3.setSelectTransformer(selTrans);
        tableFamille.addModificationListener(tableElementArticle);
        tableElementCode.addModificationListener(tableElementArticle);
        tableElementArticle.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                try {
                    SQLRowAccessor foreign;
                    if (filterFamilleArticle) {
                        if (row.isForeignEmpty("ID_FAMILLE_ARTICLE")) {
                            AbstractVenteArticleItemTable.this.codeCompletionManager.setWhere(null);
                            m2.setWhere(null);
                        } else {
                            AbstractVenteArticleItemTable.this.codeCompletionManager.setWhere(new Where((FieldRef)sqlTableArticle.getField("ID_FAMILLE_ARTICLE"), "=", row.getForeignID("ID_FAMILLE_ARTICLE")));
                            m2.setWhere(new Where((FieldRef)sqlTableArticle.getField("ID_FAMILLE_ARTICLE"), "=", row.getForeignID("ID_FAMILLE_ARTICLE")));
                        }
                    }
                    if ((foreign = row.getForeign("ID_ARTICLE")) != null && !foreign.isUndefined() && foreign.getObject("CODE") != null && foreign.getString("CODE").equals(row.getString("CODE"))) {
                        return foreign;
                    }
                    return AbstractVenteArticleItemTable.this.tableArticle.getUndefinedID();
                }
                catch (Exception e) {
                    return AbstractVenteArticleItemTable.this.tableArticle.getUndefinedID();
                }
            }
        });
        if (this.tableElementEco != null && this.tableElementEcoTotal != null && this.tableElementEcoID != null) {
            this.qte.addModificationListener(this.tableElementEcoTotal);
            this.tableElementEco.addModificationListener(this.tableElementEcoTotal);
            this.tableElementEcoTotal.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    int qte = Integer.parseInt(row.getObject("QTE").toString());
                    BigDecimal f = row.getObject("ECO_CONTRIBUTION") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("ECO_CONTRIBUTION");
                    return f.multiply(new BigDecimal(qte));
                }
            });
            this.tableElementEcoID.addModificationListener(this.tableElementEco);
            this.tableElementEco.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    if (source != null && source.equals(AbstractVenteArticleItemTable.this.tableElementEcoID)) {
                        return row.getForeign("ID_ECO_CONTRIBUTION").getBigDecimal("TAUX");
                    }
                    return row.getObject("ECO_CONTRIBUTION");
                }
            });
        }
        this.qte.addModificationListener(tableElement_PrixMetrique1_VenteHT);
        this.qte.addModificationListener(this.totalHT);
        this.qte.addModificationListener(this.totalHA);
        qteU.addModificationListener(this.totalHT);
        qteU.addModificationListener(this.totalHA);
        if (tableElementRG != null) {
            tableElementRG.addModificationListener(this.totalHT);
        }
        this.tableElementRemise.addModificationListener(this.totalHT);
        tableElement_PrixVente_HT.addModificationListener(this.totalHT);
        this.ha.addModificationListener(this.totalHA);
        this.totalHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                BigDecimal acompteMontant;
                BigDecimal acomptePercent;
                Object o3;
                BigDecimal lremise = BigDecimal.ZERO;
                if (row.getTable().getFieldsName().contains("POURCENT_RG") && (o3 = row.getObject("POURCENT_RG")) != null) {
                    lremise = lremise.add((BigDecimal)o3);
                }
                int qte = row.getObject("QTE") == null ? 0 : Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal f = (BigDecimal)row.getObject("PV_HT");
                BigDecimal r = b.multiply(f.multiply(BigDecimal.valueOf(qte), DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                if (lremise.compareTo(BigDecimal.ZERO) > 0 && lremise.compareTo(BigDecimal.valueOf(100L)) < 100) {
                    r = r.multiply(BigDecimal.valueOf(100L).subtract(lremise), DecimalUtils.HIGH_PRECISION).movePointLeft(2);
                }
                if (row.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                    acomptePercent = row.getBigDecimal("POURCENT_REMISE");
                    acompteMontant = row.getBigDecimal("MONTANT_REMISE");
                    Remise remise = new Remise(acomptePercent, acompteMontant);
                    r = remise.getResultFrom(r);
                }
                if (row.getTable().getFieldsName().contains("POURCENT_FACTURABLE")) {
                    acomptePercent = row.getBigDecimal("POURCENT_FACTURABLE");
                    acompteMontant = row.getBigDecimal("MONTANT_FACTURABLE");
                    Acompte acompte = new Acompte(acomptePercent, acompteMontant);
                    r = acompte.getResultFrom(r);
                }
                return r.setScale(AbstractVenteArticleItemTable.this.totalHT.getDecimalDigits(), 4);
            }
        });
        this.totalHA.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                BigDecimal f = (BigDecimal)row.getObject("PA_HT");
                BigDecimal rHA = b.multiply(new BigDecimal(qte), DecimalUtils.HIGH_PRECISION).multiply(f, DecimalUtils.HIGH_PRECISION).setScale(6, 4);
                if (row.getTable().getFieldsName().contains("POURCENT_FACTURABLE")) {
                    BigDecimal acomptePercent = row.getBigDecimal("POURCENT_FACTURABLE");
                    BigDecimal acompteMontant = row.getBigDecimal("MONTANT_FACTURABLE");
                    if (acomptePercent != null || acompteMontant != null) {
                        if (acomptePercent != null) {
                            rHA = rHA.multiply(acomptePercent.movePointLeft(2), DecimalUtils.HIGH_PRECISION);
                        } else {
                            Object o3;
                            BigDecimal lremise = BigDecimal.ZERO;
                            if (row.getTable().getFieldsName().contains("POURCENT_RG") && (o3 = row.getObject("POURCENT_RG")) != null) {
                                lremise = lremise.add((BigDecimal)o3);
                            }
                            BigDecimal fVT = (BigDecimal)row.getObject("PV_HT");
                            BigDecimal r = b.multiply(fVT.multiply(BigDecimal.valueOf(qte), DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                            if (lremise.compareTo(BigDecimal.ZERO) > 0) {
                                r = r.multiply(BigDecimal.valueOf(100L).subtract(lremise), DecimalUtils.HIGH_PRECISION).movePointLeft(2);
                            }
                            if (row.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                                BigDecimal acomptePercentR = row.getBigDecimal("POURCENT_REMISE");
                                BigDecimal acompteMontantR = row.getBigDecimal("MONTANT_REMISE");
                                Remise remise = new Remise(acomptePercentR, acompteMontantR);
                                r = remise.getResultFrom(r);
                                if (acompteMontant.signum() == 0 && acomptePercentR != null && acomptePercentR.compareTo(BigDecimal.ONE.movePointRight(2)) == 0) {
                                    r = BigDecimal.ZERO;
                                    BigDecimal totalHTGlobal = AbstractVenteArticleItemTable.this.getTotalHT(TypeCalcul.CALCUL_FACTURABLE);
                                    if (AbstractVenteArticleItemTable.this.acompteFacturer != null && AbstractVenteArticleItemTable.this.acompteFacturer.getMontant() != null && totalHTGlobal != null && totalHTGlobal.signum() != 0) {
                                        rHA = rHA.multiply(AbstractVenteArticleItemTable.this.acompteFacturer.getMontant().divide(totalHTGlobal, DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                                    }
                                }
                            }
                            if (r.signum() != 0) {
                                rHA = rHA.multiply(acompteMontant.divide(r, DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                            }
                        }
                    }
                }
                return rHA.setScale(AbstractVenteArticleItemTable.this.totalHA.getDecimalDigits(), 4);
            }

            @Override
            public void setValueFrom(SQLRowValues row, Object value) {
                super.setValueFrom(row, value);
            }
        });
        if (showDevise) {
            this.qte.addModificationListener(this.tableElementTotalDevise);
            qteU.addModificationListener(this.tableElementTotalDevise);
            if (eltUnitDevise != null) {
                eltUnitDevise.addModificationListener(this.tableElementTotalDevise);
            }
            this.tableElementRemise.addModificationListener(this.tableElementTotalDevise);
            this.tableElementTotalDevise.setModifier(new CellDynamicModifier(){

                @Override
                public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                    int qte = row.getInt("QTE");
                    BigDecimal prixDeVenteUnitaireDevise = row.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PV_U_DEVISE");
                    BigDecimal qUnitaire = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                    BigDecimal prixVente = qUnitaire.multiply(prixDeVenteUnitaireDevise.multiply(BigDecimal.valueOf(qte), DecimalUtils.HIGH_PRECISION), DecimalUtils.HIGH_PRECISION);
                    if (row.getTable().getFieldsName().contains("MONTANT_REMISE")) {
                        BigDecimal acomptePercent = row.getBigDecimal("POURCENT_REMISE");
                        BigDecimal acompteMontant = row.getBigDecimal("MONTANT_REMISE");
                        Remise remise = new Remise(acomptePercent, acompteMontant);
                        prixVente = remise.getResultFrom(prixVente);
                    }
                    return prixVente.setScale(AbstractVenteArticleItemTable.this.tableElementTotalDevise.getDecimalDigits(), 4);
                }
            });
        }
        this.totalHT.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTVA.addModificationListener(this.tableElementTotalTTC);
        this.tableElementTotalTTC.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                Collection minPrices;
                BigDecimal ht = (BigDecimal)row.getObject("T_PV_HT");
                int idTaux = row.getForeignID("ID_TAXE");
                Float resultTaux = TaxeCache.getCache().getTauxFromId(idTaux);
                if (resultTaux == null) {
                    SQLRow rowTax = TaxeCache.getCache().getFirstTaxe();
                    row.put("ID_TAXE", rowTax.getID());
                    resultTaux = Float.valueOf(rowTax.getFloat("TAUX"));
                }
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                editorPVHT.setTaxe(taux);
                editorPVHT.setMin(null);
                if (!row.isForeignEmpty("ID_ARTICLE") && AbstractVenteArticleItemTable.this.getSQLElement().getTable().getDBRoot().contains("ARTICLE_PRIX_MIN_VENTE") && !lockVTMinPrice && (minPrices = row.getForeign("ID_ARTICLE").asRow().getReferentRows(row.getTable().getTable("ARTICLE_PRIX_MIN_VENTE"))).size() > 0) {
                    editorPVHT.setMin(((SQLRow)minPrices.get(0)).getBigDecimal("PRIX"));
                }
                BigDecimal r = ht.multiply(BigDecimal.valueOf(taux).movePointLeft(2).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION);
                BigDecimal resultTTC = r.setScale(AbstractVenteArticleItemTable.this.tableElementTotalTTC.getDecimalDigits(), 4);
                return resultTTC;
            }

            @Override
            public void setValueFrom(SQLRowValues row, Object value) {
                super.setValueFrom(row, value);
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique2.addModificationListener(tableElementPoids);
        tableElement_ValeurMetrique3.addModificationListener(tableElementPoids);
        tableElementPoids.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                return new Float(ReferenceArticleSQLElement.getPoidsFromDetails(row));
            }
        });
        tableElementPoids.addModificationListener(this.tableElementPoidsTotal);
        qteU.addModificationListener(this.tableElementPoidsTotal);
        this.qte.addModificationListener(this.tableElementPoidsTotal);
        this.tableElementPoidsTotal.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                Number f = (Number)row.getObject("POIDS");
                if (f == null) {
                    f = 0;
                }
                int qte = Integer.parseInt(row.getObject("QTE").toString());
                BigDecimal b = row.getObject("QTE_UNITAIRE") == null ? BigDecimal.ONE : (BigDecimal)row.getObject("QTE_UNITAIRE");
                return Float.valueOf(b.multiply(new BigDecimal(f.floatValue() * (float)qte)).floatValue());
            }
        });
        uniteVente.addModificationListener(qteU);
        eltLargeur.addModificationListener(qteU);
        eltLongueur.addModificationListener(qteU);
        qteU.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                SQLRowAccessor rowUnite = row.getForeign("ID_UNITE_VENTE");
                if (rowUnite != null && !rowUnite.isUndefined() && rowUnite.getBoolean("A_LA_PIECE").booleanValue()) {
                    return BigDecimal.ONE;
                }
                if (activeCalculM2 && rowUnite != null && !rowUnite.isUndefined() && rowUnite.getID() == 4) {
                    BigDecimal longueur = row.getBigDecimal("LONGUEUR");
                    BigDecimal largeur = row.getBigDecimal("LARGEUR");
                    if (longueur == null || largeur == null) {
                        return BigDecimal.ONE;
                    }
                    return longueur.multiply(largeur);
                }
                return row.getObject("QTE_UNITAIRE");
            }
        });
        tableElement_PrixMetrique1_VenteHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (source != null && source.getField().getName().equals("PRIX_METRIQUE_VT_1")) {
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                if (source != null && source.getField().getName().equals("PV_U_DEVISE")) {
                    if (!row.isForeignEmpty("ID_DEVISE")) {
                        String devCode = row.getForeign("ID_DEVISE").getString("CODE");
                        CurrencyConverter c = new CurrencyConverter();
                        BigDecimal prixDeVenteUnitaireDevise = row.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PV_U_DEVISE");
                        BigDecimal result = c.convert(prixDeVenteUnitaireDevise, devCode, c.getCompanyCurrencyCode(), AbstractVenteArticleItemTable.this.getDateDevise(), AbstractVenteArticleItemTable.this.isUsedBiasedDevise());
                        if (result == null) {
                            result = prixDeVenteUnitaireDevise;
                        }
                        return result.setScale((int)row.getTable().getField("PRIX_METRIQUE_VT_1").getType().getDecimalDigits(), RoundingMode.HALF_UP);
                    }
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                return AbstractVenteArticleItemTable.this.tarifCompletion(row.getForeign("ID_ARTICLE"), "PRIX_METRIQUE_VT_1", row);
            }
        });
        if (showDevise) {
            if (eltUnitDevise != null) {
                eltUnitDevise.addModificationListener(tableElement_PrixMetrique1_VenteHT);
            }
            if (eltUnitDevise != null) {
                tableElement_PrixMetrique1_VenteHT.addModificationListener(eltUnitDevise);
                eltDevise.addModificationListener(eltUnitDevise);
                eltUnitDevise.setModifier(new CellDynamicModifier(){

                    @Override
                    public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                        if (source != null && source.getField().getName().equals("PV_U_DEVISE")) {
                            BigDecimal prixDeVenteUnitaireDevise = row.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PV_U_DEVISE");
                            return prixDeVenteUnitaireDevise;
                        }
                        if (!row.isForeignEmpty("ID_DEVISE")) {
                            String devCode = row.getForeign("ID_DEVISE").getString("CODE");
                            CurrencyConverter c = new CurrencyConverter();
                            BigDecimal bigDecimal = (BigDecimal)row.getObject("PRIX_METRIQUE_VT_1");
                            BigDecimal result = c.convert(bigDecimal, c.getCompanyCurrencyCode(), devCode, AbstractVenteArticleItemTable.this.getDateDevise(), AbstractVenteArticleItemTable.this.isUsedBiasedDevise());
                            if (result == null) {
                                result = bigDecimal;
                            }
                            return result.setScale((int)row.getTable().getField("PRIX_METRIQUE_VT_1").getType().getDecimalDigits(), RoundingMode.HALF_UP);
                        }
                        if (source != null && source.getField().getName().equalsIgnoreCase("PRIX_METRIQUE_VT_1")) {
                            return row.getObject("PRIX_METRIQUE_VT_1");
                        }
                        BigDecimal prixDeVenteUnitaireDevise = row.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)row.getObject("PV_U_DEVISE");
                        return prixDeVenteUnitaireDevise;
                    }
                });
            }
        }
        tableElement_ValeurMetrique1.addModificationListener(tableElement_PrixVente_HT);
        tableElement_ValeurMetrique2.addModificationListener(tableElement_PrixVente_HT);
        tableElement_ValeurMetrique3.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixMetrique1_VenteHT.addModificationListener(tableElement_PrixVente_HT);
        tableElement_PrixVente_HT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (row.isForeignEmpty("ID_MODE_VENTE_ARTICLE") || row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return row.getObject("PRIX_METRIQUE_VT_1");
                }
                BigDecimal prixVTFromDetails = ReferenceArticleSQLElement.getPrixVTFromDetails(row);
                return prixVTFromDetails.setScale(tableElement_PrixVente_HT.getDecimalDigits(), RoundingMode.HALF_UP);
            }
        });
        tableElement_ValeurMetrique1.addModificationListener(this.ha);
        tableElement_ValeurMetrique2.addModificationListener(this.ha);
        tableElement_ValeurMetrique3.addModificationListener(this.ha);
        tableElement_PrixMetrique1_AchatHT.addModificationListener(this.ha);
        this.ha.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (row.isForeignEmpty("ID_MODE_VENTE_ARTICLE") || row.getInt("ID_MODE_VENTE_ARTICLE") == 5) {
                    return row.getObject("PRIX_METRIQUE_HA_1");
                }
                BigDecimal prixHAFromDetails = ReferenceArticleSQLElement.getPrixHAFromDetails(row);
                return prixHAFromDetails.setScale(AbstractVenteArticleItemTable.this.ha.getDecimalDigits(), RoundingMode.HALF_UP);
            }
        });
        this.table.readState();
        this.setColumnVisible(model.getColumnForField("T_PA_HT"), true);
        if (prefs.getBoolean(GestionArticleGlobalPreferencePanel.ITEM_PACKAGING, false)) {
            this.setColumnVisible(model.getColumnForField("T_POIDS_COLIS_NET"), false);
        }
        boolean modeAvance = DefaultNXProps.getInstance().getBooleanValue("ArticleModeVenteAvance", false);
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_1"), modeAvance);
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_2"), modeAvance);
        this.setColumnVisible(model.getColumnForField("VALEUR_METRIQUE_3"), modeAvance);
        this.setColumnVisible(model.getColumnForField("PV_HT"), modeAvance);
        this.setColumnVisible(model.getColumnForField("PA_HT"), modeAvance);
        this.setColumnVisible(model.getColumnForField("ID_MODE_VENTE_ARTICLE"), modeAvance);
        if (this.tableElementEco != null && this.tableElementEcoTotal != null && this.tableElementEcoID != null) {
            this.setColumnVisible(model.getColumnForField("ID_ECO_CONTRIBUTION"), showEco);
            this.setColumnVisible(model.getColumnForField("ECO_CONTRIBUTION"), showEco);
            this.setColumnVisible(model.getColumnForField("T_ECO_CONTRIBUTION"), showEco);
        }
        this.setColumnVisible(model.getColumnForField("HAUTEUR"), false);
        this.setColumnVisible(model.getColumnForField("LARGEUR"), activeCalculM2);
        this.setColumnVisible(model.getColumnForField("LONGUEUR"), activeCalculM2);
        boolean gestionUV = prefs.getBoolean(GestionArticleGlobalPreferencePanel.UNITE_VENTE, true);
        this.setColumnVisible(model.getColumnForField("QTE_UNITAIRE"), gestionUV);
        this.setColumnVisible(model.getColumnForField("ID_UNITE_VENTE"), gestionUV);
        this.setColumnVisible(model.getColumnForField("ID_ARTICLE"), selectArticle);
        this.setColumnVisible(model.getColumnForField("CODE"), !selectArticle || selectArticle && createAuto);
        this.setColumnVisible(model.getColumnForField("NOM"), !selectArticle || selectArticle && createAuto);
        boolean showPoids = DefaultNXProps.getInstance().getBooleanValue("ArticleShowPoids", false);
        this.setColumnVisible(model.getColumnForField("POIDS"), showPoids);
        this.setColumnVisible(model.getColumnForField("T_POIDS"), showPoids);
        this.setColumnVisible(model.getColumnForField("ID_STYLE"), DefaultNXProps.getInstance().getBooleanValue("ArticleShowStyle", true));
        this.setColumnVisible(model.getColumnForField("POURCENT_FACTURABLE"), false);
        this.setColumnVisible(this.getModel().getColumnForField("ID_FAMILLE_ARTICLE"), filterFamilleArticle);
        this.setColumnVisible(model.getColumnForField("PRIX_METRIQUE_HA_1"), showHAPrice);
        this.setColumnVisible(model.getColumnForField("MARGE_HT"), showHAPrice);
        this.setColumnVisible(model.getColumnForField("T_PA_HT"), showHAPrice);
        this.setColumnVisible(model.getColumnForField("ID_DEPOT_STOCK"), prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_MULTI_DEPOT, false));
        this.setColumnVisible(model.getColumnForField("T_POIDS_COLIS_NET"), false);
        this.setColumnVisible(model.getColumnForField("T_POIDS_BRUT"), false);
        for (String string : visibilityMap.keySet()) {
            this.setColumnVisible(model.getColumnForField(string), visibilityMap.get(string));
        }
        Map<String, Boolean> mapCustom = this.getCustomVisibilityMap();
        if (mapCustom != null) {
            for (String string : mapCustom.keySet()) {
                this.setColumnVisible(model.getColumnForField(string), mapCustom.get(string));
            }
        }
        if ((barcodeReader = ComptaPropsConfiguration.getInstanceCompta().getBarcodeReader()) != null) {
            final BarcodeListener l = new BarcodeListener(){

                @Override
                public void keyReceived(KeyEvent ee) {
                }

                @Override
                public void barcodeRead(String code) {
                    if (((JFrame)SwingUtilities.getRoot(AbstractVenteArticleItemTable.this.getRowValuesTable())).isActive()) {
                        SQLSelect selArticle = new SQLSelect();
                        SQLTable tableArticle = AbstractVenteArticleItemTable.this.getSQLElement().getForeignElement("ID_ARTICLE").getTable();
                        selArticle.addSelectStar(tableArticle);
                        Where w = new Where((FieldRef)tableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE);
                        w = w.and(new Where((FieldRef)tableArticle.getField("CODE_BARRE"), "=", (Object)code));
                        selArticle.setWhere(w);
                        List<SQLRow> l2 = SQLRowListRSH.execute(selArticle);
                        if (l2.size() > 0) {
                            System.err.println("ARTICLE " + l2.get(0).getString("NOM"));
                            Tuple3<Double, String, String> art = Tuple3.create(1.0, l2.get(0).getString("CODE"), l2.get(0).getString("NOM"));
                            ArrayList<Tuple3<Double, String, String>> l = new ArrayList<Tuple3<Double, String, String>>();
                            l.add(art);
                            AbstractVenteArticleItemTable.this.insertFromDrop(l, AbstractVenteArticleItemTable.this.codeCompletionManager);
                        } else {
                            System.err.println("ARTICLE NOT FOUND !");
                        }
                    }
                }
            };
            this.getRowValuesTable().addHierarchyListener(new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 2L) != 0L) {
                        if (AbstractVenteArticleItemTable.this.getRowValuesTable().isDisplayable()) {
                            barcodeReader.addBarcodeListener(l);
                        } else {
                            barcodeReader.removeBarcodeListener(l);
                        }
                    }
                }
            });
        }
        this.table.writeState();
        if (this.table.getRowValuesTableModel().getColumnForField("ID_DEPOT_STOCK") >= 0 && this.table.getRowValuesTableModel().getColumnForField("ID_ARTICLE") >= 0) {
            if (this.buttons == null) {
                this.buttons = new ArrayList();
            }
            JButton buttonStock = new JButton("Consulter le stock");
            buttonStock.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    try {
                        SQLRowAccessor foreignArt;
                        SQLRowValues rowValsSel = AbstractVenteArticleItemTable.this.table.getSelectedRowValues();
                        if (rowValsSel != null && (foreignArt = rowValsSel.getForeign("ID_ARTICLE")) != null && !foreignArt.isUndefined()) {
                            StockConsultPanel panel = new StockConsultPanel(AbstractVenteArticleItemTable.this.getSQLElement().getForeignElement("ID_ARTICLE"), foreignArt);
                            PanelFrame frame = new PanelFrame(panel, "Consultation du stock");
                            frame.setVisible(true);
                        }
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Erreur d'acc\u00e8s au stock", e);
                    }
                }
            });
            this.buttons.add(buttonStock);
        }
    }

    protected BigDecimal getTarifRemiseClient(SQLRowAccessor article, BigDecimal pv) {
        if (this.cacheRemise != null && this.getRowClient() != null && !this.getRowClient().isUndefined() && article != null && !article.isUndefined()) {
            for (SQLRowAccessor sQLRowAccessor : this.cacheRemise) {
                BigDecimal remise;
                if (sQLRowAccessor.isForeignEmpty("ID_ARTICLE") || sQLRowAccessor.getForeignID("ID_ARTICLE") != article.getID() || (remise = sQLRowAccessor.getBigDecimal("POURCENT_REMISE")) == null) continue;
                return pv.multiply(BigDecimal.ONE.subtract(remise.movePointLeft(2)), DecimalUtils.HIGH_PRECISION).setScale(pv.scale(), RoundingMode.HALF_UP);
            }
        }
        return pv;
    }

    protected Acompte getRemiseClient(SQLRowAccessor article, Acompte acompteTarif) {
        SQLRow rowFamille3;
        Integer fIDPere2;
        SQLRow rowFamille2;
        Integer fIDPere;
        SQLBackgroundTableCacheItem cacheTableFamille;
        SQLRow rowFamille;
        Integer n;
        Acompte remise = null;
        if (!(this.cacheRemiseFamille == null || this.getRowClient() == null || this.getRowClient().isUndefined() || article == null || article.isUndefined() || article.getForeign("ID_FAMILLE_ARTICLE") == null || article.isForeignEmpty("ID_FAMILLE_ARTICLE") || (remise = this.getRemiseFamille(n = Integer.valueOf(article.getForeignID("ID_FAMILLE_ARTICLE")))) != null || (rowFamille = (cacheTableFamille = SQLBackgroundTableCache.getInstance().getCacheForTable(article.getTable().getForeignTable("ID_FAMILLE_ARTICLE"))).getRowFromId(n)) == null || rowFamille.getObject("ID_FAMILLE_ARTICLE_PERE") == null || rowFamille.isForeignEmpty("ID_FAMILLE_ARTICLE_PERE") || (remise = this.getRemiseFamille(fIDPere = Integer.valueOf(rowFamille.getForeignID("ID_FAMILLE_ARTICLE_PERE")))) != null || (rowFamille2 = cacheTableFamille.getRowFromId(fIDPere)) == null || rowFamille2.getObject("ID_FAMILLE_ARTICLE_PERE") == null || rowFamille2.isForeignEmpty("ID_FAMILLE_ARTICLE_PERE") || (remise = this.getRemiseFamille(fIDPere2 = Integer.valueOf(rowFamille2.getForeignID("ID_FAMILLE_ARTICLE_PERE")))) != null || (rowFamille3 = cacheTableFamille.getRowFromId(fIDPere2)) == null || rowFamille3.getObject("ID_FAMILLE_ARTICLE_PERE") == null || rowFamille3.isForeignEmpty("ID_FAMILLE_ARTICLE_PERE"))) {
            Integer fIDPere3 = rowFamille3.getForeignID("ID_FAMILLE_ARTICLE_PERE");
            remise = this.getRemiseFamille(fIDPere3);
        }
        if (this.cacheRemise != null && this.getRowClient() != null && !this.getRowClient().isUndefined() && article != null && !article.isUndefined()) {
            for (SQLRowAccessor sQLRowAccessor : this.cacheRemise) {
                if (sQLRowAccessor.isForeignEmpty("ID_ARTICLE") || sQLRowAccessor.getForeignID("ID_ARTICLE") != article.getID()) continue;
                BigDecimal r = sQLRowAccessor.getBigDecimal("POURCENT_REMISE");
                remise = new Acompte(r, null);
                break;
            }
        }
        if (remise == null) {
            if (acompteTarif == null) {
                return new Acompte(BigDecimal.ZERO, BigDecimal.ZERO);
            }
            return acompteTarif;
        }
        if (acompteTarif != null && acompteTarif.getPercent() != null && remise.getPercent().compareTo(acompteTarif.percent) > 0) {
            return remise;
        }
        return acompteTarif;
    }

    private Acompte getRemiseFamille(int fID) {
        Acompte remise = null;
        for (SQLRowAccessor sQLRowAccessor : this.cacheRemiseFamille) {
            if (sQLRowAccessor.isForeignEmpty("ID_FAMILLE_ARTICLE") || sQLRowAccessor.getForeignID("ID_FAMILLE_ARTICLE") != fID) continue;
            BigDecimal r = sQLRowAccessor.getBigDecimal("POURCENT_REMISE");
            remise = new Acompte(r, null);
            break;
        }
        return remise;
    }

    @Override
    protected void refreshDeviseAmount() {
        int count = this.getRowValuesTable().getRowCount();
        int columnForField = this.getRowValuesTable().getRowValuesTableModel().getColumnForField("PV_U_DEVISE");
        if (columnForField >= 0) {
            SQLTableElement eltDevise = this.getRowValuesTable().getRowValuesTableModel().getSQLTableElementAt(columnForField);
            int i = 0;
            while (i < count) {
                SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i);
                BigDecimal prixDeVenteUnitaireDevise = rowVals.getObject("PV_U_DEVISE") == null ? BigDecimal.ZERO : (BigDecimal)rowVals.getObject("PV_U_DEVISE");
                eltDevise.setValueFrom(rowVals, prixDeVenteUnitaireDevise);
                this.getRowValuesTable().getRowValuesTableModel().fireTableChanged(new TableModelEvent(this.getRowValuesTable().getRowValuesTableModel(), i, i, columnForField));
                ++i;
            }
        }
    }

    protected Map<String, Boolean> getCustomVisibilityMap() {
        return null;
    }

    protected Object tarifCompletion(SQLRowAccessor row, String field, SQLRowAccessor rowDest) {
        return this.tarifCompletion(row, field, rowDest, false);
    }

    protected Object tarifCompletion(SQLRowAccessor row, String field, SQLRowAccessor rowDest, boolean fromCompletion) {
        if (row != null && !row.isUndefined() && (field.equalsIgnoreCase("PRIX_METRIQUE_HA_1") || field.equalsIgnoreCase("PA_HT"))) {
            if (this.getSQLElement().getTable().getDBRoot().contains("ARTICLE_PRIX_REVIENT")) {
                BigDecimal prc;
                if (row.getBoolean("AUTO_PRIX_REVIENT_NOMENCLATURE").booleanValue()) {
                    ProductHelper helper = new ProductHelper(row.getTable().getDBRoot());
                    prc = helper.getBomPriceForQuantity(1, row.getReferentRows(row.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT")), ProductHelper.TypePrice.ARTICLE_PRIX_REVIENT);
                } else {
                    ProductComponent productComp = new ProductComponent(row, BigDecimal.ONE, null, null);
                    prc = productComp.getPRC(new Date());
                }
                if (prc == null) {
                    return BigDecimal.ZERO;
                }
                return prc;
            }
            if (this.getSQLElement().getTable().getDBRoot().contains("COUT_REVIENT") && row.getObject("ID_COUT_REVIENT") != null && !row.isForeignEmpty("ID_COUT_REVIENT")) {
                BigDecimal ha = row.getBigDecimal(field);
                BigDecimal percent = row.getForeign("ID_COUT_REVIENT").getBigDecimal("POURCENT");
                return ha.multiply(percent.movePointLeft(2).add(BigDecimal.ONE)).setScale(ha.precision(), RoundingMode.HALF_UP);
            }
        }
        if (this.getTarif() != null && !this.getTarif().isUndefined()) {
            List<SQLRowValues> fetchRows;
            SQLRowValues rowValsTarif = new SQLRowValues(this.tableArticleTarif);
            rowValsTarif.putNulls(this.tableArticleTarif.getFieldsName());
            Where where = new Where((FieldRef)this.tableArticleTarif.getField("ID_TARIF"), "=", this.getTarif().getID()).and(new Where((FieldRef)this.tableArticleTarif.getField("ID_ARTICLE"), "=", row.getID()));
            if (this.tableArticleTarif.contains("OBSOLETE")) {
                where = where.and(new Where((FieldRef)this.tableArticleTarif.getField("OBSOLETE"), "=", (Object)Boolean.FALSE));
            }
            if ((fetchRows = SQLRowValuesListFetcher.create(rowValsTarif).fetch(where)).isEmpty() && row.getObject("ID_ARTICLE_VIRTUEL_PERE") != null && !row.isForeignEmpty("ID_ARTICLE_VIRTUEL_PERE")) {
                Where where2 = new Where((FieldRef)this.tableArticleTarif.getField("ID_TARIF"), "=", this.getTarif().getID()).and(new Where((FieldRef)this.tableArticleTarif.getField("ID_ARTICLE"), "=", row.getForeignID("ID_ARTICLE_VIRTUEL_PERE")));
                if (this.tableArticleTarif.contains("OBSOLETE")) {
                    where2 = where2.and(new Where((FieldRef)this.tableArticleTarif.getField("OBSOLETE"), "=", (Object)Boolean.FALSE));
                }
                fetchRows = SQLRowValuesListFetcher.create(rowValsTarif).fetch(where2);
            }
            int quantite = 0;
            BigDecimal b = rowDest.getBigDecimal("QTE_UNITAIRE");
            int q = rowDest.getInt("QTE");
            BigDecimal qteTotal = b.multiply(new BigDecimal(q), DecimalUtils.HIGH_PRECISION);
            SQLRowAccessor rowTarif = null;
            for (SQLRowValues sqlRowAccessor : fetchRows) {
                if (sqlRowAccessor.getTable().contains("OBSOLETE") && sqlRowAccessor.getBoolean("OBSOLETE").booleanValue()) continue;
                int qteTarif = sqlRowAccessor.getInt("QTE");
                if (sqlRowAccessor.getForeignID("ID_TARIF") != this.getTarif().getID() || CompareUtils.compare(qteTarif, qteTotal) > 0 || CompareUtils.compare(qteTarif, quantite) <= 0) continue;
                quantite = qteTarif;
                rowTarif = sqlRowAccessor;
            }
            if (rowTarif == null) {
                if (!this.getTarif().isForeignEmpty("ID_DEVISE")) {
                    if (field.equalsIgnoreCase("ID_DEVISE")) {
                        return this.getTarif().getObject("ID_DEVISE");
                    }
                    if (field.equalsIgnoreCase("PV_U_DEVISE")) {
                        return this.getQtyTarifPvM1(rowDest, fromCompletion);
                    }
                }
                if (field.equalsIgnoreCase("ID_TAXE") && !this.getTarif().isForeignEmpty("ID_TAXE")) {
                    return this.getTarif().getForeignID("ID_TAXE");
                }
            } else {
                if (field.equalsIgnoreCase("PRIX_METRIQUE_VT_1")) {
                    if (rowTarif.isForeignEmpty("ID_DEVISE")) {
                        return rowTarif.getObject(field);
                    }
                    String devCode = this.getTarif().getForeign("ID_DEVISE").getString("CODE");
                    CurrencyConverter c = new CurrencyConverter();
                    BigDecimal result = c.convert(rowTarif.getBigDecimal(field), devCode, c.getCompanyCurrencyCode(), new Date(), true);
                    return result.setScale((int)row.getTable().getField(field).getType().getDecimalDigits(), RoundingMode.HALF_UP);
                }
                if (field.equalsIgnoreCase("ID_DEVISE")) {
                    return rowTarif.getObject("ID_DEVISE");
                }
                if (field.equalsIgnoreCase("PV_U_DEVISE")) {
                    return rowTarif.getObject("PRIX_METRIQUE_VT_1");
                }
                if (field.equalsIgnoreCase("ID_TAXE")) {
                    if (!rowTarif.isForeignEmpty("ID_TAXE")) {
                        return rowTarif.getObject("ID_TAXE");
                    }
                } else if (field.equalsIgnoreCase("POURCENT_REMISE")) {
                    Acompte remise = new Acompte(rowTarif.getBigDecimal("POURCENT_REMISE"), BigDecimal.ZERO);
                    return remise;
                }
            }
        }
        if (field.equalsIgnoreCase("ID_TAXE_VENTE") && this.rowCatComptable != null) {
            return this.rowCatComptable.getForeignID("ID_TAXE_VENTE");
        }
        if (field.equalsIgnoreCase("ID_TAXE") && this.rowCatComptable != null && !this.rowCatComptable.isForeignEmpty("ID_TAXE_VENTE")) {
            return this.rowCatComptable.getForeignID("ID_TAXE_VENTE");
        }
        if (field.equalsIgnoreCase("POURCENT_REMISE")) {
            return new Acompte(BigDecimal.ZERO, BigDecimal.ZERO);
        }
        if (field.equalsIgnoreCase("PRIX_METRIQUE_VT_1")) {
            return this.getQtyTarifPvM1(rowDest, fromCompletion);
        }
        return null;
    }

    @Override
    public void setClient(SQLRowAccessor rowClient, boolean ask) {
        if (rowClient == null || this.getRowClient() == null || rowClient.getID() != this.getRowClient().getID()) {
            super.setClient(rowClient, ask);
            if (this.getRowClient() != null && !this.getRowClient().isUndefined()) {
                this.cacheRemise = this.getRowClient().getReferentRows(this.getSQLElement().getTable().getTable("TARIF_ARTICLE_CLIENT"));
                this.cacheRemiseFamille = this.getRowClient().getReferentRows(this.getSQLElement().getTable().getTable("TARIF_FAMILLE_ARTICLE_CLIENT"));
                if (!(!ask || this.cacheRemise.isEmpty() && this.cacheRemiseFamille.isEmpty() || this.getRowValuesTable().getRowCount() <= 0 || JOptionPane.showConfirmDialog(null, "Appliquer les remises associ\u00e9es au client sur les lignes d\u00e9j\u00e0 pr\u00e9sentes?") != 0)) {
                    int nbRows = this.table.getRowCount();
                    int i = 0;
                    while (i < nbRows) {
                        SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i);
                        if (!rowVals.isForeignEmpty("ID_ARTICLE")) {
                            Object deviseValue;
                            SQLRowAccessor rowValsArt = rowVals.getForeign("ID_ARTICLE");
                            Object taxeValue = this.tarifCompletion(rowValsArt, "ID_TAXE", rowVals);
                            if (taxeValue != null) {
                                this.getRowValuesTable().getRowValuesTableModel().putValue(taxeValue, i, "ID_TAXE");
                            }
                            if ((deviseValue = this.tarifCompletion(rowValsArt, "ID_DEVISE", rowVals)) != null) {
                                this.getRowValuesTable().getRowValuesTableModel().putValue(deviseValue, i, "ID_DEVISE");
                            }
                            this.getRowValuesTable().getRowValuesTableModel().putValue(this.tarifCompletion(rowValsArt, "PV_U_DEVISE", rowVals), i, "PV_U_DEVISE");
                            this.getRowValuesTable().getRowValuesTableModel().putValue(this.tarifCompletion(rowValsArt, "PRIX_METRIQUE_VT_1", rowVals), i, "PRIX_METRIQUE_VT_1");
                        }
                        ++i;
                    }
                }
            } else {
                this.cacheRemise = null;
                this.cacheRemiseFamille = null;
            }
        }
    }

    @Override
    public void setTarif(SQLRowAccessor rowValuesTarif, boolean ask) {
        if (rowValuesTarif == null || this.getTarif() == null || rowValuesTarif.getID() != this.getTarif().getID()) {
            super.setTarif(rowValuesTarif, ask);
            if (ask && this.getRowValuesTable().getRowCount() > 0 && (rowValuesTarif == null || this.getTarif() == null || rowValuesTarif.isUndefined() || JOptionPane.showConfirmDialog(null, "Appliquer les tarifs associ\u00e9s au client sur les lignes d\u00e9j\u00e0 pr\u00e9sentes?") == 0)) {
                int nbRows = this.table.getRowCount();
                int i = 0;
                while (i < nbRows) {
                    SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i);
                    if (!rowVals.isForeignEmpty("ID_ARTICLE")) {
                        Object deviseValue;
                        SQLRowAccessor rowValsArt = rowVals.getForeign("ID_ARTICLE");
                        Object taxeValue = this.tarifCompletion(rowValsArt, "ID_TAXE", rowVals);
                        if (taxeValue != null) {
                            this.getRowValuesTable().getRowValuesTableModel().putValue(taxeValue, i, "ID_TAXE");
                        }
                        if ((deviseValue = this.tarifCompletion(rowValsArt, "ID_DEVISE", rowVals)) != null) {
                            this.getRowValuesTable().getRowValuesTableModel().putValue(deviseValue, i, "ID_DEVISE");
                        }
                        this.getRowValuesTable().getRowValuesTableModel().putValue(this.tarifCompletion(rowValsArt, "PV_U_DEVISE", rowVals), i, "PV_U_DEVISE");
                        this.getRowValuesTable().getRowValuesTableModel().putValue(this.tarifCompletion(rowValsArt, "PRIX_METRIQUE_VT_1", rowVals), i, "PRIX_METRIQUE_VT_1");
                    }
                    ++i;
                }
            }
        }
    }

    protected Object getQtyTarifPvM1(SQLRowAccessor row, boolean fromCompletion) {
        BigDecimal remise;
        BigDecimal qteTotal;
        int q;
        int quantite;
        Collection<? extends SQLRowAccessor> col;
        SQLRowAccessor rowA = row.getForeign("ID_ARTICLE");
        if (rowA != null && !rowA.isUndefined() && rowA.getTable().getDBRoot().contains("ARTICLE_PRIX_PUBLIC") && rowA.getTable().contains("AUTO_PRIX_MIN_VENTE_NOMENCLATURE") && rowA.getBoolean("AUTO_PRIX_MIN_VENTE_NOMENCLATURE").booleanValue()) {
            BigDecimal b3 = row.getBigDecimal("QTE_UNITAIRE");
            int q2 = row.getInt("QTE");
            BigDecimal qteTotal2 = b3.multiply(new BigDecimal(q2), DecimalUtils.HIGH_PRECISION);
            ProductHelper helper = new ProductHelper(rowA.getTable().getDBRoot());
            return helper.getBomPriceForQuantity(qteTotal2.setScale(0, RoundingMode.HALF_UP).intValue(), rowA.getReferentRows(rowA.getTable().getTable("ARTICLE_ELEMENT").getField("ID_ARTICLE_PARENT")), ProductHelper.TypePrice.ARTICLE_PRIX_PUBLIC);
        }
        BigDecimal result = null;
        if (rowA != null && !rowA.isUndefined() && rowA.getTable().getDBRoot().contains("ARTICLE_PRIX_PUBLIC")) {
            col = rowA.getReferentRows(rowA.getTable().getTable("ARTICLE_PRIX_PUBLIC"));
            quantite = 0;
            BigDecimal b2 = row.getBigDecimal("QTE_UNITAIRE");
            q = row.getInt("QTE");
            qteTotal = b2.multiply(new BigDecimal(q), DecimalUtils.HIGH_PRECISION);
            for (SQLRowAccessor sQLRowAccessor : col) {
                int qtePublic = sQLRowAccessor.getInt("QTE");
                if (CompareUtils.compare(qtePublic, qteTotal) > 0 || CompareUtils.compare(qtePublic, quantite) <= 0) continue;
                quantite = qtePublic;
                if (sQLRowAccessor.getBigDecimal("PRIX") == null) continue;
                result = sQLRowAccessor.getBigDecimal("PRIX");
            }
        }
        if (result == null && rowA != null && !rowA.isUndefined() && rowA.getTable().getDBRoot().contains("ARTICLE_PRIX_MIN_VENTE")) {
            col = rowA.getReferentRows(rowA.getTable().getTable("ARTICLE_PRIX_MIN_VENTE"));
            quantite = 0;
            BigDecimal b = row.getBigDecimal("QTE_UNITAIRE");
            q = row.getInt("QTE");
            qteTotal = b.multiply(new BigDecimal(q), DecimalUtils.HIGH_PRECISION);
            for (SQLRowAccessor sQLRowAccessor : col) {
                int qteMinVente = sQLRowAccessor.getInt("QTE");
                if (CompareUtils.compare(qteMinVente, qteTotal) > 0 || CompareUtils.compare(qteMinVente, quantite) <= 0) continue;
                quantite = qteMinVente;
                if (sQLRowAccessor.getBigDecimal("PRIX") == null) continue;
                result = sQLRowAccessor.getBigDecimal("PRIX");
            }
        }
        BigDecimal promoRemise = null;
        BigDecimal promoTarif = null;
        if (rowA != null && !rowA.isUndefined() && rowA.getTable().getDBRoot().contains("ARTICLE_TARIF_PROMOTION")) {
            Collection<? extends SQLRowAccessor> col2 = rowA.getReferentRows(rowA.getTable().getTable("ARTICLE_TARIF_PROMOTION"));
            BigDecimal quantite2 = BigDecimal.ZERO;
            int q3 = row.getInt("QTE");
            BigDecimal bigDecimal = row.getBigDecimal("QTE_UNITAIRE");
            BigDecimal qteTotal3 = bigDecimal.multiply(new BigDecimal(q3), DecimalUtils.HIGH_PRECISION);
            Calendar c = Calendar.getInstance();
            for (SQLRowAccessor sQLRowAccessor : col2) {
                SQLRowAccessor foreignPromotion = sQLRowAccessor.getForeign("ID_TARIF_PROMOTION");
                Calendar start = foreignPromotion.getDate("START");
                Calendar end = foreignPromotion.getDate("END");
                BigDecimal bigDecimal2 = new BigDecimal(sQLRowAccessor.getInt("QTE"));
                if (CompareUtils.compare(bigDecimal2, qteTotal3) > 0 || CompareUtils.compare(bigDecimal2, quantite2) <= 0 || start == null || !c.after(start) || end == null || !c.before(end)) continue;
                quantite2 = bigDecimal2;
                if (sQLRowAccessor.getBigDecimal("PRIX_METRIQUE_VT_1") != null) {
                    promoTarif = sQLRowAccessor.getBigDecimal("PRIX_METRIQUE_VT_1");
                    promoRemise = null;
                    continue;
                }
                promoTarif = null;
                promoRemise = sQLRowAccessor.getBigDecimal("POURCENT_REMISE");
            }
        }
        BigDecimal bigDecimal = remise = row.getBigDecimal("POURCENT_REMISE") == null ? BigDecimal.ZERO : row.getBigDecimal("POURCENT_REMISE");
        if (rowA != null && !rowA.isUndefined() && rowA.getTable().getDBRoot().contains("TARIF_QUANTITE")) {
            Acompte acompte;
            Collection<? extends SQLRowAccessor> col3 = rowA.getReferentRows(rowA.getTable().getTable("TARIF_QUANTITE"));
            BigDecimal quantite3 = BigDecimal.ZERO;
            BigDecimal bigDecimal3 = row.getBigDecimal("QTE_UNITAIRE");
            int q4 = row.getInt("QTE");
            BigDecimal qteTotal4 = bigDecimal3.multiply(new BigDecimal(q4), DecimalUtils.HIGH_PRECISION);
            for (SQLRowAccessor sQLRowAccessor : col3) {
                BigDecimal bigDecimal2 = sQLRowAccessor.getBigDecimal("QUANTITE");
                if (CompareUtils.compare(bigDecimal2, qteTotal4) > 0 || CompareUtils.compare(bigDecimal2, quantite3) <= 0) continue;
                quantite3 = bigDecimal2;
                if (sQLRowAccessor.getBigDecimal("PRIX_METRIQUE_VT_1") != null) {
                    result = sQLRowAccessor.getBigDecimal("PRIX_METRIQUE_VT_1");
                    remise = BigDecimal.ZERO;
                    continue;
                }
                result = null;
                remise = sQLRowAccessor.getBigDecimal("POURCENT_REMISE");
            }
            if (!(col3.isEmpty() || result != null || remise != null && remise.signum() != 0)) {
                result = rowA.getBigDecimal("PRIX_METRIQUE_VT_1");
            }
            if ((acompte = this.getRemiseClient(rowA, new Acompte(BigDecimal.ZERO, null))) != null && acompte.getPercent() != null && (remise == null || remise.compareTo(acompte.getPercent()) < 0)) {
                remise = acompte.getPercent();
            }
        }
        if (promoRemise != null && (remise == null || remise.compareTo(promoRemise) < 0)) {
            remise = promoRemise;
        }
        if (promoTarif != null && (result == null || result.compareTo(promoTarif) > 0)) {
            result = promoTarif;
        }
        int index = this.getRowValuesTable().getRowValuesTableModel().row2index(row);
        if (result == null && remise == null) {
            if (fromCompletion) {
                return null;
            }
            if (rowA != null) {
                return rowA.getObject("PRIX_METRIQUE_VT_1");
            }
            return row.getObject("PRIX_METRIQUE_VT_1");
        }
        if (result != null) {
            if (index != -1) {
                this.getRowValuesTable().getRowValuesTableModel().putValue(remise, index, "POURCENT_REMISE");
            }
            return result;
        }
        if (index != -1) {
            this.getRowValuesTable().getRowValuesTableModel().putValue(remise, index, "POURCENT_REMISE");
        }
        BigDecimal prixVT = row.getBigDecimal("PRIX_METRIQUE_VT_1");
        if (fromCompletion) {
            return null;
        }
        return prixVT;
    }

    @Override
    protected void setModel(RowValuesTableModel model) {
        super.setModel(model);
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AbstractVenteArticleItemTable.this.calculTarifNomenclature();
            }
        });
    }

    private void dropInTable(DropTargetDropEvent dtde, AutoCompletionManager autoM) {
        dtde.acceptDrop(3);
        Transferable t = dtde.getTransferable();
        try {
            ArrayList<Tuple3<Double, String, String>> articles = new ArrayList<Tuple3<Double, String, String>>();
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                DataImporter importer = new DataImporter(this.getSQLElement().getTable());
                File file = (File)list.get(0);
                if (file.getName().endsWith(".ods") || file.getName().endsWith(".xls")) {
                    ArrayTableModel m = importer.createModelFrom(file);
                    int i = 0;
                    while (i < m.getRowCount()) {
                        List l = m.getLineValuesAt(i);
                        if (l.size() > 1) {
                            if (l.get(0) == null || l.get(0).toString().length() == 0) break;
                            Double qte = ((Number)l.get(1)).doubleValue();
                            String code = "";
                            code = l.get(0) instanceof Number ? String.valueOf(((Number)l.get(0)).intValue()) : l.get(0).toString();
                            String nom = "";
                            if (l.size() > 2) {
                                nom = (String)l.get(2);
                            }
                            if (qte > 0.0) {
                                articles.add(Tuple3.create(qte, code, nom));
                            }
                        }
                        ++i;
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Les formats de fichiers pris en charge sont ods et xls!");
                }
            } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String string = (String)t.getTransferData(DataFlavor.stringFlavor);
                List<String> l = StringUtils.fastSplitTrimmed(string, '\n');
                for (String string2 : l) {
                    List<String> line = StringUtils.fastSplitTrimmed(string2, '\t');
                    if (line.size() >= 2) {
                        Double qte = Double.valueOf(line.get(1));
                        String code = line.get(0) == null ? "" : line.get(0).toString();
                        String nom = "";
                        if (line.size() > 2) {
                            nom = line.get(2);
                        }
                        if (!(qte > 0.0)) continue;
                        articles.add(Tuple3.create(qte, code, nom));
                        continue;
                    }
                    break;
                }
            }
            if (articles.size() > 0) {
                this.insertFromDrop(articles, autoM);
                for (Tuple3 tuple3 : articles) {
                    System.err.println("ADD LINE " + tuple3);
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public AutoCompletionManager getCodeCompletionManager() {
        return this.codeCompletionManager;
    }

    protected void insertFromDrop(List<Tuple3<Double, String, String>> articles, AutoCompletionManager m) {
        ArrayList<String> code = new ArrayList<String>(articles.size());
        int i = articles.size() - 1;
        while (i >= 0) {
            Tuple3<Double, String, String> tuple = articles.get(i);
            code.add((String)tuple.get1());
            --i;
        }
        SQLSelect sel = new SQLSelect();
        SQLTable articleTable = this.getSQLElement().getTable().getForeignTable("ID_ARTICLE");
        sel.addSelectStar(articleTable);
        sel.setWhere(new Where(articleTable.getField("CODE"), code));
        List<SQLRow> matchCode = SQLRowListRSH.execute(sel);
        HashMap<String, SQLRow> mapCode = new HashMap<String, SQLRow>();
        for (SQLRow sqlRow : matchCode) {
            mapCode.put(sqlRow.getString("CODE"), sqlRow);
        }
        int rowCount = this.getRowValuesTable().getRowValuesTableModel().getRowCount();
        HashMap<Integer, Integer> mapRows = new HashMap<Integer, Integer>();
        int i2 = 0;
        while (i2 < rowCount) {
            SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(i2);
            if (rowVals.getObject("ID_ARTICLE") != null && !rowVals.isForeignEmpty("ID_ARTICLE")) {
                mapRows.put(rowVals.getForeignID("ID_ARTICLE"), i2);
            }
            ++i2;
        }
        Set<String> fieldsFrom = m.getFieldsFrom();
        fieldsFrom.remove("POURCENT_REMISE");
        int i3 = articles.size() - 1;
        while (i3 >= 0) {
            Tuple3<Double, String, String> tuple = articles.get(i3);
            SQLRow article = (SQLRow)mapCode.get(tuple.get1());
            String fieldQte = "QTE";
            if (article != null && mapRows.containsKey(article.getID())) {
                Integer index = (Integer)mapRows.get(article.getID());
                SQLRowValues rowVals = this.getRowValuesTable().getRowValuesTableModel().getRowValuesAt(index);
                if (rowVals.getTable().getName().equals("BON_DE_LIVRAISON_ELEMENT")) {
                    fieldQte = "QTE_LIVREE";
                }
                this.getRowValuesTable().getRowValuesTableModel().putValue(rowVals.getInt(fieldQte) + 1, index, fieldQte);
            } else {
                SQLRowValues row2Insert = new SQLRowValues(this.getRowValuesTable().getRowValuesTableModel().getDefaultRowValues());
                if (article != null) {
                    m.fillRowValues(article, fieldsFrom, row2Insert);
                    row2Insert.put("ID_ARTICLE", article.getID());
                    row2Insert.put("CODE", article.getObject("CODE"));
                    row2Insert.put("NOM", article.getObject("NOM"));
                } else {
                    row2Insert.put("CODE", tuple.get1());
                    row2Insert.put("NOM", tuple.get2());
                }
                row2Insert.put(fieldQte, Math.round(((Double)tuple.get0()).floatValue()));
                if (row2Insert.getTable().getName().equals("BON_DE_LIVRAISON_ELEMENT")) {
                    row2Insert.put("QTE_LIVREE", Math.round(((Double)tuple.get0()).floatValue()));
                }
                row2Insert.put("POURCENT_REMISE", BigDecimal.ZERO);
                row2Insert.put("MONTANT_REMISE", BigDecimal.ZERO);
                row2Insert.put("PV_HT", row2Insert.getObject("PRIX_METRIQUE_VT_1"));
                BigDecimal resultTotalHT = row2Insert.getBigDecimal("PV_HT").multiply(new BigDecimal(row2Insert.getInt(fieldQte)));
                row2Insert.put("T_PV_HT", resultTotalHT);
                Float resultTaux = TaxeCache.getCache().getTauxFromId(row2Insert.getForeignID("ID_TAXE"));
                if (resultTaux == null) {
                    SQLRow rowTax = TaxeCache.getCache().getFirstTaxe();
                    resultTaux = Float.valueOf(rowTax.getFloat("TAUX"));
                }
                float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                BigDecimal r = resultTotalHT.multiply(BigDecimal.valueOf(taux).movePointLeft(2).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION);
                row2Insert.put("T_PV_TTC", r);
                this.getRowValuesTable().getRowValuesTableModel().addRowAt(0, row2Insert);
            }
            --i3;
        }
    }

    public static enum TypeCalcul {
        CALCUL_MONTANT_TOTAL("MONTANT_FACTURABLE", "POURCENT_FACTURABLE"),
        CALCUL_FACTURABLE("MONTANT_FACTURABLE", "POURCENT_FACTURABLE"),
        CALCUL_REMISE("MONTANT_REMISE", "POURCENT_REMISE");

        String fieldMontant;
        String fieldPourcent;

        private TypeCalcul(String fieldMontant, String fieldPourcent) {
            this.fieldMontant = fieldMontant;
            this.fieldPourcent = fieldPourcent;
        }

        public String getFieldMontant() {
            return this.fieldMontant;
        }

        public String getFieldPourcent() {
            return this.fieldPourcent;
        }
    }
}

