/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.IntHashSet;
import org.openconcerto.utils.cc.IdentitySet;

public abstract class ListIdentitySet<E>
extends AbstractSet<E>
implements IdentitySet<E> {
    static final int THRESHOLD = 16;
    private final List<E> list;
    private IntHashSet identityHashCodes;

    protected ListIdentitySet(Collection<? extends E> c) {
        this(c.size());
        if (c instanceof ListIdentitySet) {
            ListIdentitySet s = (ListIdentitySet)c;
            this.list.addAll(c);
            this.identityHashCodes = s.identityHashCodes;
        } else {
            this.addAll(c);
        }
    }

    protected ListIdentitySet() {
        this(16);
    }

    protected ListIdentitySet(int expectedSize) {
        this.list = this.newList(expectedSize);
        this.identityHashCodes = null;
    }

    public final boolean hasHashCodes() {
        return this.identityHashCodes != null;
    }

    public final void initHashCodes() {
        if (this.identityHashCodes == null) {
            this.identityHashCodes = new IntHashSet(this.size());
            for (E i : this.list) {
                this.identityHashCodes.add(System.identityHashCode(i));
            }
        }
    }

    final boolean sameSize() {
        return this.identityHashCodes == null || this.identityHashCodes.size() == this.list.size();
    }

    protected abstract List<E> newList(int var1);

    public final List<E> getList() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public final boolean add(E e) {
        if (this.identityHashCodes != null) {
            boolean added = this.identityHashCodes.add(System.identityHashCode(e));
            if (added) {
                this.list.add(e);
            }
            assert (this.sameSize());
            return added;
        }
        boolean contains = this.contains(e);
        if (!contains) {
            this.list.add(e);
            if (this.size() > 16) {
                this.initHashCodes();
            }
        }
        assert (this.sameSize());
        return !contains;
    }

    @Override
    public final boolean addAll(Collection<? extends E> c) {
        return super.addAll(c);
    }

    @Override
    public final void clear() {
        this.list.clear();
        this.identityHashCodes = null;
    }

    @Override
    public final int size() {
        return this.list.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public final Iterator<E> iterator() {
        if (this.identityHashCodes == null) {
            return this.list.iterator();
        }
        return new Iterator<E>(){
            private final Iterator<E> iter;
            private E lastReturned;
            {
                this.iter = ListIdentitySet.this.list.iterator();
                this.lastReturned = null;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public E next() {
                this.lastReturned = this.iter.next();
                return this.lastReturned;
            }

            @Override
            public void remove() {
                this.iter.remove();
                ListIdentitySet.this.identityHashCodes.remove(System.identityHashCode(this.lastReturned));
                if (!$assertionsDisabled && !ListIdentitySet.this.sameSize()) {
                    throw new AssertionError();
                }
            }
        };
    }

    @Override
    public boolean contains(Object o) {
        if (this.identityHashCodes != null) {
            return this.identityHashCodes.contains(System.identityHashCode(o));
        }
        return CollectionUtils.identityContains(this.list, o);
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return super.containsAll(c);
    }

    @Override
    public boolean remove(Object o) {
        boolean res;
        if (this.identityHashCodes != null) {
            res = this.identityHashCodes.remove(System.identityHashCode(o));
            if (res) {
                CollectionUtils.identityRemove(this.list, o);
            }
        } else {
            res = CollectionUtils.identityRemove(this.list, o);
        }
        assert (this.sameSize());
        return res;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> i = this.iterator();
        while (i.hasNext()) {
            if (!c.contains(i.next())) continue;
            i.remove();
            modified = true;
        }
        assert (this.sameSize());
        return modified;
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        return super.retainAll(c);
    }

    @Override
    public final Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public final int hashCode() {
        int result = 0;
        for (E key : this.list) {
            result += System.identityHashCode(key);
        }
        return result;
    }
}

