/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.NumberUtils;

public class CoreEqualizer {
    private static final CoreEqualizer INSTANCE = new CoreEqualizer(true);
    private static final CoreEqualizer MAP_KEYS_INSTANCE = new CoreEqualizer(false);
    private final boolean standardMapKeys;

    public static final CoreEqualizer getInstance() {
        return INSTANCE;
    }

    public static final CoreEqualizer getMapKeysInstance() {
        return MAP_KEYS_INSTANCE;
    }

    public CoreEqualizer(boolean standardMapKeys) {
        this.standardMapKeys = standardMapKeys;
    }

    public final boolean contains(Collection<?> coll, Object item) {
        for (Object o : coll) {
            if (!this.equals(o, item)) continue;
            return true;
        }
        return false;
    }

    private final boolean equals(Collection<?> a, Collection<?> b) {
        if (a.size() != b.size()) {
            return false;
        }
        if (a instanceof Set) {
            for (Object o : a) {
                if (this.contains(b, o)) continue;
                return false;
            }
            return true;
        }
        Iterator<?> iterA = a.iterator();
        Iterator<?> iterB = b.iterator();
        while (iterA.hasNext()) {
            Object bV;
            Object aV = iterA.next();
            if (this.equals(aV, bV = iterB.next())) continue;
            return false;
        }
        return true;
    }

    private final <K, V> Map.Entry<K, V> get(Map<K, V> map, Object key) {
        for (Map.Entry<K, V> e : map.entrySet()) {
            if (!this.equals(e.getKey(), key)) continue;
            return e;
        }
        return null;
    }

    private final boolean equals(Map<?, ?> a, Map<?, ?> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (Map.Entry<?, ?> e : a.entrySet()) {
            Object bV;
            Object key = e.getKey();
            Object aV = e.getValue();
            if (this.standardMapKeys) {
                if (aV == null && !b.containsKey(key)) {
                    return false;
                }
                bV = b.get(key);
            } else {
                Map.Entry<?, ?> bEntry = this.get(b, key);
                if (bEntry == null) {
                    return false;
                }
                bV = bEntry.getValue();
            }
            if (this.equals(aV, bV)) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (a instanceof Number) {
            return NumberUtils.areNumericallyEqual((Number)a, (Number)b);
        }
        if (a instanceof Comparable) {
            Comparable comp = (Comparable)a;
            return CompareUtils.equalsWithCompareTo(comp, b);
        }
        if (a instanceof Map) {
            return b instanceof Map && this.equals((Map)a, (Map)b);
        }
        if (a instanceof Collection) {
            return b instanceof Collection && this.equals((Collection)a, (Collection)b);
        }
        return a.equals(b);
    }
}

