/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;

public final class SQLRowMapListRSH
implements ResultSetHandler {
    private final Set<SQLTable> t;

    static final List<Map<SQLTable, SQLRow>> createListFromRS(Set<SQLTable> tables, ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        ArrayList<Map<SQLTable, SQLRow>> res = new ArrayList<Map<SQLTable, SQLRow>>();
        while (rs.next()) {
            HashMap<SQLTable, SQLRow> rows = new HashMap<SQLTable, SQLRow>();
            for (SQLTable table : tables) {
                rows.put(table, SQLRow.createFromRS(table, rs, rsmd, false));
            }
            res.add(rows);
        }
        return res;
    }

    public SQLRowMapListRSH(Set<SQLTable> tables) {
        this.t = tables;
    }

    @Override
    public Object handle(ResultSet rs) throws SQLException {
        return SQLRowMapListRSH.createListFromRS(this.t, rs);
    }
}

