/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import java.util.Date;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.generationEcritures.GenerationEcritures;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;

public class GenerationMvtAvoirFournisseur
extends GenerationEcritures {
    private static final String source = "AVOIR_FOURNISSEUR";
    private static final Integer journal = 2;
    private int idAvoirFourn;
    private static final SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
    private static final SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);

    public GenerationMvtAvoirFournisseur(SQLRow row) {
        this(row, 1);
    }

    public GenerationMvtAvoirFournisseur(SQLRow row, int idMvt) {
        this.idMvt = idMvt;
        this.idAvoirFourn = row.getID();
        this.setRowAnalytiqueSource(row);
    }

    public int genereMouvement() throws Exception {
        int idCompteFourn;
        SQLTable avoirFournTable = base.getTable(source);
        SQLTable fournTable = base.getTable("FOURNISSEUR");
        SQLRow avoirRow = avoirFournTable.getRow(this.idAvoirFourn);
        SQLRow rowFourn = fournTable.getRow(avoirRow.getInt("ID_FOURNISSEUR"));
        PrixTTC prixTTC = new PrixTTC(((Long)avoirRow.getObject("MONTANT_TTC")).longValue());
        PrixHT prixHT = new PrixHT(((Long)avoirRow.getObject("MONTANT_HT")).longValue());
        PrixHT prixTVA = new PrixHT(((Long)avoirRow.getObject("MONTANT_TVA")).longValue());
        this.date = (Date)avoirRow.getObject("DATE");
        this.nom = avoirRow.getObject("NOM").toString();
        this.putValue("DATE", new java.sql.Date(this.date.getTime()));
        this.putValue("NOM", "Avoir fournisseur : " + avoirRow.getString("NUMERO") + " " + rowFourn.getString("NOM"));
        this.putValue("ID_JOURNAL", journal);
        this.putValue("ID_MOUVEMENT", 1);
        if (rowFourn.getTable().getTable("ECRITURE").contains("CODE_CLIENT")) {
            this.putValue("CODE_CLIENT", rowFourn.getString("CODE"));
        }
        if (this.idMvt == 1) {
            this.getNewMouvement(source, this.idAvoirFourn, 1, "Avoir Fournisseur : " + avoirRow.getString("NUMERO"));
        } else {
            this.putValue("ID_MOUVEMENT", this.idMvt);
        }
        int idCompteAchat = avoirRow.getInt("ID_COMPTE_PCE");
        if (idCompteAchat <= 1 && (idCompteAchat = rowPrefsCompte.getInt("ID_COMPTE_PCE_ACHAT")) <= 1) {
            try {
                idCompteAchat = ComptePCESQLElement.getIdComptePceDefault("Achats");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.putValue("ID_COMPTE_PCE", idCompteAchat);
        this.putValue("DEBIT", 0L);
        this.putValue("CREDIT", prixHT.getLongValue());
        SQLRow rowEcr = this.ajoutEcriture();
        SQLRowAccessor taxe = TaxeCache.getCache().getRowFromId(avoirRow.getForeignID("ID_TAXE"));
        if (prixTVA.getLongValue() > 0L) {
            int idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_ACHAT");
            if (avoirRow.getBoolean("IMMO").booleanValue()) {
                idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_IMMO");
                if (idCompteTVA <= 1) {
                    idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVAImmo");
                }
            } else if (rowFourn.getBoolean("UE").booleanValue()) {
                idCompteTVA = taxe.getForeignID("ID_COMPTE_PCE_DED_INTRA");
                if (idCompteTVA <= 1 && (idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_ACHAT")) <= 1) {
                    idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVADeductible");
                }
            } else {
                idCompteTVA = taxe.getForeignID("ID_COMPTE_PCE_DED");
                if (idCompteTVA <= 1 && (idCompteTVA = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_ACHAT")) <= 1) {
                    idCompteTVA = ComptePCESQLElement.getIdComptePceDefault("TVADeductible");
                }
            }
            this.putValue("ID_COMPTE_PCE", idCompteTVA);
            this.putValue("DEBIT", 0L);
            this.putValue("CREDIT", prixTVA.getLongValue());
            this.ajoutEcriture();
            if (rowFourn.getBoolean("UE").booleanValue()) {
                int idCompteTVAIntra = taxe.getForeignID("ID_COMPTE_PCE_COLLECTE_INTRA");
                if (idCompteTVAIntra <= 1 && (idCompteTVAIntra = rowPrefsCompte.getInt("ID_COMPTE_PCE_TVA_INTRA")) <= 1) {
                    idCompteTVAIntra = ComptePCESQLElement.getIdComptePceDefault("TVAIntraComm");
                }
                this.putValue("ID_COMPTE_PCE", idCompteTVAIntra);
                this.putValue("DEBIT", prixTVA.getLongValue());
                this.putValue("CREDIT", 0L);
                this.ajoutEcriture();
            }
        }
        if ((idCompteFourn = rowFourn.getInt("ID_COMPTE_PCE")) <= 1 && (idCompteFourn = rowPrefsCompte.getInt("ID_COMPTE_PCE_FOURNISSEUR")) <= 1) {
            idCompteFourn = ComptePCESQLElement.getIdComptePceDefault("Fournisseurs");
        }
        this.putValue("ID_COMPTE_PCE", idCompteFourn);
        this.putValue("DEBIT", prixTTC.getLongValue());
        this.putValue("CREDIT", 0L);
        this.ajoutEcriture();
        SQLRowValues valAvoir = new SQLRowValues(avoirFournTable);
        valAvoir.put("ID_MOUVEMENT", (Object)this.idMvt);
        if (valAvoir.getInvalid() == null) {
            valAvoir.update(this.idAvoirFourn);
            this.displayMvtNumber();
        }
        return this.idMvt;
    }
}

