/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.UserInitialsValueProvider;
import org.openconcerto.sql.model.SQLRowAccessor;

public class QteLineDocProvider
extends UserInitialsValueProvider {
    protected final TypePoidsDocProvider type;

    public QteLineDocProvider(TypePoidsDocProvider t) {
        this.type = t;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor sqlRowAccessor = context.getRow();
        return this.getPoidsFromRow(sqlRowAccessor);
    }

    protected BigDecimal getPoidsFromRow(SQLRowAccessor sqlRowAccessor) {
        BigDecimal nbColis = sqlRowAccessor.getObject("NB_COLIS") != null ? new BigDecimal(sqlRowAccessor.getInt("NB_COLIS")) : BigDecimal.ZERO;
        BigDecimal qteUV = sqlRowAccessor.getBigDecimal("QTE_UNITAIRE");
        BigDecimal qte = new BigDecimal(sqlRowAccessor.getInt("QTE"));
        BigDecimal tare = sqlRowAccessor.getObject("TARE") != null ? sqlRowAccessor.getBigDecimal("TARE") : BigDecimal.ZERO;
        BigDecimal pdsNet = nbColis.multiply(qte).multiply(qteUV);
        if (this.type == TypePoidsDocProvider.POIDS_NET) {
            return pdsNet;
        }
        return pdsNet.add(tare.multiply(nbColis));
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.poids.net.line", new QteLineDocProvider(TypePoidsDocProvider.POIDS_NET));
        SpreadSheetCellValueProviderManager.put("sales.poids.brut.line", new QteLineDocProvider(TypePoidsDocProvider.POIDS_BRUT));
    }

    protected static enum TypePoidsDocProvider {
        POIDS_NET,
        POIDS_BRUT;

    }
}

