/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.jopencalendar.ui.FixedColumnTable;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.erp.core.sales.product.element.TailleCouleurTableModel;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Tuple2;

public class NouvellesDeclinaisonsFrame
extends JFrame {
    public NouvellesDeclinaisonsFrame(final ReferenceArticleSQLElement element, final SQLRow selectedRow) {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JLabelBold l = new JLabelBold(selectedRow.getString("NOM"));
        p.add((Component)l, "North");
        final TailleCouleurTableModel model = new TailleCouleurTableModel(element);
        FixedColumnTable t = new FixedColumnTable(1, (TableModel)model);
        t.getMain().setAutoResizeMode(0);
        t.getColumn(0).setMinWidth(140);
        t.setColumnWidth(0, 150);
        int i = 1;
        while (i < model.getColumnCount()) {
            t.getColumn(i).setMinWidth(40);
            ++i;
        }
        t.getMain().setDefaultRenderer(Boolean.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DefaultTableCellRenderer c = (DefaultTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                c.setText("");
                Boolean b = (Boolean)value;
                if (b.booleanValue()) {
                    c.setBackground(Color.GREEN);
                } else if (isSelected) {
                    c.setBackground(Color.GRAY);
                } else {
                    c.setBackground(Color.WHITE);
                }
                return c;
            }
        });
        JScrollPane scroll = new JScrollPane((Component)t);
        p.add(scroll);
        JPanel actions = new JPanel();
        actions.setLayout(new FlowLayout(2));
        JButton createButton = new JButton("Cr\u00e9er les d\u00e9clinaisons");
        actions.add(createButton);
        p.add((Component)actions, "South");
        this.setContentPane(p);
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<Tuple2<SQLRow, SQLRow>> r = model.getSelected();
                try {
                    element.createDeclinaison(selectedRow.getID(), r);
                }
                catch (SQLException e1) {
                    ExceptionHandler.handle("erreur de cr\u00e9ation", e1);
                }
                NouvellesDeclinaisonsFrame.this.dispose();
            }
        });
    }
}

