/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import java.awt.GridBagLayout;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.sales.product.model.BatchQuantity;
import org.openconcerto.erp.core.sales.product.model.ProductComponent;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLUpdate;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.checks.ValidState;

public class LotSQLElement
extends ComptaSQLConfElement {
    public LotSQLElement() {
        super("LOT", "un lot", "lots");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_STOCK");
        l.add("QUANTITE");
        l.add("NUMERO_LOT");
        l.add("NUMERO_SERIE");
        l.add("DLC");
        l.add("DLUO");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_STOCK");
        l.add("QUANTITE");
        l.add("NUMERO_LOT");
        l.add("NUMERO_SERIE");
        l.add("DLC");
        l.add("DLUO");
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        ListMap<String, String> map = new ListMap<String, String>();
        map.add("ID_STOCK", "ID_DEPOT_STOCK");
        return map;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
            }
        };
    }

    public ValidState getValidStateOfRowValuesTable(RowValuesTableModel rowValuesTableModel, TypeLot type) {
        int line = 0;
        while (line < rowValuesTableModel.getRowCount()) {
            SQLRowValues rowValuesAt = rowValuesTableModel.getRowValuesAt(line);
            SQLRowAccessor nonEmptyForeign = rowValuesAt.getNonEmptyForeign("ID_ARTICLE");
            if (nonEmptyForeign != null) {
                SQLRow asRowArticle = nonEmptyForeign.asRow();
                Boolean lotReq = asRowArticle.getBoolean("NUMERO_LOT_REQUIS");
                Boolean lotSerie = asRowArticle.getBoolean("NUMERO_SERIE_REQUIS");
                Boolean lotDLC = asRowArticle.getBoolean("DLC_REQUIS");
                Boolean lotDLUO = asRowArticle.getBoolean("DLUO_REQUIS");
                if (lotReq.booleanValue() || lotSerie.booleanValue()) {
                    Collection referentRows = rowValuesAt.getReferentRows(this.getTable().getTable(type.getTableLot()).getField("ID_" + type.getTableItems()));
                    ArrayList<SQLRowValues> lotRows = new ArrayList<SQLRowValues>();
                    for (SQLRowValues sqlRowValues : referentRows) {
                        if (sqlRowValues.contains("ARCHIVE") && sqlRowValues.isArchived()) continue;
                        if (lotReq.booleanValue() && sqlRowValues.getString("NUMERO_LOT").trim().length() == 0) {
                            return ValidState.create(false, "Ligne " + (line + 1) + " : lot sans r\u00e9f\u00e9rence!");
                        }
                        if (lotSerie.booleanValue() && sqlRowValues.getString("NUMERO_SERIE").trim().length() == 0) {
                            return ValidState.create(false, "Ligne " + (line + 1) + " : num\u00e9ro de s\u00e9rie non renseign\u00e9!");
                        }
                        if (lotDLC.booleanValue() && sqlRowValues.getDate("DLC") == null) {
                            return ValidState.create(false, "Ligne " + (line + 1) + " : DLC non renseign\u00e9e!");
                        }
                        if (lotDLUO.booleanValue() && sqlRowValues.getDate("DLUO") == null) {
                            return ValidState.create(false, "Ligne " + (line + 1) + " : DLUO non renseign\u00e9e!");
                        }
                        lotRows.add(sqlRowValues);
                    }
                    if (lotRows.isEmpty()) {
                        return ValidState.create(false, "La ligne " + (line + 1) + " n'a aucun lot associ\u00e9!");
                    }
                }
            }
            ++line;
        }
        return ValidState.getTrueInstance();
    }

    public void updateLotQuantiteFromLotItems(List<SQLRowValues> rowValues, TypeLot type) throws SQLException {
        if (!rowValues.isEmpty()) {
            List<Integer> findOrCreateLot = this.findOrCreateLot(rowValues);
            if (findOrCreateLot.size() != rowValues.size()) {
                throw new IllegalArgumentException("La taille des lignes de bons [" + rowValues.size() + "] ne correspond pas \u00e0 la liste des lots trouv\u00e9s [" + findOrCreateLot.size() + "]");
            }
            ArrayList<String> updates = new ArrayList<String>();
            int index = 0;
            while (index < findOrCreateLot.size()) {
                UpdateBuilder builder = new UpdateBuilder(this.getTable());
                builder.set("QUANTITE", String.valueOf(this.getTable().getField("QUANTITE").getQuotedName()) + (type == TypeLot.RECEPTION ? " + " : " - ") + rowValues.get(index).getBigDecimal("QUANTITE"));
                builder.setWhere(new Where((FieldRef)this.getTable().getKey(), "=", (Object)findOrCreateLot.get(index)));
                updates.add(builder.asString());
                ++index;
            }
            this.getTable().getDBSystemRoot().getDataSource().executeBatch(updates, true);
        }
    }

    public void removeLotQuantiteFromLotItems(List<SQLRowValues> rowValuesLotReceptionOrLivraison, TypeLot type) throws SQLException {
        if (!rowValuesLotReceptionOrLivraison.isEmpty()) {
            List<Integer> findOrCreateLot = this.findOrCreateLot(rowValuesLotReceptionOrLivraison);
            if (findOrCreateLot.size() != rowValuesLotReceptionOrLivraison.size()) {
                throw new IllegalArgumentException("La taille des lignes de bons [" + rowValuesLotReceptionOrLivraison.size() + "] ne correspond pas \u00e0 la liste des lots trouv\u00e9s [" + findOrCreateLot.size() + "]");
            }
            ArrayList<String> updates = new ArrayList<String>();
            int index = 0;
            while (index < findOrCreateLot.size()) {
                UpdateBuilder builder = new UpdateBuilder(this.getTable());
                builder.set("QUANTITE", String.valueOf(this.getTable().getField("QUANTITE").getQuotedName()) + (type == TypeLot.RECEPTION ? " - " : " + ") + rowValuesLotReceptionOrLivraison.get(index).getBigDecimal("QUANTITE"));
                builder.setWhere(new Where((FieldRef)this.getTable().getKey(), "=", (Object)findOrCreateLot.get(index)));
                updates.add(builder.asString());
                ++index;
            }
            this.getTable().getDBSystemRoot().getDataSource().executeBatch(updates, true);
        }
    }

    public List<Integer> findOrCreateLot(List<SQLRowValues> rowValuesLotRecOrLiv) throws SQLException {
        if (rowValuesLotRecOrLiv.isEmpty()) {
            return new ArrayList<Integer>();
        }
        SQLTable tableItem = rowValuesLotRecOrLiv.get(0).getTable();
        ArrayList<String> numeroLot = new ArrayList<String>();
        ArrayList<String> numeroSerie = new ArrayList<String>();
        for (SQLRowValues r : rowValuesLotRecOrLiv) {
            if (!r.isForeignEmpty("ID_LOT")) continue;
            String lot = r.getString("NUMERO_LOT");
            String serie = r.getString("NUMERO_SERIE");
            if (lot.length() > 0) {
                numeroLot.add(lot);
            }
            if (serie.length() <= 0) continue;
            numeroSerie.add(serie);
        }
        SQLRowValues rowValsToFecth = new SQLRowValues(this.getTable());
        rowValsToFecth.putNulls("DLC", "DLUO", "QUANTITE", "NUMERO_SERIE", "NUMERO_LOT");
        rowValsToFecth.putRowValues("ID_STOCK").putNulls("ID_ARTICLE", "ID_DEPOT_STOCK");
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsToFecth);
        List<SQLRowValues> resultMatchLot = fetcher.fetch(Where.inValues(this.getTable().getField("NUMERO_LOT"), numeroLot).or(Where.inValues(this.getTable().getField("NUMERO_SERIE"), numeroSerie)));
        HashMap<LotKey, SQLRowValues> mapLotSerie = new HashMap<LotKey, SQLRowValues>();
        for (SQLRowValues sqlRowValues : resultMatchLot) {
            SQLRowAccessor foreignStock = sqlRowValues.getForeign("ID_STOCK");
            LotKey key = new LotKey(foreignStock.getForeignID("ID_ARTICLE"), foreignStock.getForeignID("ID_DEPOT_STOCK"), sqlRowValues.getString("NUMERO_SERIE"), sqlRowValues.getString("NUMERO_LOT"));
            mapLotSerie.put(key, sqlRowValues);
        }
        ArrayList<Integer> idsLot = new ArrayList<Integer>(rowValuesLotRecOrLiv.size());
        ArrayList<SQLInsert> inserts = new ArrayList<SQLInsert>();
        List<String> fieldsToCopy = Arrays.asList("DLC", "DLUO", "NUMERO_SERIE", "NUMERO_LOT");
        int i = 0;
        while (i < rowValuesLotRecOrLiv.size()) {
            SQLRowValues rowVals = rowValuesLotRecOrLiv.get(i);
            int foreignIDDepot = rowVals.isForeignEmpty("ID_DEPOT_STOCK") ? DepotStockSQLElement.DEFAULT_ID : rowVals.getForeignID("ID_DEPOT_STOCK");
            LotKey key = new LotKey(rowVals.getForeignID("ID_ARTICLE"), foreignIDDepot, rowVals.getString("NUMERO_SERIE"), rowVals.getString("NUMERO_LOT"));
            if (!rowVals.isForeignEmpty("ID_LOT")) {
                idsLot.add(rowVals.getForeignID("ID_LOT"));
            } else if (mapLotSerie.containsKey(key)) {
                idsLot.add(((SQLRowValues)mapLotSerie.get(key)).getID());
            } else {
                idsLot.add(null);
                SQLInsert insert = new SQLInsert();
                for (String f : fieldsToCopy) {
                    insert.add(this.getTable().getField(f), rowVals.getObject(f));
                }
                insert.add(this.getTable().getField("QUANTITE"), BigDecimal.ZERO);
                String fieldForeignBonItem = tableItem.getName().equals("LOT_RECEPTION") ? "ID_BON_RECEPTION_ELEMENT" : "ID_BON_LIVRAISON_ELEMENT";
                SQLRowAccessor bonTiem = rowVals.getForeign(fieldForeignBonItem);
                SQLRowAccessor foreignArt = bonTiem.getForeign("ID_ARTICLE");
                ProductComponent comp = ProductComponent.createFromRowArticle(foreignArt, bonTiem);
                this.stock(comp);
                insert.add(this.getTable().getField("ID_STOCK"), comp.getStock().getID());
                inserts.add(insert);
            }
            ++i;
        }
        if (!inserts.isEmpty()) {
            ArrayList<SQLUpdate> updates = new ArrayList<SQLUpdate>();
            List<Number> executeSimilarInserts = SQLInsert.executeSimilarInserts(this.getTable().getDBSystemRoot(), inserts, true);
            int index = 0;
            int i2 = 0;
            while (i2 < idsLot.size()) {
                Integer id = (Integer)idsLot.get(i2);
                if (id == null) {
                    int insertedId = executeSimilarInserts.get(index).intValue();
                    idsLot.set(i2, insertedId);
                    SQLUpdate update = new SQLUpdate(new Where((FieldRef)tableItem.getKey(), "=", rowValuesLotRecOrLiv.get(i2).getID()));
                    update.add(tableItem.getField("ID_LOT"), insertedId);
                    updates.add(update);
                    ++index;
                }
                ++i2;
            }
            if (!updates.isEmpty()) {
                SQLUpdate.executeMultipleWithBatch(tableItem.getDBSystemRoot(), updates);
            }
        }
        return idsLot;
    }

    public List<SQLRowValues> createLotLivraison(List<BatchQuantity> l, SQLRowValues refBLRowItem) {
        HashMap<Integer, SQLRowValues> rowValsExists = new HashMap<Integer, SQLRowValues>();
        Collection referentRows = refBLRowItem.getReferentRows(this.getTable().getTable("LOT_LIVRAISON").getField("ID_BON_DE_LIVRAISON_ELEMENT"));
        for (SQLRowValues sqlRowValues : referentRows) {
            rowValsExists.put(sqlRowValues.getForeignID("ID_LOT"), sqlRowValues);
        }
        ArrayList<Integer> idBatchsNotExisting = new ArrayList<Integer>();
        HashSet<Integer> idBatchsExisting = new HashSet<Integer>();
        for (BatchQuantity batchQuantity : l) {
            int idBatch = batchQuantity.getIdBatch();
            if (!rowValsExists.containsKey(idBatch)) {
                idBatchsNotExisting.add(idBatch);
                continue;
            }
            idBatchsExisting.add(idBatch);
        }
        HashSet keySet = new HashSet(rowValsExists.keySet());
        keySet.removeAll(idBatchsExisting);
        for (Integer integer : keySet) {
            ((SQLRowValues)rowValsExists.get(integer)).put("ARCHIVE", 1);
        }
        SQLRowValues rowValsToFetch = new SQLRowValues(this.getTable());
        rowValsToFetch.putNulls(this.getTable().getFieldsName());
        SQLRowValues putRowValues = rowValsToFetch.putRowValues("ID_STOCK");
        putRowValues.putNulls("ID_DEPOT_STOCK");
        putRowValues.putRowValues("ID_ARTICLE").putNulls("NOM");
        List<SQLRowValues> fetch = SQLRowValuesListFetcher.create(rowValsToFetch).fetch(Where.inValues(this.getTable().getKey(), idBatchsNotExisting));
        HashMap<Integer, SQLRowValues> mapLot = new HashMap<Integer, SQLRowValues>();
        for (SQLRowValues sqlRowValues : fetch) {
            mapLot.put(sqlRowValues.getID(), sqlRowValues);
        }
        ArrayList<SQLRowValues> items = new ArrayList<SQLRowValues>();
        for (BatchQuantity batchQuantity : l) {
            SQLRowValues rowVals;
            int idBatch = batchQuantity.getIdBatch();
            BigDecimal quantity = batchQuantity.getQuantity();
            if (rowValsExists.containsKey(idBatch)) {
                rowVals = (SQLRowValues)rowValsExists.get(idBatch);
            } else {
                rowVals = new SQLRowValues(this.getTable().getTable("LOT_LIVRAISON"));
                SQLRowValues rLot = (SQLRowValues)mapLot.get(idBatch);
                SQLRowAccessor foreignStock = rLot.getForeign("ID_STOCK");
                SQLRowAccessor foreignArticle = foreignStock.getForeign("ID_ARTICLE");
                rowVals.put("ARTICLE", foreignArticle.getString("NOM"));
                rowVals.put("ID_ARTICLE", foreignArticle.getID());
                rowVals.put("ID_BON_DE_LIVRAISON_ELEMENT", (Object)refBLRowItem);
                rowVals.put("ID_DEPOT_STOCK", foreignStock.getForeignID("ID_DEPOT_STOCK"));
                rowVals.put("ID_LOT", idBatch);
                rowVals.put("NUMERO_LOT", rLot.getObject("NUMERO_LOT"));
                rowVals.put("DLC", rLot.getObject("DLC"));
                rowVals.put("DLUO", rLot.getObject("DLUO"));
                rowVals.put("NUMERO_SERIE", rLot.getObject("NUMERO_SERIE"));
            }
            rowVals.put("QUANTITE", quantity);
            items.add(rowVals);
        }
        return items;
    }

    public List<BatchQuantity> createBatchQuantity(List<SQLRowValues> lotLivraisonItems) throws SQLException {
        List<Integer> findOrCreateLot = this.findOrCreateLot(lotLivraisonItems);
        ArrayList<BatchQuantity> l = new ArrayList<BatchQuantity>();
        int index = 0;
        while (index < findOrCreateLot.size()) {
            Integer idLot = findOrCreateLot.get(index);
            SQLRowValues lotItem = lotLivraisonItems.get(index);
            l.add(new BatchQuantity(idLot, lotItem.getBigDecimal("QUANTITE"), BigDecimal.ZERO));
            ++index;
        }
        return l;
    }

    public void updateLotQuantiteFromBRItems(List<SQLRowValues> rowValuesBRItems) throws SQLException {
        this.updateLotQuantiteFromLotItems(this.fetchLotItem(SQLRow.getIDs(rowValuesBRItems), TypeLot.RECEPTION), TypeLot.RECEPTION);
    }

    public void removeLotQuantiteFromBR(List<SQLRowValues> rowValuesBR) throws SQLException {
        this.removeLotQuantiteFromLotItems(this.fetchLotItemsFromBonItems(SQLRow.getIDs(rowValuesBR), TypeLot.RECEPTION), TypeLot.RECEPTION);
    }

    public void removeLotQuantiteFromBR(Collection<Integer> idsBR) throws SQLException {
        this.removeLotQuantiteFromLotItems(this.fetchLotItemsFromBonItems(idsBR, TypeLot.RECEPTION), TypeLot.RECEPTION);
    }

    public void updateLotQuantiteFromBLItems(List<SQLRowValues> rowValuesBLItems) throws SQLException {
        this.updateLotQuantiteFromLotItems(this.fetchLotItem(SQLRow.getIDs(rowValuesBLItems), TypeLot.LIVRAISON), TypeLot.LIVRAISON);
    }

    public void removeLotQuantiteFromBL(List<SQLRowValues> rowValuesBL) throws SQLException {
        this.removeLotQuantiteFromLotItems(this.fetchLotItemsFromBonItems(SQLRow.getIDs(rowValuesBL), TypeLot.LIVRAISON), TypeLot.LIVRAISON);
    }

    public void removeLotQuantiteFromBL(Collection<Integer> idsBL) throws SQLException {
        this.removeLotQuantiteFromLotItems(this.fetchLotItemsFromBonItems(idsBL, TypeLot.LIVRAISON), TypeLot.LIVRAISON);
    }

    public List<SQLRowValues> fetchLotItem(final Collection<Number> idsBRorBLItem, final TypeLot type) throws SQLException {
        SQLTable brItemTable = this.getTable().getTable(type.getTableItems());
        SQLRowValues rowValsBRItem = new SQLRowValues(brItemTable);
        rowValsBRItem.putRowValues("ID_ARTICLE").putNulls("ID_DEPOT_STOCK");
        rowValsBRItem.putNulls("ID_DEPOT_STOCK");
        final SQLTable lotReceipttable = this.getTable().getTable(type.getTableLot());
        SQLRowValues rowValsLotReceipt = new SQLRowValues(lotReceipttable);
        rowValsLotReceipt.putNulls("DLC", "DLUO", "QUANTITE", "NUMERO_SERIE", "NUMERO_LOT", "ID_ARTICLE", "ID_DEPOT_STOCK", "ID_LOT").put("ID_" + type.getTableItems(), (Object)rowValsBRItem);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsLotReceipt);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                SQLSelectJoin join = input.getJoin(lotReceipttable.getField("ID_" + type.getTableItems()));
                input.setWhere(Where.inValues(join.getJoinedTable().getKey(), idsBRorBLItem));
                return input;
            }
        });
        return fetcher.fetch();
    }

    public List<SQLRowValues> fetchLotItemsFromBonItems(final Collection<? extends Number> idsBRorBL, final TypeLot type) throws SQLException {
        SQLTable brItemTable = this.getTable().getTable(type.getTableItems());
        SQLRowValues rowValsBRItem = new SQLRowValues(brItemTable);
        rowValsBRItem.putRowValues("ID_ARTICLE").putNulls("ID_DEPOT_STOCK");
        rowValsBRItem.putNulls("ID_DEPOT_STOCK");
        final SQLTable lotReceipttable = this.getTable().getTable(type.getTableLot());
        SQLRowValues rowValsLotReceipt = new SQLRowValues(lotReceipttable);
        rowValsLotReceipt.putNulls("DLC", "DLUO", "QUANTITE", "NUMERO_SERIE", "NUMERO_LOT", "ID_LOT", "ID_ARTICLE", "ID_DEPOT_STOCK").put("ID_" + type.getTableItems(), (Object)rowValsBRItem);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsLotReceipt);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                SQLSelectJoin join = input.getJoin(lotReceipttable.getField("ID_" + type.getTableItems()));
                input.setWhere(Where.inValues(join.getJoinedTable().getField("ID_" + type.getTableRootItems()), idsBRorBL));
                return input;
            }
        });
        return fetcher.fetch();
    }

    public void stock(ProductComponent comp) {
        comp.getStock();
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".batch";
    }

    class LotKey {
        private final Integer idArticle;
        private final Integer idDepot;
        private final String serie;
        private final String lot;

        public LotKey(Integer idArticle, Integer idDepot, String serie, String lot) {
            this.idArticle = idArticle;
            this.idDepot = idDepot;
            this.serie = serie;
            this.lot = lot;
        }

        public int hashCode() {
            return this.idArticle.hashCode() ^ this.idDepot.hashCode() ^ this.serie.hashCode() ^ this.lot.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof LotKey && ((LotKey)obj).idArticle.equals(this.idArticle) && ((LotKey)obj).idDepot.equals(this.idDepot) && ((LotKey)obj).serie.equals(this.serie) && ((LotKey)obj).lot.equals(this.lot);
        }
    }

    public static enum TypeLot {
        RECEPTION("LOT_RECEPTION", "BON_RECEPTION_ELEMENT", "BON_RECEPTION"),
        LIVRAISON("LOT_LIVRAISON", "BON_DE_LIVRAISON_ELEMENT", "BON_DE_LIVRAISON");

        private final String tableLot;
        private final String tableItems;
        private final String tableRootItems;

        private TypeLot(String tableLot, String tableItems, String tableRootItems) {
            this.tableLot = tableLot;
            this.tableItems = tableItems;
            this.tableRootItems = tableRootItems;
        }

        public String getTableItems() {
            return this.tableItems;
        }

        public String getTableLot() {
            return this.tableLot;
        }

        public String getTableRootItems() {
            return this.tableRootItems;
        }
    }
}

