/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ArticleTarifSQLElement
extends ComptaSQLConfElement {
    public ArticleTarifSQLElement() {
        super("ARTICLE_TARIF", "un tarif d'article", "tarifs d'article");
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_TARIF");
        l.add("ID_ARTICLE");
        l.add("QTE");
        l.add("PV_HT");
        l.add("PV_TTC");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_TARIF");
        l.add("ID_ARTICLE");
        l.add("PV_TTC");
        return l;
    }

    @Override
    protected String getParentFFName() {
        return "ID_ARTICLE";
    }

    @Override
    public Set<String> getInsertOnlyFields() {
        HashSet<String> req = new HashSet<String>();
        req.add("ID_TARIF");
        req.add("ID_ARTICLE");
        return req;
    }

    @Override
    public Set<String> getReadOnlyFields() {
        HashSet<String> ro = new HashSet<String>();
        ro.add("PV_HT");
        ro.add("PV_TTC");
        return ro;
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){

            @Override
            public void addViews() {
                this.setLayout(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                c.gridx = 0;
                c.weightx = 0.0;
                this.add((Component)new JLabel(this.getLabelFor("ID_TARIF")), c);
                ++c.gridx;
                c.weightx = 1.0;
                SQLRequestComboBox tarifCombo = new SQLRequestComboBox();
                this.add((Component)tarifCombo, c);
                this.addRequiredSQLObject(tarifCombo, "ID_TARIF");
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                this.add((Component)new JLabel(this.getLabelFor("ID_ARTICLE")), c);
                ++c.gridx;
                c.weightx = 1.0;
                final SQLRequestComboBox artCombo = new SQLRequestComboBox();
                this.add((Component)artCombo, c);
                this.addRequiredSQLObject(artCombo, "ID_ARTICLE");
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                JLabel labelQTE = new JLabel(this.getLabelFor("QTE"));
                JTextField textQTE = new JTextField();
                this.add((Component)labelQTE, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)textQTE, c);
                this.addRequiredSQLObject(textQTE, "QTE");
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                JLabel labelRemise = new JLabel(this.getLabelFor("POURCENT_REMISE"));
                JTextField textRemise = new JTextField();
                this.add((Component)labelRemise, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)textRemise, c);
                this.addSQLObject(textRemise, "POURCENT_REMISE");
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                JLabel labelPVM = new JLabel(this.getLabelFor("PRIX_METRIQUE_VT_1"));
                final JTextField textPVM = new JTextField();
                this.add((Component)labelPVM, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)textPVM, c);
                this.addSQLObject(textPVM, "PRIX_METRIQUE_VT_1");
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                JLabel labelPV = new JLabel(this.getLabelFor("PV_HT"));
                final JTextField textPV = new JTextField();
                this.add((Component)labelPV, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)textPV, c);
                this.addSQLObject(textPV, "PV_HT");
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                this.add((Component)new JLabel(this.getLabelFor("ID_TAXE")), c);
                ++c.gridx;
                c.weightx = 1.0;
                final SQLRequestComboBox taxeCombo = new SQLRequestComboBox();
                this.add((Component)taxeCombo, c);
                this.addSQLObject(taxeCombo, "ID_TAXE");
                ++c.gridy;
                c.gridx = 0;
                c.weightx = 0.0;
                JLabel labelPVTTC = new JLabel(this.getLabelFor("PV_TTC"));
                final JTextField textTTC = new JTextField();
                this.add((Component)labelPVTTC, c);
                ++c.gridx;
                c.weightx = 1.0;
                this.add((Component)textTTC, c);
                this.addSQLObject(textTTC, "PV_TTC");
                textPVM.getDocument().addDocumentListener(new SimpleDocumentListener(){

                    @Override
                    public void update(DocumentEvent e) {
                        BigDecimal ht = StringUtils.getBigDecimalFromUserText(textPVM.getText());
                        if (ht != null) {
                            Float resultTaux;
                            SQLRowAccessor rTaxe = taxeCombo.getSelectedRowAccessor();
                            if (rTaxe == null || rTaxe.isUndefined()) {
                                SQLRowAccessor a = artCombo.getSelectedRowAccessor();
                                if (a != null && !a.isUndefined()) {
                                    rTaxe = a.asRow().fetchNewRow().getForeignRow("ID_TAXE");
                                }
                                if (rTaxe == null || rTaxe.isUndefined()) {
                                    rTaxe = TaxeCache.getCache().getFirstTaxe();
                                }
                            }
                            if ((resultTaux = TaxeCache.getCache().getTauxFromId(rTaxe.getID())) == null) {
                                SQLRow i = TaxeCache.getCache().getFirstTaxe();
                                resultTaux = Float.valueOf(i.getFloat("TAUX"));
                            }
                            float taux = resultTaux == null ? 0.0f : resultTaux.floatValue();
                            BigDecimal r = ht.multiply(BigDecimal.valueOf(taux).divide(BigDecimal.valueOf(100L)).add(BigDecimal.ONE), DecimalUtils.HIGH_PRECISION);
                            textPV.setText(textPVM.getText());
                            textTTC.setText(r.setScale(2, RoundingMode.HALF_UP).toString());
                        } else {
                            textPV.setText("");
                            textTTC.setText("");
                        }
                    }
                });
            }
        };
    }

    @Override
    public SQLRowValues createDefaultRowValues(String token) {
        SQLRowValues rowVals = super.createDefaultRowValues(token);
        rowVals.put("QTE", 1);
        return rowVals;
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".price";
    }
}

