/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Font;
import javax.swing.JEditorPane;
import org.openconcerto.erp.core.sales.pos.io.TicketPrinter;
import org.openconcerto.erp.core.sales.pos.model.TicketLine;

public class TextAreaTicketPrinter
extends JEditorPane
implements TicketPrinter {
    private String docName = "unknown doc";
    private StringBuffer text = new StringBuffer();
    private final String retour = "<br/>";

    public TextAreaTicketPrinter() {
        this.setContentType("text/html");
        this.setEditable(false);
        this.setFont(new Font("Monospaced", 0, 14));
    }

    @Override
    public void addToBuffer(String t) {
        this.text.append(t);
        this.text.append("<br/>");
    }

    @Override
    public void addToBuffer(String t, int mode) {
        boolean barCode;
        boolean bl = barCode = mode == 10;
        if (barCode) {
            this.text.append("* ");
        } else if (mode == 1) {
            this.text.append("<b>");
        } else if (mode == 2) {
            this.text.append("<big>");
            this.text.append("<b>");
        } else if (mode == 3) {
            this.text.append("<u>");
        }
        this.text.append(t);
        if (barCode) {
            this.text.append(" *");
        } else if (mode == 1) {
            this.text.append("</b>");
        } else if (mode == 2) {
            this.text.append("</b>");
            this.text.append("</big>");
        } else if (mode == 3) {
            this.text.append("</u>");
        }
        this.text.append("<br/>");
    }

    @Override
    public void printBuffer() throws Exception {
        this.setText("<pre>" + this.text.toString() + "</pre>");
    }

    public void clear() {
        this.text = new StringBuffer();
        this.setText("");
    }

    @Override
    public void openDrawer() throws Exception {
    }

    @Override
    public void addToBuffer(TicketLine line) {
        this.addToBuffer(line.getText(), 0);
    }

    @Override
    public void clearBuffer(String docName) {
        this.clear();
        this.docName = docName;
    }

    public final String getDocName() {
        return this.docName;
    }
}

