/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class ArticleCache {
    private static ArticleCache instance;
    private final Map<Integer, SQLRowAccessor> cacheArticle = new HashMap<Integer, SQLRowAccessor>();
    private final SQLElementDirectory dir;

    public ArticleCache(SQLElementDirectory dir) {
        this.dir = dir;
    }

    public static synchronized void initCache(SQLElementDirectory dir) {
        if (instance != null) {
            throw new IllegalStateException("cache already inited");
        }
        instance = new ArticleCache(dir);
    }

    public static synchronized ArticleCache getInstance() {
        if (instance == null) {
            throw new IllegalStateException("cache not inited");
        }
        return instance;
    }

    public synchronized SQLRowAccessor getArticleRowValuesFromCache(int id) {
        SQLRowAccessor r = this.cacheArticle.get(id);
        if (r == null) {
            this.preloadCacheArticleMap(Arrays.asList(id));
            System.out.println("warning product not in cache : " + id);
            r = this.cacheArticle.get(id);
        }
        return r;
    }

    public synchronized boolean isInCache(int id) {
        return this.cacheArticle.get(id) != null;
    }

    public synchronized void preloadCacheArticleMap(List<Integer> ids) {
        SQLTable tableArt = this.dir.getElement("ARTICLE").getTable();
        SQLRowValues rowValsArt = new SQLRowValues(tableArt);
        rowValsArt.putNulls(tableArt.getFieldsName());
        SQLTable tableArtCatComptable = this.dir.getElement("ARTICLE_CATEGORIE_COMPTABLE").getTable();
        SQLRowValues rowValsArtCatComptable = new SQLRowValues(tableArtCatComptable);
        rowValsArtCatComptable.putNulls(tableArtCatComptable.getFieldsName());
        rowValsArtCatComptable.put("ID_ARTICLE", (Object)rowValsArt);
        SQLRowValues rowValsCaCompt = rowValsArtCatComptable.putRowValues("ID_CATEGORIE_COMPTABLE");
        rowValsCaCompt.putNulls(rowValsCaCompt.getTable().getFieldsName());
        SQLRowValues rowValsFam = rowValsArt.putRowValues("ID_FAMILLE_ARTICLE");
        rowValsFam.putNulls(rowValsFam.getTable().getFieldsName());
        SQLRowValues rowValuesFamP = rowValsFam.putRowValues("ID_FAMILLE_ARTICLE_PERE");
        rowValuesFamP.putNulls(rowValuesFamP.getTable().getFieldsName());
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsArt);
        List<SQLRowValues> res = fetcher.fetch(Where.inValues(tableArt.getKey(), ids));
        for (SQLRowValues sqlRowValues : res) {
            this.cacheArticle.put(sqlRowValues.getID(), sqlRowValues);
        }
    }
}

