/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.reports.history.ui;

import java.awt.GridLayout;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.model.Currency;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.GestionDevise;

public class HistoriqueClientBilanPanel
extends JPanel {
    private final JLabel labelVentesComptoir = new JLabel();
    private final JLabel labelVentesFacture = new JLabel();
    private final JLabel labelPropositions = new JLabel();
    private final JLabel labelCheques = new JLabel();
    private final JLabel labelEcheances = new JLabel();
    private final JLabel labelRelances = new JLabel();
    private final JLabel labelTotalVente = new JLabel();
    private final JLabel labelTotalVentesArticle = new JLabel();
    private long nbVentesCompoir;
    private long totalVentesCompoir;
    private long nbVentesFacture;
    private long totalVentesFacture;
    private long totalVentesArticle;
    private long nbTotalCheques;
    private long totalCheques;
    private long nbChequesNonEncaisses;
    private long nbRelances;
    private int delaiPaiementMoyen;
    private long nbPropositions;
    private long totalPropositions;
    private long nbFacturesImpayees;
    private long totalFacturesImpayees;
    private int poucentageVentes;
    CurrencyConverter cc = new CurrencyConverter();

    public HistoriqueClientBilanPanel() {
        this.setLayout(new GridLayout(4, 2));
        Boolean bModeVenteComptoir = DefaultNXProps.getInstance().getBooleanValue("ArticleVenteComptoir", true);
        if (bModeVenteComptoir.booleanValue()) {
            this.add(this.labelVentesComptoir);
        }
        this.add(this.labelVentesFacture);
        this.add(this.labelPropositions);
        this.add(this.labelCheques);
        this.add(this.labelEcheances);
        this.add(this.labelRelances);
        this.add(this.labelTotalVente);
        this.add(this.labelTotalVentesArticle);
    }

    public synchronized void updateRelance(List<Integer> listId) {
        int nb = listId.size();
        if (this.nbRelances != (long)nb) {
            this.setRelances(nb);
            this.updateLabels();
        }
    }

    public synchronized void updateEcheance(final List<Integer> listId) {
        ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

            @Override
            public void run() {
                long valueTotal = 0L;
                if (listId != null && listId.size() > 0) {
                    SQLBase base = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getSQLBaseSociete();
                    SQLSelect select = new SQLSelect();
                    SQLTable table = base.getTable("ECHEANCE_CLIENT");
                    select.addSelect(table.getField("MONTANT"), "SUM");
                    select.setWhere(new Where(table.getKey(), listId));
                    Number n = (Number)base.getDBSystemRoot().getDataSource().executeScalar(select.asString());
                    if (n != null) {
                        valueTotal = n.longValue();
                    }
                }
                HistoriqueClientBilanPanel.this.setNbFacturesImpayees(listId == null ? 0 : listId.size());
                HistoriqueClientBilanPanel.this.setTotalFacturesImpayees(valueTotal);
                HistoriqueClientBilanPanel.this.updateLabels();
            }
        });
    }

    public synchronized void updateVFData(final List<Integer> listId, final int idClient) {
        ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SQLBase base = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getSQLBaseSociete();
                long valueTotal = 0L;
                if (listId != null && listId.size() > 0) {
                    SQLSelect select = new SQLSelect();
                    SQLTable table = base.getTable("SAISIE_VENTE_FACTURE");
                    select.addSelect(table.getField("T_HT"), "SUM");
                    select.setWhere(new Where(table.getKey(), listId));
                    Number n = (Number)base.getDBSystemRoot().getDataSource().executeScalar(select.asString());
                    if (n != null) {
                        valueTotal = n.longValue();
                    }
                }
                HashMap mapDateFact = new HashMap();
                SQLSelect selDateFacture = new SQLSelect();
                SQLTable tableFacture = base.getTable("SAISIE_VENTE_FACTURE");
                SQLTable tableEncaisse = base.getTable("ENCAISSER_MONTANT");
                SQLTable tableEcheance = base.getTable("ECHEANCE_CLIENT");
                SQLTable tableMvt = base.getTable("MOUVEMENT");
                selDateFacture.addSelect(tableFacture.getField("DATE"));
                selDateFacture.addSelect(tableMvt.getField("ID_PIECE"));
                Where w = new Where((FieldRef)tableFacture.getField("ID_MOUVEMENT"), "=", tableMvt.getKey());
                if (idClient > 1) {
                    w = w.and(new Where((FieldRef)tableFacture.getField("ID_CLIENT"), "=", idClient));
                }
                selDateFacture.setWhere(w);
                HistoriqueClientBilanPanel.this.addDatesToMap(base, selDateFacture, mapDateFact);
                SQLSelect selDateFactureC = new SQLSelect();
                SQLTable tableComptoir = base.getTable("SAISIE_VENTE_COMPTOIR");
                selDateFactureC.addSelect(tableComptoir.getField("DATE"));
                selDateFactureC.addSelect(tableMvt.getField("ID_PIECE"));
                Where wC = new Where((FieldRef)tableComptoir.getField("ID_MOUVEMENT"), "=", tableMvt.getKey());
                if (idClient > 1) {
                    wC = wC.and(new Where((FieldRef)tableComptoir.getField("ID_CLIENT"), "=", idClient));
                }
                selDateFactureC.setWhere(wC);
                HistoriqueClientBilanPanel.this.addDatesToMap(base, selDateFactureC, mapDateFact);
                SQLSelect selDateEncaisse = new SQLSelect();
                selDateEncaisse.addSelect(tableEncaisse.getField("DATE"));
                selDateEncaisse.addSelect(tableMvt.getField("ID_PIECE"));
                selDateEncaisse.addSelect(tableEcheance.getField("ID"));
                Where wEncaisse = new Where((FieldRef)tableEcheance.getField("ID"), "=", tableEncaisse.getField("ID_ECHEANCE_CLIENT"));
                wEncaisse = wEncaisse.and(new Where((FieldRef)tableEcheance.getField("ID_MOUVEMENT"), "=", tableMvt.getField("ID")));
                wEncaisse = wEncaisse.and(new Where((FieldRef)tableEcheance.getArchiveField(), "=", 1));
                if (idClient > 1) {
                    wEncaisse = wEncaisse.and(new Where((FieldRef)tableEcheance.getField("ID_CLIENT"), "=", idClient));
                }
                selDateEncaisse.setWhere(wEncaisse);
                selDateEncaisse.setArchivedPolicy(SQLSelect.BOTH);
                List lDateEncaisse = (List)base.getDataSource().execute(selDateEncaisse.asString(), new ArrayListHandler());
                HashMap<Object, Date> mapDateEncaisse = new HashMap<Object, Date>();
                int i = 0;
                while (i < lDateEncaisse.size()) {
                    Object[] tmp = (Object[])lDateEncaisse.get(i);
                    Date d2 = (Date)tmp[0];
                    Object d = mapDateEncaisse.get(tmp[1]);
                    if (d != null) {
                        Date d1 = (Date)d;
                        if (d1.before(d2)) {
                            mapDateEncaisse.put(tmp[1], d2);
                        }
                    } else {
                        mapDateEncaisse.put(tmp[1], d2);
                    }
                    ++i;
                }
                int cpt = 0;
                int day = 0;
                Calendar cal1 = Calendar.getInstance();
                Calendar cal2 = Calendar.getInstance();
                for (Object key : mapDateFact.keySet()) {
                    Date dFact = (Date)mapDateFact.get(key);
                    Date dEncaisse = (Date)mapDateEncaisse.get(key);
                    if (dFact == null || dEncaisse == null) continue;
                    ++cpt;
                    cal1.setTime(dFact);
                    cal2.setTime(dEncaisse);
                    cal1.set(10, 0);
                    cal1.set(12, 0);
                    cal1.set(13, 0);
                    cal1.set(14, 0);
                    cal2.set(10, 0);
                    cal2.set(12, 0);
                    cal2.set(13, 0);
                    cal2.set(14, 0);
                    day = (int)((long)day + (cal2.getTime().getTime() - cal1.getTime().getTime()) / 86400000L);
                }
                HistoriqueClientBilanPanel.this.setPoucentageVentes(cpt == 0 ? 0 : day / cpt);
                HistoriqueClientBilanPanel.this.setTotalVentesFacture(valueTotal);
                HistoriqueClientBilanPanel.this.setNbVentesFacture(listId == null ? 0 : listId.size());
                HistoriqueClientBilanPanel.this.updateLabels();
            }
        });
    }

    public synchronized void updateVFArticleData(final List<Integer> listId, int idClient) {
        ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SQLBase base = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getSQLBaseSociete();
                double valueTotal = 0.0;
                if (listId != null && listId.size() > 0) {
                    SQLSelect select = new SQLSelect();
                    SQLTable tableElt = base.getTable("SAISIE_VENTE_FACTURE_ELEMENT");
                    select.addSelect(tableElt.getField("T_PV_HT"), "SUM");
                    Where w = new Where(tableElt.getKey(), listId);
                    w = w.and(new Where((FieldRef)tableElt.getField("NIVEAU"), "=", 1));
                    select.setWhere(w);
                    Number n = (Number)base.getDBSystemRoot().getDataSource().executeScalar(select.asString());
                    if (n != null) {
                        valueTotal = n.doubleValue();
                    }
                }
                HistoriqueClientBilanPanel.this.setTotalVentesArticle(Math.round(valueTotal * 100.0));
                HistoriqueClientBilanPanel.this.updateLabels();
            }
        });
    }

    private void addDatesToMap(SQLBase base, SQLSelect selDateFacture, Map mapDateFact) {
        List lDateFact = (List)base.getDataSource().execute(selDateFacture.asString(), new ArrayListHandler());
        int size = lDateFact.size();
        int i = 0;
        while (i < size) {
            Object[] tmp = (Object[])lDateFact.get(i);
            mapDateFact.put(tmp[1], tmp[0]);
            ++i;
        }
    }

    public synchronized void updateVCData(final List<Integer> listId) {
        ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SQLBase base = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getSQLBaseSociete();
                long valueTotal = 0L;
                if (listId != null && listId.size() > 0) {
                    SQLSelect select = new SQLSelect();
                    SQLTable table = base.getTable("SAISIE_VENTE_COMPTOIR");
                    select.addSelect(table.getField("MONTANT_HT"), "SUM");
                    select.setWhere(new Where(table.getKey(), listId));
                    Number n = (Number)base.getDBSystemRoot().getDataSource().executeScalar(select.asString());
                    if (n != null) {
                        valueTotal = n.longValue();
                    }
                }
                HistoriqueClientBilanPanel.this.setNbVentesComptoir(listId == null ? 0 : listId.size());
                HistoriqueClientBilanPanel.this.setTotalVentesComptoir(valueTotal);
                HistoriqueClientBilanPanel.this.updateLabels();
            }
        });
    }

    public synchronized void updateChequeData(final List<Integer> listId) {
        ComptaPropsConfiguration.getInstanceCompta().getNonInteractiveSQLExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SQLBase base = ((ComptaPropsConfiguration)ComptaPropsConfiguration.getInstance()).getSQLBaseSociete();
                SQLTable table = base.getTable("CHEQUE_A_ENCAISSER");
                long valueTotalTmp = 0L;
                long valueNonEncaisseTmp = 0L;
                if (listId != null && listId.size() > 0) {
                    SQLSelect select = new SQLSelect();
                    select.addSelect(table.getField("MONTANT"), "SUM");
                    select.setWhere(new Where(table.getKey(), listId));
                    Number n = (Number)base.getDBSystemRoot().getDataSource().executeScalar(select.asString());
                    if (n != null) {
                        valueTotalTmp = n.longValue();
                    }
                    select.setWhere(new Where(table.getKey(), listId).and(new Where((FieldRef)table.getField("ENCAISSE"), "=", (Object)Boolean.FALSE)));
                    n = (Number)base.getDBSystemRoot().getDataSource().executeScalar(select.asString());
                    if (n != null) {
                        valueNonEncaisseTmp = n.longValue();
                    }
                }
                HistoriqueClientBilanPanel.this.setNbTotalCheques(listId == null ? 0 : listId.size());
                HistoriqueClientBilanPanel.this.setNbChequesNonEncaisses(valueNonEncaisseTmp);
                HistoriqueClientBilanPanel.this.setTotalCheques(valueTotalTmp);
                HistoriqueClientBilanPanel.this.updateLabels();
            }
        });
    }

    public void setNbVentesComptoir(long nb) {
        this.nbVentesCompoir = nb;
    }

    public void setTotalVentesComptoir(long totalInCents) {
        this.totalVentesCompoir = totalInCents;
    }

    public void setNbVentesFacture(long nb) {
        this.nbVentesFacture = nb;
    }

    public void setTotalVentesFacture(long totalInCents) {
        this.totalVentesFacture = totalInCents;
    }

    public void setTotalVentesArticle(long totalVentesArticle) {
        this.totalVentesArticle = totalVentesArticle;
    }

    public void setNbTotalCheques(long nb) {
        this.nbTotalCheques = nb;
    }

    public void setTotalCheques(long totalInCents) {
        this.totalCheques = totalInCents;
    }

    public void setNbChequesNonEncaisses(long nb) {
        this.nbChequesNonEncaisses = nb;
    }

    public void setRelances(long nb) {
        this.nbRelances = nb;
    }

    public void setDelaiPaiementMoyen(int nb) {
        this.delaiPaiementMoyen = nb;
    }

    public void setNbPropositions(long nb) {
        this.nbPropositions = nb;
    }

    public void setTotalPropositions(long totalInCents) {
        this.totalPropositions = totalInCents;
    }

    public void setNbFacturesImpayees(long nb) {
        this.nbFacturesImpayees = nb;
    }

    public void setTotalFacturesImpayees(long totalInCents) {
        this.totalFacturesImpayees = totalInCents;
    }

    public void setPoucentageVentes(int pourCent) {
        this.poucentageVentes = pourCent;
    }

    private void updateLabels() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String symbol = Currency.getSymbol(HistoriqueClientBilanPanel.this.cc.getCompanyCurrencyCode());
                String total = GestionDevise.currencyToString(HistoriqueClientBilanPanel.this.totalVentesCompoir, true);
                long nb = HistoriqueClientBilanPanel.this.nbVentesCompoir;
                if (nb == 0L) {
                    HistoriqueClientBilanPanel.this.labelVentesComptoir.setText(" pas de vente comptoir");
                } else if (nb == 1L) {
                    HistoriqueClientBilanPanel.this.labelVentesComptoir.setText(" une vente comptoir d'un montant de " + total + " " + symbol + " HT");
                } else {
                    HistoriqueClientBilanPanel.this.labelVentesComptoir.setText(" " + nb + " ventes comptoir d'un montant total de " + total + " " + symbol + " HT");
                }
                total = GestionDevise.currencyToString(HistoriqueClientBilanPanel.this.totalVentesFacture, true);
                nb = HistoriqueClientBilanPanel.this.nbVentesFacture;
                if (nb == 0L) {
                    HistoriqueClientBilanPanel.this.labelVentesFacture.setText(" pas de vente avec facture");
                } else if (nb == 1L) {
                    HistoriqueClientBilanPanel.this.labelVentesFacture.setText(" une vente avec facture d'un montant de " + total + " " + symbol + " HT");
                } else {
                    HistoriqueClientBilanPanel.this.labelVentesFacture.setText(" " + nb + " ventes avec facture d'un montant total de " + total + " " + symbol + " HT");
                }
                total = GestionDevise.currencyToString(HistoriqueClientBilanPanel.this.totalPropositions, true);
                nb = HistoriqueClientBilanPanel.this.nbPropositions;
                if (nb == 0L) {
                    HistoriqueClientBilanPanel.this.labelPropositions.setText(" pas de proposition commerciale");
                } else if (nb == 1L) {
                    HistoriqueClientBilanPanel.this.labelPropositions.setText(" une proposition commerciale d'un montant de " + total + " " + symbol + " HT");
                } else {
                    HistoriqueClientBilanPanel.this.labelPropositions.setText(" " + nb + " propositions commerciales d'un montant total de " + total + " " + symbol + " HT");
                }
                nb = HistoriqueClientBilanPanel.this.nbTotalCheques;
                total = GestionDevise.currencyToString(HistoriqueClientBilanPanel.this.totalCheques, true);
                if (nb == 0L) {
                    HistoriqueClientBilanPanel.this.labelCheques.setText(" pas de ch\u00e8que");
                } else if (nb == 1L) {
                    if (HistoriqueClientBilanPanel.this.nbChequesNonEncaisses == 0L) {
                        HistoriqueClientBilanPanel.this.labelCheques.setText(" un ch\u00e8que d'un montant de " + total + " " + symbol + " HT");
                    } else {
                        HistoriqueClientBilanPanel.this.labelCheques.setText(" un ch\u00e8que non encaiss\u00e9 d'un montant de " + total + " " + symbol + " HT");
                    }
                } else if (HistoriqueClientBilanPanel.this.nbChequesNonEncaisses == 0L) {
                    HistoriqueClientBilanPanel.this.labelCheques.setText(" " + nb + " ch\u00e8ques d'un montant total de " + total + " " + symbol + " HT");
                } else if (HistoriqueClientBilanPanel.this.nbChequesNonEncaisses == nb) {
                    HistoriqueClientBilanPanel.this.labelCheques.setText(" " + nb + " ch\u00e8ques non encaiss\u00e9s d'un montant total de " + total + " " + symbol + " HT");
                } else {
                    HistoriqueClientBilanPanel.this.labelCheques.setText(" " + nb + " ch\u00e8ques d'un montant total de " + total + " " + symbol + " HT dont " + HistoriqueClientBilanPanel.this.nbChequesNonEncaisses + " non encaiss\u00e9s");
                }
                nb = HistoriqueClientBilanPanel.this.nbFacturesImpayees;
                total = GestionDevise.currencyToString(HistoriqueClientBilanPanel.this.totalFacturesImpayees, true);
                if (nb == 0L) {
                    HistoriqueClientBilanPanel.this.labelEcheances.setText(" pas de facture non pay\u00e9e");
                } else if (nb == 1L) {
                    HistoriqueClientBilanPanel.this.labelEcheances.setText(" une facture non pay\u00e9e d'un montant de " + total + " " + symbol + " HT");
                } else {
                    HistoriqueClientBilanPanel.this.labelEcheances.setText(" " + nb + " factures non pay\u00e9es d'un montant total de " + total + " " + symbol + " HT");
                }
                nb = HistoriqueClientBilanPanel.this.nbRelances;
                String txt = nb == 0L ? " pas de relance effectu\u00e9e" : (nb == 1L ? " une relance effectu\u00e9e" : " " + nb + " relances effectu\u00e9es");
                if (nb > 0L) {
                    if (HistoriqueClientBilanPanel.this.delaiPaiementMoyen == 1) {
                        txt = String.valueOf(txt) + ", d\u00e9lai moyen de paiment d'une journ\u00e9e";
                    } else if (HistoriqueClientBilanPanel.this.delaiPaiementMoyen > 1) {
                        txt = String.valueOf(txt) + ", d\u00e9lai moyen de paiment de " + HistoriqueClientBilanPanel.this.delaiPaiementMoyen + " jours";
                    }
                }
                HistoriqueClientBilanPanel.this.labelRelances.setText(txt);
                long cents = HistoriqueClientBilanPanel.this.totalVentesCompoir + HistoriqueClientBilanPanel.this.totalVentesFacture;
                total = GestionDevise.currencyToString(cents, true);
                if (cents == 0L) {
                    HistoriqueClientBilanPanel.this.labelTotalVente.setText(" pas de vente");
                } else if (HistoriqueClientBilanPanel.this.poucentageVentes <= 0) {
                    HistoriqueClientBilanPanel.this.labelTotalVente.setText(" ventes de " + total + " " + symbol + " HT");
                } else {
                    HistoriqueClientBilanPanel.this.labelTotalVente.setText(" ventes de " + total + " " + symbol + " HT, soit " + HistoriqueClientBilanPanel.this.poucentageVentes + "% des ventes totales");
                }
                total = GestionDevise.currencyToString(HistoriqueClientBilanPanel.this.totalVentesArticle, true);
                if (HistoriqueClientBilanPanel.this.totalVentesArticle == 0L) {
                    HistoriqueClientBilanPanel.this.labelTotalVentesArticle.setText(" Aucun article vendu");
                } else {
                    HistoriqueClientBilanPanel.this.labelTotalVentesArticle.setText(String.valueOf(total) + " " + symbol + " HT d'articles factur\u00e9s");
                }
            }
        });
    }
}

