/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.element;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.customerrelationship.customer.element.ClientNormalSQLComponent;
import org.openconcerto.erp.core.customerrelationship.customer.report.FicheClientXmlSheet;
import org.openconcerto.erp.preferences.GestionClientPreferencePanel;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.ql.LabelCreator;
import org.openconcerto.ql.QLPrinter;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.ui.EmailComposer;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;

public class ClientNormalSQLElement
extends ComptaSQLConfElement {
    protected boolean showMdr = true;

    public ClientNormalSQLElement() {
        super("CLIENT", "un client", "clients");
        try {
            final String property = PrinterNXProps.getInstance().getProperty("QLPrinter");
            if (property != null && property.trim().length() > 0) {
                RowAction.PredicateRowAction actionPrintLabel = new RowAction.PredicateRowAction((Action)new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SQLRow row = IListe.get(e).fetchSelectedRow();
                        ClientNormalSQLElement.this.printLabel(row, property);
                    }
                }, false, "customerrelationship.customer.label.print");
                actionPrintLabel.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
                this.getRowActions().add(actionPrintLabel);
            }
            RowAction.PredicateRowAction actionFicheClient = new RowAction.PredicateRowAction((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SQLRow row = IListe.get(e).fetchSelectedRow();
                    FicheClientXmlSheet sheet = new FicheClientXmlSheet(row.asRow());
                    sheet.createDocumentAsynchronous();
                    sheet.showPrintAndExportAsynchronous(true, false, true, Collections.emptyList());
                }
            }, false, "customerrelationship.customer.info.create");
            actionFicheClient.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
            this.getRowActions().add(actionFicheClient);
            RowAction.PredicateRowAction action = new RowAction.PredicateRowAction((Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientNormalSQLElement.this.sendMail(IListe.get(e).getSelectedRows());
                }
            }, true, "customerrelationship.customer.email.send");
            action.setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
            this.getRowActions().add(action);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printLabel(SQLRowAccessor row, String qlPrinterProperty) {
        String[] s;
        LabelCreator c = new LabelCreator(720);
        c.setLeftMargin(10);
        c.setTopMargin(10);
        c.setDefaultFont(new Font("Verdana", 0, 50));
        c.addLineBold(row.getString("NOM"));
        SQLRow foreignRow = row.asRow().getForeign("ID_ADRESSE");
        String string = foreignRow.getString("RUE");
        String[] stringArray = s = string.split("\n");
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            c.addLineNormal(string2);
            ++n2;
        }
        c.addLineNormal(String.valueOf(foreignRow.getString("CODE_POSTAL")) + " " + foreignRow.getString("VILLE"));
        String pays = foreignRow.getString("PAYS");
        if (pays != null && pays.trim().length() > 0 && !pays.equalsIgnoreCase(ComptaPropsConfiguration.getInstanceCompta().getRowSociete().getForeignRow("ID_ADRESSE_COMMON").getString("PAYS"))) {
            c.addLineNormal(pays);
        }
        QLPrinter prt = new QLPrinter(qlPrinterProperty);
        try {
            prt.print(c.getImage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void sendMail(List<SQLRowValues> l) {
        String mail = "";
        for (SQLRowAccessor sQLRowAccessor : l) {
            String string = sQLRowAccessor.getString("MAIL");
            if (string == null) {
                string = sQLRowAccessor.asRow().getString("MAIL");
            }
            if (string == null || string.trim().length() <= 0) continue;
            mail = String.valueOf(mail) + string + ";";
        }
        try {
            EmailComposer.getInstance().compose(mail, "", "", new File[0]);
        }
        catch (Exception exception) {
            ExceptionHandler.handle(null, "Impossible de cr\u00e9er le courriel", exception);
        }
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("CODE");
        l.add("NOM");
        l.add("RESPONSABLE");
        l.add("ID_ADRESSE");
        l.add("TEL");
        l.add("TEL_P");
        l.add("FAX");
        l.add("MAIL");
        l.add("NUMERO_TVA");
        l.add("SIRET");
        l.add("ID_COMPTE_PCE");
        l.add("ID_MODE_REGLEMENT");
        l.add("INFOS");
        l.add("ID_COMMERCIAL");
        return l;
    }

    @Override
    protected void _initListRequest(ListSQLRequest req) {
        super._initListRequest(req);
        req.addForeignToGraphToFetch("ID_MODE_REGLEMENT", Arrays.asList("AJOURS", "LENJOUR"));
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("GROUPE");
        l.add("NOM");
        if (this.getTable().getFieldsName().contains("LOCALISATION")) {
            l.add("LOCALISATION");
        } else {
            l.add("CODE");
        }
        SQLPreferences prefs = SQLPreferences.getMemCached(this.getTable().getDBRoot());
        if (prefs.getBoolean(GestionClientPreferencePanel.DISPLAY_CLIENT_PCE, false)) {
            l.add("ID_COMPTE_PCE");
        }
        return l;
    }

    @Override
    protected void _initTableSource(SQLTableModelSource res) {
        super._initTableSource(res);
        this.addCommercialFilter(res, this.getTable().getField("ID_COMMERCIAL"));
        res.getColumns().add(new BaseSQLTableModelColumn(this.getDirectory().getTranslator().getLabelFor(this.getTable().getField("CATEGORIES")), String.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                return r.getString("CATEGORIES");
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(ClientNormalSQLElement.this.getTable());
                return CollectionUtils.createSet(new FieldPath(p, "CATEGORIES"));
            }
        });
    }

    @Override
    protected void _initComboRequest(ComboSQLRequest req) {
        super._initComboRequest(req);
        this.addCommercialFilterCombo(req, this.getTable().getField("ID_COMMERCIAL"));
        req.putWhere("Obsolete", new Where((FieldRef)this.getTable().getField("OBSOLETE"), "=", (Object)Boolean.FALSE));
    }

    @Override
    public SQLComponent createComponent() {
        return new ClientNormalSQLComponent(this);
    }

    @Override
    protected String createCode() {
        return "customerrelationship.customer";
    }
}

