/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.text.DateProp;
import org.openconcerto.utils.text.DateTimeFormat;
import org.openconcerto.utils.text.DateTimeFormatComponent;
import org.openconcerto.utils.text.DateTimeSkeleton;

public final class DateTimeFormatBuilder {
    private final List<DateTimeFormatComponent> components;
    private boolean onlyDateProp = true;

    public static final DateTimeFormat build(Object ... components) {
        DateTimeFormatBuilder res = new DateTimeFormatBuilder(components.length);
        Object[] objectArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof DateTimeFormatComponent) {
                res.add((DateTimeFormatComponent)o);
            } else {
                res.addLiteral(o.toString());
            }
            ++n2;
        }
        return res.build();
    }

    public static final DateTimeSkeleton buildSkeleton(DateProp ... components) {
        return new DateTimeSkeleton(CollectionUtils.toImmutableList(components));
    }

    public DateTimeFormatBuilder() {
        this(8);
    }

    public DateTimeFormatBuilder(int initialCapacity) {
        this.components = new ArrayList<DateTimeFormatComponent>(initialCapacity);
    }

    public final boolean isEmpty() {
        return this.components.isEmpty();
    }

    public final void clear() {
        this.components.clear();
        this.onlyDateProp = true;
    }

    public final DateTimeFormatBuilder add(DateTimeFormatComponent comp) {
        this.components.add(comp);
        return this;
    }

    public final DateTimeFormatBuilder addLiteral(String s) {
        this.components.add(new DateTimeFormat.Literal(s));
        this.onlyDateProp = false;
        return this;
    }

    public final DateTimeFormat build() {
        return new DateTimeFormat(this.components);
    }

    public final DateTimeSkeleton buildSkeleton() {
        if (!this.onlyDateProp) {
            throw new IllegalStateException("Not only DateProp");
        }
        return new DateTimeSkeleton(Collections.unmodifiableList(CollectionUtils.castList(Objects.requireNonNull(this.components), DateProp.class)));
    }
}

