/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.grid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openconcerto.ui.VFlowLayout;
import org.openconcerto.ui.grid.GridItem;
import org.openconcerto.ui.grid.GridListener;
import org.openconcerto.ui.grid.GridPanel;
import org.openconcerto.ui.grid.ScrollablePanel;
import org.openconcerto.ui.grid.TwoYearsHeaderPanel;

public class DecoratedGridPanel
extends JPanel {
    private GridPanel grid;
    final JScrollPane scroll;

    public DecoratedGridPanel(JComponent header, int columnCount, int rowHeight, List<JComponent> rowHeader) {
        this.setBackground(Color.WHITE);
        this.setLayout(new GridBagLayout());
        JPanel topLeft = new JPanel();
        topLeft.setMinimumSize(new Dimension(0, 0));
        this.grid = new GridPanel(columnCount, rowHeader.size(), rowHeight);
        header.setPreferredSize(new Dimension(this.grid.getPreferredSize().width, header.getMinimumSize().height));
        header.setMaximumSize(new Dimension(this.grid.getPreferredSize().width, header.getMinimumSize().height));
        header.setMinimumSize(new Dimension(this.grid.getPreferredSize().width, header.getMinimumSize().height));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.fill = 1;
        this.add((Component)topLeft, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)header, c);
        ++c.gridx;
        c.weightx = 0.0;
        JPanel spacerScroll = new JPanel();
        Object width = UIManager.get("ScrollBar.width");
        if (width == null) {
            width = 20;
        }
        int wScroll = (Integer)width;
        spacerScroll.setMinimumSize(new Dimension(wScroll, header.getHeight()));
        spacerScroll.setPreferredSize(new Dimension(wScroll, header.getHeight()));
        spacerScroll.setMaximumSize(new Dimension(wScroll, header.getHeight()));
        spacerScroll.setSize(new Dimension(wScroll, header.getHeight()));
        this.add((Component)spacerScroll, c);
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        ++c.gridy;
        ScrollablePanel panel = new ScrollablePanel(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return false;
            }
        };
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = 0;
        c2.gridy = 0;
        c2.weightx = 1.0;
        c2.anchor = 11;
        c2.fill = 1;
        panel.add(this.createLeft(rowHeader, this.grid.getCellHeight()), c2);
        ++c2.gridx;
        c2.weightx = 0.0;
        c2.weighty = 1.0;
        panel.add((Component)this.grid, c2);
        this.scroll = new JScrollPane(panel);
        this.scroll.setVerticalScrollBarPolicy(22);
        this.scroll.setBorder(null);
        this.add((Component)this.scroll, c);
    }

    public int getYScrollLocation() {
        return this.scroll.getVerticalScrollBar().getValue();
    }

    public void setYScrollLocation(int location) {
        this.scroll.getVerticalScrollBar().setValue(location);
    }

    private Component createLeft(List<JComponent> rowHeader, int h) {
        JPanel p = new JPanel();
        p.setLayout(new VFlowLayout(0, 1, 1, true));
        for (JComponent c : rowHeader) {
            c.setMinimumSize(new Dimension(c.getMinimumSize().width, h));
            c.setPreferredSize(new Dimension(c.getPreferredSize().width, h));
            p.add(c);
        }
        return p;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                    // empty catch block
                }
                JFrame f = new JFrame();
                f.setDefaultCloseOperation(3);
                TwoYearsHeaderPanel b = new TwoYearsHeaderPanel(2018);
                ArrayList<JComponent> panels = new ArrayList<JComponent>();
                int i = 0;
                while (i < 5) {
                    panels.add(new JButton("line " + i));
                    ++i;
                }
                DecoratedGridPanel contentPane = new DecoratedGridPanel(b, 24, 40, panels);
                contentPane.add(new GridItem(0, 0, 1, 1));
                contentPane.add(new GridItem(4, 0, 3, 1));
                contentPane.add(new GridItem(1, 1, 2, 1));
                f.setContentPane(contentPane);
                f.pack();
                f.setLocationRelativeTo(null);
                f.setVisible(true);
            }
        });
    }

    public void add(GridItem gridItem) {
        this.grid.add(gridItem);
    }

    public void setEnableEditMode(boolean enable) {
        this.grid.setEnableEditMode(enable);
    }

    public void setGridListener(GridListener gridListener) {
        this.grid.setGridListener(gridListener);
    }
}

