/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.ChangeTable;
import org.openconcerto.sql.utils.SQLCreateRoot;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.sql.utils.SQL_URL;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.LogUtils;
import org.openconcerto.utils.PropertiesUtils;
import org.openconcerto.utils.SetMap;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cc.IClosure;

public class Copy {
    private static final String STRUCT_EXT = ".sql";
    private static final DateFormat DATE_FMT = new SimpleDateFormat("yyyy MM dd HH.mm.ss");
    public static final String ROOTS_TO_MAP = "rootsToMap";
    private static final String NO_STRUCT = "noStruct";
    private static final String NO_DATA = "noData";
    public static final String DELETE_TABLE = "deleteTable";
    public static final String NAME_TO_STORE = "nameToStore";
    private static final String ROOT_CREATION_MODE = "rootCreationMode";
    private static final String FILE_MODE = "fileMode";
    private static final int CURRENT_VERSION = 2;
    private static final String PROPS_NAME = "dump.properties";
    private static final String VERSION_KEY = "version";
    private static final String CREATED_KEY = "created";
    private static final String MODIFIED_KEY = "modified";
    private final boolean store;
    private final boolean noStruct;
    private final boolean noData;
    private final File dir;
    private final FileExistsMode mode;
    private final DBSystemRoot sysRoot;

    private static final synchronized String format(Date d) {
        return DATE_FMT.format(d);
    }

    private static boolean isEmpty(String name) {
        return StringUtils.isEmpty(name, true);
    }

    private static <T extends Enum<T>> T getEnum(String propName, Class<T> enumType, T defaultVal) {
        assert (enumType == defaultVal.getClass());
        String propValue = System.getProperty(propName);
        if (Copy.isEmpty(propValue)) {
            return defaultVal;
        }
        return Enum.valueOf(enumType, propValue.toUpperCase());
    }

    private static Set<String> getFiles(File dir, String ext) {
        File[] files = dir.listFiles(FileUtils.createEndFileFilter(ext));
        if (files == null) {
            return null;
        }
        HashSet<String> res = new HashSet<String>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            res.add(f.getName().substring(0, f.getName().length() - ext.length()));
            ++n2;
        }
        return res;
    }

    private static void usage() {
        System.out.println("Usage: " + Copy.class.getName() + " [ -store | -load ] directory url [root,... [table,...]]");
        System.out.println("Dump or restore roots or tables from/to url to/from files.");
        System.out.println("The roots and tables are specified as comma separated lists.If there's only one it can be specified in the URL. If no roots are specified then use all available ones, i.e. store every visible (limited by rootsToMap) root in the database and load every root directory of the dump If no tables are specified then use all available ones, i.e. store every existing tables of each dumped root and load every table file in each root directory of the dump");
        System.out.println("System properties:");
        System.out.println("\trootsToMap = comma separated list of roots to map in addition to the ones dumped/restored. Only needed when dumping/restoring roots that reference roots not being dumped/restored.");
        System.out.println("\tnoStruct = true to avoid dumping/restoring the structure");
        System.out.println("\tnoData = true to avoid dumping/restoring the data");
        System.out.println("\tdeleteTable = (only for loading) true to empty tables before loading data");
        System.out.println("\trootCreationMode = (only for loading) existing root check : " + Arrays.asList(CreationMode.values()));
        System.out.println("\tfileMode = (only for storing) existing dump handling : " + Arrays.asList(FileExistsMode.values()));
        System.out.println("\tnameToStore = (only for storing one root) root name to use when storing, e.g. allow to copy one root to another");
    }

    static Tuple3<SQL_URL, Map<String, String>, Set<String>> parseNames(String[] args, int offset) throws SQLException, IOException, URISyntaxException {
        int tablesIndex;
        int rootsIndex;
        int urlIndex = offset;
        SQL_URL url = SQL_URL.create(args[urlIndex]);
        if (url.getTableName() != null) {
            assert (url.getRootName() != null);
            rootsIndex = urlIndex;
            tablesIndex = urlIndex;
        } else if (url.getRootName() != null) {
            rootsIndex = urlIndex;
            tablesIndex = urlIndex + 1;
        } else {
            rootsIndex = urlIndex + 1;
            tablesIndex = rootsIndex + 1;
        }
        if (args.length > tablesIndex + 1) {
            throw new IllegalArgumentException("Too many parameters");
        }
        List<String> roots = url.getRootName() != null ? Collections.singletonList(url.getRootName()) : (rootsIndex < args.length ? SQLRow.toList(args[rootsIndex]) : null);
        Map<String, Object> rootNames = roots == null ? null : (roots.size() == 1 ? Collections.singletonMap(roots.get(0), System.getProperty(NAME_TO_STORE)) : CollectionUtils.createMap(roots));
        Set<String> tables = url.getTableName() != null ? Collections.singleton(url.getTableName()) : (tablesIndex < args.length ? new HashSet<String>(SQLRow.toList(args[tablesIndex])) : null);
        return Tuple3.create(url, rootNames, tables);
    }

    public static void main(String[] args) throws SQLException, IOException, URISyntaxException {
        boolean store;
        if (args.length < 3) {
            Copy.usage();
            System.exit(1);
        }
        if (args[0].equals("-store")) {
            store = true;
        } else if (args[0].equals("-load")) {
            store = false;
        } else {
            throw new IllegalArgumentException("-store or -load");
        }
        File dir = new File(args[1]);
        Tuple3<SQL_URL, Map<String, String>, Set<String>> names = Copy.parseNames(args, 2);
        CreationMode rootCreationMode = Copy.getEnum(ROOT_CREATION_MODE, CreationMode.class, CreationMode.REQUIRED);
        FileExistsMode existingDumpMode = Copy.getEnum(FILE_MODE, FileExistsMode.class, FileExistsMode.RENAME);
        LogUtils.rmRootHandlers();
        LogUtils.setUpConsoleHandler();
        Log.get().setLevel(Level.INFO);
        System.setProperty("org.openconcerto.sql.identifier.allowRemoval", "true");
        System.setProperty("org.openconcerto.sql.noautoCreateMetadata", "true");
        DBSystemRoot sysRoot = SQLServer.create((SQL_URL)names.get0(), SQLRow.toList(System.getProperty(ROOTS_TO_MAP, "")), true, new IClosure<SQLDataSource>(){

            @Override
            public void executeChecked(SQLDataSource input) {
                input.addConnectionProperty("allowMultiQueries", "true");
            }
        });
        try {
            new Copy(store, dir, existingDumpMode, sysRoot, Boolean.getBoolean(NO_STRUCT), Boolean.getBoolean(NO_DATA)).applyTo(rootCreationMode, (Map)names.get1(), names.get2());
        }
        finally {
            sysRoot.getServer().destroy();
        }
    }

    public Copy(boolean store, File dir, DBSystemRoot base, boolean noStruct, boolean noData) throws SQLException, IOException {
        this(store, dir, FileExistsMode.RENAME, base, noStruct, noData);
    }

    public Copy(boolean store, File dir, FileExistsMode mode, DBSystemRoot base, boolean noStruct, boolean noData) throws SQLException, IOException {
        this.store = store;
        this.noStruct = noStruct;
        this.noData = noData;
        this.dir = dir;
        this.mode = mode;
        this.sysRoot = base;
    }

    public final void applyTo(String rootName, String tableName) throws SQLException, IOException {
        this.applyTo(rootName, rootName, tableName);
    }

    public final File applyTo(String rootName, String newRootName, String tableName) throws SQLException, IOException {
        if (rootName == null) {
            throw new NullPointerException("Null root name");
        }
        return this.applyTo(CreationMode.ALLOWED, Collections.singletonMap(rootName, newRootName), tableName == null ? null : Collections.singleton(tableName));
    }

    public final File applyTo(final CreationMode rootCreationMode, Map<String, String> rootNames, final Set<String> tableNames) throws SQLException, IOException {
        Map resolvedRoots;
        File previousDump = null;
        if (this.store && this.dir.exists()) {
            if (this.mode == FileExistsMode.FAIL) {
                throw new IllegalStateException("Dump exists at " + this.dir);
            }
            if (this.mode == FileExistsMode.RENAME) {
                previousDump = FileUtils.addSuffix(this.dir, String.valueOf('_') + Copy.format(new Date()));
                if (!this.dir.renameTo(previousDump)) {
                    throw new IOException("could not rename " + this.dir + " to " + previousDump);
                }
            } else if (this.mode == FileExistsMode.DELETE) {
                FileUtils.rm_R(this.dir);
            } else {
                assert (this.mode == FileExistsMode.OVERWRITE);
                previousDump = this.dir;
            }
        }
        if (!this.sysRoot.isMappingAllRoots()) {
            if (rootNames == null && this.store) {
                this.sysRoot.mapAllRoots();
                this.sysRoot.reload();
            } else {
                Set<String> roots;
                if (rootNames == null) {
                    assert (!this.store);
                    roots = this.getRoots();
                } else {
                    roots = rootNames.keySet();
                }
                this.sysRoot.reload(this.sysRoot.addRootsToMap(roots));
            }
        }
        Set<String> resolvedRootNames = this.store ? this.resolveNames(this.sysRoot.getName(), rootNames == null ? null : rootNames.keySet(), this.sysRoot.getChildrenNames()) : this.resolveNames(this.dir.getName(), rootNames == null ? null : rootNames.keySet(), this.getRoots());
        if (rootNames == null) {
            resolvedRoots = CollectionUtils.createMap(resolvedRootNames);
        } else {
            resolvedRoots = new LinkedHashMap<String, String>(rootNames);
            resolvedRoots.keySet().retainAll(resolvedRootNames);
        }
        SQLUtils.executeAtomic(this.sysRoot.getDataSource(), new ConnectionHandlerNoSetup<Object, IOException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException, IOException {
                Copy.this.applyToP(rootCreationMode, resolvedRoots, tableNames);
                return null;
            }
        });
        return previousDump;
    }

    private void applyToP(CreationMode rootCreationMode, final Map<String, String> rootNames, Set<String> tableNames) throws IOException, SQLException {
        boolean dumpExists = this.dir.exists();
        File propsFile = new File(this.dir, PROPS_NAME);
        Properties dumpProps = propsFile.exists() ? PropertiesUtils.createFromFile(propsFile) : new Properties();
        Integer storedVersion = dumpExists ? Integer.valueOf(Integer.parseInt(dumpProps.getProperty(VERSION_KEY, "1"))) : null;
        SQLSyntax syntax = this.sysRoot.getSyntax();
        if (this.store) {
            if (dumpExists) {
                assert (storedVersion != null);
                if (storedVersion != 2) {
                    throw new IllegalStateException("Cannot modify dump version " + storedVersion + " with current version " + 2);
                }
            } else {
                dumpProps.setProperty(VERSION_KEY, String.valueOf(2));
            }
            Date now = new Date();
            if (dumpProps.getProperty(CREATED_KEY) == null) {
                if (dumpExists) {
                    System.err.println("Missing created key on existing dump");
                }
                dumpProps.setProperty(CREATED_KEY, Copy.format(now));
            }
            dumpProps.setProperty(MODIFIED_KEY, Copy.format(now));
            FileUtils.mkdir_p(this.dir);
            try (FileOutputStream out = new FileOutputStream(propsFile);){
                dumpProps.store(out, "");
            }
            ChangeTable.NameTransformer nameTransformer = new ChangeTable.NameTransformer(){

                @Override
                public SQLName transformTableName(SQLName tableName) {
                    if (tableName.getItemCount() != 2) {
                        throw new IllegalArgumentException("Not 2 items : " + tableName);
                    }
                    String translatedName = (String)rootNames.get(tableName.getItem(0));
                    if (Copy.isEmpty(translatedName)) {
                        return tableName;
                    }
                    return new SQLName(translatedName, tableName.getItem(1));
                }
            };
            for (Map.Entry<String, String> e : rootNames.entrySet()) {
                String newRootName;
                String dbName = e.getKey();
                String string = newRootName = Copy.isEmpty(e.getValue()) ? dbName : e.getValue();
                if (!this.sysRoot.contains(dbName)) {
                    throw new IllegalArgumentException(String.valueOf(dbName) + " does not exist in " + this.sysRoot);
                }
                DBRoot r = this.sysRoot.getRoot(dbName);
                Set<String> resolvedTables = this.resolveNames(r.getName(), tableNames, r.getChildrenNames());
                File rootDir = this.getDir(newRootName);
                if (!this.noStruct) {
                    String newName = newRootName.equals(dbName) ? "" : " -> " + newRootName;
                    System.err.print("Structure of " + dbName + newName + "." + resolvedTables + " ... ");
                    SQLSystem[] sQLSystemArray = SQLSystem.values();
                    int n = sQLSystemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SQLSystem sys = sQLSystemArray[n2];
                        SQLSyntax targetSyntax = sys.getSyntax();
                        if (targetSyntax != null) {
                            File rootFile = this.getRootFile(newRootName, sys, true);
                            FileUtils.mkParentDirs(rootFile);
                            FileUtils.write(r.getDefinitionSQL(targetSyntax, false).asString(newRootName, false, true), rootFile);
                            File createDir = this.getTableDir(newRootName, sys, true);
                            File alterDir = this.getTableDir(newRootName, sys, false);
                            FileUtils.mkdir_p(createDir);
                            FileUtils.mkdir_p(alterDir);
                            for (String tableName : resolvedTables) {
                                SQLTable t = r.getTable(tableName);
                                Tuple2.List2<String> createTable = t.getCreateTable(targetSyntax).getCreateAndAlter(nameTransformer);
                                if (Copy.isEmpty((String)createTable.get0())) {
                                    throw new IllegalStateException("Empty CREATE for " + t.getSQLName());
                                }
                                FileUtils.write((String)createTable.get0(), this.getTableFile(createDir, tableName));
                                if (Copy.isEmpty((String)createTable.get1())) continue;
                                FileUtils.write((String)createTable.get1(), this.getTableFile(alterDir, tableName));
                            }
                        }
                        ++n2;
                    }
                    System.err.println("done");
                }
                if (this.noData) continue;
                System.err.println("Data of " + resolvedTables + " ... ");
                syntax.storeData(r, resolvedTables, rootDir);
                System.err.println("Data done");
            }
        } else if (storedVersion == 1) {
            for (String rootName : rootNames.keySet()) {
                if (tableNames == null) {
                    this.loadV1(rootName, null);
                    continue;
                }
                for (String t : tableNames) {
                    this.loadV1(rootName, t);
                }
            }
        } else {
            Set<String> existingRoots = this.sysRoot.getChildrenNames();
            if (rootCreationMode == CreationMode.FORBIDDEN) {
                if (!existingRoots.containsAll(rootNames.keySet())) {
                    throw new IllegalStateException("Some roots are missing");
                }
            } else if (rootCreationMode == CreationMode.REQUIRED && !Collections.disjoint(existingRoots, rootNames.keySet())) {
                throw new IllegalStateException("Some roots are already created");
            }
            SQLSystem system = this.sysRoot.getServer().getSQLSystem();
            SetMap resolvedTablesByRoot = new SetMap();
            for (String rootName : rootNames.keySet()) {
                DBRoot r;
                Set<String> availableStruct;
                Set<String> availableData = this.noData ? null : this.getTablesData(rootName);
                Set<String> set = availableStruct = this.noStruct ? null : this.getTablesStruct(rootName, system);
                Set<String> availableTables = availableData == null ? availableStruct : (availableStruct == null ? availableData : CollectionUtils.union(availableData, availableStruct));
                Set<String> resolvedTables = this.resolveNames(rootName, tableNames, availableTables);
                if (availableData != null && availableStruct != null) {
                    if (!availableStruct.containsAll(resolvedTables)) {
                        throw new IllegalStateException("Structure missing for " + CollectionUtils.substract(resolvedTables, availableStruct));
                    }
                    if (!availableData.containsAll(resolvedTables)) {
                        throw new IllegalStateException("Data missing for " + CollectionUtils.substract(resolvedTables, availableData));
                    }
                }
                resolvedTablesByRoot.put(rootName, resolvedTables);
                DBRoot dBRoot = r = existingRoots.contains(rootName) ? this.sysRoot.getRoot(rootName) : null;
                if (!this.noStruct) {
                    if (r == null) {
                        System.err.print("Creation of " + rootName + " ... ");
                        String sql = FileUtils.readUTF8(this.getRootFile(rootName, system, true));
                        if (system == SQLSystem.MSSQL) {
                            SQLUtils.executeScript(sql, this.sysRoot);
                        } else {
                            this.sysRoot.getDataSource().execute(sql);
                        }
                        System.err.println("done");
                    }
                    System.err.print("Creation of " + resolvedTables + " ... ");
                    File createDir = this.getTableDir(rootName, system, true);
                    for (String tableName : resolvedTables) {
                        String tableSQL = FileUtils.readUTF8(this.getTableFile(createDir, tableName));
                        this.sysRoot.getDataSource().execute(tableSQL);
                    }
                    System.err.println("done");
                    this.sysRoot.refetch(Collections.singleton(rootName));
                    r = this.sysRoot.getRoot(rootName);
                }
                if (this.noData) continue;
                System.err.println("Data of " + rootName + " ... ");
                syntax.loadData(this.getDir(rootName), r, resolvedTables, Boolean.getBoolean(DELETE_TABLE), this.noStruct);
                System.err.println("Data done");
            }
            if (!this.noStruct) {
                for (String rootName : rootNames.keySet()) {
                    Set resolvedTables = (Set)resolvedTablesByRoot.get(rootName);
                    System.err.println("Constraints of " + rootName + "." + resolvedTables + " ... ");
                    File alterDir = this.getTableDir(rootName, system, false);
                    for (String tableName : resolvedTables) {
                        File alterFile = this.getTableFile(alterDir, tableName);
                        if (!alterFile.exists()) continue;
                        this.sysRoot.getDataSource().execute(FileUtils.readUTF8(alterFile));
                    }
                    System.err.println("Constraints done");
                    File rootFile = this.getRootFile(rootName, system, false);
                    if (!rootFile.exists()) continue;
                    this.sysRoot.getDataSource().execute(FileUtils.readUTF8(rootFile));
                }
                this.sysRoot.refetch(rootNames.keySet());
            }
        }
    }

    private void loadV1(String rootName, String tableName) throws IOException, SQLException {
        DBRoot r;
        DBRoot dBRoot = r = this.sysRoot.contains(rootName) ? this.sysRoot.getRoot(rootName) : null;
        if (!this.noStruct) {
            System.err.print("Structure of " + rootName + " ... ");
            SQLSystem system = this.sysRoot.getServer().getSQLSystem();
            String sql = FileUtils.readUTF8(this.getSQLFile(rootName, tableName, system));
            if (r == null && tableName != null) {
                sql = String.valueOf(new SQLCreateRoot(SQLSyntax.get(this.sysRoot), rootName).asString()) + ";\n" + sql;
            }
            if (system == SQLSystem.MSSQL) {
                SQLUtils.executeScript(sql, this.sysRoot);
            } else {
                this.sysRoot.getDataSource().execute(sql);
            }
            this.sysRoot.refetch(Collections.singleton(rootName));
            r = this.sysRoot.getRoot(rootName);
            System.err.println("done");
        }
        if (!this.noData) {
            System.err.println("Data of " + rootName + " ... ");
            SQLSyntax syntax = this.sysRoot.getServer().getSQLSystem().getSyntax();
            Set<String> tableNames = tableName == null ? null : Collections.singleton(tableName);
            syntax.loadData(this.getDir(rootName), r, tableNames, Boolean.getBoolean(DELETE_TABLE));
            System.err.println("Data done");
        }
    }

    private Set<String> resolveNames(String parentName, Set<String> wantedNames, Set<String> availableNames) {
        return this.resolveNames(parentName, wantedNames, availableNames, this.store);
    }

    private Set<String> resolveNames(String parentName, Set<String> wantedNames, Set<String> availableNames, boolean throwExn) {
        Set<String> res;
        if (wantedNames != null) {
            HashSet<String> missing = new HashSet<String>(wantedNames);
            missing.removeAll(availableNames);
            if (missing.size() > 0) {
                if (throwExn) {
                    throw new IllegalStateException("Not found in " + parentName + " : " + missing);
                }
                System.err.println("In " + parentName + " ignoring " + missing);
            }
            res = new HashSet<String>(availableNames);
            res.retainAll(wantedNames);
        } else {
            res = availableNames;
        }
        return res;
    }

    private Set<String> getRoots() {
        File[] dirs = this.dir.listFiles(FileUtils.DIR_FILTER);
        if (dirs == null) {
            throw new IllegalStateException("No directory at : " + this.dir);
        }
        HashSet<String> res = new HashSet<String>();
        File[] fileArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            res.add(FileUtils.FILENAME_ESCAPER.unescape(dir.getName()));
            ++n2;
        }
        return res;
    }

    private File getDir(String rootName) {
        return new File(this.dir, FileUtils.FILENAME_ESCAPER.escape(rootName));
    }

    private Set<String> getTablesData(String rootName) {
        Set<String> tables = Copy.getFiles(this.getDir(rootName), ".txt");
        if (tables == null) {
            throw new IllegalStateException("No table data files in " + rootName);
        }
        return tables;
    }

    private Set<String> getTablesStruct(String rootName, SQLSystem system) {
        Set<String> tables = Copy.getFiles(this.getTableDir(rootName, system, true), STRUCT_EXT);
        if (tables == null) {
            throw new IllegalStateException("No table structure files in " + rootName);
        }
        return tables;
    }

    private File getSQLFile(String rootName, String tableName, SQLSystem system) {
        String t = tableName == null ? "" : String.valueOf(tableName) + "-";
        return new File(this.getDir(rootName), String.valueOf(t) + system.name().toLowerCase() + STRUCT_EXT);
    }

    private File getRootDir(String rootName, SQLSystem system) {
        return new File(this.getDir(rootName), system.name().toLowerCase());
    }

    private File getRootFile(String rootName, SQLSystem system, boolean pre) {
        return new File(this.getRootDir(rootName, system), pre ? "pre.sql" : "post.sql");
    }

    private File getTableDir(String rootName, SQLSystem system, boolean create) {
        return new File(this.getRootDir(rootName, system), create ? "tables-create" : "tables-alter");
    }

    private File getTableFile(File tableDir, String tableName) {
        return new File(tableDir, String.valueOf(FileUtils.FILENAME_ESCAPER.escape(tableName)) + STRUCT_EXT);
    }

    public static enum CreationMode {
        REQUIRED,
        ALLOWED,
        FORBIDDEN;

    }

    public static enum FileExistsMode {
        FAIL,
        RENAME,
        DELETE,
        OVERWRITE;

    }
}

