/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class ResteALivrerDocProvider
implements SpreadSheetCellValueProvider {
    protected final ResteProvider type;

    public ResteALivrerDocProvider(ResteProvider t) {
        this.type = t;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor sqlRowAccessor = context.getRow();
        return this.geTotalFromRow(sqlRowAccessor);
    }

    protected BigDecimal geTotalFromRow(SQLRowAccessor sqlRowAccessor) {
        BigDecimal total = sqlRowAccessor.getBigDecimal("QTE_UNITAIRE");
        total = total.multiply(new BigDecimal(sqlRowAccessor.getInt("QTE")));
        if (this.type == ResteProvider.RESTE_CMD || this.type == ResteProvider.LIVRE_TOTAL_CMD) {
            BigDecimal totalD = new BigDecimal(sqlRowAccessor.getInt("QTE_LIVREE"));
            if (this.type == ResteProvider.RESTE_CMD) {
                return total.subtract(totalD);
            }
            return totalD;
        }
        SQLRowAccessor nonEmptyForeignCmdItem = sqlRowAccessor.getNonEmptyForeign("ID_COMMANDE_CLIENT_ELEMENT");
        if (nonEmptyForeignCmdItem == null) {
            BigDecimal totalD = sqlRowAccessor.getBigDecimal("QTE_UNITAIRE");
            totalD = totalD.multiply(new BigDecimal(sqlRowAccessor.getInt("QTE_LIVREE")));
            return total.subtract(totalD);
        }
        BigDecimal totalD = nonEmptyForeignCmdItem.getBigDecimal("QTE_LIVREE");
        if (this.type == ResteProvider.LIVRE_TOTAL) {
            if (totalD.signum() > 0) {
                return totalD;
            }
            return null;
        }
        BigDecimal r = total.subtract(totalD);
        if (r.signum() > 0) {
            return r;
        }
        return null;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.qty.delivred.total", new ResteALivrerDocProvider(ResteProvider.LIVRE_TOTAL));
        SpreadSheetCellValueProviderManager.put("sales.qty.delivred.remained", new ResteALivrerDocProvider(ResteProvider.RESTE));
        SpreadSheetCellValueProviderManager.put("sales.qty.cmd.delivred.total", new ResteALivrerDocProvider(ResteProvider.LIVRE_TOTAL_CMD));
        SpreadSheetCellValueProviderManager.put("sales.qty.cmd.delivred.remained", new ResteALivrerDocProvider(ResteProvider.RESTE_CMD));
    }

    protected static enum ResteProvider {
        RESTE,
        LIVRE_TOTAL,
        RESTE_CMD,
        LIVRE_TOTAL_CMD;

    }
}

