/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import org.openconcerto.erp.core.common.ui.NumericFormat;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class FormatedGlobalQtyTotalProvider
implements SpreadSheetCellValueProvider {
    private final boolean shortName;
    private final boolean alwaysShowOnZeroQty;
    private final boolean pieceName;
    public final Type type;
    private final BigDecimal cent = new BigDecimal(100);

    private FormatedGlobalQtyTotalProvider(Type t, boolean shortName) {
        this(t, shortName, false, false);
    }

    private FormatedGlobalQtyTotalProvider(Type t, boolean shortName, boolean alwaysShowOnZeroQty, boolean withPieceName) {
        this.shortName = shortName;
        this.type = t;
        this.alwaysShowOnZeroQty = alwaysShowOnZeroQty;
        this.pieceName = withPieceName;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        String field;
        SQLRowAccessor row = context.getRow();
        BigDecimal pv = row.getBigDecimal("PV_HT");
        BigDecimal pR = row.getBigDecimal("POURCENT_REMISE");
        if (!(this.alwaysShowOnZeroQty || pv == null || pv.compareTo(BigDecimal.ZERO) != 0 || pR != null && pR.compareTo(this.cent) == 0)) {
            return null;
        }
        if (this.type == Type.NORMAL) {
            field = "QTE";
        } else if (row.getTable().contains("QTE_LIVREE")) {
            field = "QTE_LIVREE";
        } else if (row.getTable().contains("QTE_ORIGINE")) {
            field = "QTE_ORIGINE";
        } else {
            return null;
        }
        if (row.getObject(field) == null) {
            return null;
        }
        int qte = row.getInt(field);
        if (this.type == Type.REMAIND && row.getObject("QTE") != null) {
            qte = field.equalsIgnoreCase("QTE_ORIGINE") ? (qte -= row.getInt("QTE")) : row.getInt("QTE") - qte;
        }
        if (!this.pieceName && row.getInt("ID_UNITE_VENTE") == 2) {
            return String.valueOf(qte);
        }
        String result = "";
        if (this.alwaysShowOnZeroQty || qte != 0) {
            result = String.valueOf(result) + qte + " x ";
            BigDecimal qteUV = row.getBigDecimal("QTE_UNITAIRE");
            result = String.valueOf(result) + NumericFormat.getQtyDecimalFormat().format(qteUV);
            SQLRowAccessor rMode = row.getForeign("ID_UNITE_VENTE");
            result = String.valueOf(result) + " " + (this.shortName ? rMode.getString("CODE") : rMode.getString("NOM"));
        }
        return result;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.short.with.quantity", new FormatedGlobalQtyTotalProvider(Type.NORMAL, true, true, false));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.short", new FormatedGlobalQtyTotalProvider(Type.NORMAL, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit", new FormatedGlobalQtyTotalProvider(Type.NORMAL, false));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.deliver.short", new FormatedGlobalQtyTotalProvider(Type.SHIPMENT, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.deliver", new FormatedGlobalQtyTotalProvider(Type.SHIPMENT, false));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.deliver.short.with.quantity", new FormatedGlobalQtyTotalProvider(Type.SHIPMENT, true, true, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.remainder.short", new FormatedGlobalQtyTotalProvider(Type.REMAIND, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.remainder", new FormatedGlobalQtyTotalProvider(Type.REMAIND, false));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.remainder.short.with.quantity", new FormatedGlobalQtyTotalProvider(Type.REMAIND, true, true, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.alwaysnamed.short.with.quantity", new FormatedGlobalQtyTotalProvider(Type.NORMAL, true, true, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.alwaysnamed.short", new FormatedGlobalQtyTotalProvider(Type.NORMAL, true, false, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.alwaysnamed", new FormatedGlobalQtyTotalProvider(Type.NORMAL, false, false, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.alwaysnamed.deliver.short", new FormatedGlobalQtyTotalProvider(Type.SHIPMENT, true, false, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.alwaysnamed.deliver", new FormatedGlobalQtyTotalProvider(Type.SHIPMENT, false, false, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.alwaysnamed.remainder.short", new FormatedGlobalQtyTotalProvider(Type.REMAIND, true, false, true));
        SpreadSheetCellValueProviderManager.put("supplychain.element.qtyunit.alwaysnamed.remainder", new FormatedGlobalQtyTotalProvider(Type.REMAIND, false, false, true));
    }

    public static enum Type {
        NORMAL,
        SHIPMENT,
        REMAIND;

    }
}

