/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.receipt.ui;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.StringUtils;

public class LotReceptionTableModel
extends AbstractTableModel {
    private final List<SQLRowValues> dataRowVals = new ArrayList<SQLRowValues>();
    private final List<SQLField> fields = new ArrayList<SQLField>();
    private final SQLElement eltLotReception;
    private final SQLRowValues rowRef;
    private final Set<Number> delivredIdLot = new HashSet<Number>();
    private final List<Class<?>> colClass = Arrays.asList(BigDecimal.class, String.class, Date.class, Date.class, String.class);
    private List<SQLRowAccessor> rmLines = new ArrayList<SQLRowAccessor>();

    public LotReceptionTableModel(SQLElement eltLotReception, SQLRowValues rowRef) {
        this.eltLotReception = eltLotReception;
        this.rowRef = rowRef;
        this.fields.add(eltLotReception.getTable().getField("QUANTITE"));
        this.fields.add(eltLotReception.getTable().getField("NUMERO_LOT"));
        this.fields.add(eltLotReception.getTable().getField("DLC"));
        this.fields.add(eltLotReception.getTable().getField("DLUO"));
        this.fields.add(eltLotReception.getTable().getField("NUMERO_SERIE"));
        this.load();
    }

    @Override
    public int getRowCount() {
        return this.dataRowVals.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    public void addLine() {
        this.dataRowVals.add(this.createDefaultRowValues());
        this.fireTableDataChanged();
    }

    private SQLRowValues createDefaultRowValues() {
        SQLRowValues r = new SQLRowValues(this.eltLotReception.getTable());
        r.put("QUANTITE", BigDecimal.ONE);
        r.put("NUMERO_SERIE", "");
        r.put("NUMERO_LOT", "");
        r.put("DLC", null);
        r.put("DLUO", null);
        r.put("ID_BON_RECEPTION_ELEMENT", (Object)this.rowRef);
        return r;
    }

    @Override
    public String getColumnName(int column) {
        return this.eltLotReception.getDirectory().getTranslator().getTitleFor(this.fields.get(column));
    }

    public void load() {
        this.delivredIdLot.clear();
        this.dataRowVals.clear();
        this.rmLines.clear();
        Collection referentRows = this.rowRef.getReferentRows(this.eltLotReception.getTable().getField("ID_BON_RECEPTION_ELEMENT"));
        HashSet<Number> idUsedLot = new HashSet<Number>();
        for (SQLRowValues sqlRowValues : referentRows) {
            Number nonEmptyForeignIDNumberLot;
            if (!sqlRowValues.contains("ARCHIVE") || !sqlRowValues.isArchived()) {
                this.dataRowVals.add(sqlRowValues);
            }
            if (!sqlRowValues.contains("ID_LOT") || (nonEmptyForeignIDNumberLot = sqlRowValues.getNonEmptyForeignIDNumber("ID_LOT")) == null) continue;
            idUsedLot.add(nonEmptyForeignIDNumberLot);
        }
        if (!idUsedLot.isEmpty()) {
            SQLTable lotTable = this.eltLotReception.getTable().getTable("LOT_LIVRAISON");
            SQLRowValues rowVals = new SQLRowValues(lotTable);
            rowVals.putNulls("ID_LOT");
            List<SQLRowValues> fetch = SQLRowValuesListFetcher.create(rowVals).fetch(Where.inValues(lotTable.getField("ID_LOT"), idUsedLot));
            for (SQLRowValues sqlRowValues : fetch) {
                this.delivredIdLot.add(sqlRowValues.getForeignIDNumber("ID_LOT"));
            }
        }
        if (this.dataRowVals.isEmpty()) {
            this.addLine();
        } else {
            this.fireTableDataChanged();
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        SQLRowValues sqlRowValues = this.dataRowVals.get(rowIndex);
        if (sqlRowValues.contains("ID_LOT") && sqlRowValues.getNonEmptyForeignIDNumber("ID_LOT") != null && this.delivredIdLot.contains(sqlRowValues.getNonEmptyForeignIDNumber("ID_LOT"))) {
            return false;
        }
        if (this.fields.indexOf(this.eltLotReception.getTable().getField("QUANTITE")) == columnIndex) {
            return sqlRowValues.getString("NUMERO_SERIE") == null || sqlRowValues.getString("NUMERO_SERIE").isEmpty();
        }
        return true;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.colClass.get(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.getRowCount()) {
            SQLRowValues sqlRowValues = this.dataRowVals.get(rowIndex);
            sqlRowValues.put(this.fields.get(columnIndex).getName(), aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
            if (!this.isEmptyVals(sqlRowValues) && !this.isEmptyVals(this.dataRowVals.get(this.dataRowVals.size() - 1))) {
                this.addLine();
            }
        }
    }

    private boolean isEmptyVals(SQLRowValues rowVals) {
        return rowVals.getDate("DLC") == null && rowVals.getDate("DLUO") == null && rowVals.getString("NUMERO_SERIE").trim().length() == 0 && rowVals.getString("NUMERO_LOT").trim().length() == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.dataRowVals.get(rowIndex).getObject(this.fields.get(columnIndex).getName());
    }

    public void removeLine(int selectedRow) {
        SQLRowValues remove = this.dataRowVals.remove(selectedRow);
        this.rmLines.add(remove);
        if (!remove.hasID()) {
            remove.putEmptyLink("ID_BON_RECEPTION_ELEMENT");
        } else {
            remove.put("ARCHIVE", 1);
        }
        if (this.getRowCount() == 0) {
            this.addLine();
        }
        this.fireTableDataChanged();
    }

    public void checkData() {
        ArrayList<SQLRowValues> emptyRowVals = new ArrayList<SQLRowValues>();
        int indexInDataRows = this.dataRowVals.size() - 1;
        while (indexInDataRows >= 0) {
            SQLRowValues rowVals = this.dataRowVals.get(indexInDataRows);
            this.trimValues(rowVals);
            String serial = rowVals.getString("NUMERO_SERIE");
            if (serial != null && serial.contains("\n")) {
                String value;
                List<String> fastSplit = StringUtils.fastSplitTrimmed(serial, '\n');
                int serialIndex = fastSplit.size() - 1;
                while (serialIndex > 0) {
                    String value2 = fastSplit.get(serialIndex);
                    if (value2 != null && value2.length() > 0) {
                        SQLRowValues createCopy = this.createDefaultRowValues();
                        createCopy.put("NUMERO_LOT", rowVals.getObject("NUMERO_LOT"));
                        createCopy.put("DLC", rowVals.getObject("DLC"));
                        createCopy.put("DLUO", rowVals.getObject("DLUO"));
                        createCopy.put("NUMERO_SERIE", value2);
                        this.dataRowVals.add(indexInDataRows, createCopy);
                    }
                    --serialIndex;
                }
                if (!fastSplit.isEmpty() && (value = fastSplit.get(0)) != null && value.trim().length() > 0) {
                    rowVals.put("NUMERO_SERIE", value);
                }
            }
            if (this.isEmptyVals(rowVals)) {
                emptyRowVals.add(rowVals);
            }
            --indexInDataRows;
        }
        for (SQLRowValues r : emptyRowVals) {
            if (r.hasID()) {
                this.rmLines.add(r);
                r.put("ARCHIVE", 1);
            } else {
                r.putEmptyLink("ID_BON_RECEPTION_ELEMENT");
            }
            this.dataRowVals.remove(r);
        }
    }

    private void trimValues(SQLRowValues rowVals) {
        rowVals.put("NUMERO_SERIE", rowVals.getString("NUMERO_SERIE").trim());
        rowVals.put("NUMERO_LOT", rowVals.getString("NUMERO_LOT").trim());
    }
}

