/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.employe.report;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.humanresources.employe.report.N4DS;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.StringUtils;

public class N4DSSalarie {
    private DateFormat format = new SimpleDateFormat("ddMMyyyy");
    private ComptaPropsConfiguration conf = (ComptaPropsConfiguration)Configuration.getInstance();
    private N4DS n4ds;
    Date d = new Date(117, 0, 1);
    Date d2 = new Date(117, 11, 31);
    DecimalFormat decimalFormat = new DecimalFormat("0.00");
    DateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");

    public N4DSSalarie(N4DS n4ds) {
        this.n4ds = n4ds;
        DecimalFormatSymbols symbol = new DecimalFormatSymbols();
        symbol.setDecimalSeparator('.');
        this.decimalFormat.setDecimalFormatSymbols(symbol);
    }

    public void write(SQLRow row, SQLRow rowSociete) throws IOException {
        this.writeS30(row);
        this.writeS41(row, rowSociete);
        this.writeS44(row);
        this.writeS45(row);
        this.writeS48(row);
    }

    private void writeS45(SQLRow rowSalarie) throws IOException {
        SQLRow rowInfos = rowSalarie.getForeignRow("ID_INFOS_SALARIE_PAYE");
        SQLRow rowEtatCivil = rowSalarie.getForeignRow("ID_ETAT_CIVIL");
        SQLRow siutationFam = rowEtatCivil.getForeign("ID_SITUATION_FAMILIALE");
        Calendar dateArrivee = rowInfos.getDate("DATE_ARRIVE");
        this.n4ds.write("S45.G01.00.001.001", this.dateFormat.format(dateArrivee.getTime()));
        this.n4ds.write("S45.G01.00.002", "0" + (siutationFam.getID() - 1));
        this.n4ds.write("S45.G01.00.006", rowEtatCivil.getString("NB_ENFANTS"));
        this.n4ds.write("S45.G01.05.001.001", "01");
        this.n4ds.write("S45.G01.05.001.002", "02");
        int monthArrive = dateArrivee.get(2);
        int yearArrive = dateArrivee.get(1);
        int month = this.d2.getMonth();
        int year = this.d2.getYear() + 1900;
        int diff = month > monthArrive ? (year - yearArrive) * 12 + month - monthArrive : (year - yearArrive - 1) * 12 + month + (12 - monthArrive);
        this.n4ds.write("S45.G01.05.002", String.valueOf(diff));
        SQLRow rowContrat = rowInfos.getForeignRow("ID_CONTRAT_SALARIE");
        if (rowContrat.getString("CODE_IRC_RETRAITE") != null && rowContrat.getString("CODE_IRC_RETRAITE").trim().length() > 0) {
            this.n4ds.write("S45.G05.00.001", rowContrat.getString("NUMERO_RATTACHEMENT_RETRAITE"));
            this.n4ds.write("S45.G05.00.005", rowContrat.getString("CODE_IRC_RETRAITE"));
        }
        this.n4ds.write("S45.G05.10.001", this.dateFormat.format(this.d));
        this.n4ds.write("S45.G05.10.002", this.dateFormat.format(this.d2));
        double baseBrute = this.getBaseBrute(rowSalarie);
        this.n4ds.write("S45.G05.15.001.001", this.decimalFormat.format(baseBrute));
        this.n4ds.write("S45.G05.15.002.001", this.decimalFormat.format(baseBrute));
        this.n4ds.write("S45.G05.15.003.001", "0.00");
        this.n4ds.write("S45.G05.15.004.001", "0.00");
        this.n4ds.write("S45.G05.15.005.001", "0.00");
        this.n4ds.write("S45.G05.15.006.001", "0.00");
        this.n4ds.write("S45.G05.15.007.001", "0.00");
        this.n4ds.write("S45.G05.15.008.001", "0.00");
        this.n4ds.write("S45.G05.15.009.001", this.decimalFormat.format(baseBrute * 0.016));
    }

    private void writeS44(final SQLRow rowSalarie) throws IOException {
        this.n4ds.write("S44.G03.00.001", "90");
        SQLRow rowInfos = rowSalarie.getForeignRow("ID_INFOS_SALARIE_PAYE");
        SQLRow rowContrat = rowInfos.getForeignRow("ID_CONTRAT_SALARIE");
        if (rowContrat.getString("CODE_IRC_UGRR") != null && rowContrat.getString("CODE_IRC_UGRR").trim().length() > 0 && rowContrat.getString("NUMERO_RATTACHEMENT_UGRR") != null && rowContrat.getString("NUMERO_RATTACHEMENT_UGRR").trim().length() > 0) {
            this.n4ds.write("S44.G03.05.001", rowContrat.getString("CODE_IRC_UGRR"));
            this.n4ds.write("S44.G03.05.002", rowContrat.getString("NUMERO_RATTACHEMENT_UGRR"));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "Attention les informations de rattachement \u00e0 l'UGRR ne sont pas d\u00e9finies pour le salari\u00e9 " + rowSalarie.getString("NOM"));
                }
            });
        }
        if (rowContrat.getString("CODE_IRC_UGRC") != null && rowContrat.getString("CODE_IRC_UGRC").trim().length() > 0 && rowContrat.getString("NUMERO_RATTACHEMENT_UGRC") != null && rowContrat.getString("NUMERO_RATTACHEMENT_UGRC").trim().length() > 0) {
            this.n4ds.write("S44.G03.05.001", rowContrat.getString("CODE_IRC_UGRC"));
            this.n4ds.write("S44.G03.05.002", rowContrat.getString("NUMERO_RATTACHEMENT_UGRC"));
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "Attention les informations de rattachement \u00e0 l'UGRC ne sont pas d\u00e9finies pour le salari\u00e9 " + rowSalarie.getString("NOM"));
                }
            });
        }
    }

    private void writeS48(SQLRow rowSalarie) throws IOException {
        this.n4ds.write("S48.G10.00.015", "01");
        this.n4ds.write("S48.G10.00.016", "90");
        this.n4ds.write("S48.G10.00.017", "01");
        double baseBrute = this.getBaseBrute(rowSalarie);
        this.n4ds.write("S48.G10.00.018", this.decimalFormat.format(baseBrute));
    }

    private void writeS65(SQLRow rowSalarie) throws IOException {
        this.n4ds.write("S65.G40.05.009", "01");
        this.n4ds.write("S65.G40.05.010", "05");
    }

    private void writeS41(SQLRow rowSalarie, SQLRow rowSociete) throws IOException {
        this.n4ds.write("S40.G01.00.001", this.dateFormat.format(this.d));
        this.n4ds.write("S40.G01.00.002.001", "097");
        this.n4ds.write("S40.G01.00.003", this.dateFormat.format(this.d2));
        this.n4ds.write("S40.G01.00.004.001", "098");
        String siret = rowSociete.getString("NUM_SIRET").replaceAll(" ", "");
        String siren = StringUtils.limitLength(siret, 9);
        String nic = siret.substring(siren.length(), siret.length());
        this.n4ds.write("S40.G01.00.005", nic);
        this.n4ds.write("S40.G10.00.005", "10");
        this.n4ds.write("S40.G10.00.008.001", "01");
        this.n4ds.write("S40.G10.00.008.002", "01");
        this.n4ds.write("S40.G10.00.009.001", "01");
        this.n4ds.write("S40.G10.00.009.002", "16");
        SQLRow rowInfos = rowSalarie.getForeignRow("ID_INFOS_SALARIE_PAYE");
        SQLRow rowContrat = rowInfos.getForeignRow("ID_CONTRAT_SALARIE");
        this.n4ds.write("S40.G10.00.010", N4DSSalarie.normalizeString2(rowContrat.getString("NATURE")));
        SQLRow rowCodeEmploi = rowContrat.getForeignRow("ID_CODE_EMPLOI");
        this.n4ds.write("S40.G10.05.011.001", rowCodeEmploi.getString("CODE"));
        SQLRow rowCodeContrat = rowContrat.getForeignRow("ID_CODE_CONTRAT_TRAVAIL");
        this.n4ds.write("S40.G10.05.012.001", rowCodeContrat.getString("CODE"));
        this.n4ds.write("S40.G10.05.012.003", "90");
        this.n4ds.write("S40.G10.05.013.004", "90");
        SQLRow rowCodeStatutConv = rowContrat.getForeignRow("ID_CODE_STATUT_CAT_CONV");
        this.n4ds.write("S40.G10.05.015.001", rowCodeStatutConv.getString("CODE"));
        SQLRow rowStatutCat = rowContrat.getForeignRow("ID_CODE_STATUT_CATEGORIEL");
        this.n4ds.write("S40.G10.05.015.002", rowStatutCat.getString("CODE"));
        SQLRow rowIDCC = rowInfos.getForeignRow("ID_IDCC");
        String idcc = rowIDCC.getString("CODE").trim();
        if (idcc.length() <= 3) {
            int c = 0;
            while (c < 4 - idcc.length()) {
                idcc = "0" + idcc;
                ++c;
            }
        }
        this.n4ds.write("S40.G10.05.016", idcc);
        this.n4ds.write("S40.G10.05.017", "sans classement conventionnel");
        this.n4ds.write("S40.G15.00.001", "10");
        double tempsTravail = 1820.0;
        this.n4ds.write("S40.G15.00.003", this.decimalFormat.format(tempsTravail));
        this.n4ds.write("S40.G15.00.022.001", this.decimalFormat.format(tempsTravail));
        this.n4ds.write("S40.G15.00.022.002", this.decimalFormat.format(tempsTravail));
        this.n4ds.write("S40.G15.05.013.001", "10");
        this.n4ds.write("S40.G15.05.025.001", "10");
        this.n4ds.write("S40.G15.05.025.002", this.decimalFormat.format(tempsTravail));
        this.n4ds.write("S40.G15.05.025.003", this.decimalFormat.format(tempsTravail));
        this.n4ds.write("S40.G20.00.018.002", "200");
        this.n4ds.write("S40.G20.00.018.003", "200");
        this.n4ds.write("S40.G20.00.018.004", "200");
        this.n4ds.write("S40.G25.00.025", rowInfos.getString("CODE_SECTION_AT"));
        this.n4ds.write("S40.G25.00.026", rowInfos.getString("CODE_AT"));
        float f = rowInfos.getFloat("TAUX_AT");
        this.n4ds.write("S40.G25.00.028", this.decimalFormat.format(f));
        this.n4ds.write("S40.G25.00.029", this.decimalFormat.format(tempsTravail));
        double baseBrute = this.getBaseBrute(rowSalarie);
        this.n4ds.write("S40.G28.05.029.001", this.decimalFormat.format(baseBrute));
        this.n4ds.addMasseSalarialeBrute(baseBrute);
        this.n4ds.write("S40.G28.05.029.003", "01");
        this.n4ds.write("S40.G28.05.029.004", "0");
        this.n4ds.write("S40.G28.05.030.001", this.decimalFormat.format(baseBrute));
        this.n4ds.write("S40.G30.04.001", this.decimalFormat.format(this.getCSG(rowSalarie)));
        this.n4ds.write("S40.G30.04.002", this.decimalFormat.format(this.getCSG(rowSalarie)));
        double smicMensuel = 9.61;
        if (baseBrute < 43725.509609999994) {
            this.n4ds.write("S40.G30.40.001", String.valueOf("17490.00"));
            this.n4ds.write("S40.G30.40.002", this.decimalFormat.format(baseBrute));
        }
        if (baseBrute / 12.0 / 151.6667 < 15.376) {
            double COEFF_FILLON = 0.4658333333333334 * (27984.0 / ((double)rowSalarie.getForeign("ID_INFOS_SALARIE_PAYE").getFloat("SALAIRE_MOIS") * 12.0) - 1.0);
            this.n4ds.write("S40.G30.40.003", this.decimalFormat.format(baseBrute * COEFF_FILLON));
        } else {
            this.n4ds.write("S40.G30.40.003", String.valueOf("0.00"));
        }
        if (baseBrute < 43725.0) {
            this.n4ds.write("S40.G30.40.005", String.valueOf("17490.00"));
            this.n4ds.write("S40.G30.40.006", this.decimalFormat.format(baseBrute));
        } else {
            this.n4ds.write("S40.G30.40.005", String.valueOf("0.00"));
            this.n4ds.write("S40.G30.40.006", String.valueOf("0.00"));
        }
        this.n4ds.write("S40.G40.00.035.001", this.decimalFormat.format(baseBrute));
        this.n4ds.write("S40.G40.00.063.001", this.decimalFormat.format(this.getNetImp(rowSalarie)));
        double fraisPro = this.getFraisProfessionels(rowSalarie);
        if (fraisPro > 0.0) {
            this.n4ds.write("S40.G40.10.043", "02");
            this.n4ds.write("S40.G40.10.044.001", this.decimalFormat.format(fraisPro));
        }
    }

    private double getFraisProfessionels(SQLRow rowSalarie) {
        SQLElement eltFichePaye = this.conf.getDirectory().getElement("FICHE_PAYE");
        SQLElement eltFichePayeElement = this.conf.getDirectory().getElement("FICHE_PAYE_ELEMENT");
        SQLElement eltRubriqueNet = this.conf.getDirectory().getElement("RUBRIQUE_NET");
        SQLSelect sel = new SQLSelect(rowSalarie.getTable().getBase());
        sel.addSelect(eltFichePayeElement.getTable().getKey());
        Where w = new Where((FieldRef)eltFichePaye.getTable().getField("DU"), this.d, (Object)this.d2);
        w = w.and(new Where((FieldRef)eltFichePaye.getTable().getField("VALIDE"), "=", (Object)Boolean.TRUE));
        w = w.and(new Where((FieldRef)eltFichePaye.getTable().getField("ID_SALARIE"), "=", rowSalarie.getID()));
        w = w.and(new Where((FieldRef)eltFichePayeElement.getTable().getField("ID_FICHE_PAYE"), "=", eltFichePaye.getTable().getKey()));
        w = w.and(new Where((FieldRef)eltFichePayeElement.getTable().getField("SOURCE"), "=", (Object)"RUBRIQUE_NET"));
        sel.setWhere(w);
        System.err.println(sel.asString());
        List l = (List)this.conf.getBase().getDataSource().execute(sel.asString(), new SQLRowListRSH(eltFichePayeElement.getTable()));
        double fraisPro = 0.0;
        for (SQLRow row : l) {
            SQLRow rowRubrique;
            int id = row.getInt("IDSOURCE");
            if (id <= 1 || !(rowRubrique = eltRubriqueNet.getTable().getRow(id)).getBoolean("FRAIS_PERS").booleanValue()) continue;
            fraisPro += (double)row.getFloat("MONTANT_SAL_AJ");
        }
        return fraisPro;
    }

    private double getBaseBrute(SQLRow rowSalarie) {
        SQLElement eltFichePaye = this.conf.getDirectory().getElement("FICHE_PAYE");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(eltFichePaye.getTable().getKey());
        Where w = new Where((FieldRef)eltFichePaye.getTable().getField("DU"), this.d, (Object)this.d2);
        w = w.and(new Where((FieldRef)eltFichePaye.getTable().getField("VALIDE"), "=", (Object)Boolean.TRUE));
        w = w.and(new Where((FieldRef)eltFichePaye.getTable().getField("ID_SALARIE"), "=", rowSalarie.getID()));
        sel.setWhere(w);
        System.err.println(sel.asString());
        List l = (List)this.conf.getBase().getDataSource().execute(sel.asString(), new SQLRowListRSH(eltFichePaye.getTable()));
        double brut = 0.0;
        for (SQLRow row : l) {
            brut += (double)row.getFloat("SAL_BRUT");
        }
        return brut;
    }

    private double getNetImp(SQLRow rowSalarie) {
        SQLElement eltFichePaye = this.conf.getDirectory().getElement("FICHE_PAYE");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(eltFichePaye.getTable().getKey());
        Where w = new Where((FieldRef)eltFichePaye.getTable().getField("DU"), this.d, (Object)this.d2);
        w = w.and(new Where((FieldRef)eltFichePaye.getTable().getField("VALIDE"), "=", (Object)Boolean.TRUE));
        w = w.and(new Where((FieldRef)eltFichePaye.getTable().getField("ID_SALARIE"), "=", rowSalarie.getID()));
        sel.setWhere(w);
        List l = (List)this.conf.getBase().getDataSource().execute(sel.asString(), new SQLRowListRSH(eltFichePaye.getTable()));
        double brut = 0.0;
        for (SQLRow row : l) {
            brut += (double)row.getFloat("NET_IMP");
        }
        return brut;
    }

    private double getCSG(SQLRow rowSalarie) {
        SQLElement eltFichePaye = this.conf.getDirectory().getElement("FICHE_PAYE");
        SQLSelect sel = new SQLSelect();
        sel.addSelect(eltFichePaye.getTable().getKey());
        Where w = new Where((FieldRef)eltFichePaye.getTable().getField("DU"), this.d, (Object)this.d2);
        w = w.and(new Where((FieldRef)eltFichePaye.getTable().getField("VALIDE"), "=", (Object)Boolean.TRUE));
        w = w.and(new Where((FieldRef)eltFichePaye.getTable().getField("ID_SALARIE"), "=", rowSalarie.getID()));
        sel.setWhere(w);
        List l = (List)this.conf.getBase().getDataSource().execute(sel.asString(), new SQLRowListRSH(eltFichePaye.getTable()));
        double brut = 0.0;
        for (SQLRow row : l) {
            brut += (double)row.getFloat("CSG");
        }
        return brut;
    }

    private void writeS30(SQLRow rowSalarie) throws IOException {
        String[] sVoies;
        SQLRow rowEtatCivil = rowSalarie.getForeignRow("ID_ETAT_CIVIL");
        String nir = rowEtatCivil.getString("NUMERO_SS").replaceAll(" ", "");
        if (nir.length() >= 13) {
            nir = nir.substring(0, 13);
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "Num\u00e9ro d'inscription pour le salari\u00e9 " + rowSalarie.getString("PRENOM") + " " + rowSalarie.getString("NOM") + " incorrect");
        }
        this.n4ds.write("S30.G01.00.001", nir);
        this.n4ds.write("S30.G01.00.002", N4DSSalarie.normalizeString2(rowSalarie.getString("NOM")));
        this.n4ds.write("S30.G01.00.003", N4DSSalarie.normalizeString2(rowSalarie.getString("PRENOM")));
        SQLRow rowTitre = rowSalarie.getForeignRow("ID_TITRE_PERSONNEL");
        String civilite = rowTitre.getString("NOM").toLowerCase();
        if (civilite.contains("monsieur")) {
            this.n4ds.write("S30.G01.00.007", "01");
        } else if (civilite.contains("madame")) {
            this.n4ds.write("S30.G01.00.007", "02");
        } else if (civilite.contains("mademoiselle") || civilite.contains("mlle")) {
            this.n4ds.write("S30.G01.00.007", "03");
        } else {
            JOptionPane.showMessageDialog(new JFrame(), "Civilit\u00e9 incorrecte pour " + rowSalarie.getString("PRENOM") + " " + rowSalarie.getString("NOM") + " (" + civilite + ")");
        }
        SQLRow rowAdr = rowEtatCivil.getForeignRow("ID_ADRESSE");
        String voie = rowAdr.getString("RUE");
        if (voie.contains("\n") && (sVoies = voie.split("\n")).length > 0) {
            voie = sVoies[0].trim();
            String complement = "";
            int i = 1;
            while (i < sVoies.length) {
                complement = String.valueOf(complement) + sVoies[i].trim() + " ";
                ++i;
            }
            if (complement.length() > 0) {
                complement = complement.substring(0, complement.length() - 1);
            }
            this.n4ds.write("S30.G01.00.008.001", N4DSSalarie.normalizeString2(complement));
        }
        this.n4ds.write("S30.G01.00.008.006", N4DSSalarie.normalizeString2(voie));
        this.n4ds.write("S30.G01.00.008.010", rowAdr.getString("CODE_POSTAL"));
        String villeFormat = N4DSSalarie.normalizeString2(rowAdr.getString("VILLE"));
        this.n4ds.write("S30.G01.00.008.012", villeFormat);
        Date d = rowEtatCivil.getDate("DATE_NAISSANCE").getTime();
        this.n4ds.write("S30.G01.00.009", this.format.format(d));
        String villeFormat2 = N4DSSalarie.normalizeString2(rowEtatCivil.getString("COMMUNE_NAISSANCE"));
        this.n4ds.write("S30.G01.00.010", villeFormat2);
        SQLRow rowDept = rowEtatCivil.getForeignRow("ID_DEPARTEMENT_NAISSANCE");
        this.n4ds.write("S30.G01.00.011", rowDept.getString("NUMERO"));
        SQLRow rowPays = rowEtatCivil.getForeignRow("ID_PAYS_NAISSANCE");
        String pays = rowPays.getString("NOM").toUpperCase();
        this.n4ds.write("S30.G01.00.012", pays);
        this.n4ds.write("S30.G01.00.013", pays);
        this.n4ds.write("S30.G01.00.019", rowSalarie.getString("CODE"));
    }

    public static String normalizeString2(String s) {
        s = s.toUpperCase();
        String temp = Normalizer.normalize(s, Normalizer.Form.NFC);
        temp = temp.replaceAll("-", " ");
        temp = temp.replaceAll("\u00e9", "e");
        temp = temp.replaceAll("\u00e8", "e");
        temp = temp.replaceAll("\u00ea", "e");
        temp = temp.replaceAll(",", "");
        return temp.replaceAll("[^\\p{ASCII}]", "");
    }

    private String getNumeroVoie(String voie) {
        String numero = "";
        voie = voie.trim();
        int i = 0;
        while (i < voie.trim().length()) {
            char c = voie.charAt(i);
            if (c < '0' || c > '9') break;
            numero = String.valueOf(numero) + c;
            ++i;
        }
        return numero;
    }

    private String getVoieWithoutNumber(String voie) {
        voie = voie.trim();
        String resultVoie = new String(voie);
        int i = 0;
        while (i < voie.trim().length()) {
            char c = voie.charAt(i);
            if (c < '0' || c > '9') break;
            resultVoie = resultVoie.substring(1);
            ++i;
        }
        return resultVoie.trim();
    }
}

