/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openconcerto.erp.core.finance.accounting.importer.Transaction;

public class OFXParser {
    private List<Transaction> transactions;
    private LocalDate startDate;
    private LocalDate endDate;
    private String bankId = "";
    private String branchId = "";
    private String accId = "";
    private List<String> openTags;

    public String getBasicBankAccountNumber() {
        return String.valueOf(this.bankId) + this.branchId + this.accId;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public List<Month> getCompleteMonth() {
        ArrayList<Month> result = new ArrayList<Month>();
        if (this.startDate != null && this.endDate != null) {
            LocalDate d = this.startDate;
            while (d.isBefore(this.endDate)) {
                LocalDate d1 = d.with(TemporalAdjusters.firstDayOfMonth());
                LocalDate d2 = d.with(TemporalAdjusters.lastDayOfMonth());
                if ((d1.isEqual(this.startDate) || d1.isAfter(this.startDate)) && (d2.isEqual(this.endDate) || d2.isBefore(this.endDate))) {
                    result.add(d.getMonth());
                }
                d = d.plusMonths(1L);
            }
        }
        return result;
    }

    public void parse(File file) throws IOException {
        this.parse(new FileInputStream(file));
    }

    public void parse(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String line = null;
        this.transactions = new ArrayList<Transaction>();
        this.openTags = new LinkedList<String>();
        try {
            while ((line = reader.readLine()) != null) {
                this.parseLine(line.trim());
            }
        }
        finally {
            reader.close();
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("ddMMyy");
        for (Transaction t : this.transactions) {
            String d;
            if (t.getMemo().length() > 10 && (d = t.getMemo().substring(0, 10)).startsWith("DU ") && d.endsWith(" ")) {
                t.setMemo(t.getMemo().substring(10));
                LocalDate date = LocalDate.parse(d.substring(3, 9), formatter);
                t.setDate(date);
            }
            t.setUUID(String.valueOf(t.getUUID()) + "-" + t.getDateValue().getYear() + "-" + t.getDateValue().getDayOfYear());
        }
        this.openTags = null;
    }

    private void openTag(String tag) {
        this.openTags.add(tag);
        if (tag.equals("STMTTRN")) {
            this.transactions.add(new Transaction());
        }
    }

    private void closeTag(String tag) {
        while (!this.lastOpenTag().equals(tag)) {
            this.closeTag(this.lastOpenTag());
        }
        this.openTags.remove(this.openTags.size() - 1);
    }

    private void text(String text) {
        String lastOpenTag = this.lastOpenTag();
        Transaction lastTransaction = this.lastTransaction();
        if (lastOpenTag.equals("BANKID")) {
            this.bankId = text;
        } else if (lastOpenTag.equals("BRANCHID")) {
            this.branchId = text;
        } else if (lastOpenTag.equals("ACCTID")) {
            this.accId = text;
        } else if (lastTransaction != null) {
            if (lastOpenTag.equals("TRNAMT")) {
                lastTransaction.setAmount(new BigDecimal(text));
            } else if (lastOpenTag.equals("NAME")) {
                lastTransaction.setName(text);
            } else if (lastOpenTag.equals("MEMO")) {
                lastTransaction.setMemo(text.trim());
            } else if (lastOpenTag.equals("DTPOSTED")) {
                String t = text.substring(0, 8);
                lastTransaction.setDate(LocalDate.parse(t, DateTimeFormatter.ofPattern("yyyyMMdd")));
                lastTransaction.setDateValue(LocalDate.parse(t, DateTimeFormatter.ofPattern("yyyyMMdd")));
            } else if (lastOpenTag.equals("FITID")) {
                lastTransaction.setUUID(text);
            } else {
                lastOpenTag.equals("TRNTYPE");
            }
        } else if (lastOpenTag.equals("DTSTART") && this.openTags.get(this.openTags.size() - 2).equals("BANKTRANLIST")) {
            String t = text.substring(0, 8);
            this.startDate = LocalDate.parse(t, DateTimeFormatter.ofPattern("yyyyMMdd"));
        } else if (lastOpenTag.equals("DTEND") && this.openTags.get(this.openTags.size() - 2).equals("DTSTART")) {
            String t = text.substring(0, 8);
            this.endDate = LocalDate.parse(t, DateTimeFormatter.ofPattern("yyyyMMdd"));
        }
    }

    private String lastOpenTag() {
        if (this.openTags.isEmpty()) {
            return "";
        }
        return this.openTags.get(this.openTags.size() - 1);
    }

    private Transaction lastTransaction() {
        if (this.transactions.isEmpty()) {
            return null;
        }
        return this.transactions.get(this.transactions.size() - 1);
    }

    private void parseLine(String line) {
        if (line.startsWith("<")) {
            String text;
            int close = line.indexOf(62, 1);
            this.openTag(line.substring(1, close));
            int next = line.indexOf(60, close);
            if (next == -1) {
                next = line.length();
            }
            if (!(text = line.substring(close + 1, next)).isEmpty()) {
                this.text(text);
            }
        } else if (line.startsWith("</")) {
            int close = line.indexOf(62, 1);
            this.closeTag(line.substring(2, close));
        }
    }
}

